/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.hadoop.conf.Configuration;

public class ClientInfoImpl
implements ClientInfo {
    private Properties properties;
    private AuthenticationToken token;
    private Configuration hadoopConf;

    public ClientInfoImpl(Path propertiesFile) {
        this(ClientInfoImpl.toProperties(propertiesFile));
    }

    public ClientInfoImpl(Properties properties) {
        this(properties, null);
    }

    public ClientInfoImpl(Properties properties, AuthenticationToken token) {
        this.properties = properties;
        this.token = token;
        this.hadoopConf = new Configuration();
    }

    @Override
    public String getInstanceName() {
        return this.getString(ClientProperty.INSTANCE_NAME);
    }

    @Override
    public String getZooKeepers() {
        return this.getString(ClientProperty.INSTANCE_ZOOKEEPERS);
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return (int)ConfigurationTypeHelper.getTimeInMillis(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getValue(this.properties));
    }

    @Override
    public String getPrincipal() {
        return this.getString(ClientProperty.AUTH_PRINCIPAL);
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty((String)key, (String)value)));
        return result;
    }

    @Override
    public AuthenticationToken getAuthenticationToken() {
        if (this.token == null) {
            this.token = ClientProperty.getAuthenticationToken(this.properties);
        }
        return this.token;
    }

    @Override
    public boolean saslEnabled() {
        return Boolean.valueOf(this.getString(ClientProperty.SASL_ENABLED));
    }

    private String getString(ClientProperty property) {
        return property.getValue(this.properties);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided propertiesFilePath")
    public static Properties toProperties(String propertiesFilePath) {
        return ClientInfoImpl.toProperties(Paths.get(propertiesFilePath, new String[0]));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided propertiesFile")
    public static Properties toProperties(Path propertiesFile) {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(propertiesFile.toFile());){
            properties.load(is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load properties from " + propertiesFile, e);
        }
        return properties;
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }
}

