/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileScannerBuilder;
import org.apache.accumulo.core.client.rfile.RFileSource;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.summary.SummaryReader;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

class RFileSummariesRetriever
implements RFile.SummaryInputArguments,
RFile.SummaryFSOptions,
RFile.SummaryOptions {
    private Predicate<SummarizerConfiguration> summarySelector = sc -> true;
    private Text startRow;
    private RFileScannerBuilder.InputArgs in;
    private Text endRow;
    private Map<String, String> config = Collections.emptyMap();

    RFileSummariesRetriever() {
    }

    @Override
    public RFile.SummaryOptions selectSummaries(Predicate<SummarizerConfiguration> summarySelector) {
        Objects.requireNonNull(summarySelector);
        this.summarySelector = summarySelector;
        return this;
    }

    @Override
    public RFile.SummaryOptions startRow(CharSequence startRow) {
        return this.startRow(new Text(startRow.toString()));
    }

    @Override
    public RFile.SummaryOptions startRow(Text startRow) {
        Objects.requireNonNull(startRow);
        this.startRow = startRow;
        return this;
    }

    @Override
    public RFile.SummaryOptions endRow(CharSequence endRow) {
        return this.endRow(new Text(endRow.toString()));
    }

    @Override
    public RFile.SummaryOptions endRow(Text endRow) {
        Objects.requireNonNull(endRow);
        this.endRow = endRow;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Summary> read() throws IOException {
        SummarizerFactory factory = new SummarizerFactory();
        ConfigurationCopy acuconf = new ConfigurationCopy(DefaultConfiguration.getInstance());
        this.config.forEach((k, v) -> acuconf.set((String)k, (String)v));
        RFileSource[] sources = this.in.getSources();
        try {
            SummaryCollection all = new SummaryCollection();
            CryptoService cservice = CryptoServiceFactory.newInstance(acuconf, CryptoServiceFactory.ClassloaderType.JAVA);
            for (RFileSource source : sources) {
                SummaryReader fileSummary = SummaryReader.load(this.in.getFileSystem().getConf(), source.getInputStream(), source.getLength(), this.summarySelector, factory, cservice);
                SummaryCollection sc = fileSummary.getSummaries(Collections.singletonList(new Gatherer.RowRange(this.startRow, this.endRow)));
                all.merge(sc, factory);
            }
            List<Summary> list = all.getSummaries();
            return list;
        }
        finally {
            for (RFileSource source : sources) {
                source.getInputStream().close();
            }
        }
    }

    @Override
    public RFile.SummaryOptions withFileSystem(FileSystem fs) {
        Objects.requireNonNull(fs);
        this.in.fs = fs;
        return this;
    }

    @Override
    public RFile.SummaryOptions from(RFileSource ... inputs) {
        Objects.requireNonNull(inputs);
        this.in = new RFileScannerBuilder.InputArgs(inputs);
        return this;
    }

    @Override
    public RFile.SummaryFSOptions from(String ... files) {
        Objects.requireNonNull(files);
        this.in = new RFileScannerBuilder.InputArgs(files);
        return this;
    }

    @Override
    public RFile.SummaryOptions withTableProperties(Iterable<Map.Entry<String, String>> props) {
        Objects.requireNonNull(props);
        HashMap<String, String> cfg = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props) {
            cfg.put(entry.getKey(), entry.getValue());
        }
        this.config = cfg;
        return this;
    }

    @Override
    public RFile.SummaryOptions withTableProperties(Map<String, String> props) {
        Objects.requireNonNull(props);
        this.withTableProperties(props.entrySet());
        return this;
    }
}

