/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.OutputConfigurator;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@Deprecated
public class AccumuloOutputFormat
extends OutputFormat<Text, Mutation> {
    private static final Class<?> CLASS = AccumuloOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (token instanceof KerberosToken) {
            log.info((Object)"Received KerberosToken, attempting to fetch DelegationToken");
            try {
                ClientContext client = OutputConfigurator.client(CLASS, job.getConfiguration());
                token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
            catch (Exception e) {
                log.warn((Object)"Failed to automatically obtain DelegationToken, Mappers/Reducers will likely fail to communicate with Accumulo", (Throwable)e);
            }
        }
        if (token instanceof DelegationTokenImpl) {
            DelegationTokenImpl delegationToken = (DelegationTokenImpl)token;
            AuthenticationTokenIdentifier identifier = delegationToken.getIdentifier();
            Token hadoopToken = new Token(identifier.getBytes(), delegationToken.getPassword(), identifier.getKind(), delegationToken.getServiceName());
            job.getCredentials().addToken(hadoopToken.getService(), hadoopToken);
        }
        OutputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    public static void setConnectorInfo(Job job, String principal, String tokenFile) throws AccumuloSecurityException {
        OutputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobContext context) {
        return OutputConfigurator.isConnectorInfoSet(CLASS, context.getConfiguration());
    }

    protected static String getPrincipal(JobContext context) {
        return OutputConfigurator.getPrincipal(CLASS, context.getConfiguration());
    }

    @Deprecated
    protected static String getTokenClass(JobContext context) {
        return AccumuloOutputFormat.getAuthenticationToken(context).getClass().getName();
    }

    @Deprecated
    protected static byte[] getToken(JobContext context) {
        return AuthenticationToken.AuthenticationTokenSerializer.serialize(AccumuloOutputFormat.getAuthenticationToken(context));
    }

    protected static AuthenticationToken getAuthenticationToken(JobContext context) {
        AuthenticationToken token = OutputConfigurator.getAuthenticationToken(CLASS, context.getConfiguration());
        return OutputConfigurator.unwrapAuthenticationToken(context, token);
    }

    @Deprecated
    public static void setZooKeeperInstance(Job job, String instanceName, String zooKeepers) {
        AccumuloOutputFormat.setZooKeeperInstance(job, ClientConfiguration.create().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    public static void setZooKeeperInstance(Job job, ClientConfiguration clientConfig) {
        OutputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), clientConfig);
    }

    protected static Instance getInstance(JobContext context) {
        return OutputConfigurator.getInstance(CLASS, context.getConfiguration());
    }

    public static void setLogLevel(Job job, Level level) {
        OutputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext context) {
        return OutputConfigurator.getLogLevel(CLASS, context.getConfiguration());
    }

    public static void setDefaultTableName(Job job, String tableName) {
        OutputConfigurator.setDefaultTableName(CLASS, job.getConfiguration(), tableName);
    }

    protected static String getDefaultTableName(JobContext context) {
        return OutputConfigurator.getDefaultTableName(CLASS, context.getConfiguration());
    }

    public static void setBatchWriterOptions(Job job, BatchWriterConfig bwConfig) {
        OutputConfigurator.setBatchWriterOptions(CLASS, job.getConfiguration(), bwConfig);
    }

    protected static BatchWriterConfig getBatchWriterOptions(JobContext context) {
        return OutputConfigurator.getBatchWriterOptions(CLASS, context.getConfiguration());
    }

    public static void setCreateTables(Job job, boolean enableFeature) {
        OutputConfigurator.setCreateTables(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static Boolean canCreateTables(JobContext context) {
        return OutputConfigurator.canCreateTables(CLASS, context.getConfiguration());
    }

    public static void setSimulationMode(Job job, boolean enableFeature) {
        OutputConfigurator.setSimulationMode(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static Boolean getSimulationMode(JobContext context) {
        return OutputConfigurator.getSimulationMode(CLASS, context.getConfiguration());
    }

    public void checkOutputSpecs(JobContext job) throws IOException {
        if (!AccumuloOutputFormat.isConnectorInfoSet(job).booleanValue()) {
            throw new IOException("Connector info has not been set.");
        }
        String principal = AccumuloOutputFormat.getPrincipal(job);
        AuthenticationToken token = AccumuloOutputFormat.getAuthenticationToken(job);
        try {
            ClientContext c = OutputConfigurator.client(CLASS, job.getConfiguration());
            if (!c.securityOperations().authenticateUser(principal, token)) {
                throw new IOException("Unable to authenticate user");
            }
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(TaskAttemptContext attempt) throws IOException {
        try {
            return new AccumuloRecordWriter(attempt);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static class AccumuloRecordWriter
    extends RecordWriter<Text, Mutation> {
        private MultiTableBatchWriter mtbw = null;
        private HashMap<Text, BatchWriter> bws = null;
        private Text defaultTableName = null;
        private boolean simulate = false;
        private boolean createTables = false;
        private long mutCount = 0L;
        private long valCount = 0L;
        private AccumuloClient client;

        protected AccumuloRecordWriter(TaskAttemptContext context) throws AccumuloException, AccumuloSecurityException, IOException {
            Level l = AccumuloOutputFormat.getLogLevel((JobContext)context);
            if (l != null) {
                log.setLevel(AccumuloOutputFormat.getLogLevel((JobContext)context));
            }
            this.simulate = AccumuloOutputFormat.getSimulationMode((JobContext)context);
            this.createTables = AccumuloOutputFormat.canCreateTables((JobContext)context);
            if (this.simulate) {
                log.info((Object)"Simulating output only. No writes to tables will occur");
            }
            this.bws = new HashMap();
            String tname = AccumuloOutputFormat.getDefaultTableName((JobContext)context);
            Text text = this.defaultTableName = tname == null ? null : new Text(tname);
            if (!this.simulate) {
                this.client = OutputConfigurator.client(CLASS, context.getConfiguration());
                this.mtbw = this.client.createMultiTableBatchWriter(AccumuloOutputFormat.getBatchWriterOptions((JobContext)context));
            }
        }

        public void write(Text table, Mutation mutation) throws IOException {
            if (table == null || table.toString().isEmpty()) {
                table = this.defaultTableName;
            }
            if (!this.simulate && table == null) {
                throw new IOException("No table or default table specified. Try simulation mode next time");
            }
            ++this.mutCount;
            this.valCount += (long)mutation.size();
            this.printMutation(table, mutation);
            if (this.simulate) {
                return;
            }
            if (!this.bws.containsKey(table)) {
                try {
                    this.addTable(table);
                }
                catch (Exception e) {
                    log.error((Object)("Could not add table '" + table + "'"), (Throwable)e);
                    throw new IOException(e);
                }
            }
            try {
                this.bws.get(table).addMutation(mutation);
            }
            catch (MutationsRejectedException e) {
                throw new IOException(e);
            }
        }

        public void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
            if (this.simulate) {
                log.info((Object)("Simulating adding table: " + tableName));
                return;
            }
            log.debug((Object)("Adding table: " + tableName));
            BatchWriter bw = null;
            String table = tableName.toString();
            if (this.createTables && !this.client.tableOperations().exists(table)) {
                try {
                    this.client.tableOperations().create(table);
                }
                catch (AccumuloSecurityException e) {
                    log.error((Object)("Accumulo security violation creating " + table), (Throwable)e);
                    throw e;
                }
                catch (TableExistsException e) {
                    // empty catch block
                }
            }
            try {
                bw = this.mtbw.getBatchWriter(table);
            }
            catch (TableNotFoundException e) {
                log.error((Object)("Accumulo table " + table + " doesn't exist and cannot be created."), (Throwable)e);
                throw new AccumuloException(e);
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw e;
            }
            if (bw != null) {
                this.bws.put(tableName, bw);
            }
        }

        private int printMutation(Text table, Mutation m) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Table %s row key: %s", table, this.hexDump(m.getRow())));
                for (ColumnUpdate cu : m.getUpdates()) {
                    log.trace((Object)String.format("Table %s column: %s:%s", table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())));
                    log.trace((Object)String.format("Table %s security: %s", table, new ColumnVisibility(cu.getColumnVisibility()).toString()));
                    log.trace((Object)String.format("Table %s value: %s", table, this.hexDump(cu.getValue())));
                }
            }
            return m.getUpdates().size();
        }

        private String hexDump(byte[] ba) {
            StringBuilder sb = new StringBuilder();
            for (byte b : ba) {
                if (b > 32 && b < 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(String.format("x%02x", b));
            }
            return sb.toString();
        }

        public void close(TaskAttemptContext attempt) throws IOException, InterruptedException {
            log.debug((Object)("mutations written: " + this.mutCount + ", values written: " + this.valCount));
            if (this.simulate) {
                return;
            }
            try {
                this.mtbw.close();
            }
            catch (MutationsRejectedException e) {
                if (!e.getSecurityErrorCodes().isEmpty()) {
                    HashMap tables = new HashMap();
                    for (Map.Entry<TabletId, Set<SecurityErrorCode>> ke : e.getSecurityErrorCodes().entrySet()) {
                        String tableId = ke.getKey().getTableId().toString();
                        HashSet secCodes = (HashSet)tables.get(tableId);
                        if (secCodes == null) {
                            secCodes = new HashSet();
                            tables.put(tableId, secCodes);
                        }
                        secCodes.addAll(ke.getValue());
                    }
                    log.error((Object)("Not authorized to write to tables : " + tables));
                }
                if (e.getConstraintViolationSummaries().size() > 0) {
                    log.error((Object)("Constraint violations : " + e.getConstraintViolationSummaries().size()));
                }
                throw new IOException(e);
            }
            finally {
                this.client.close();
            }
        }
    }
}

