/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    public static final String USER_ACCUMULO_DIR_NAME = ".accumulo";
    public static final String USER_CONF_FILENAME = "config";
    public static final String GLOBAL_CONF_FILENAME = "client.conf";
    private final CompositeConfiguration compositeConfig;

    private ClientConfiguration(List<? extends Configuration> configs) {
        this.compositeConfig = new CompositeConfiguration(configs);
    }

    public static ClientConfiguration loadDefault() {
        return ClientConfiguration.loadFromSearchPath(ClientConfiguration.getDefaultSearchPath());
    }

    public static ClientConfiguration create() {
        return new ClientConfiguration(Collections.emptyList());
    }

    public static ClientConfiguration fromFile(File file) {
        FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFile(file)});
        try {
            return new ClientConfiguration(Collections.singletonList((PropertiesConfiguration)propsBuilder.getConfiguration()));
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Bad configuration file: " + file, e);
        }
    }

    public static ClientConfiguration fromMap(Map<String, String> properties) {
        MapConfiguration mapConf = new MapConfiguration(properties);
        return new ClientConfiguration(Collections.singletonList(mapConf));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="process runs in same security context as user who provided path")
    private static ClientConfiguration loadFromSearchPath(List<String> paths) {
        LinkedList<Configuration> configs = new LinkedList<Configuration>();
        for (String path : paths) {
            File conf = new File(path);
            if (!conf.isFile() || !conf.canRead()) continue;
            FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFile(conf)});
            try {
                configs.add((Configuration)propsBuilder.getConfiguration());
                log.info("Loaded client configuration file {}", (Object)conf);
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("Error loading client configuration file " + conf, e);
            }
        }
        if (configs.isEmpty()) {
            log.debug("Found no client.conf in default paths. Using default client configuration values.");
        }
        return new ClientConfiguration(configs);
    }

    public static ClientConfiguration deserialize(String serializedConfig) {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        try {
            propConfig.getLayout().load(propConfig, (Reader)new StringReader(serializedConfig));
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Error deserializing client configuration: " + serializedConfig, e);
        }
        return new ClientConfiguration(Collections.singletonList(propConfig));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="process runs in same security context as user who provided path")
    static String getClientConfPath(String clientConfPath) {
        if (clientConfPath == null) {
            return null;
        }
        File filePath = new File(clientConfPath);
        if (filePath.exists() && filePath.isDirectory()) {
            return new File(filePath, GLOBAL_CONF_FILENAME).toString();
        }
        return clientConfPath;
    }

    private static List<String> getDefaultSearchPath() {
        LinkedList<String> clientConfPaths;
        String clientConfSearchPath = ClientConfiguration.getClientConfPath(System.getenv("ACCUMULO_CLIENT_CONF_PATH"));
        if (clientConfSearchPath != null) {
            clientConfPaths = Arrays.asList(clientConfSearchPath.split(File.pathSeparator));
        } else {
            clientConfPaths = new LinkedList();
            clientConfPaths.add(System.getProperty("user.home") + File.separator + USER_ACCUMULO_DIR_NAME + File.separator + USER_CONF_FILENAME);
            if (System.getenv("ACCUMULO_CONF_DIR") != null) {
                clientConfPaths.add(System.getenv("ACCUMULO_CONF_DIR") + File.separator + GLOBAL_CONF_FILENAME);
            }
            clientConfPaths.add("/etc/accumulo/client.conf");
            clientConfPaths.add("/etc/accumulo/conf/client.conf");
        }
        return clientConfPaths;
    }

    public String serialize() {
        PropertiesConfiguration propConfig = new PropertiesConfiguration();
        propConfig.copy((Configuration)this.compositeConfig);
        StringWriter writer = new StringWriter();
        try {
            propConfig.getLayout().save(propConfig, (Writer)writer);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public String get(ClientProperty prop) {
        if (this.compositeConfig.containsKey(prop.getKey())) {
            return this.compositeConfig.getString(prop.getKey());
        }
        return prop.getDefaultValue();
    }

    private void checkType(ClientProperty property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    public Map<String, String> getAllPropertiesWithPrefix(ClientProperty property) {
        this.checkType(property, PropertyType.PREFIX);
        HashMap<String, String> propMap = new HashMap<String, String>();
        String prefix = property.getKey();
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        Iterator iter = this.compositeConfig.getKeys(prefix);
        while (iter.hasNext()) {
            String p = (String)iter.next();
            propMap.put(p, this.compositeConfig.getString(p));
        }
        return propMap;
    }

    public void setProperty(ClientProperty prop, String value) {
        this.with(prop, value);
    }

    public ClientConfiguration with(ClientProperty prop, String value) {
        return this.with(prop.getKey(), value);
    }

    public void setProperty(String prop, String value) {
        this.with(prop, value);
    }

    public ClientConfiguration with(String prop, String value) {
        this.compositeConfig.setProperty(prop, (Object)value);
        return this;
    }

    public ClientConfiguration withInstance(String instanceName) {
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"instanceName is null");
        return this.with(ClientProperty.INSTANCE_NAME, instanceName);
    }

    public ClientConfiguration withInstance(UUID instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"instanceId is null");
        return this.with(ClientProperty.INSTANCE_ID, instanceId.toString());
    }

    public ClientConfiguration withZkHosts(String zooKeepers) {
        Preconditions.checkArgument((zooKeepers != null ? 1 : 0) != 0, (Object)"zooKeepers is null");
        return this.with(ClientProperty.INSTANCE_ZK_HOST, zooKeepers);
    }

    public ClientConfiguration withZkTimeout(int timeout) {
        return this.with(ClientProperty.INSTANCE_ZK_TIMEOUT, String.valueOf(timeout));
    }

    public ClientConfiguration withSsl(boolean sslEnabled) {
        return this.withSsl(sslEnabled, false);
    }

    public ClientConfiguration withSsl(boolean sslEnabled, boolean useJsseConfig) {
        return this.with(ClientProperty.INSTANCE_RPC_SSL_ENABLED, String.valueOf(sslEnabled)).with(ClientProperty.RPC_USE_JSSE, String.valueOf(useJsseConfig));
    }

    public ClientConfiguration withTruststore(String path) {
        return this.withTruststore(path, null, null);
    }

    public ClientConfiguration withTruststore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_TRUSTSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withKeystore(String path) {
        return this.withKeystore(path, null, null);
    }

    public ClientConfiguration withKeystore(String path, String password, String type) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path is null");
        this.setProperty(ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, "true");
        this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PATH, path);
        if (password != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_PASSWORD, password);
        }
        if (type != null) {
            this.setProperty(ClientProperty.RPC_SSL_KEYSTORE_TYPE, type);
        }
        return this;
    }

    public ClientConfiguration withSasl(boolean saslEnabled) {
        return this.with(ClientProperty.INSTANCE_RPC_SASL_ENABLED, String.valueOf(saslEnabled));
    }

    public boolean hasSasl() {
        return this.compositeConfig.getBoolean(ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), Boolean.parseBoolean(ClientProperty.INSTANCE_RPC_SASL_ENABLED.getDefaultValue()));
    }

    public ClientConfiguration withSasl(boolean saslEnabled, String kerberosServerPrimary) {
        return this.withSasl(saslEnabled).with(ClientProperty.KERBEROS_SERVER_PRIMARY, kerberosServerPrimary);
    }

    public boolean containsKey(String key) {
        return this.compositeConfig.containsKey(key);
    }

    public Iterator<String> getKeys() {
        return this.compositeConfig.getKeys();
    }

    public String getString(String key) {
        return this.compositeConfig.getString(key);
    }

    public static enum ClientProperty {
        RPC_SSL_TRUSTSTORE_PATH(Property.RPC_SSL_TRUSTSTORE_PATH),
        RPC_SSL_TRUSTSTORE_PASSWORD(Property.RPC_SSL_TRUSTSTORE_PASSWORD),
        RPC_SSL_TRUSTSTORE_TYPE(Property.RPC_SSL_TRUSTSTORE_TYPE),
        RPC_SSL_KEYSTORE_PATH(Property.RPC_SSL_KEYSTORE_PATH),
        RPC_SSL_KEYSTORE_PASSWORD(Property.RPC_SSL_KEYSTORE_PASSWORD),
        RPC_SSL_KEYSTORE_TYPE(Property.RPC_SSL_KEYSTORE_TYPE),
        RPC_USE_JSSE(Property.RPC_USE_JSSE),
        GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS),
        INSTANCE_RPC_SSL_CLIENT_AUTH(Property.INSTANCE_RPC_SSL_CLIENT_AUTH),
        INSTANCE_RPC_SSL_ENABLED(Property.INSTANCE_RPC_SSL_ENABLED),
        INSTANCE_ZK_HOST(Property.INSTANCE_ZK_HOST),
        INSTANCE_ZK_TIMEOUT(Property.INSTANCE_ZK_TIMEOUT),
        INSTANCE_NAME("instance.name", null, PropertyType.STRING, "Name of Accumulo instance to connect to"),
        INSTANCE_ID("instance.id", null, PropertyType.STRING, "UUID of Accumulo instance to connect to"),
        TRACE_SPAN_RECEIVERS(Property.TRACE_SPAN_RECEIVERS),
        TRACE_SPAN_RECEIVER_PREFIX(Property.TRACE_SPAN_RECEIVER_PREFIX),
        TRACE_ZK_PATH(Property.TRACE_ZK_PATH),
        INSTANCE_RPC_SASL_ENABLED(Property.INSTANCE_RPC_SASL_ENABLED),
        RPC_SASL_QOP(Property.RPC_SASL_QOP),
        KERBEROS_SERVER_PRIMARY("kerberos.server.primary", "accumulo", PropertyType.STRING, "The first component of the Kerberos principal, the 'primary', that Accumulo servers use to login");

        private String key;
        private String defaultValue;
        private PropertyType type;
        private String description;

        private ClientProperty(Property prop) {
            this(prop.getKey(), prop.getDefaultValue(), prop.getType(), prop.getDescription());
        }

        private ClientProperty(String key, String defaultValue, PropertyType type, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.type = type;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        private PropertyType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public static ClientProperty getPropertyByKey(String key) {
            for (ClientProperty prop : ClientProperty.values()) {
                if (!prop.getKey().equals(key)) continue;
                return prop;
            }
            return null;
        }
    }
}

