/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.convert;

import java.util.HashSet;
import java.util.Set;
import org.apache.turbine.util.Log;
import org.chefproject.core.SiteEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.RealmService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.Sql;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Xml;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupSiteRealmConverter
implements Runnable {
    /*
     * Unable to fully structure code
     */
    private void convertGroups() {
        template = null;
        try {
            template = SiteService.getSite("!worksite");
        }
        catch (IdUnusedException e) {
            Log.warn("chef", " ** site \"!worksite\" not found!");
            return;
        }
        try {
            defaultSiteRealm = RealmService.getRealm("@");
            access = defaultSiteRealm.getRole("access");
            maintain = defaultSiteRealm.getRole("maintain");
            if (access == null || maintain == null) {
                Log.warn("chef", " ** roles \"access\" and \"maintain\" not both defined in realm \"@\"");
                return;
            }
        }
        catch (IdUnusedException e) {
            Log.warn("chef", " ** missing default site realm \"@\"");
            return;
        }
        sql = "select XML from CHEF_GROUP";
        records = Sql.dbRead(sql);
        it = records.iterator();
        while (it.hasNext()) {
            id = null;
            try {
                xml = (String)it.next();
                doc = Xml.readDocumentFromString(xml);
                root = doc.getDocumentElement();
                group = new BaseGroup(root);
                id = group.m_id;
                try {
                    site = SiteService.getSite(id);
                    Log.info("chef", " ** group: " + id + " site found.");
                    continue;
                }
                catch (IdUnusedException e) {
                    site = SiteService.addSite(id, template);
                    site.setTitle(group.m_name);
                    site.setIconUrl(group.m_icon);
                    site.setInfoUrl(group.m_info);
                    site.setJoinable(group.m_open);
                    site.setJoinerRole("access");
                    site.setDescription(group.m_description);
                    site.setStatus(2);
                    SiteService.commitEdit((SiteEdit)site);
                    Log.info("chef", " ** site: " + id + " created.");
                    realm = RealmService.editRealm(site.getReference());
                    student = realm.getRole("Student");
                    if (student == null) {
                        realm.addRole("Student", realm.getRole("access"));
                    }
                    if ((instructor = realm.getRole("Instructor")) == null) {
                        realm.addRole("Instructor", realm.getRole("maintain"));
                    }
                    iRoles = group.m_roles.iterator();
                    ** while (iRoles.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    role = (String)iRoles.next();
                    parts = StringUtil.split(role, "%");
                    try {
                        realm.addUserRole(UserDirectoryService.getUser(parts[0]), realm.getRole(parts[1]));
                    }
                    catch (Exception e) {
                        Log.warn("chef", " ** exception while converting group: " + id + " role: " + role + " : " + e);
                    }
                    continue;
                }
lbl63:
                // 1 sources

                realm.setProviderRealmId(group.m_externalId);
                RealmService.commitEdit(realm);
                Log.info("chef", " ** realm: " + realm.getId() + " updated.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting group: " + id + " : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.info("chef", " ** Converting groups to site + realm **");
        UsageSessionService.loginThreadUser("admin");
        try {
            this.convertGroups();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    public static void convert() {
        GroupSiteRealmConverter converter = new GroupSiteRealmConverter();
        Thread thread = new Thread((Runnable)converter, "GroupSiteRealmConverter");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class BaseGroup {
        protected String m_id = null;
        protected String m_name = null;
        protected String m_description = null;
        protected boolean m_open = false;
        protected String m_icon = null;
        protected String m_info = null;
        protected Set m_roles = new HashSet();
        protected String m_externalId = null;

        public BaseGroup(Element el) {
            this.m_id = el.getAttribute("id");
            this.m_name = StringUtil.trimToNull(el.getAttribute("name"));
            this.m_icon = StringUtil.trimToNull(el.getAttribute("icon"));
            this.m_info = StringUtil.trimToNull(el.getAttribute("info"));
            this.m_externalId = StringUtil.trimToNull(el.getAttribute("external"));
            this.m_description = StringUtil.trimToNull(el.getAttribute("description"));
            this.m_open = new Boolean(el.getAttribute("open"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("roles")) {
                    this.mergeRoles(element);
                }
                ++i;
            }
        }

        public void mergeRoles(Element element) {
            if (element.getTagName().equals("roles")) {
                NodeList rlsChildren = element.getChildNodes();
                int rlsLength = rlsChildren.getLength();
                int r = 0;
                while (r < rlsLength) {
                    Element rlsElement;
                    Node rlsChild = rlsChildren.item(r);
                    if (rlsChild.getNodeType() == 1 && (rlsElement = (Element)rlsChild).getTagName().equals("role")) {
                        this.m_roles.add(rlsElement.getAttribute("value"));
                    }
                    ++r;
                }
            }
        }

        private String roleKeyUser(String key) {
            String[] parts = StringUtil.split(key, "%");
            return parts[0];
        }

        private String roleKeyRole(String key) {
            String[] parts = StringUtil.split(key, "%");
            return parts[1];
        }
    }
}

