// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for Elliptic Curve Digital Signature Algorithm (ECDSA).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.21.12
// source: ecdsa.proto

package ecdsa_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EcdsaSignatureEncoding int32

const (
	EcdsaSignatureEncoding_UNKNOWN_ENCODING EcdsaSignatureEncoding = 0
	// The signature's format is r || s, where r and s are zero-padded and have
	// the same size in bytes as the order of the curve. For example, for NIST
	// P-256 curve, r and s are zero-padded to 32 bytes.
	EcdsaSignatureEncoding_IEEE_P1363 EcdsaSignatureEncoding = 1
	// The signature is encoded using ASN.1
	// (https://tools.ietf.org/html/rfc5480#appendix-A):
	//
	//	ECDSA-Sig-Value :: = SEQUENCE {
	//	 r INTEGER,
	//	 s INTEGER
	//	}
	EcdsaSignatureEncoding_DER EcdsaSignatureEncoding = 2
)

// Enum value maps for EcdsaSignatureEncoding.
var (
	EcdsaSignatureEncoding_name = map[int32]string{
		0: "UNKNOWN_ENCODING",
		1: "IEEE_P1363",
		2: "DER",
	}
	EcdsaSignatureEncoding_value = map[string]int32{
		"UNKNOWN_ENCODING": 0,
		"IEEE_P1363":       1,
		"DER":              2,
	}
)

func (x EcdsaSignatureEncoding) Enum() *EcdsaSignatureEncoding {
	p := new(EcdsaSignatureEncoding)
	*p = x
	return p
}

func (x EcdsaSignatureEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EcdsaSignatureEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_ecdsa_proto_enumTypes[0].Descriptor()
}

func (EcdsaSignatureEncoding) Type() protoreflect.EnumType {
	return &file_ecdsa_proto_enumTypes[0]
}

func (x EcdsaSignatureEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EcdsaSignatureEncoding.Descriptor instead.
func (EcdsaSignatureEncoding) EnumDescriptor() ([]byte, []int) {
	return file_ecdsa_proto_rawDescGZIP(), []int{0}
}

// Protos for Ecdsa.
type EcdsaParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	HashType common_go_proto.HashType `protobuf:"varint,1,opt,name=hash_type,json=hashType,proto3,enum=google.crypto.tink.HashType" json:"hash_type,omitempty"`
	// Required.
	Curve common_go_proto.EllipticCurveType `protobuf:"varint,2,opt,name=curve,proto3,enum=google.crypto.tink.EllipticCurveType" json:"curve,omitempty"`
	// Required.
	Encoding      EcdsaSignatureEncoding `protobuf:"varint,3,opt,name=encoding,proto3,enum=google.crypto.tink.EcdsaSignatureEncoding" json:"encoding,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EcdsaParams) Reset() {
	*x = EcdsaParams{}
	mi := &file_ecdsa_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EcdsaParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EcdsaParams) ProtoMessage() {}

func (x *EcdsaParams) ProtoReflect() protoreflect.Message {
	mi := &file_ecdsa_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EcdsaParams.ProtoReflect.Descriptor instead.
func (*EcdsaParams) Descriptor() ([]byte, []int) {
	return file_ecdsa_proto_rawDescGZIP(), []int{0}
}

func (x *EcdsaParams) GetHashType() common_go_proto.HashType {
	if x != nil {
		return x.HashType
	}
	return common_go_proto.HashType(0)
}

func (x *EcdsaParams) GetCurve() common_go_proto.EllipticCurveType {
	if x != nil {
		return x.Curve
	}
	return common_go_proto.EllipticCurveType(0)
}

func (x *EcdsaParams) GetEncoding() EcdsaSignatureEncoding {
	if x != nil {
		return x.Encoding
	}
	return EcdsaSignatureEncoding_UNKNOWN_ENCODING
}

// key_type: type.googleapis.com/google.crypto.tink.EcdsaPublicKey
type EcdsaPublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *EcdsaParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Affine coordinates of the public key in bigendian representation. The
	// public key is a point (x, y) on the curve defined by params.curve. For
	// ECDH, it is crucial to verify whether the public key point (x, y) is on the
	// private's key curve. For ECDSA, such verification is a defense in depth.
	// Required.
	X []byte `protobuf:"bytes,3,opt,name=x,proto3" json:"x,omitempty"`
	// Required.
	Y             []byte `protobuf:"bytes,4,opt,name=y,proto3" json:"y,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EcdsaPublicKey) Reset() {
	*x = EcdsaPublicKey{}
	mi := &file_ecdsa_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EcdsaPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EcdsaPublicKey) ProtoMessage() {}

func (x *EcdsaPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_ecdsa_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EcdsaPublicKey.ProtoReflect.Descriptor instead.
func (*EcdsaPublicKey) Descriptor() ([]byte, []int) {
	return file_ecdsa_proto_rawDescGZIP(), []int{1}
}

func (x *EcdsaPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EcdsaPublicKey) GetParams() *EcdsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *EcdsaPublicKey) GetX() []byte {
	if x != nil {
		return x.X
	}
	return nil
}

func (x *EcdsaPublicKey) GetY() []byte {
	if x != nil {
		return x.Y
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.EcdsaPrivateKey
type EcdsaPrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *EcdsaPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Unsigned big integer in bigendian representation.
	// Required.
	KeyValue      []byte `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype and debug_redact.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EcdsaPrivateKey) Reset() {
	*x = EcdsaPrivateKey{}
	mi := &file_ecdsa_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EcdsaPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EcdsaPrivateKey) ProtoMessage() {}

func (x *EcdsaPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_ecdsa_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EcdsaPrivateKey.ProtoReflect.Descriptor instead.
func (*EcdsaPrivateKey) Descriptor() ([]byte, []int) {
	return file_ecdsa_proto_rawDescGZIP(), []int{2}
}

func (x *EcdsaPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EcdsaPrivateKey) GetPublicKey() *EcdsaPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *EcdsaPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

type EcdsaKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Params        *EcdsaParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	Version       uint32       `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EcdsaKeyFormat) Reset() {
	*x = EcdsaKeyFormat{}
	mi := &file_ecdsa_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EcdsaKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EcdsaKeyFormat) ProtoMessage() {}

func (x *EcdsaKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_ecdsa_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EcdsaKeyFormat.ProtoReflect.Descriptor instead.
func (*EcdsaKeyFormat) Descriptor() ([]byte, []int) {
	return file_ecdsa_proto_rawDescGZIP(), []int{3}
}

func (x *EcdsaKeyFormat) GetParams() *EcdsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *EcdsaKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

var File_ecdsa_proto protoreflect.FileDescriptor

const file_ecdsa_proto_rawDesc = "" +
	"\n" +
	"\vecdsa.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\"\xcd\x01\n" +
	"\vEcdsaParams\x129\n" +
	"\thash_type\x18\x01 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\bhashType\x12;\n" +
	"\x05curve\x18\x02 \x01(\x0e2%.google.crypto.tink.EllipticCurveTypeR\x05curve\x12F\n" +
	"\bencoding\x18\x03 \x01(\x0e2*.google.crypto.tink.EcdsaSignatureEncodingR\bencoding\"\x7f\n" +
	"\x0eEcdsaPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x127\n" +
	"\x06params\x18\x02 \x01(\v2\x1f.google.crypto.tink.EcdsaParamsR\x06params\x12\f\n" +
	"\x01x\x18\x03 \x01(\fR\x01x\x12\f\n" +
	"\x01y\x18\x04 \x01(\fR\x01y\"\x8b\x01\n" +
	"\x0fEcdsaPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12A\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2\".google.crypto.tink.EcdsaPublicKeyR\tpublicKey\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValue\"c\n" +
	"\x0eEcdsaKeyFormat\x127\n" +
	"\x06params\x18\x02 \x01(\v2\x1f.google.crypto.tink.EcdsaParamsR\x06params\x12\x18\n" +
	"\aversion\x18\x03 \x01(\rR\aversion*G\n" +
	"\x16EcdsaSignatureEncoding\x12\x14\n" +
	"\x10UNKNOWN_ENCODING\x10\x00\x12\x0e\n" +
	"\n" +
	"IEEE_P1363\x10\x01\x12\a\n" +
	"\x03DER\x10\x02BX\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z6github.com/tink-crypto/tink-go/v2/proto/ecdsa_go_protob\x06proto3"

var (
	file_ecdsa_proto_rawDescOnce sync.Once
	file_ecdsa_proto_rawDescData []byte
)

func file_ecdsa_proto_rawDescGZIP() []byte {
	file_ecdsa_proto_rawDescOnce.Do(func() {
		file_ecdsa_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_ecdsa_proto_rawDesc), len(file_ecdsa_proto_rawDesc)))
	})
	return file_ecdsa_proto_rawDescData
}

var file_ecdsa_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ecdsa_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_ecdsa_proto_goTypes = []any{
	(EcdsaSignatureEncoding)(0),            // 0: google.crypto.tink.EcdsaSignatureEncoding
	(*EcdsaParams)(nil),                    // 1: google.crypto.tink.EcdsaParams
	(*EcdsaPublicKey)(nil),                 // 2: google.crypto.tink.EcdsaPublicKey
	(*EcdsaPrivateKey)(nil),                // 3: google.crypto.tink.EcdsaPrivateKey
	(*EcdsaKeyFormat)(nil),                 // 4: google.crypto.tink.EcdsaKeyFormat
	(common_go_proto.HashType)(0),          // 5: google.crypto.tink.HashType
	(common_go_proto.EllipticCurveType)(0), // 6: google.crypto.tink.EllipticCurveType
}
var file_ecdsa_proto_depIdxs = []int32{
	5, // 0: google.crypto.tink.EcdsaParams.hash_type:type_name -> google.crypto.tink.HashType
	6, // 1: google.crypto.tink.EcdsaParams.curve:type_name -> google.crypto.tink.EllipticCurveType
	0, // 2: google.crypto.tink.EcdsaParams.encoding:type_name -> google.crypto.tink.EcdsaSignatureEncoding
	1, // 3: google.crypto.tink.EcdsaPublicKey.params:type_name -> google.crypto.tink.EcdsaParams
	2, // 4: google.crypto.tink.EcdsaPrivateKey.public_key:type_name -> google.crypto.tink.EcdsaPublicKey
	1, // 5: google.crypto.tink.EcdsaKeyFormat.params:type_name -> google.crypto.tink.EcdsaParams
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_ecdsa_proto_init() }
func file_ecdsa_proto_init() {
	if File_ecdsa_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_ecdsa_proto_rawDesc), len(file_ecdsa_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ecdsa_proto_goTypes,
		DependencyIndexes: file_ecdsa_proto_depIdxs,
		EnumInfos:         file_ecdsa_proto_enumTypes,
		MessageInfos:      file_ecdsa_proto_msgTypes,
	}.Build()
	File_ecdsa_proto = out.File
	file_ecdsa_proto_goTypes = nil
	file_ecdsa_proto_depIdxs = nil
}
