// Code generated by Fiat Cryptography. DO NOT EDIT.
//
// Autogenerated: word_by_word_montgomery --lang Go --no-wide-int --cmovznz-by-mul --relax-primitive-carry-to-bitwidth 32,64 --internal-static --public-function-case camelCase --public-type-case camelCase --private-function-case camelCase --private-type-case camelCase --doc-text-before-function-name '' --doc-newline-before-package-declaration --doc-prepend-header 'Code generated by Fiat Cryptography. DO NOT EDIT.' --package-name fiat --no-prefix-fiat p384 64 '2^384 - 2^128 - 2^96 + 2^32 - 1' mul square add sub one from_montgomery to_montgomery selectznz to_bytes from_bytes
//
// curve description: p384
//
// machine_wordsize = 64 (from "64")
//
// requested operations: mul, square, add, sub, one, from_montgomery, to_montgomery, selectznz, to_bytes, from_bytes
//
// m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1")
//
//
//
// NOTE: In addition to the bounds specified above each function, all
//
//   functions synthesized for this Montgomery arithmetic require the
//
//   input to be strictly less than the prime modulus (m), and also
//
//   require the input to be in the unique saturated representation.
//
//   All functions also ensure that these two properties are true of
//
//   return values.
//
//
//
// Computed values:
//
//   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140)
//
//   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)
//
//   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) in
//
//                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384

package fiat

import "math/bits"

type p384Uint1 uint64 // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927
type p384Int1 int64   // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927

// The type p384MontgomeryDomainFieldElement is a field element in the Montgomery domain.
//
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type p384MontgomeryDomainFieldElement [6]uint64

// The type p384NonMontgomeryDomainFieldElement is a field element NOT in the Montgomery domain.
//
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type p384NonMontgomeryDomainFieldElement [6]uint64

// p384CmovznzU64 is a single-word conditional move.
//
// Postconditions:
//   out1 = (if arg1 = 0 then arg2 else arg3)
//
// Input Bounds:
//   arg1: [0x0 ~> 0x1]
//   arg2: [0x0 ~> 0xffffffffffffffff]
//   arg3: [0x0 ~> 0xffffffffffffffff]
// Output Bounds:
//   out1: [0x0 ~> 0xffffffffffffffff]
func p384CmovznzU64(out1 *uint64, arg1 p384Uint1, arg2 uint64, arg3 uint64) {
	x1 := (uint64(arg1) * 0xffffffffffffffff)
	x2 := ((x1 & arg3) | ((^x1) & arg2))
	*out1 = x2
}

// p384Mul multiplies two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
func p384Mul(out1 *p384MontgomeryDomainFieldElement, arg1 *p384MontgomeryDomainFieldElement, arg2 *p384MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x6, arg2[5])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x6, arg2[4])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x6, arg2[3])
	var x13 uint64
	var x14 uint64
	x14, x13 = bits.Mul64(x6, arg2[2])
	var x15 uint64
	var x16 uint64
	x16, x15 = bits.Mul64(x6, arg2[1])
	var x17 uint64
	var x18 uint64
	x18, x17 = bits.Mul64(x6, arg2[0])
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Add64(x18, x15, uint64(0x0))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Add64(x16, x13, uint64(p384Uint1(x20)))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Add64(x14, x11, uint64(p384Uint1(x22)))
	var x25 uint64
	var x26 uint64
	x25, x26 = bits.Add64(x12, x9, uint64(p384Uint1(x24)))
	var x27 uint64
	var x28 uint64
	x27, x28 = bits.Add64(x10, x7, uint64(p384Uint1(x26)))
	x29 := (uint64(p384Uint1(x28)) + x8)
	var x30 uint64
	_, x30 = bits.Mul64(x17, 0x100000001)
	var x32 uint64
	var x33 uint64
	x33, x32 = bits.Mul64(x30, 0xffffffffffffffff)
	var x34 uint64
	var x35 uint64
	x35, x34 = bits.Mul64(x30, 0xffffffffffffffff)
	var x36 uint64
	var x37 uint64
	x37, x36 = bits.Mul64(x30, 0xffffffffffffffff)
	var x38 uint64
	var x39 uint64
	x39, x38 = bits.Mul64(x30, 0xfffffffffffffffe)
	var x40 uint64
	var x41 uint64
	x41, x40 = bits.Mul64(x30, 0xffffffff00000000)
	var x42 uint64
	var x43 uint64
	x43, x42 = bits.Mul64(x30, 0xffffffff)
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x43, x40, uint64(0x0))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x41, x38, uint64(p384Uint1(x45)))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x39, x36, uint64(p384Uint1(x47)))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x37, x34, uint64(p384Uint1(x49)))
	var x52 uint64
	var x53 uint64
	x52, x53 = bits.Add64(x35, x32, uint64(p384Uint1(x51)))
	x54 := (uint64(p384Uint1(x53)) + x33)
	var x56 uint64
	_, x56 = bits.Add64(x17, x42, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x19, x44, uint64(p384Uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x21, x46, uint64(p384Uint1(x58)))
	var x61 uint64
	var x62 uint64
	x61, x62 = bits.Add64(x23, x48, uint64(p384Uint1(x60)))
	var x63 uint64
	var x64 uint64
	x63, x64 = bits.Add64(x25, x50, uint64(p384Uint1(x62)))
	var x65 uint64
	var x66 uint64
	x65, x66 = bits.Add64(x27, x52, uint64(p384Uint1(x64)))
	var x67 uint64
	var x68 uint64
	x67, x68 = bits.Add64(x29, x54, uint64(p384Uint1(x66)))
	var x69 uint64
	var x70 uint64
	x70, x69 = bits.Mul64(x1, arg2[5])
	var x71 uint64
	var x72 uint64
	x72, x71 = bits.Mul64(x1, arg2[4])
	var x73 uint64
	var x74 uint64
	x74, x73 = bits.Mul64(x1, arg2[3])
	var x75 uint64
	var x76 uint64
	x76, x75 = bits.Mul64(x1, arg2[2])
	var x77 uint64
	var x78 uint64
	x78, x77 = bits.Mul64(x1, arg2[1])
	var x79 uint64
	var x80 uint64
	x80, x79 = bits.Mul64(x1, arg2[0])
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x80, x77, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x78, x75, uint64(p384Uint1(x82)))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x76, x73, uint64(p384Uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x74, x71, uint64(p384Uint1(x86)))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x72, x69, uint64(p384Uint1(x88)))
	x91 := (uint64(p384Uint1(x90)) + x70)
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x57, x79, uint64(0x0))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x59, x81, uint64(p384Uint1(x93)))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x61, x83, uint64(p384Uint1(x95)))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x63, x85, uint64(p384Uint1(x97)))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x65, x87, uint64(p384Uint1(x99)))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x67, x89, uint64(p384Uint1(x101)))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(uint64(p384Uint1(x68)), x91, uint64(p384Uint1(x103)))
	var x106 uint64
	_, x106 = bits.Mul64(x92, 0x100000001)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x106, 0xffffffffffffffff)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x106, 0xffffffffffffffff)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x106, 0xffffffffffffffff)
	var x114 uint64
	var x115 uint64
	x115, x114 = bits.Mul64(x106, 0xfffffffffffffffe)
	var x116 uint64
	var x117 uint64
	x117, x116 = bits.Mul64(x106, 0xffffffff00000000)
	var x118 uint64
	var x119 uint64
	x119, x118 = bits.Mul64(x106, 0xffffffff)
	var x120 uint64
	var x121 uint64
	x120, x121 = bits.Add64(x119, x116, uint64(0x0))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x117, x114, uint64(p384Uint1(x121)))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x115, x112, uint64(p384Uint1(x123)))
	var x126 uint64
	var x127 uint64
	x126, x127 = bits.Add64(x113, x110, uint64(p384Uint1(x125)))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64(x111, x108, uint64(p384Uint1(x127)))
	x130 := (uint64(p384Uint1(x129)) + x109)
	var x132 uint64
	_, x132 = bits.Add64(x92, x118, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x94, x120, uint64(p384Uint1(x132)))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x96, x122, uint64(p384Uint1(x134)))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x98, x124, uint64(p384Uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x100, x126, uint64(p384Uint1(x138)))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x102, x128, uint64(p384Uint1(x140)))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(x104, x130, uint64(p384Uint1(x142)))
	x145 := (uint64(p384Uint1(x144)) + uint64(p384Uint1(x105)))
	var x146 uint64
	var x147 uint64
	x147, x146 = bits.Mul64(x2, arg2[5])
	var x148 uint64
	var x149 uint64
	x149, x148 = bits.Mul64(x2, arg2[4])
	var x150 uint64
	var x151 uint64
	x151, x150 = bits.Mul64(x2, arg2[3])
	var x152 uint64
	var x153 uint64
	x153, x152 = bits.Mul64(x2, arg2[2])
	var x154 uint64
	var x155 uint64
	x155, x154 = bits.Mul64(x2, arg2[1])
	var x156 uint64
	var x157 uint64
	x157, x156 = bits.Mul64(x2, arg2[0])
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x157, x154, uint64(0x0))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x155, x152, uint64(p384Uint1(x159)))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x153, x150, uint64(p384Uint1(x161)))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x151, x148, uint64(p384Uint1(x163)))
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Add64(x149, x146, uint64(p384Uint1(x165)))
	x168 := (uint64(p384Uint1(x167)) + x147)
	var x169 uint64
	var x170 uint64
	x169, x170 = bits.Add64(x133, x156, uint64(0x0))
	var x171 uint64
	var x172 uint64
	x171, x172 = bits.Add64(x135, x158, uint64(p384Uint1(x170)))
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x137, x160, uint64(p384Uint1(x172)))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x139, x162, uint64(p384Uint1(x174)))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x141, x164, uint64(p384Uint1(x176)))
	var x179 uint64
	var x180 uint64
	x179, x180 = bits.Add64(x143, x166, uint64(p384Uint1(x178)))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x145, x168, uint64(p384Uint1(x180)))
	var x183 uint64
	_, x183 = bits.Mul64(x169, 0x100000001)
	var x185 uint64
	var x186 uint64
	x186, x185 = bits.Mul64(x183, 0xffffffffffffffff)
	var x187 uint64
	var x188 uint64
	x188, x187 = bits.Mul64(x183, 0xffffffffffffffff)
	var x189 uint64
	var x190 uint64
	x190, x189 = bits.Mul64(x183, 0xffffffffffffffff)
	var x191 uint64
	var x192 uint64
	x192, x191 = bits.Mul64(x183, 0xfffffffffffffffe)
	var x193 uint64
	var x194 uint64
	x194, x193 = bits.Mul64(x183, 0xffffffff00000000)
	var x195 uint64
	var x196 uint64
	x196, x195 = bits.Mul64(x183, 0xffffffff)
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x196, x193, uint64(0x0))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x194, x191, uint64(p384Uint1(x198)))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x192, x189, uint64(p384Uint1(x200)))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x190, x187, uint64(p384Uint1(x202)))
	var x205 uint64
	var x206 uint64
	x205, x206 = bits.Add64(x188, x185, uint64(p384Uint1(x204)))
	x207 := (uint64(p384Uint1(x206)) + x186)
	var x209 uint64
	_, x209 = bits.Add64(x169, x195, uint64(0x0))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Add64(x171, x197, uint64(p384Uint1(x209)))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Add64(x173, x199, uint64(p384Uint1(x211)))
	var x214 uint64
	var x215 uint64
	x214, x215 = bits.Add64(x175, x201, uint64(p384Uint1(x213)))
	var x216 uint64
	var x217 uint64
	x216, x217 = bits.Add64(x177, x203, uint64(p384Uint1(x215)))
	var x218 uint64
	var x219 uint64
	x218, x219 = bits.Add64(x179, x205, uint64(p384Uint1(x217)))
	var x220 uint64
	var x221 uint64
	x220, x221 = bits.Add64(x181, x207, uint64(p384Uint1(x219)))
	x222 := (uint64(p384Uint1(x221)) + uint64(p384Uint1(x182)))
	var x223 uint64
	var x224 uint64
	x224, x223 = bits.Mul64(x3, arg2[5])
	var x225 uint64
	var x226 uint64
	x226, x225 = bits.Mul64(x3, arg2[4])
	var x227 uint64
	var x228 uint64
	x228, x227 = bits.Mul64(x3, arg2[3])
	var x229 uint64
	var x230 uint64
	x230, x229 = bits.Mul64(x3, arg2[2])
	var x231 uint64
	var x232 uint64
	x232, x231 = bits.Mul64(x3, arg2[1])
	var x233 uint64
	var x234 uint64
	x234, x233 = bits.Mul64(x3, arg2[0])
	var x235 uint64
	var x236 uint64
	x235, x236 = bits.Add64(x234, x231, uint64(0x0))
	var x237 uint64
	var x238 uint64
	x237, x238 = bits.Add64(x232, x229, uint64(p384Uint1(x236)))
	var x239 uint64
	var x240 uint64
	x239, x240 = bits.Add64(x230, x227, uint64(p384Uint1(x238)))
	var x241 uint64
	var x242 uint64
	x241, x242 = bits.Add64(x228, x225, uint64(p384Uint1(x240)))
	var x243 uint64
	var x244 uint64
	x243, x244 = bits.Add64(x226, x223, uint64(p384Uint1(x242)))
	x245 := (uint64(p384Uint1(x244)) + x224)
	var x246 uint64
	var x247 uint64
	x246, x247 = bits.Add64(x210, x233, uint64(0x0))
	var x248 uint64
	var x249 uint64
	x248, x249 = bits.Add64(x212, x235, uint64(p384Uint1(x247)))
	var x250 uint64
	var x251 uint64
	x250, x251 = bits.Add64(x214, x237, uint64(p384Uint1(x249)))
	var x252 uint64
	var x253 uint64
	x252, x253 = bits.Add64(x216, x239, uint64(p384Uint1(x251)))
	var x254 uint64
	var x255 uint64
	x254, x255 = bits.Add64(x218, x241, uint64(p384Uint1(x253)))
	var x256 uint64
	var x257 uint64
	x256, x257 = bits.Add64(x220, x243, uint64(p384Uint1(x255)))
	var x258 uint64
	var x259 uint64
	x258, x259 = bits.Add64(x222, x245, uint64(p384Uint1(x257)))
	var x260 uint64
	_, x260 = bits.Mul64(x246, 0x100000001)
	var x262 uint64
	var x263 uint64
	x263, x262 = bits.Mul64(x260, 0xffffffffffffffff)
	var x264 uint64
	var x265 uint64
	x265, x264 = bits.Mul64(x260, 0xffffffffffffffff)
	var x266 uint64
	var x267 uint64
	x267, x266 = bits.Mul64(x260, 0xffffffffffffffff)
	var x268 uint64
	var x269 uint64
	x269, x268 = bits.Mul64(x260, 0xfffffffffffffffe)
	var x270 uint64
	var x271 uint64
	x271, x270 = bits.Mul64(x260, 0xffffffff00000000)
	var x272 uint64
	var x273 uint64
	x273, x272 = bits.Mul64(x260, 0xffffffff)
	var x274 uint64
	var x275 uint64
	x274, x275 = bits.Add64(x273, x270, uint64(0x0))
	var x276 uint64
	var x277 uint64
	x276, x277 = bits.Add64(x271, x268, uint64(p384Uint1(x275)))
	var x278 uint64
	var x279 uint64
	x278, x279 = bits.Add64(x269, x266, uint64(p384Uint1(x277)))
	var x280 uint64
	var x281 uint64
	x280, x281 = bits.Add64(x267, x264, uint64(p384Uint1(x279)))
	var x282 uint64
	var x283 uint64
	x282, x283 = bits.Add64(x265, x262, uint64(p384Uint1(x281)))
	x284 := (uint64(p384Uint1(x283)) + x263)
	var x286 uint64
	_, x286 = bits.Add64(x246, x272, uint64(0x0))
	var x287 uint64
	var x288 uint64
	x287, x288 = bits.Add64(x248, x274, uint64(p384Uint1(x286)))
	var x289 uint64
	var x290 uint64
	x289, x290 = bits.Add64(x250, x276, uint64(p384Uint1(x288)))
	var x291 uint64
	var x292 uint64
	x291, x292 = bits.Add64(x252, x278, uint64(p384Uint1(x290)))
	var x293 uint64
	var x294 uint64
	x293, x294 = bits.Add64(x254, x280, uint64(p384Uint1(x292)))
	var x295 uint64
	var x296 uint64
	x295, x296 = bits.Add64(x256, x282, uint64(p384Uint1(x294)))
	var x297 uint64
	var x298 uint64
	x297, x298 = bits.Add64(x258, x284, uint64(p384Uint1(x296)))
	x299 := (uint64(p384Uint1(x298)) + uint64(p384Uint1(x259)))
	var x300 uint64
	var x301 uint64
	x301, x300 = bits.Mul64(x4, arg2[5])
	var x302 uint64
	var x303 uint64
	x303, x302 = bits.Mul64(x4, arg2[4])
	var x304 uint64
	var x305 uint64
	x305, x304 = bits.Mul64(x4, arg2[3])
	var x306 uint64
	var x307 uint64
	x307, x306 = bits.Mul64(x4, arg2[2])
	var x308 uint64
	var x309 uint64
	x309, x308 = bits.Mul64(x4, arg2[1])
	var x310 uint64
	var x311 uint64
	x311, x310 = bits.Mul64(x4, arg2[0])
	var x312 uint64
	var x313 uint64
	x312, x313 = bits.Add64(x311, x308, uint64(0x0))
	var x314 uint64
	var x315 uint64
	x314, x315 = bits.Add64(x309, x306, uint64(p384Uint1(x313)))
	var x316 uint64
	var x317 uint64
	x316, x317 = bits.Add64(x307, x304, uint64(p384Uint1(x315)))
	var x318 uint64
	var x319 uint64
	x318, x319 = bits.Add64(x305, x302, uint64(p384Uint1(x317)))
	var x320 uint64
	var x321 uint64
	x320, x321 = bits.Add64(x303, x300, uint64(p384Uint1(x319)))
	x322 := (uint64(p384Uint1(x321)) + x301)
	var x323 uint64
	var x324 uint64
	x323, x324 = bits.Add64(x287, x310, uint64(0x0))
	var x325 uint64
	var x326 uint64
	x325, x326 = bits.Add64(x289, x312, uint64(p384Uint1(x324)))
	var x327 uint64
	var x328 uint64
	x327, x328 = bits.Add64(x291, x314, uint64(p384Uint1(x326)))
	var x329 uint64
	var x330 uint64
	x329, x330 = bits.Add64(x293, x316, uint64(p384Uint1(x328)))
	var x331 uint64
	var x332 uint64
	x331, x332 = bits.Add64(x295, x318, uint64(p384Uint1(x330)))
	var x333 uint64
	var x334 uint64
	x333, x334 = bits.Add64(x297, x320, uint64(p384Uint1(x332)))
	var x335 uint64
	var x336 uint64
	x335, x336 = bits.Add64(x299, x322, uint64(p384Uint1(x334)))
	var x337 uint64
	_, x337 = bits.Mul64(x323, 0x100000001)
	var x339 uint64
	var x340 uint64
	x340, x339 = bits.Mul64(x337, 0xffffffffffffffff)
	var x341 uint64
	var x342 uint64
	x342, x341 = bits.Mul64(x337, 0xffffffffffffffff)
	var x343 uint64
	var x344 uint64
	x344, x343 = bits.Mul64(x337, 0xffffffffffffffff)
	var x345 uint64
	var x346 uint64
	x346, x345 = bits.Mul64(x337, 0xfffffffffffffffe)
	var x347 uint64
	var x348 uint64
	x348, x347 = bits.Mul64(x337, 0xffffffff00000000)
	var x349 uint64
	var x350 uint64
	x350, x349 = bits.Mul64(x337, 0xffffffff)
	var x351 uint64
	var x352 uint64
	x351, x352 = bits.Add64(x350, x347, uint64(0x0))
	var x353 uint64
	var x354 uint64
	x353, x354 = bits.Add64(x348, x345, uint64(p384Uint1(x352)))
	var x355 uint64
	var x356 uint64
	x355, x356 = bits.Add64(x346, x343, uint64(p384Uint1(x354)))
	var x357 uint64
	var x358 uint64
	x357, x358 = bits.Add64(x344, x341, uint64(p384Uint1(x356)))
	var x359 uint64
	var x360 uint64
	x359, x360 = bits.Add64(x342, x339, uint64(p384Uint1(x358)))
	x361 := (uint64(p384Uint1(x360)) + x340)
	var x363 uint64
	_, x363 = bits.Add64(x323, x349, uint64(0x0))
	var x364 uint64
	var x365 uint64
	x364, x365 = bits.Add64(x325, x351, uint64(p384Uint1(x363)))
	var x366 uint64
	var x367 uint64
	x366, x367 = bits.Add64(x327, x353, uint64(p384Uint1(x365)))
	var x368 uint64
	var x369 uint64
	x368, x369 = bits.Add64(x329, x355, uint64(p384Uint1(x367)))
	var x370 uint64
	var x371 uint64
	x370, x371 = bits.Add64(x331, x357, uint64(p384Uint1(x369)))
	var x372 uint64
	var x373 uint64
	x372, x373 = bits.Add64(x333, x359, uint64(p384Uint1(x371)))
	var x374 uint64
	var x375 uint64
	x374, x375 = bits.Add64(x335, x361, uint64(p384Uint1(x373)))
	x376 := (uint64(p384Uint1(x375)) + uint64(p384Uint1(x336)))
	var x377 uint64
	var x378 uint64
	x378, x377 = bits.Mul64(x5, arg2[5])
	var x379 uint64
	var x380 uint64
	x380, x379 = bits.Mul64(x5, arg2[4])
	var x381 uint64
	var x382 uint64
	x382, x381 = bits.Mul64(x5, arg2[3])
	var x383 uint64
	var x384 uint64
	x384, x383 = bits.Mul64(x5, arg2[2])
	var x385 uint64
	var x386 uint64
	x386, x385 = bits.Mul64(x5, arg2[1])
	var x387 uint64
	var x388 uint64
	x388, x387 = bits.Mul64(x5, arg2[0])
	var x389 uint64
	var x390 uint64
	x389, x390 = bits.Add64(x388, x385, uint64(0x0))
	var x391 uint64
	var x392 uint64
	x391, x392 = bits.Add64(x386, x383, uint64(p384Uint1(x390)))
	var x393 uint64
	var x394 uint64
	x393, x394 = bits.Add64(x384, x381, uint64(p384Uint1(x392)))
	var x395 uint64
	var x396 uint64
	x395, x396 = bits.Add64(x382, x379, uint64(p384Uint1(x394)))
	var x397 uint64
	var x398 uint64
	x397, x398 = bits.Add64(x380, x377, uint64(p384Uint1(x396)))
	x399 := (uint64(p384Uint1(x398)) + x378)
	var x400 uint64
	var x401 uint64
	x400, x401 = bits.Add64(x364, x387, uint64(0x0))
	var x402 uint64
	var x403 uint64
	x402, x403 = bits.Add64(x366, x389, uint64(p384Uint1(x401)))
	var x404 uint64
	var x405 uint64
	x404, x405 = bits.Add64(x368, x391, uint64(p384Uint1(x403)))
	var x406 uint64
	var x407 uint64
	x406, x407 = bits.Add64(x370, x393, uint64(p384Uint1(x405)))
	var x408 uint64
	var x409 uint64
	x408, x409 = bits.Add64(x372, x395, uint64(p384Uint1(x407)))
	var x410 uint64
	var x411 uint64
	x410, x411 = bits.Add64(x374, x397, uint64(p384Uint1(x409)))
	var x412 uint64
	var x413 uint64
	x412, x413 = bits.Add64(x376, x399, uint64(p384Uint1(x411)))
	var x414 uint64
	_, x414 = bits.Mul64(x400, 0x100000001)
	var x416 uint64
	var x417 uint64
	x417, x416 = bits.Mul64(x414, 0xffffffffffffffff)
	var x418 uint64
	var x419 uint64
	x419, x418 = bits.Mul64(x414, 0xffffffffffffffff)
	var x420 uint64
	var x421 uint64
	x421, x420 = bits.Mul64(x414, 0xffffffffffffffff)
	var x422 uint64
	var x423 uint64
	x423, x422 = bits.Mul64(x414, 0xfffffffffffffffe)
	var x424 uint64
	var x425 uint64
	x425, x424 = bits.Mul64(x414, 0xffffffff00000000)
	var x426 uint64
	var x427 uint64
	x427, x426 = bits.Mul64(x414, 0xffffffff)
	var x428 uint64
	var x429 uint64
	x428, x429 = bits.Add64(x427, x424, uint64(0x0))
	var x430 uint64
	var x431 uint64
	x430, x431 = bits.Add64(x425, x422, uint64(p384Uint1(x429)))
	var x432 uint64
	var x433 uint64
	x432, x433 = bits.Add64(x423, x420, uint64(p384Uint1(x431)))
	var x434 uint64
	var x435 uint64
	x434, x435 = bits.Add64(x421, x418, uint64(p384Uint1(x433)))
	var x436 uint64
	var x437 uint64
	x436, x437 = bits.Add64(x419, x416, uint64(p384Uint1(x435)))
	x438 := (uint64(p384Uint1(x437)) + x417)
	var x440 uint64
	_, x440 = bits.Add64(x400, x426, uint64(0x0))
	var x441 uint64
	var x442 uint64
	x441, x442 = bits.Add64(x402, x428, uint64(p384Uint1(x440)))
	var x443 uint64
	var x444 uint64
	x443, x444 = bits.Add64(x404, x430, uint64(p384Uint1(x442)))
	var x445 uint64
	var x446 uint64
	x445, x446 = bits.Add64(x406, x432, uint64(p384Uint1(x444)))
	var x447 uint64
	var x448 uint64
	x447, x448 = bits.Add64(x408, x434, uint64(p384Uint1(x446)))
	var x449 uint64
	var x450 uint64
	x449, x450 = bits.Add64(x410, x436, uint64(p384Uint1(x448)))
	var x451 uint64
	var x452 uint64
	x451, x452 = bits.Add64(x412, x438, uint64(p384Uint1(x450)))
	x453 := (uint64(p384Uint1(x452)) + uint64(p384Uint1(x413)))
	var x454 uint64
	var x455 uint64
	x454, x455 = bits.Sub64(x441, 0xffffffff, uint64(0x0))
	var x456 uint64
	var x457 uint64
	x456, x457 = bits.Sub64(x443, 0xffffffff00000000, uint64(p384Uint1(x455)))
	var x458 uint64
	var x459 uint64
	x458, x459 = bits.Sub64(x445, 0xfffffffffffffffe, uint64(p384Uint1(x457)))
	var x460 uint64
	var x461 uint64
	x460, x461 = bits.Sub64(x447, 0xffffffffffffffff, uint64(p384Uint1(x459)))
	var x462 uint64
	var x463 uint64
	x462, x463 = bits.Sub64(x449, 0xffffffffffffffff, uint64(p384Uint1(x461)))
	var x464 uint64
	var x465 uint64
	x464, x465 = bits.Sub64(x451, 0xffffffffffffffff, uint64(p384Uint1(x463)))
	var x467 uint64
	_, x467 = bits.Sub64(x453, uint64(0x0), uint64(p384Uint1(x465)))
	var x468 uint64
	p384CmovznzU64(&x468, p384Uint1(x467), x454, x441)
	var x469 uint64
	p384CmovznzU64(&x469, p384Uint1(x467), x456, x443)
	var x470 uint64
	p384CmovznzU64(&x470, p384Uint1(x467), x458, x445)
	var x471 uint64
	p384CmovznzU64(&x471, p384Uint1(x467), x460, x447)
	var x472 uint64
	p384CmovznzU64(&x472, p384Uint1(x467), x462, x449)
	var x473 uint64
	p384CmovznzU64(&x473, p384Uint1(x467), x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}

// p384Square squares a field element in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
//   0 ≤ eval out1 < m
//
func p384Square(out1 *p384MontgomeryDomainFieldElement, arg1 *p384MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x6, arg1[5])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x6, arg1[4])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x6, arg1[3])
	var x13 uint64
	var x14 uint64
	x14, x13 = bits.Mul64(x6, arg1[2])
	var x15 uint64
	var x16 uint64
	x16, x15 = bits.Mul64(x6, arg1[1])
	var x17 uint64
	var x18 uint64
	x18, x17 = bits.Mul64(x6, arg1[0])
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Add64(x18, x15, uint64(0x0))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Add64(x16, x13, uint64(p384Uint1(x20)))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Add64(x14, x11, uint64(p384Uint1(x22)))
	var x25 uint64
	var x26 uint64
	x25, x26 = bits.Add64(x12, x9, uint64(p384Uint1(x24)))
	var x27 uint64
	var x28 uint64
	x27, x28 = bits.Add64(x10, x7, uint64(p384Uint1(x26)))
	x29 := (uint64(p384Uint1(x28)) + x8)
	var x30 uint64
	_, x30 = bits.Mul64(x17, 0x100000001)
	var x32 uint64
	var x33 uint64
	x33, x32 = bits.Mul64(x30, 0xffffffffffffffff)
	var x34 uint64
	var x35 uint64
	x35, x34 = bits.Mul64(x30, 0xffffffffffffffff)
	var x36 uint64
	var x37 uint64
	x37, x36 = bits.Mul64(x30, 0xffffffffffffffff)
	var x38 uint64
	var x39 uint64
	x39, x38 = bits.Mul64(x30, 0xfffffffffffffffe)
	var x40 uint64
	var x41 uint64
	x41, x40 = bits.Mul64(x30, 0xffffffff00000000)
	var x42 uint64
	var x43 uint64
	x43, x42 = bits.Mul64(x30, 0xffffffff)
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x43, x40, uint64(0x0))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x41, x38, uint64(p384Uint1(x45)))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x39, x36, uint64(p384Uint1(x47)))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x37, x34, uint64(p384Uint1(x49)))
	var x52 uint64
	var x53 uint64
	x52, x53 = bits.Add64(x35, x32, uint64(p384Uint1(x51)))
	x54 := (uint64(p384Uint1(x53)) + x33)
	var x56 uint64
	_, x56 = bits.Add64(x17, x42, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x19, x44, uint64(p384Uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x21, x46, uint64(p384Uint1(x58)))
	var x61 uint64
	var x62 uint64
	x61, x62 = bits.Add64(x23, x48, uint64(p384Uint1(x60)))
	var x63 uint64
	var x64 uint64
	x63, x64 = bits.Add64(x25, x50, uint64(p384Uint1(x62)))
	var x65 uint64
	var x66 uint64
	x65, x66 = bits.Add64(x27, x52, uint64(p384Uint1(x64)))
	var x67 uint64
	var x68 uint64
	x67, x68 = bits.Add64(x29, x54, uint64(p384Uint1(x66)))
	var x69 uint64
	var x70 uint64
	x70, x69 = bits.Mul64(x1, arg1[5])
	var x71 uint64
	var x72 uint64
	x72, x71 = bits.Mul64(x1, arg1[4])
	var x73 uint64
	var x74 uint64
	x74, x73 = bits.Mul64(x1, arg1[3])
	var x75 uint64
	var x76 uint64
	x76, x75 = bits.Mul64(x1, arg1[2])
	var x77 uint64
	var x78 uint64
	x78, x77 = bits.Mul64(x1, arg1[1])
	var x79 uint64
	var x80 uint64
	x80, x79 = bits.Mul64(x1, arg1[0])
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x80, x77, uint64(0x0))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x78, x75, uint64(p384Uint1(x82)))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x76, x73, uint64(p384Uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x74, x71, uint64(p384Uint1(x86)))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x72, x69, uint64(p384Uint1(x88)))
	x91 := (uint64(p384Uint1(x90)) + x70)
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x57, x79, uint64(0x0))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x59, x81, uint64(p384Uint1(x93)))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x61, x83, uint64(p384Uint1(x95)))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x63, x85, uint64(p384Uint1(x97)))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x65, x87, uint64(p384Uint1(x99)))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x67, x89, uint64(p384Uint1(x101)))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Add64(uint64(p384Uint1(x68)), x91, uint64(p384Uint1(x103)))
	var x106 uint64
	_, x106 = bits.Mul64(x92, 0x100000001)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x106, 0xffffffffffffffff)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x106, 0xffffffffffffffff)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x106, 0xffffffffffffffff)
	var x114 uint64
	var x115 uint64
	x115, x114 = bits.Mul64(x106, 0xfffffffffffffffe)
	var x116 uint64
	var x117 uint64
	x117, x116 = bits.Mul64(x106, 0xffffffff00000000)
	var x118 uint64
	var x119 uint64
	x119, x118 = bits.Mul64(x106, 0xffffffff)
	var x120 uint64
	var x121 uint64
	x120, x121 = bits.Add64(x119, x116, uint64(0x0))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x117, x114, uint64(p384Uint1(x121)))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x115, x112, uint64(p384Uint1(x123)))
	var x126 uint64
	var x127 uint64
	x126, x127 = bits.Add64(x113, x110, uint64(p384Uint1(x125)))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64(x111, x108, uint64(p384Uint1(x127)))
	x130 := (uint64(p384Uint1(x129)) + x109)
	var x132 uint64
	_, x132 = bits.Add64(x92, x118, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x94, x120, uint64(p384Uint1(x132)))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x96, x122, uint64(p384Uint1(x134)))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x98, x124, uint64(p384Uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x100, x126, uint64(p384Uint1(x138)))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x102, x128, uint64(p384Uint1(x140)))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(x104, x130, uint64(p384Uint1(x142)))
	x145 := (uint64(p384Uint1(x144)) + uint64(p384Uint1(x105)))
	var x146 uint64
	var x147 uint64
	x147, x146 = bits.Mul64(x2, arg1[5])
	var x148 uint64
	var x149 uint64
	x149, x148 = bits.Mul64(x2, arg1[4])
	var x150 uint64
	var x151 uint64
	x151, x150 = bits.Mul64(x2, arg1[3])
	var x152 uint64
	var x153 uint64
	x153, x152 = bits.Mul64(x2, arg1[2])
	var x154 uint64
	var x155 uint64
	x155, x154 = bits.Mul64(x2, arg1[1])
	var x156 uint64
	var x157 uint64
	x157, x156 = bits.Mul64(x2, arg1[0])
	var x158 uint64
	var x159 uint64
	x158, x159 = bits.Add64(x157, x154, uint64(0x0))
	var x160 uint64
	var x161 uint64
	x160, x161 = bits.Add64(x155, x152, uint64(p384Uint1(x159)))
	var x162 uint64
	var x163 uint64
	x162, x163 = bits.Add64(x153, x150, uint64(p384Uint1(x161)))
	var x164 uint64
	var x165 uint64
	x164, x165 = bits.Add64(x151, x148, uint64(p384Uint1(x163)))
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Add64(x149, x146, uint64(p384Uint1(x165)))
	x168 := (uint64(p384Uint1(x167)) + x147)
	var x169 uint64
	var x170 uint64
	x169, x170 = bits.Add64(x133, x156, uint64(0x0))
	var x171 uint64
	var x172 uint64
	x171, x172 = bits.Add64(x135, x158, uint64(p384Uint1(x170)))
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x137, x160, uint64(p384Uint1(x172)))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x139, x162, uint64(p384Uint1(x174)))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x141, x164, uint64(p384Uint1(x176)))
	var x179 uint64
	var x180 uint64
	x179, x180 = bits.Add64(x143, x166, uint64(p384Uint1(x178)))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x145, x168, uint64(p384Uint1(x180)))
	var x183 uint64
	_, x183 = bits.Mul64(x169, 0x100000001)
	var x185 uint64
	var x186 uint64
	x186, x185 = bits.Mul64(x183, 0xffffffffffffffff)
	var x187 uint64
	var x188 uint64
	x188, x187 = bits.Mul64(x183, 0xffffffffffffffff)
	var x189 uint64
	var x190 uint64
	x190, x189 = bits.Mul64(x183, 0xffffffffffffffff)
	var x191 uint64
	var x192 uint64
	x192, x191 = bits.Mul64(x183, 0xfffffffffffffffe)
	var x193 uint64
	var x194 uint64
	x194, x193 = bits.Mul64(x183, 0xffffffff00000000)
	var x195 uint64
	var x196 uint64
	x196, x195 = bits.Mul64(x183, 0xffffffff)
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x196, x193, uint64(0x0))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x194, x191, uint64(p384Uint1(x198)))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x192, x189, uint64(p384Uint1(x200)))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x190, x187, uint64(p384Uint1(x202)))
	var x205 uint64
	var x206 uint64
	x205, x206 = bits.Add64(x188, x185, uint64(p384Uint1(x204)))
	x207 := (uint64(p384Uint1(x206)) + x186)
	var x209 uint64
	_, x209 = bits.Add64(x169, x195, uint64(0x0))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Add64(x171, x197, uint64(p384Uint1(x209)))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Add64(x173, x199, uint64(p384Uint1(x211)))
	var x214 uint64
	var x215 uint64
	x214, x215 = bits.Add64(x175, x201, uint64(p384Uint1(x213)))
	var x216 uint64
	var x217 uint64
	x216, x217 = bits.Add64(x177, x203, uint64(p384Uint1(x215)))
	var x218 uint64
	var x219 uint64
	x218, x219 = bits.Add64(x179, x205, uint64(p384Uint1(x217)))
	var x220 uint64
	var x221 uint64
	x220, x221 = bits.Add64(x181, x207, uint64(p384Uint1(x219)))
	x222 := (uint64(p384Uint1(x221)) + uint64(p384Uint1(x182)))
	var x223 uint64
	var x224 uint64
	x224, x223 = bits.Mul64(x3, arg1[5])
	var x225 uint64
	var x226 uint64
	x226, x225 = bits.Mul64(x3, arg1[4])
	var x227 uint64
	var x228 uint64
	x228, x227 = bits.Mul64(x3, arg1[3])
	var x229 uint64
	var x230 uint64
	x230, x229 = bits.Mul64(x3, arg1[2])
	var x231 uint64
	var x232 uint64
	x232, x231 = bits.Mul64(x3, arg1[1])
	var x233 uint64
	var x234 uint64
	x234, x233 = bits.Mul64(x3, arg1[0])
	var x235 uint64
	var x236 uint64
	x235, x236 = bits.Add64(x234, x231, uint64(0x0))
	var x237 uint64
	var x238 uint64
	x237, x238 = bits.Add64(x232, x229, uint64(p384Uint1(x236)))
	var x239 uint64
	var x240 uint64
	x239, x240 = bits.Add64(x230, x227, uint64(p384Uint1(x238)))
	var x241 uint64
	var x242 uint64
	x241, x242 = bits.Add64(x228, x225, uint64(p384Uint1(x240)))
	var x243 uint64
	var x244 uint64
	x243, x244 = bits.Add64(x226, x223, uint64(p384Uint1(x242)))
	x245 := (uint64(p384Uint1(x244)) + x224)
	var x246 uint64
	var x247 uint64
	x246, x247 = bits.Add64(x210, x233, uint64(0x0))
	var x248 uint64
	var x249 uint64
	x248, x249 = bits.Add64(x212, x235, uint64(p384Uint1(x247)))
	var x250 uint64
	var x251 uint64
	x250, x251 = bits.Add64(x214, x237, uint64(p384Uint1(x249)))
	var x252 uint64
	var x253 uint64
	x252, x253 = bits.Add64(x216, x239, uint64(p384Uint1(x251)))
	var x254 uint64
	var x255 uint64
	x254, x255 = bits.Add64(x218, x241, uint64(p384Uint1(x253)))
	var x256 uint64
	var x257 uint64
	x256, x257 = bits.Add64(x220, x243, uint64(p384Uint1(x255)))
	var x258 uint64
	var x259 uint64
	x258, x259 = bits.Add64(x222, x245, uint64(p384Uint1(x257)))
	var x260 uint64
	_, x260 = bits.Mul64(x246, 0x100000001)
	var x262 uint64
	var x263 uint64
	x263, x262 = bits.Mul64(x260, 0xffffffffffffffff)
	var x264 uint64
	var x265 uint64
	x265, x264 = bits.Mul64(x260, 0xffffffffffffffff)
	var x266 uint64
	var x267 uint64
	x267, x266 = bits.Mul64(x260, 0xffffffffffffffff)
	var x268 uint64
	var x269 uint64
	x269, x268 = bits.Mul64(x260, 0xfffffffffffffffe)
	var x270 uint64
	var x271 uint64
	x271, x270 = bits.Mul64(x260, 0xffffffff00000000)
	var x272 uint64
	var x273 uint64
	x273, x272 = bits.Mul64(x260, 0xffffffff)
	var x274 uint64
	var x275 uint64
	x274, x275 = bits.Add64(x273, x270, uint64(0x0))
	var x276 uint64
	var x277 uint64
	x276, x277 = bits.Add64(x271, x268, uint64(p384Uint1(x275)))
	var x278 uint64
	var x279 uint64
	x278, x279 = bits.Add64(x269, x266, uint64(p384Uint1(x277)))
	var x280 uint64
	var x281 uint64
	x280, x281 = bits.Add64(x267, x264, uint64(p384Uint1(x279)))
	var x282 uint64
	var x283 uint64
	x282, x283 = bits.Add64(x265, x262, uint64(p384Uint1(x281)))
	x284 := (uint64(p384Uint1(x283)) + x263)
	var x286 uint64
	_, x286 = bits.Add64(x246, x272, uint64(0x0))
	var x287 uint64
	var x288 uint64
	x287, x288 = bits.Add64(x248, x274, uint64(p384Uint1(x286)))
	var x289 uint64
	var x290 uint64
	x289, x290 = bits.Add64(x250, x276, uint64(p384Uint1(x288)))
	var x291 uint64
	var x292 uint64
	x291, x292 = bits.Add64(x252, x278, uint64(p384Uint1(x290)))
	var x293 uint64
	var x294 uint64
	x293, x294 = bits.Add64(x254, x280, uint64(p384Uint1(x292)))
	var x295 uint64
	var x296 uint64
	x295, x296 = bits.Add64(x256, x282, uint64(p384Uint1(x294)))
	var x297 uint64
	var x298 uint64
	x297, x298 = bits.Add64(x258, x284, uint64(p384Uint1(x296)))
	x299 := (uint64(p384Uint1(x298)) + uint64(p384Uint1(x259)))
	var x300 uint64
	var x301 uint64
	x301, x300 = bits.Mul64(x4, arg1[5])
	var x302 uint64
	var x303 uint64
	x303, x302 = bits.Mul64(x4, arg1[4])
	var x304 uint64
	var x305 uint64
	x305, x304 = bits.Mul64(x4, arg1[3])
	var x306 uint64
	var x307 uint64
	x307, x306 = bits.Mul64(x4, arg1[2])
	var x308 uint64
	var x309 uint64
	x309, x308 = bits.Mul64(x4, arg1[1])
	var x310 uint64
	var x311 uint64
	x311, x310 = bits.Mul64(x4, arg1[0])
	var x312 uint64
	var x313 uint64
	x312, x313 = bits.Add64(x311, x308, uint64(0x0))
	var x314 uint64
	var x315 uint64
	x314, x315 = bits.Add64(x309, x306, uint64(p384Uint1(x313)))
	var x316 uint64
	var x317 uint64
	x316, x317 = bits.Add64(x307, x304, uint64(p384Uint1(x315)))
	var x318 uint64
	var x319 uint64
	x318, x319 = bits.Add64(x305, x302, uint64(p384Uint1(x317)))
	var x320 uint64
	var x321 uint64
	x320, x321 = bits.Add64(x303, x300, uint64(p384Uint1(x319)))
	x322 := (uint64(p384Uint1(x321)) + x301)
	var x323 uint64
	var x324 uint64
	x323, x324 = bits.Add64(x287, x310, uint64(0x0))
	var x325 uint64
	var x326 uint64
	x325, x326 = bits.Add64(x289, x312, uint64(p384Uint1(x324)))
	var x327 uint64
	var x328 uint64
	x327, x328 = bits.Add64(x291, x314, uint64(p384Uint1(x326)))
	var x329 uint64
	var x330 uint64
	x329, x330 = bits.Add64(x293, x316, uint64(p384Uint1(x328)))
	var x331 uint64
	var x332 uint64
	x331, x332 = bits.Add64(x295, x318, uint64(p384Uint1(x330)))
	var x333 uint64
	var x334 uint64
	x333, x334 = bits.Add64(x297, x320, uint64(p384Uint1(x332)))
	var x335 uint64
	var x336 uint64
	x335, x336 = bits.Add64(x299, x322, uint64(p384Uint1(x334)))
	var x337 uint64
	_, x337 = bits.Mul64(x323, 0x100000001)
	var x339 uint64
	var x340 uint64
	x340, x339 = bits.Mul64(x337, 0xffffffffffffffff)
	var x341 uint64
	var x342 uint64
	x342, x341 = bits.Mul64(x337, 0xffffffffffffffff)
	var x343 uint64
	var x344 uint64
	x344, x343 = bits.Mul64(x337, 0xffffffffffffffff)
	var x345 uint64
	var x346 uint64
	x346, x345 = bits.Mul64(x337, 0xfffffffffffffffe)
	var x347 uint64
	var x348 uint64
	x348, x347 = bits.Mul64(x337, 0xffffffff00000000)
	var x349 uint64
	var x350 uint64
	x350, x349 = bits.Mul64(x337, 0xffffffff)
	var x351 uint64
	var x352 uint64
	x351, x352 = bits.Add64(x350, x347, uint64(0x0))
	var x353 uint64
	var x354 uint64
	x353, x354 = bits.Add64(x348, x345, uint64(p384Uint1(x352)))
	var x355 uint64
	var x356 uint64
	x355, x356 = bits.Add64(x346, x343, uint64(p384Uint1(x354)))
	var x357 uint64
	var x358 uint64
	x357, x358 = bits.Add64(x344, x341, uint64(p384Uint1(x356)))
	var x359 uint64
	var x360 uint64
	x359, x360 = bits.Add64(x342, x339, uint64(p384Uint1(x358)))
	x361 := (uint64(p384Uint1(x360)) + x340)
	var x363 uint64
	_, x363 = bits.Add64(x323, x349, uint64(0x0))
	var x364 uint64
	var x365 uint64
	x364, x365 = bits.Add64(x325, x351, uint64(p384Uint1(x363)))
	var x366 uint64
	var x367 uint64
	x366, x367 = bits.Add64(x327, x353, uint64(p384Uint1(x365)))
	var x368 uint64
	var x369 uint64
	x368, x369 = bits.Add64(x329, x355, uint64(p384Uint1(x367)))
	var x370 uint64
	var x371 uint64
	x370, x371 = bits.Add64(x331, x357, uint64(p384Uint1(x369)))
	var x372 uint64
	var x373 uint64
	x372, x373 = bits.Add64(x333, x359, uint64(p384Uint1(x371)))
	var x374 uint64
	var x375 uint64
	x374, x375 = bits.Add64(x335, x361, uint64(p384Uint1(x373)))
	x376 := (uint64(p384Uint1(x375)) + uint64(p384Uint1(x336)))
	var x377 uint64
	var x378 uint64
	x378, x377 = bits.Mul64(x5, arg1[5])
	var x379 uint64
	var x380 uint64
	x380, x379 = bits.Mul64(x5, arg1[4])
	var x381 uint64
	var x382 uint64
	x382, x381 = bits.Mul64(x5, arg1[3])
	var x383 uint64
	var x384 uint64
	x384, x383 = bits.Mul64(x5, arg1[2])
	var x385 uint64
	var x386 uint64
	x386, x385 = bits.Mul64(x5, arg1[1])
	var x387 uint64
	var x388 uint64
	x388, x387 = bits.Mul64(x5, arg1[0])
	var x389 uint64
	var x390 uint64
	x389, x390 = bits.Add64(x388, x385, uint64(0x0))
	var x391 uint64
	var x392 uint64
	x391, x392 = bits.Add64(x386, x383, uint64(p384Uint1(x390)))
	var x393 uint64
	var x394 uint64
	x393, x394 = bits.Add64(x384, x381, uint64(p384Uint1(x392)))
	var x395 uint64
	var x396 uint64
	x395, x396 = bits.Add64(x382, x379, uint64(p384Uint1(x394)))
	var x397 uint64
	var x398 uint64
	x397, x398 = bits.Add64(x380, x377, uint64(p384Uint1(x396)))
	x399 := (uint64(p384Uint1(x398)) + x378)
	var x400 uint64
	var x401 uint64
	x400, x401 = bits.Add64(x364, x387, uint64(0x0))
	var x402 uint64
	var x403 uint64
	x402, x403 = bits.Add64(x366, x389, uint64(p384Uint1(x401)))
	var x404 uint64
	var x405 uint64
	x404, x405 = bits.Add64(x368, x391, uint64(p384Uint1(x403)))
	var x406 uint64
	var x407 uint64
	x406, x407 = bits.Add64(x370, x393, uint64(p384Uint1(x405)))
	var x408 uint64
	var x409 uint64
	x408, x409 = bits.Add64(x372, x395, uint64(p384Uint1(x407)))
	var x410 uint64
	var x411 uint64
	x410, x411 = bits.Add64(x374, x397, uint64(p384Uint1(x409)))
	var x412 uint64
	var x413 uint64
	x412, x413 = bits.Add64(x376, x399, uint64(p384Uint1(x411)))
	var x414 uint64
	_, x414 = bits.Mul64(x400, 0x100000001)
	var x416 uint64
	var x417 uint64
	x417, x416 = bits.Mul64(x414, 0xffffffffffffffff)
	var x418 uint64
	var x419 uint64
	x419, x418 = bits.Mul64(x414, 0xffffffffffffffff)
	var x420 uint64
	var x421 uint64
	x421, x420 = bits.Mul64(x414, 0xffffffffffffffff)
	var x422 uint64
	var x423 uint64
	x423, x422 = bits.Mul64(x414, 0xfffffffffffffffe)
	var x424 uint64
	var x425 uint64
	x425, x424 = bits.Mul64(x414, 0xffffffff00000000)
	var x426 uint64
	var x427 uint64
	x427, x426 = bits.Mul64(x414, 0xffffffff)
	var x428 uint64
	var x429 uint64
	x428, x429 = bits.Add64(x427, x424, uint64(0x0))
	var x430 uint64
	var x431 uint64
	x430, x431 = bits.Add64(x425, x422, uint64(p384Uint1(x429)))
	var x432 uint64
	var x433 uint64
	x432, x433 = bits.Add64(x423, x420, uint64(p384Uint1(x431)))
	var x434 uint64
	var x435 uint64
	x434, x435 = bits.Add64(x421, x418, uint64(p384Uint1(x433)))
	var x436 uint64
	var x437 uint64
	x436, x437 = bits.Add64(x419, x416, uint64(p384Uint1(x435)))
	x438 := (uint64(p384Uint1(x437)) + x417)
	var x440 uint64
	_, x440 = bits.Add64(x400, x426, uint64(0x0))
	var x441 uint64
	var x442 uint64
	x441, x442 = bits.Add64(x402, x428, uint64(p384Uint1(x440)))
	var x443 uint64
	var x444 uint64
	x443, x444 = bits.Add64(x404, x430, uint64(p384Uint1(x442)))
	var x445 uint64
	var x446 uint64
	x445, x446 = bits.Add64(x406, x432, uint64(p384Uint1(x444)))
	var x447 uint64
	var x448 uint64
	x447, x448 = bits.Add64(x408, x434, uint64(p384Uint1(x446)))
	var x449 uint64
	var x450 uint64
	x449, x450 = bits.Add64(x410, x436, uint64(p384Uint1(x448)))
	var x451 uint64
	var x452 uint64
	x451, x452 = bits.Add64(x412, x438, uint64(p384Uint1(x450)))
	x453 := (uint64(p384Uint1(x452)) + uint64(p384Uint1(x413)))
	var x454 uint64
	var x455 uint64
	x454, x455 = bits.Sub64(x441, 0xffffffff, uint64(0x0))
	var x456 uint64
	var x457 uint64
	x456, x457 = bits.Sub64(x443, 0xffffffff00000000, uint64(p384Uint1(x455)))
	var x458 uint64
	var x459 uint64
	x458, x459 = bits.Sub64(x445, 0xfffffffffffffffe, uint64(p384Uint1(x457)))
	var x460 uint64
	var x461 uint64
	x460, x461 = bits.Sub64(x447, 0xffffffffffffffff, uint64(p384Uint1(x459)))
	var x462 uint64
	var x463 uint64
	x462, x463 = bits.Sub64(x449, 0xffffffffffffffff, uint64(p384Uint1(x461)))
	var x464 uint64
	var x465 uint64
	x464, x465 = bits.Sub64(x451, 0xffffffffffffffff, uint64(p384Uint1(x463)))
	var x467 uint64
	_, x467 = bits.Sub64(x453, uint64(0x0), uint64(p384Uint1(x465)))
	var x468 uint64
	p384CmovznzU64(&x468, p384Uint1(x467), x454, x441)
	var x469 uint64
	p384CmovznzU64(&x469, p384Uint1(x467), x456, x443)
	var x470 uint64
	p384CmovznzU64(&x470, p384Uint1(x467), x458, x445)
	var x471 uint64
	p384CmovznzU64(&x471, p384Uint1(x467), x460, x447)
	var x472 uint64
	p384CmovznzU64(&x472, p384Uint1(x467), x462, x449)
	var x473 uint64
	p384CmovznzU64(&x473, p384Uint1(x467), x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}

// p384Add adds two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
func p384Add(out1 *p384MontgomeryDomainFieldElement, arg1 *p384MontgomeryDomainFieldElement, arg2 *p384MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Add64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Add64(arg1[1], arg2[1], uint64(p384Uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Add64(arg1[2], arg2[2], uint64(p384Uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Add64(arg1[3], arg2[3], uint64(p384Uint1(x6)))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Add64(arg1[4], arg2[4], uint64(p384Uint1(x8)))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Add64(arg1[5], arg2[5], uint64(p384Uint1(x10)))
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Sub64(x1, 0xffffffff, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Sub64(x3, 0xffffffff00000000, uint64(p384Uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Sub64(x5, 0xfffffffffffffffe, uint64(p384Uint1(x16)))
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Sub64(x7, 0xffffffffffffffff, uint64(p384Uint1(x18)))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Sub64(x9, 0xffffffffffffffff, uint64(p384Uint1(x20)))
	var x23 uint64
	var x24 uint64
	x23, x24 = bits.Sub64(x11, 0xffffffffffffffff, uint64(p384Uint1(x22)))
	var x26 uint64
	_, x26 = bits.Sub64(uint64(p384Uint1(x12)), uint64(0x0), uint64(p384Uint1(x24)))
	var x27 uint64
	p384CmovznzU64(&x27, p384Uint1(x26), x13, x1)
	var x28 uint64
	p384CmovznzU64(&x28, p384Uint1(x26), x15, x3)
	var x29 uint64
	p384CmovznzU64(&x29, p384Uint1(x26), x17, x5)
	var x30 uint64
	p384CmovznzU64(&x30, p384Uint1(x26), x19, x7)
	var x31 uint64
	p384CmovznzU64(&x31, p384Uint1(x26), x21, x9)
	var x32 uint64
	p384CmovznzU64(&x32, p384Uint1(x26), x23, x11)
	out1[0] = x27
	out1[1] = x28
	out1[2] = x29
	out1[3] = x30
	out1[4] = x31
	out1[5] = x32
}

// p384Sub subtracts two field elements in the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
//   0 ≤ eval arg2 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
//   0 ≤ eval out1 < m
//
func p384Sub(out1 *p384MontgomeryDomainFieldElement, arg1 *p384MontgomeryDomainFieldElement, arg2 *p384MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Sub64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Sub64(arg1[1], arg2[1], uint64(p384Uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Sub64(arg1[2], arg2[2], uint64(p384Uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Sub64(arg1[3], arg2[3], uint64(p384Uint1(x6)))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Sub64(arg1[4], arg2[4], uint64(p384Uint1(x8)))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Sub64(arg1[5], arg2[5], uint64(p384Uint1(x10)))
	var x13 uint64
	p384CmovznzU64(&x13, p384Uint1(x12), uint64(0x0), 0xffffffffffffffff)
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x1, (x13 & 0xffffffff), uint64(0x0))
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(x3, (x13 & 0xffffffff00000000), uint64(p384Uint1(x15)))
	var x18 uint64
	var x19 uint64
	x18, x19 = bits.Add64(x5, (x13 & 0xfffffffffffffffe), uint64(p384Uint1(x17)))
	var x20 uint64
	var x21 uint64
	x20, x21 = bits.Add64(x7, x13, uint64(p384Uint1(x19)))
	var x22 uint64
	var x23 uint64
	x22, x23 = bits.Add64(x9, x13, uint64(p384Uint1(x21)))
	var x24 uint64
	x24, _ = bits.Add64(x11, x13, uint64(p384Uint1(x23)))
	out1[0] = x14
	out1[1] = x16
	out1[2] = x18
	out1[3] = x20
	out1[4] = x22
	out1[5] = x24
}

// p384SetOne returns the field element one in the Montgomery domain.
//
// Postconditions:
//   eval (from_montgomery out1) mod m = 1 mod m
//   0 ≤ eval out1 < m
//
func p384SetOne(out1 *p384MontgomeryDomainFieldElement) {
	out1[0] = 0xffffffff00000001
	out1[1] = 0xffffffff
	out1[2] = uint64(0x1)
	out1[3] = uint64(0x0)
	out1[4] = uint64(0x0)
	out1[5] = uint64(0x0)
}

// p384FromMontgomery translates a field element out of the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
// Postconditions:
//   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m
//   0 ≤ eval out1 < m
//
func p384FromMontgomery(out1 *p384NonMontgomeryDomainFieldElement, arg1 *p384MontgomeryDomainFieldElement) {
	x1 := arg1[0]
	var x2 uint64
	_, x2 = bits.Mul64(x1, 0x100000001)
	var x4 uint64
	var x5 uint64
	x5, x4 = bits.Mul64(x2, 0xffffffffffffffff)
	var x6 uint64
	var x7 uint64
	x7, x6 = bits.Mul64(x2, 0xffffffffffffffff)
	var x8 uint64
	var x9 uint64
	x9, x8 = bits.Mul64(x2, 0xffffffffffffffff)
	var x10 uint64
	var x11 uint64
	x11, x10 = bits.Mul64(x2, 0xfffffffffffffffe)
	var x12 uint64
	var x13 uint64
	x13, x12 = bits.Mul64(x2, 0xffffffff00000000)
	var x14 uint64
	var x15 uint64
	x15, x14 = bits.Mul64(x2, 0xffffffff)
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(x15, x12, uint64(0x0))
	var x18 uint64
	var x19 uint64
	x18, x19 = bits.Add64(x13, x10, uint64(p384Uint1(x17)))
	var x20 uint64
	var x21 uint64
	x20, x21 = bits.Add64(x11, x8, uint64(p384Uint1(x19)))
	var x22 uint64
	var x23 uint64
	x22, x23 = bits.Add64(x9, x6, uint64(p384Uint1(x21)))
	var x24 uint64
	var x25 uint64
	x24, x25 = bits.Add64(x7, x4, uint64(p384Uint1(x23)))
	var x27 uint64
	_, x27 = bits.Add64(x1, x14, uint64(0x0))
	var x28 uint64
	var x29 uint64
	x28, x29 = bits.Add64(uint64(0x0), x16, uint64(p384Uint1(x27)))
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(uint64(0x0), x18, uint64(p384Uint1(x29)))
	var x32 uint64
	var x33 uint64
	x32, x33 = bits.Add64(uint64(0x0), x20, uint64(p384Uint1(x31)))
	var x34 uint64
	var x35 uint64
	x34, x35 = bits.Add64(uint64(0x0), x22, uint64(p384Uint1(x33)))
	var x36 uint64
	var x37 uint64
	x36, x37 = bits.Add64(uint64(0x0), x24, uint64(p384Uint1(x35)))
	var x38 uint64
	var x39 uint64
	x38, x39 = bits.Add64(uint64(0x0), (uint64(p384Uint1(x25)) + x5), uint64(p384Uint1(x37)))
	var x40 uint64
	var x41 uint64
	x40, x41 = bits.Add64(x28, arg1[1], uint64(0x0))
	var x42 uint64
	var x43 uint64
	x42, x43 = bits.Add64(x30, uint64(0x0), uint64(p384Uint1(x41)))
	var x44 uint64
	var x45 uint64
	x44, x45 = bits.Add64(x32, uint64(0x0), uint64(p384Uint1(x43)))
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x34, uint64(0x0), uint64(p384Uint1(x45)))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x36, uint64(0x0), uint64(p384Uint1(x47)))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x38, uint64(0x0), uint64(p384Uint1(x49)))
	var x52 uint64
	_, x52 = bits.Mul64(x40, 0x100000001)
	var x54 uint64
	var x55 uint64
	x55, x54 = bits.Mul64(x52, 0xffffffffffffffff)
	var x56 uint64
	var x57 uint64
	x57, x56 = bits.Mul64(x52, 0xffffffffffffffff)
	var x58 uint64
	var x59 uint64
	x59, x58 = bits.Mul64(x52, 0xffffffffffffffff)
	var x60 uint64
	var x61 uint64
	x61, x60 = bits.Mul64(x52, 0xfffffffffffffffe)
	var x62 uint64
	var x63 uint64
	x63, x62 = bits.Mul64(x52, 0xffffffff00000000)
	var x64 uint64
	var x65 uint64
	x65, x64 = bits.Mul64(x52, 0xffffffff)
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(x65, x62, uint64(0x0))
	var x68 uint64
	var x69 uint64
	x68, x69 = bits.Add64(x63, x60, uint64(p384Uint1(x67)))
	var x70 uint64
	var x71 uint64
	x70, x71 = bits.Add64(x61, x58, uint64(p384Uint1(x69)))
	var x72 uint64
	var x73 uint64
	x72, x73 = bits.Add64(x59, x56, uint64(p384Uint1(x71)))
	var x74 uint64
	var x75 uint64
	x74, x75 = bits.Add64(x57, x54, uint64(p384Uint1(x73)))
	var x77 uint64
	_, x77 = bits.Add64(x40, x64, uint64(0x0))
	var x78 uint64
	var x79 uint64
	x78, x79 = bits.Add64(x42, x66, uint64(p384Uint1(x77)))
	var x80 uint64
	var x81 uint64
	x80, x81 = bits.Add64(x44, x68, uint64(p384Uint1(x79)))
	var x82 uint64
	var x83 uint64
	x82, x83 = bits.Add64(x46, x70, uint64(p384Uint1(x81)))
	var x84 uint64
	var x85 uint64
	x84, x85 = bits.Add64(x48, x72, uint64(p384Uint1(x83)))
	var x86 uint64
	var x87 uint64
	x86, x87 = bits.Add64(x50, x74, uint64(p384Uint1(x85)))
	var x88 uint64
	var x89 uint64
	x88, x89 = bits.Add64((uint64(p384Uint1(x51)) + uint64(p384Uint1(x39))), (uint64(p384Uint1(x75)) + x55), uint64(p384Uint1(x87)))
	var x90 uint64
	var x91 uint64
	x90, x91 = bits.Add64(x78, arg1[2], uint64(0x0))
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x80, uint64(0x0), uint64(p384Uint1(x91)))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x82, uint64(0x0), uint64(p384Uint1(x93)))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x84, uint64(0x0), uint64(p384Uint1(x95)))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x86, uint64(0x0), uint64(p384Uint1(x97)))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x88, uint64(0x0), uint64(p384Uint1(x99)))
	var x102 uint64
	_, x102 = bits.Mul64(x90, 0x100000001)
	var x104 uint64
	var x105 uint64
	x105, x104 = bits.Mul64(x102, 0xffffffffffffffff)
	var x106 uint64
	var x107 uint64
	x107, x106 = bits.Mul64(x102, 0xffffffffffffffff)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x102, 0xffffffffffffffff)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x102, 0xfffffffffffffffe)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x102, 0xffffffff00000000)
	var x114 uint64
	var x115 uint64
	x115, x114 = bits.Mul64(x102, 0xffffffff)
	var x116 uint64
	var x117 uint64
	x116, x117 = bits.Add64(x115, x112, uint64(0x0))
	var x118 uint64
	var x119 uint64
	x118, x119 = bits.Add64(x113, x110, uint64(p384Uint1(x117)))
	var x120 uint64
	var x121 uint64
	x120, x121 = bits.Add64(x111, x108, uint64(p384Uint1(x119)))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x109, x106, uint64(p384Uint1(x121)))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x107, x104, uint64(p384Uint1(x123)))
	var x127 uint64
	_, x127 = bits.Add64(x90, x114, uint64(0x0))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64(x92, x116, uint64(p384Uint1(x127)))
	var x130 uint64
	var x131 uint64
	x130, x131 = bits.Add64(x94, x118, uint64(p384Uint1(x129)))
	var x132 uint64
	var x133 uint64
	x132, x133 = bits.Add64(x96, x120, uint64(p384Uint1(x131)))
	var x134 uint64
	var x135 uint64
	x134, x135 = bits.Add64(x98, x122, uint64(p384Uint1(x133)))
	var x136 uint64
	var x137 uint64
	x136, x137 = bits.Add64(x100, x124, uint64(p384Uint1(x135)))
	var x138 uint64
	var x139 uint64
	x138, x139 = bits.Add64((uint64(p384Uint1(x101)) + uint64(p384Uint1(x89))), (uint64(p384Uint1(x125)) + x105), uint64(p384Uint1(x137)))
	var x140 uint64
	var x141 uint64
	x140, x141 = bits.Add64(x128, arg1[3], uint64(0x0))
	var x142 uint64
	var x143 uint64
	x142, x143 = bits.Add64(x130, uint64(0x0), uint64(p384Uint1(x141)))
	var x144 uint64
	var x145 uint64
	x144, x145 = bits.Add64(x132, uint64(0x0), uint64(p384Uint1(x143)))
	var x146 uint64
	var x147 uint64
	x146, x147 = bits.Add64(x134, uint64(0x0), uint64(p384Uint1(x145)))
	var x148 uint64
	var x149 uint64
	x148, x149 = bits.Add64(x136, uint64(0x0), uint64(p384Uint1(x147)))
	var x150 uint64
	var x151 uint64
	x150, x151 = bits.Add64(x138, uint64(0x0), uint64(p384Uint1(x149)))
	var x152 uint64
	_, x152 = bits.Mul64(x140, 0x100000001)
	var x154 uint64
	var x155 uint64
	x155, x154 = bits.Mul64(x152, 0xffffffffffffffff)
	var x156 uint64
	var x157 uint64
	x157, x156 = bits.Mul64(x152, 0xffffffffffffffff)
	var x158 uint64
	var x159 uint64
	x159, x158 = bits.Mul64(x152, 0xffffffffffffffff)
	var x160 uint64
	var x161 uint64
	x161, x160 = bits.Mul64(x152, 0xfffffffffffffffe)
	var x162 uint64
	var x163 uint64
	x163, x162 = bits.Mul64(x152, 0xffffffff00000000)
	var x164 uint64
	var x165 uint64
	x165, x164 = bits.Mul64(x152, 0xffffffff)
	var x166 uint64
	var x167 uint64
	x166, x167 = bits.Add64(x165, x162, uint64(0x0))
	var x168 uint64
	var x169 uint64
	x168, x169 = bits.Add64(x163, x160, uint64(p384Uint1(x167)))
	var x170 uint64
	var x171 uint64
	x170, x171 = bits.Add64(x161, x158, uint64(p384Uint1(x169)))
	var x172 uint64
	var x173 uint64
	x172, x173 = bits.Add64(x159, x156, uint64(p384Uint1(x171)))
	var x174 uint64
	var x175 uint64
	x174, x175 = bits.Add64(x157, x154, uint64(p384Uint1(x173)))
	var x177 uint64
	_, x177 = bits.Add64(x140, x164, uint64(0x0))
	var x178 uint64
	var x179 uint64
	x178, x179 = bits.Add64(x142, x166, uint64(p384Uint1(x177)))
	var x180 uint64
	var x181 uint64
	x180, x181 = bits.Add64(x144, x168, uint64(p384Uint1(x179)))
	var x182 uint64
	var x183 uint64
	x182, x183 = bits.Add64(x146, x170, uint64(p384Uint1(x181)))
	var x184 uint64
	var x185 uint64
	x184, x185 = bits.Add64(x148, x172, uint64(p384Uint1(x183)))
	var x186 uint64
	var x187 uint64
	x186, x187 = bits.Add64(x150, x174, uint64(p384Uint1(x185)))
	var x188 uint64
	var x189 uint64
	x188, x189 = bits.Add64((uint64(p384Uint1(x151)) + uint64(p384Uint1(x139))), (uint64(p384Uint1(x175)) + x155), uint64(p384Uint1(x187)))
	var x190 uint64
	var x191 uint64
	x190, x191 = bits.Add64(x178, arg1[4], uint64(0x0))
	var x192 uint64
	var x193 uint64
	x192, x193 = bits.Add64(x180, uint64(0x0), uint64(p384Uint1(x191)))
	var x194 uint64
	var x195 uint64
	x194, x195 = bits.Add64(x182, uint64(0x0), uint64(p384Uint1(x193)))
	var x196 uint64
	var x197 uint64
	x196, x197 = bits.Add64(x184, uint64(0x0), uint64(p384Uint1(x195)))
	var x198 uint64
	var x199 uint64
	x198, x199 = bits.Add64(x186, uint64(0x0), uint64(p384Uint1(x197)))
	var x200 uint64
	var x201 uint64
	x200, x201 = bits.Add64(x188, uint64(0x0), uint64(p384Uint1(x199)))
	var x202 uint64
	_, x202 = bits.Mul64(x190, 0x100000001)
	var x204 uint64
	var x205 uint64
	x205, x204 = bits.Mul64(x202, 0xffffffffffffffff)
	var x206 uint64
	var x207 uint64
	x207, x206 = bits.Mul64(x202, 0xffffffffffffffff)
	var x208 uint64
	var x209 uint64
	x209, x208 = bits.Mul64(x202, 0xffffffffffffffff)
	var x210 uint64
	var x211 uint64
	x211, x210 = bits.Mul64(x202, 0xfffffffffffffffe)
	var x212 uint64
	var x213 uint64
	x213, x212 = bits.Mul64(x202, 0xffffffff00000000)
	var x214 uint64
	var x215 uint64
	x215, x214 = bits.Mul64(x202, 0xffffffff)
	var x216 uint64
	var x217 uint64
	x216, x217 = bits.Add64(x215, x212, uint64(0x0))
	var x218 uint64
	var x219 uint64
	x218, x219 = bits.Add64(x213, x210, uint64(p384Uint1(x217)))
	var x220 uint64
	var x221 uint64
	x220, x221 = bits.Add64(x211, x208, uint64(p384Uint1(x219)))
	var x222 uint64
	var x223 uint64
	x222, x223 = bits.Add64(x209, x206, uint64(p384Uint1(x221)))
	var x224 uint64
	var x225 uint64
	x224, x225 = bits.Add64(x207, x204, uint64(p384Uint1(x223)))
	var x227 uint64
	_, x227 = bits.Add64(x190, x214, uint64(0x0))
	var x228 uint64
	var x229 uint64
	x228, x229 = bits.Add64(x192, x216, uint64(p384Uint1(x227)))
	var x230 uint64
	var x231 uint64
	x230, x231 = bits.Add64(x194, x218, uint64(p384Uint1(x229)))
	var x232 uint64
	var x233 uint64
	x232, x233 = bits.Add64(x196, x220, uint64(p384Uint1(x231)))
	var x234 uint64
	var x235 uint64
	x234, x235 = bits.Add64(x198, x222, uint64(p384Uint1(x233)))
	var x236 uint64
	var x237 uint64
	x236, x237 = bits.Add64(x200, x224, uint64(p384Uint1(x235)))
	var x238 uint64
	var x239 uint64
	x238, x239 = bits.Add64((uint64(p384Uint1(x201)) + uint64(p384Uint1(x189))), (uint64(p384Uint1(x225)) + x205), uint64(p384Uint1(x237)))
	var x240 uint64
	var x241 uint64
	x240, x241 = bits.Add64(x228, arg1[5], uint64(0x0))
	var x242 uint64
	var x243 uint64
	x242, x243 = bits.Add64(x230, uint64(0x0), uint64(p384Uint1(x241)))
	var x244 uint64
	var x245 uint64
	x244, x245 = bits.Add64(x232, uint64(0x0), uint64(p384Uint1(x243)))
	var x246 uint64
	var x247 uint64
	x246, x247 = bits.Add64(x234, uint64(0x0), uint64(p384Uint1(x245)))
	var x248 uint64
	var x249 uint64
	x248, x249 = bits.Add64(x236, uint64(0x0), uint64(p384Uint1(x247)))
	var x250 uint64
	var x251 uint64
	x250, x251 = bits.Add64(x238, uint64(0x0), uint64(p384Uint1(x249)))
	var x252 uint64
	_, x252 = bits.Mul64(x240, 0x100000001)
	var x254 uint64
	var x255 uint64
	x255, x254 = bits.Mul64(x252, 0xffffffffffffffff)
	var x256 uint64
	var x257 uint64
	x257, x256 = bits.Mul64(x252, 0xffffffffffffffff)
	var x258 uint64
	var x259 uint64
	x259, x258 = bits.Mul64(x252, 0xffffffffffffffff)
	var x260 uint64
	var x261 uint64
	x261, x260 = bits.Mul64(x252, 0xfffffffffffffffe)
	var x262 uint64
	var x263 uint64
	x263, x262 = bits.Mul64(x252, 0xffffffff00000000)
	var x264 uint64
	var x265 uint64
	x265, x264 = bits.Mul64(x252, 0xffffffff)
	var x266 uint64
	var x267 uint64
	x266, x267 = bits.Add64(x265, x262, uint64(0x0))
	var x268 uint64
	var x269 uint64
	x268, x269 = bits.Add64(x263, x260, uint64(p384Uint1(x267)))
	var x270 uint64
	var x271 uint64
	x270, x271 = bits.Add64(x261, x258, uint64(p384Uint1(x269)))
	var x272 uint64
	var x273 uint64
	x272, x273 = bits.Add64(x259, x256, uint64(p384Uint1(x271)))
	var x274 uint64
	var x275 uint64
	x274, x275 = bits.Add64(x257, x254, uint64(p384Uint1(x273)))
	var x277 uint64
	_, x277 = bits.Add64(x240, x264, uint64(0x0))
	var x278 uint64
	var x279 uint64
	x278, x279 = bits.Add64(x242, x266, uint64(p384Uint1(x277)))
	var x280 uint64
	var x281 uint64
	x280, x281 = bits.Add64(x244, x268, uint64(p384Uint1(x279)))
	var x282 uint64
	var x283 uint64
	x282, x283 = bits.Add64(x246, x270, uint64(p384Uint1(x281)))
	var x284 uint64
	var x285 uint64
	x284, x285 = bits.Add64(x248, x272, uint64(p384Uint1(x283)))
	var x286 uint64
	var x287 uint64
	x286, x287 = bits.Add64(x250, x274, uint64(p384Uint1(x285)))
	var x288 uint64
	var x289 uint64
	x288, x289 = bits.Add64((uint64(p384Uint1(x251)) + uint64(p384Uint1(x239))), (uint64(p384Uint1(x275)) + x255), uint64(p384Uint1(x287)))
	var x290 uint64
	var x291 uint64
	x290, x291 = bits.Sub64(x278, 0xffffffff, uint64(0x0))
	var x292 uint64
	var x293 uint64
	x292, x293 = bits.Sub64(x280, 0xffffffff00000000, uint64(p384Uint1(x291)))
	var x294 uint64
	var x295 uint64
	x294, x295 = bits.Sub64(x282, 0xfffffffffffffffe, uint64(p384Uint1(x293)))
	var x296 uint64
	var x297 uint64
	x296, x297 = bits.Sub64(x284, 0xffffffffffffffff, uint64(p384Uint1(x295)))
	var x298 uint64
	var x299 uint64
	x298, x299 = bits.Sub64(x286, 0xffffffffffffffff, uint64(p384Uint1(x297)))
	var x300 uint64
	var x301 uint64
	x300, x301 = bits.Sub64(x288, 0xffffffffffffffff, uint64(p384Uint1(x299)))
	var x303 uint64
	_, x303 = bits.Sub64(uint64(p384Uint1(x289)), uint64(0x0), uint64(p384Uint1(x301)))
	var x304 uint64
	p384CmovznzU64(&x304, p384Uint1(x303), x290, x278)
	var x305 uint64
	p384CmovznzU64(&x305, p384Uint1(x303), x292, x280)
	var x306 uint64
	p384CmovznzU64(&x306, p384Uint1(x303), x294, x282)
	var x307 uint64
	p384CmovznzU64(&x307, p384Uint1(x303), x296, x284)
	var x308 uint64
	p384CmovznzU64(&x308, p384Uint1(x303), x298, x286)
	var x309 uint64
	p384CmovznzU64(&x309, p384Uint1(x303), x300, x288)
	out1[0] = x304
	out1[1] = x305
	out1[2] = x306
	out1[3] = x307
	out1[4] = x308
	out1[5] = x309
}

// p384ToMontgomery translates a field element into the Montgomery domain.
//
// Preconditions:
//   0 ≤ eval arg1 < m
// Postconditions:
//   eval (from_montgomery out1) mod m = eval arg1 mod m
//   0 ≤ eval out1 < m
//
func p384ToMontgomery(out1 *p384MontgomeryDomainFieldElement, arg1 *p384NonMontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x6, 0x200000000)
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x6, 0xfffffffe00000000)
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x6, 0x200000000)
	var x13 uint64
	var x14 uint64
	x14, x13 = bits.Mul64(x6, 0xfffffffe00000001)
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x14, x11, uint64(0x0))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x12, x9, uint64(p384Uint1(x16)))
	var x19 uint64
	var x20 uint64
	x19, x20 = bits.Add64(x10, x7, uint64(p384Uint1(x18)))
	var x21 uint64
	var x22 uint64
	x21, x22 = bits.Add64(x8, x6, uint64(p384Uint1(x20)))
	var x23 uint64
	_, x23 = bits.Mul64(x13, 0x100000001)
	var x25 uint64
	var x26 uint64
	x26, x25 = bits.Mul64(x23, 0xffffffffffffffff)
	var x27 uint64
	var x28 uint64
	x28, x27 = bits.Mul64(x23, 0xffffffffffffffff)
	var x29 uint64
	var x30 uint64
	x30, x29 = bits.Mul64(x23, 0xffffffffffffffff)
	var x31 uint64
	var x32 uint64
	x32, x31 = bits.Mul64(x23, 0xfffffffffffffffe)
	var x33 uint64
	var x34 uint64
	x34, x33 = bits.Mul64(x23, 0xffffffff00000000)
	var x35 uint64
	var x36 uint64
	x36, x35 = bits.Mul64(x23, 0xffffffff)
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x36, x33, uint64(0x0))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x34, x31, uint64(p384Uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x32, x29, uint64(p384Uint1(x40)))
	var x43 uint64
	var x44 uint64
	x43, x44 = bits.Add64(x30, x27, uint64(p384Uint1(x42)))
	var x45 uint64
	var x46 uint64
	x45, x46 = bits.Add64(x28, x25, uint64(p384Uint1(x44)))
	var x48 uint64
	_, x48 = bits.Add64(x13, x35, uint64(0x0))
	var x49 uint64
	var x50 uint64
	x49, x50 = bits.Add64(x15, x37, uint64(p384Uint1(x48)))
	var x51 uint64
	var x52 uint64
	x51, x52 = bits.Add64(x17, x39, uint64(p384Uint1(x50)))
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Add64(x19, x41, uint64(p384Uint1(x52)))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x21, x43, uint64(p384Uint1(x54)))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(uint64(p384Uint1(x22)), x45, uint64(p384Uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(uint64(0x0), (uint64(p384Uint1(x46)) + x26), uint64(p384Uint1(x58)))
	var x61 uint64
	var x62 uint64
	x62, x61 = bits.Mul64(x1, 0x200000000)
	var x63 uint64
	var x64 uint64
	x64, x63 = bits.Mul64(x1, 0xfffffffe00000000)
	var x65 uint64
	var x66 uint64
	x66, x65 = bits.Mul64(x1, 0x200000000)
	var x67 uint64
	var x68 uint64
	x68, x67 = bits.Mul64(x1, 0xfffffffe00000001)
	var x69 uint64
	var x70 uint64
	x69, x70 = bits.Add64(x68, x65, uint64(0x0))
	var x71 uint64
	var x72 uint64
	x71, x72 = bits.Add64(x66, x63, uint64(p384Uint1(x70)))
	var x73 uint64
	var x74 uint64
	x73, x74 = bits.Add64(x64, x61, uint64(p384Uint1(x72)))
	var x75 uint64
	var x76 uint64
	x75, x76 = bits.Add64(x62, x1, uint64(p384Uint1(x74)))
	var x77 uint64
	var x78 uint64
	x77, x78 = bits.Add64(x49, x67, uint64(0x0))
	var x79 uint64
	var x80 uint64
	x79, x80 = bits.Add64(x51, x69, uint64(p384Uint1(x78)))
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x53, x71, uint64(p384Uint1(x80)))
	var x83 uint64
	var x84 uint64
	x83, x84 = bits.Add64(x55, x73, uint64(p384Uint1(x82)))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x57, x75, uint64(p384Uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x59, uint64(p384Uint1(x76)), uint64(p384Uint1(x86)))
	var x89 uint64
	_, x89 = bits.Mul64(x77, 0x100000001)
	var x91 uint64
	var x92 uint64
	x92, x91 = bits.Mul64(x89, 0xffffffffffffffff)
	var x93 uint64
	var x94 uint64
	x94, x93 = bits.Mul64(x89, 0xffffffffffffffff)
	var x95 uint64
	var x96 uint64
	x96, x95 = bits.Mul64(x89, 0xffffffffffffffff)
	var x97 uint64
	var x98 uint64
	x98, x97 = bits.Mul64(x89, 0xfffffffffffffffe)
	var x99 uint64
	var x100 uint64
	x100, x99 = bits.Mul64(x89, 0xffffffff00000000)
	var x101 uint64
	var x102 uint64
	x102, x101 = bits.Mul64(x89, 0xffffffff)
	var x103 uint64
	var x104 uint64
	x103, x104 = bits.Add64(x102, x99, uint64(0x0))
	var x105 uint64
	var x106 uint64
	x105, x106 = bits.Add64(x100, x97, uint64(p384Uint1(x104)))
	var x107 uint64
	var x108 uint64
	x107, x108 = bits.Add64(x98, x95, uint64(p384Uint1(x106)))
	var x109 uint64
	var x110 uint64
	x109, x110 = bits.Add64(x96, x93, uint64(p384Uint1(x108)))
	var x111 uint64
	var x112 uint64
	x111, x112 = bits.Add64(x94, x91, uint64(p384Uint1(x110)))
	var x114 uint64
	_, x114 = bits.Add64(x77, x101, uint64(0x0))
	var x115 uint64
	var x116 uint64
	x115, x116 = bits.Add64(x79, x103, uint64(p384Uint1(x114)))
	var x117 uint64
	var x118 uint64
	x117, x118 = bits.Add64(x81, x105, uint64(p384Uint1(x116)))
	var x119 uint64
	var x120 uint64
	x119, x120 = bits.Add64(x83, x107, uint64(p384Uint1(x118)))
	var x121 uint64
	var x122 uint64
	x121, x122 = bits.Add64(x85, x109, uint64(p384Uint1(x120)))
	var x123 uint64
	var x124 uint64
	x123, x124 = bits.Add64(x87, x111, uint64(p384Uint1(x122)))
	var x125 uint64
	var x126 uint64
	x125, x126 = bits.Add64((uint64(p384Uint1(x88)) + uint64(p384Uint1(x60))), (uint64(p384Uint1(x112)) + x92), uint64(p384Uint1(x124)))
	var x127 uint64
	var x128 uint64
	x128, x127 = bits.Mul64(x2, 0x200000000)
	var x129 uint64
	var x130 uint64
	x130, x129 = bits.Mul64(x2, 0xfffffffe00000000)
	var x131 uint64
	var x132 uint64
	x132, x131 = bits.Mul64(x2, 0x200000000)
	var x133 uint64
	var x134 uint64
	x134, x133 = bits.Mul64(x2, 0xfffffffe00000001)
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x134, x131, uint64(0x0))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x132, x129, uint64(p384Uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x130, x127, uint64(p384Uint1(x138)))
	var x141 uint64
	var x142 uint64
	x141, x142 = bits.Add64(x128, x2, uint64(p384Uint1(x140)))
	var x143 uint64
	var x144 uint64
	x143, x144 = bits.Add64(x115, x133, uint64(0x0))
	var x145 uint64
	var x146 uint64
	x145, x146 = bits.Add64(x117, x135, uint64(p384Uint1(x144)))
	var x147 uint64
	var x148 uint64
	x147, x148 = bits.Add64(x119, x137, uint64(p384Uint1(x146)))
	var x149 uint64
	var x150 uint64
	x149, x150 = bits.Add64(x121, x139, uint64(p384Uint1(x148)))
	var x151 uint64
	var x152 uint64
	x151, x152 = bits.Add64(x123, x141, uint64(p384Uint1(x150)))
	var x153 uint64
	var x154 uint64
	x153, x154 = bits.Add64(x125, uint64(p384Uint1(x142)), uint64(p384Uint1(x152)))
	var x155 uint64
	_, x155 = bits.Mul64(x143, 0x100000001)
	var x157 uint64
	var x158 uint64
	x158, x157 = bits.Mul64(x155, 0xffffffffffffffff)
	var x159 uint64
	var x160 uint64
	x160, x159 = bits.Mul64(x155, 0xffffffffffffffff)
	var x161 uint64
	var x162 uint64
	x162, x161 = bits.Mul64(x155, 0xffffffffffffffff)
	var x163 uint64
	var x164 uint64
	x164, x163 = bits.Mul64(x155, 0xfffffffffffffffe)
	var x165 uint64
	var x166 uint64
	x166, x165 = bits.Mul64(x155, 0xffffffff00000000)
	var x167 uint64
	var x168 uint64
	x168, x167 = bits.Mul64(x155, 0xffffffff)
	var x169 uint64
	var x170 uint64
	x169, x170 = bits.Add64(x168, x165, uint64(0x0))
	var x171 uint64
	var x172 uint64
	x171, x172 = bits.Add64(x166, x163, uint64(p384Uint1(x170)))
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x164, x161, uint64(p384Uint1(x172)))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x162, x159, uint64(p384Uint1(x174)))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x160, x157, uint64(p384Uint1(x176)))
	var x180 uint64
	_, x180 = bits.Add64(x143, x167, uint64(0x0))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x145, x169, uint64(p384Uint1(x180)))
	var x183 uint64
	var x184 uint64
	x183, x184 = bits.Add64(x147, x171, uint64(p384Uint1(x182)))
	var x185 uint64
	var x186 uint64
	x185, x186 = bits.Add64(x149, x173, uint64(p384Uint1(x184)))
	var x187 uint64
	var x188 uint64
	x187, x188 = bits.Add64(x151, x175, uint64(p384Uint1(x186)))
	var x189 uint64
	var x190 uint64
	x189, x190 = bits.Add64(x153, x177, uint64(p384Uint1(x188)))
	var x191 uint64
	var x192 uint64
	x191, x192 = bits.Add64((uint64(p384Uint1(x154)) + uint64(p384Uint1(x126))), (uint64(p384Uint1(x178)) + x158), uint64(p384Uint1(x190)))
	var x193 uint64
	var x194 uint64
	x194, x193 = bits.Mul64(x3, 0x200000000)
	var x195 uint64
	var x196 uint64
	x196, x195 = bits.Mul64(x3, 0xfffffffe00000000)
	var x197 uint64
	var x198 uint64
	x198, x197 = bits.Mul64(x3, 0x200000000)
	var x199 uint64
	var x200 uint64
	x200, x199 = bits.Mul64(x3, 0xfffffffe00000001)
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x200, x197, uint64(0x0))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x198, x195, uint64(p384Uint1(x202)))
	var x205 uint64
	var x206 uint64
	x205, x206 = bits.Add64(x196, x193, uint64(p384Uint1(x204)))
	var x207 uint64
	var x208 uint64
	x207, x208 = bits.Add64(x194, x3, uint64(p384Uint1(x206)))
	var x209 uint64
	var x210 uint64
	x209, x210 = bits.Add64(x181, x199, uint64(0x0))
	var x211 uint64
	var x212 uint64
	x211, x212 = bits.Add64(x183, x201, uint64(p384Uint1(x210)))
	var x213 uint64
	var x214 uint64
	x213, x214 = bits.Add64(x185, x203, uint64(p384Uint1(x212)))
	var x215 uint64
	var x216 uint64
	x215, x216 = bits.Add64(x187, x205, uint64(p384Uint1(x214)))
	var x217 uint64
	var x218 uint64
	x217, x218 = bits.Add64(x189, x207, uint64(p384Uint1(x216)))
	var x219 uint64
	var x220 uint64
	x219, x220 = bits.Add64(x191, uint64(p384Uint1(x208)), uint64(p384Uint1(x218)))
	var x221 uint64
	_, x221 = bits.Mul64(x209, 0x100000001)
	var x223 uint64
	var x224 uint64
	x224, x223 = bits.Mul64(x221, 0xffffffffffffffff)
	var x225 uint64
	var x226 uint64
	x226, x225 = bits.Mul64(x221, 0xffffffffffffffff)
	var x227 uint64
	var x228 uint64
	x228, x227 = bits.Mul64(x221, 0xffffffffffffffff)
	var x229 uint64
	var x230 uint64
	x230, x229 = bits.Mul64(x221, 0xfffffffffffffffe)
	var x231 uint64
	var x232 uint64
	x232, x231 = bits.Mul64(x221, 0xffffffff00000000)
	var x233 uint64
	var x234 uint64
	x234, x233 = bits.Mul64(x221, 0xffffffff)
	var x235 uint64
	var x236 uint64
	x235, x236 = bits.Add64(x234, x231, uint64(0x0))
	var x237 uint64
	var x238 uint64
	x237, x238 = bits.Add64(x232, x229, uint64(p384Uint1(x236)))
	var x239 uint64
	var x240 uint64
	x239, x240 = bits.Add64(x230, x227, uint64(p384Uint1(x238)))
	var x241 uint64
	var x242 uint64
	x241, x242 = bits.Add64(x228, x225, uint64(p384Uint1(x240)))
	var x243 uint64
	var x244 uint64
	x243, x244 = bits.Add64(x226, x223, uint64(p384Uint1(x242)))
	var x246 uint64
	_, x246 = bits.Add64(x209, x233, uint64(0x0))
	var x247 uint64
	var x248 uint64
	x247, x248 = bits.Add64(x211, x235, uint64(p384Uint1(x246)))
	var x249 uint64
	var x250 uint64
	x249, x250 = bits.Add64(x213, x237, uint64(p384Uint1(x248)))
	var x251 uint64
	var x252 uint64
	x251, x252 = bits.Add64(x215, x239, uint64(p384Uint1(x250)))
	var x253 uint64
	var x254 uint64
	x253, x254 = bits.Add64(x217, x241, uint64(p384Uint1(x252)))
	var x255 uint64
	var x256 uint64
	x255, x256 = bits.Add64(x219, x243, uint64(p384Uint1(x254)))
	var x257 uint64
	var x258 uint64
	x257, x258 = bits.Add64((uint64(p384Uint1(x220)) + uint64(p384Uint1(x192))), (uint64(p384Uint1(x244)) + x224), uint64(p384Uint1(x256)))
	var x259 uint64
	var x260 uint64
	x260, x259 = bits.Mul64(x4, 0x200000000)
	var x261 uint64
	var x262 uint64
	x262, x261 = bits.Mul64(x4, 0xfffffffe00000000)
	var x263 uint64
	var x264 uint64
	x264, x263 = bits.Mul64(x4, 0x200000000)
	var x265 uint64
	var x266 uint64
	x266, x265 = bits.Mul64(x4, 0xfffffffe00000001)
	var x267 uint64
	var x268 uint64
	x267, x268 = bits.Add64(x266, x263, uint64(0x0))
	var x269 uint64
	var x270 uint64
	x269, x270 = bits.Add64(x264, x261, uint64(p384Uint1(x268)))
	var x271 uint64
	var x272 uint64
	x271, x272 = bits.Add64(x262, x259, uint64(p384Uint1(x270)))
	var x273 uint64
	var x274 uint64
	x273, x274 = bits.Add64(x260, x4, uint64(p384Uint1(x272)))
	var x275 uint64
	var x276 uint64
	x275, x276 = bits.Add64(x247, x265, uint64(0x0))
	var x277 uint64
	var x278 uint64
	x277, x278 = bits.Add64(x249, x267, uint64(p384Uint1(x276)))
	var x279 uint64
	var x280 uint64
	x279, x280 = bits.Add64(x251, x269, uint64(p384Uint1(x278)))
	var x281 uint64
	var x282 uint64
	x281, x282 = bits.Add64(x253, x271, uint64(p384Uint1(x280)))
	var x283 uint64
	var x284 uint64
	x283, x284 = bits.Add64(x255, x273, uint64(p384Uint1(x282)))
	var x285 uint64
	var x286 uint64
	x285, x286 = bits.Add64(x257, uint64(p384Uint1(x274)), uint64(p384Uint1(x284)))
	var x287 uint64
	_, x287 = bits.Mul64(x275, 0x100000001)
	var x289 uint64
	var x290 uint64
	x290, x289 = bits.Mul64(x287, 0xffffffffffffffff)
	var x291 uint64
	var x292 uint64
	x292, x291 = bits.Mul64(x287, 0xffffffffffffffff)
	var x293 uint64
	var x294 uint64
	x294, x293 = bits.Mul64(x287, 0xffffffffffffffff)
	var x295 uint64
	var x296 uint64
	x296, x295 = bits.Mul64(x287, 0xfffffffffffffffe)
	var x297 uint64
	var x298 uint64
	x298, x297 = bits.Mul64(x287, 0xffffffff00000000)
	var x299 uint64
	var x300 uint64
	x300, x299 = bits.Mul64(x287, 0xffffffff)
	var x301 uint64
	var x302 uint64
	x301, x302 = bits.Add64(x300, x297, uint64(0x0))
	var x303 uint64
	var x304 uint64
	x303, x304 = bits.Add64(x298, x295, uint64(p384Uint1(x302)))
	var x305 uint64
	var x306 uint64
	x305, x306 = bits.Add64(x296, x293, uint64(p384Uint1(x304)))
	var x307 uint64
	var x308 uint64
	x307, x308 = bits.Add64(x294, x291, uint64(p384Uint1(x306)))
	var x309 uint64
	var x310 uint64
	x309, x310 = bits.Add64(x292, x289, uint64(p384Uint1(x308)))
	var x312 uint64
	_, x312 = bits.Add64(x275, x299, uint64(0x0))
	var x313 uint64
	var x314 uint64
	x313, x314 = bits.Add64(x277, x301, uint64(p384Uint1(x312)))
	var x315 uint64
	var x316 uint64
	x315, x316 = bits.Add64(x279, x303, uint64(p384Uint1(x314)))
	var x317 uint64
	var x318 uint64
	x317, x318 = bits.Add64(x281, x305, uint64(p384Uint1(x316)))
	var x319 uint64
	var x320 uint64
	x319, x320 = bits.Add64(x283, x307, uint64(p384Uint1(x318)))
	var x321 uint64
	var x322 uint64
	x321, x322 = bits.Add64(x285, x309, uint64(p384Uint1(x320)))
	var x323 uint64
	var x324 uint64
	x323, x324 = bits.Add64((uint64(p384Uint1(x286)) + uint64(p384Uint1(x258))), (uint64(p384Uint1(x310)) + x290), uint64(p384Uint1(x322)))
	var x325 uint64
	var x326 uint64
	x326, x325 = bits.Mul64(x5, 0x200000000)
	var x327 uint64
	var x328 uint64
	x328, x327 = bits.Mul64(x5, 0xfffffffe00000000)
	var x329 uint64
	var x330 uint64
	x330, x329 = bits.Mul64(x5, 0x200000000)
	var x331 uint64
	var x332 uint64
	x332, x331 = bits.Mul64(x5, 0xfffffffe00000001)
	var x333 uint64
	var x334 uint64
	x333, x334 = bits.Add64(x332, x329, uint64(0x0))
	var x335 uint64
	var x336 uint64
	x335, x336 = bits.Add64(x330, x327, uint64(p384Uint1(x334)))
	var x337 uint64
	var x338 uint64
	x337, x338 = bits.Add64(x328, x325, uint64(p384Uint1(x336)))
	var x339 uint64
	var x340 uint64
	x339, x340 = bits.Add64(x326, x5, uint64(p384Uint1(x338)))
	var x341 uint64
	var x342 uint64
	x341, x342 = bits.Add64(x313, x331, uint64(0x0))
	var x343 uint64
	var x344 uint64
	x343, x344 = bits.Add64(x315, x333, uint64(p384Uint1(x342)))
	var x345 uint64
	var x346 uint64
	x345, x346 = bits.Add64(x317, x335, uint64(p384Uint1(x344)))
	var x347 uint64
	var x348 uint64
	x347, x348 = bits.Add64(x319, x337, uint64(p384Uint1(x346)))
	var x349 uint64
	var x350 uint64
	x349, x350 = bits.Add64(x321, x339, uint64(p384Uint1(x348)))
	var x351 uint64
	var x352 uint64
	x351, x352 = bits.Add64(x323, uint64(p384Uint1(x340)), uint64(p384Uint1(x350)))
	var x353 uint64
	_, x353 = bits.Mul64(x341, 0x100000001)
	var x355 uint64
	var x356 uint64
	x356, x355 = bits.Mul64(x353, 0xffffffffffffffff)
	var x357 uint64
	var x358 uint64
	x358, x357 = bits.Mul64(x353, 0xffffffffffffffff)
	var x359 uint64
	var x360 uint64
	x360, x359 = bits.Mul64(x353, 0xffffffffffffffff)
	var x361 uint64
	var x362 uint64
	x362, x361 = bits.Mul64(x353, 0xfffffffffffffffe)
	var x363 uint64
	var x364 uint64
	x364, x363 = bits.Mul64(x353, 0xffffffff00000000)
	var x365 uint64
	var x366 uint64
	x366, x365 = bits.Mul64(x353, 0xffffffff)
	var x367 uint64
	var x368 uint64
	x367, x368 = bits.Add64(x366, x363, uint64(0x0))
	var x369 uint64
	var x370 uint64
	x369, x370 = bits.Add64(x364, x361, uint64(p384Uint1(x368)))
	var x371 uint64
	var x372 uint64
	x371, x372 = bits.Add64(x362, x359, uint64(p384Uint1(x370)))
	var x373 uint64
	var x374 uint64
	x373, x374 = bits.Add64(x360, x357, uint64(p384Uint1(x372)))
	var x375 uint64
	var x376 uint64
	x375, x376 = bits.Add64(x358, x355, uint64(p384Uint1(x374)))
	var x378 uint64
	_, x378 = bits.Add64(x341, x365, uint64(0x0))
	var x379 uint64
	var x380 uint64
	x379, x380 = bits.Add64(x343, x367, uint64(p384Uint1(x378)))
	var x381 uint64
	var x382 uint64
	x381, x382 = bits.Add64(x345, x369, uint64(p384Uint1(x380)))
	var x383 uint64
	var x384 uint64
	x383, x384 = bits.Add64(x347, x371, uint64(p384Uint1(x382)))
	var x385 uint64
	var x386 uint64
	x385, x386 = bits.Add64(x349, x373, uint64(p384Uint1(x384)))
	var x387 uint64
	var x388 uint64
	x387, x388 = bits.Add64(x351, x375, uint64(p384Uint1(x386)))
	var x389 uint64
	var x390 uint64
	x389, x390 = bits.Add64((uint64(p384Uint1(x352)) + uint64(p384Uint1(x324))), (uint64(p384Uint1(x376)) + x356), uint64(p384Uint1(x388)))
	var x391 uint64
	var x392 uint64
	x391, x392 = bits.Sub64(x379, 0xffffffff, uint64(0x0))
	var x393 uint64
	var x394 uint64
	x393, x394 = bits.Sub64(x381, 0xffffffff00000000, uint64(p384Uint1(x392)))
	var x395 uint64
	var x396 uint64
	x395, x396 = bits.Sub64(x383, 0xfffffffffffffffe, uint64(p384Uint1(x394)))
	var x397 uint64
	var x398 uint64
	x397, x398 = bits.Sub64(x385, 0xffffffffffffffff, uint64(p384Uint1(x396)))
	var x399 uint64
	var x400 uint64
	x399, x400 = bits.Sub64(x387, 0xffffffffffffffff, uint64(p384Uint1(x398)))
	var x401 uint64
	var x402 uint64
	x401, x402 = bits.Sub64(x389, 0xffffffffffffffff, uint64(p384Uint1(x400)))
	var x404 uint64
	_, x404 = bits.Sub64(uint64(p384Uint1(x390)), uint64(0x0), uint64(p384Uint1(x402)))
	var x405 uint64
	p384CmovznzU64(&x405, p384Uint1(x404), x391, x379)
	var x406 uint64
	p384CmovznzU64(&x406, p384Uint1(x404), x393, x381)
	var x407 uint64
	p384CmovznzU64(&x407, p384Uint1(x404), x395, x383)
	var x408 uint64
	p384CmovznzU64(&x408, p384Uint1(x404), x397, x385)
	var x409 uint64
	p384CmovznzU64(&x409, p384Uint1(x404), x399, x387)
	var x410 uint64
	p384CmovznzU64(&x410, p384Uint1(x404), x401, x389)
	out1[0] = x405
	out1[1] = x406
	out1[2] = x407
	out1[3] = x408
	out1[4] = x409
	out1[5] = x410
}

// p384Selectznz is a multi-limb conditional select.
//
// Postconditions:
//   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
//
// Input Bounds:
//   arg1: [0x0 ~> 0x1]
//   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func p384Selectznz(out1 *[6]uint64, arg1 p384Uint1, arg2 *[6]uint64, arg3 *[6]uint64) {
	var x1 uint64
	p384CmovznzU64(&x1, arg1, arg2[0], arg3[0])
	var x2 uint64
	p384CmovznzU64(&x2, arg1, arg2[1], arg3[1])
	var x3 uint64
	p384CmovznzU64(&x3, arg1, arg2[2], arg3[2])
	var x4 uint64
	p384CmovznzU64(&x4, arg1, arg2[3], arg3[3])
	var x5 uint64
	p384CmovznzU64(&x5, arg1, arg2[4], arg3[4])
	var x6 uint64
	p384CmovznzU64(&x6, arg1, arg2[5], arg3[5])
	out1[0] = x1
	out1[1] = x2
	out1[2] = x3
	out1[3] = x4
	out1[4] = x5
	out1[5] = x6
}

// p384ToBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
//
// Preconditions:
//   0 ≤ eval arg1 < m
// Postconditions:
//   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
func p384ToBytes(out1 *[48]uint8, arg1 *[6]uint64) {
	x1 := arg1[5]
	x2 := arg1[4]
	x3 := arg1[3]
	x4 := arg1[2]
	x5 := arg1[1]
	x6 := arg1[0]
	x7 := (uint8(x6) & 0xff)
	x8 := (x6 >> 8)
	x9 := (uint8(x8) & 0xff)
	x10 := (x8 >> 8)
	x11 := (uint8(x10) & 0xff)
	x12 := (x10 >> 8)
	x13 := (uint8(x12) & 0xff)
	x14 := (x12 >> 8)
	x15 := (uint8(x14) & 0xff)
	x16 := (x14 >> 8)
	x17 := (uint8(x16) & 0xff)
	x18 := (x16 >> 8)
	x19 := (uint8(x18) & 0xff)
	x20 := uint8((x18 >> 8))
	x21 := (uint8(x5) & 0xff)
	x22 := (x5 >> 8)
	x23 := (uint8(x22) & 0xff)
	x24 := (x22 >> 8)
	x25 := (uint8(x24) & 0xff)
	x26 := (x24 >> 8)
	x27 := (uint8(x26) & 0xff)
	x28 := (x26 >> 8)
	x29 := (uint8(x28) & 0xff)
	x30 := (x28 >> 8)
	x31 := (uint8(x30) & 0xff)
	x32 := (x30 >> 8)
	x33 := (uint8(x32) & 0xff)
	x34 := uint8((x32 >> 8))
	x35 := (uint8(x4) & 0xff)
	x36 := (x4 >> 8)
	x37 := (uint8(x36) & 0xff)
	x38 := (x36 >> 8)
	x39 := (uint8(x38) & 0xff)
	x40 := (x38 >> 8)
	x41 := (uint8(x40) & 0xff)
	x42 := (x40 >> 8)
	x43 := (uint8(x42) & 0xff)
	x44 := (x42 >> 8)
	x45 := (uint8(x44) & 0xff)
	x46 := (x44 >> 8)
	x47 := (uint8(x46) & 0xff)
	x48 := uint8((x46 >> 8))
	x49 := (uint8(x3) & 0xff)
	x50 := (x3 >> 8)
	x51 := (uint8(x50) & 0xff)
	x52 := (x50 >> 8)
	x53 := (uint8(x52) & 0xff)
	x54 := (x52 >> 8)
	x55 := (uint8(x54) & 0xff)
	x56 := (x54 >> 8)
	x57 := (uint8(x56) & 0xff)
	x58 := (x56 >> 8)
	x59 := (uint8(x58) & 0xff)
	x60 := (x58 >> 8)
	x61 := (uint8(x60) & 0xff)
	x62 := uint8((x60 >> 8))
	x63 := (uint8(x2) & 0xff)
	x64 := (x2 >> 8)
	x65 := (uint8(x64) & 0xff)
	x66 := (x64 >> 8)
	x67 := (uint8(x66) & 0xff)
	x68 := (x66 >> 8)
	x69 := (uint8(x68) & 0xff)
	x70 := (x68 >> 8)
	x71 := (uint8(x70) & 0xff)
	x72 := (x70 >> 8)
	x73 := (uint8(x72) & 0xff)
	x74 := (x72 >> 8)
	x75 := (uint8(x74) & 0xff)
	x76 := uint8((x74 >> 8))
	x77 := (uint8(x1) & 0xff)
	x78 := (x1 >> 8)
	x79 := (uint8(x78) & 0xff)
	x80 := (x78 >> 8)
	x81 := (uint8(x80) & 0xff)
	x82 := (x80 >> 8)
	x83 := (uint8(x82) & 0xff)
	x84 := (x82 >> 8)
	x85 := (uint8(x84) & 0xff)
	x86 := (x84 >> 8)
	x87 := (uint8(x86) & 0xff)
	x88 := (x86 >> 8)
	x89 := (uint8(x88) & 0xff)
	x90 := uint8((x88 >> 8))
	out1[0] = x7
	out1[1] = x9
	out1[2] = x11
	out1[3] = x13
	out1[4] = x15
	out1[5] = x17
	out1[6] = x19
	out1[7] = x20
	out1[8] = x21
	out1[9] = x23
	out1[10] = x25
	out1[11] = x27
	out1[12] = x29
	out1[13] = x31
	out1[14] = x33
	out1[15] = x34
	out1[16] = x35
	out1[17] = x37
	out1[18] = x39
	out1[19] = x41
	out1[20] = x43
	out1[21] = x45
	out1[22] = x47
	out1[23] = x48
	out1[24] = x49
	out1[25] = x51
	out1[26] = x53
	out1[27] = x55
	out1[28] = x57
	out1[29] = x59
	out1[30] = x61
	out1[31] = x62
	out1[32] = x63
	out1[33] = x65
	out1[34] = x67
	out1[35] = x69
	out1[36] = x71
	out1[37] = x73
	out1[38] = x75
	out1[39] = x76
	out1[40] = x77
	out1[41] = x79
	out1[42] = x81
	out1[43] = x83
	out1[44] = x85
	out1[45] = x87
	out1[46] = x89
	out1[47] = x90
}

// p384FromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
//
// Preconditions:
//   0 ≤ bytes_eval arg1 < m
// Postconditions:
//   eval out1 mod m = bytes_eval arg1 mod m
//   0 ≤ eval out1 < m
//
// Input Bounds:
//   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
// Output Bounds:
//   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func p384FromBytes(out1 *[6]uint64, arg1 *[48]uint8) {
	x1 := (uint64(arg1[47]) << 56)
	x2 := (uint64(arg1[46]) << 48)
	x3 := (uint64(arg1[45]) << 40)
	x4 := (uint64(arg1[44]) << 32)
	x5 := (uint64(arg1[43]) << 24)
	x6 := (uint64(arg1[42]) << 16)
	x7 := (uint64(arg1[41]) << 8)
	x8 := arg1[40]
	x9 := (uint64(arg1[39]) << 56)
	x10 := (uint64(arg1[38]) << 48)
	x11 := (uint64(arg1[37]) << 40)
	x12 := (uint64(arg1[36]) << 32)
	x13 := (uint64(arg1[35]) << 24)
	x14 := (uint64(arg1[34]) << 16)
	x15 := (uint64(arg1[33]) << 8)
	x16 := arg1[32]
	x17 := (uint64(arg1[31]) << 56)
	x18 := (uint64(arg1[30]) << 48)
	x19 := (uint64(arg1[29]) << 40)
	x20 := (uint64(arg1[28]) << 32)
	x21 := (uint64(arg1[27]) << 24)
	x22 := (uint64(arg1[26]) << 16)
	x23 := (uint64(arg1[25]) << 8)
	x24 := arg1[24]
	x25 := (uint64(arg1[23]) << 56)
	x26 := (uint64(arg1[22]) << 48)
	x27 := (uint64(arg1[21]) << 40)
	x28 := (uint64(arg1[20]) << 32)
	x29 := (uint64(arg1[19]) << 24)
	x30 := (uint64(arg1[18]) << 16)
	x31 := (uint64(arg1[17]) << 8)
	x32 := arg1[16]
	x33 := (uint64(arg1[15]) << 56)
	x34 := (uint64(arg1[14]) << 48)
	x35 := (uint64(arg1[13]) << 40)
	x36 := (uint64(arg1[12]) << 32)
	x37 := (uint64(arg1[11]) << 24)
	x38 := (uint64(arg1[10]) << 16)
	x39 := (uint64(arg1[9]) << 8)
	x40 := arg1[8]
	x41 := (uint64(arg1[7]) << 56)
	x42 := (uint64(arg1[6]) << 48)
	x43 := (uint64(arg1[5]) << 40)
	x44 := (uint64(arg1[4]) << 32)
	x45 := (uint64(arg1[3]) << 24)
	x46 := (uint64(arg1[2]) << 16)
	x47 := (uint64(arg1[1]) << 8)
	x48 := arg1[0]
	x49 := (x47 + uint64(x48))
	x50 := (x46 + x49)
	x51 := (x45 + x50)
	x52 := (x44 + x51)
	x53 := (x43 + x52)
	x54 := (x42 + x53)
	x55 := (x41 + x54)
	x56 := (x39 + uint64(x40))
	x57 := (x38 + x56)
	x58 := (x37 + x57)
	x59 := (x36 + x58)
	x60 := (x35 + x59)
	x61 := (x34 + x60)
	x62 := (x33 + x61)
	x63 := (x31 + uint64(x32))
	x64 := (x30 + x63)
	x65 := (x29 + x64)
	x66 := (x28 + x65)
	x67 := (x27 + x66)
	x68 := (x26 + x67)
	x69 := (x25 + x68)
	x70 := (x23 + uint64(x24))
	x71 := (x22 + x70)
	x72 := (x21 + x71)
	x73 := (x20 + x72)
	x74 := (x19 + x73)
	x75 := (x18 + x74)
	x76 := (x17 + x75)
	x77 := (x15 + uint64(x16))
	x78 := (x14 + x77)
	x79 := (x13 + x78)
	x80 := (x12 + x79)
	x81 := (x11 + x80)
	x82 := (x10 + x81)
	x83 := (x9 + x82)
	x84 := (x7 + uint64(x8))
	x85 := (x6 + x84)
	x86 := (x5 + x85)
	x87 := (x4 + x86)
	x88 := (x3 + x87)
	x89 := (x2 + x88)
	x90 := (x1 + x89)
	out1[0] = x55
	out1[1] = x62
	out1[2] = x69
	out1[3] = x76
	out1[4] = x83
	out1[5] = x90
}
