-- C46024A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- OBJECTIVE:
--     CHECK FLOATING POINT CONVERSIONS WHEN THE TARGET TYPE IS A
--     FIXED POINT TYPE, FOR DIGITS 5.

-- HISTORY:
--     JET 02/19/88  CREATED ORIGINAL TEST.

WITH REPORT; USE REPORT;

PROCEDURE C46024A IS

     TYPE FLOAT5 IS DIGITS 5;
     TYPE FIX1 IS DELTA 2#0.01# RANGE -16#20.0# .. 16#20.0#;
     TYPE FIX2 IS DELTA 2#0.0001# RANGE -16#80.0# .. 16#80.0#;
     TYPE FIX3 IS DELTA 2#0.000001# RANGE -16#200.0# .. 16#200.0#;

     F5, F5A, F5B : FLOAT5;

     GENERIC
          TYPE F IS DELTA <>;
     FUNCTION IDENTG (A : F) RETURN F;

     FUNCTION IDENTG (A : F) RETURN F IS
     BEGIN
          RETURN A + F(IDENT_INT(0));
     END IDENTG;

     FUNCTION IDENT1 IS NEW IDENTG(FIX1);
     FUNCTION IDENT2 IS NEW IDENTG(FIX2);
     FUNCTION IDENT3 IS NEW IDENTG(FIX3);

BEGIN
     TEST ("C46024A", "CHECK FLOATING POINT CONVERSIONS WHEN THE " &
                      "TARGET TYPE IS A FIXED POINT TYPE, FOR " &
                      "5-DIGIT PRECISION");

     IF FIX1(FLOAT5'(2#0.1000_0000_0000_0000_00#E-1)) /=
        IDENT1(2#0.01#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (1)");
     END IF;

     IF FIX1(FLOAT5'(-2#0.1111_1110_0000_0000_00#E5)) /=
        IDENT1(-2#1_1111.11#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (2)");
     END IF;

     IF FIX1(FLOAT5'(-2#0.1010_0111_1111_1111_11#E4)) <
        IDENT1(-2#1010.10#) OR
        FIX1(FLOAT5'(-2#0.1010_0111_1111_1111_11#E4)) >
        IDENT1(-2#1010.01#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (3)");
     END IF;

     IF FIX2(FLOAT5'(-2#0.1000_0000_0000_0000_00#E-3)) /=
        IDENT2(-2#0.0001#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (4)");
     END IF;

     IF FIX2(FLOAT5'(2#0.1111_1111_1110_0000_00#E7)) /=
        IDENT2(2#111_1111.1111#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (5)");
     END IF;

     F5 := 2#0.1010_1010_1010_1010_10#E5;
     IF FIX2(F5) < IDENT2(2#1_0101.0101#) OR
        FIX2(F5) > IDENT2(2#1_0101.0110#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (6)");
     END IF;

     IF FIX3(FLOAT5'(2#0.1000_0000_0000_0000_00#E-5)) /=
        IDENT3(2#0.000001#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (7)");
     END IF;

     IF FIX3(FLOAT5'(-2#0.1111_1111_1111_1110_00#E9)) /=
        IDENT3(-2#1_1111_1111.1111_11#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (8)");
     END IF;

     F5 := -2#0.1010_1010_1010_1010_10#E8;
     IF FIX3(F5) < IDENT3(-2#1010_1010.1010_11#) OR
        FIX3(F5) > IDENT3(-2#1010_1010.1010_10#) THEN
          FAILED ("INCORRECT RESULT FROM CONVERSION (9)");
     END IF;

     F5A := 2#0.1010_1010_1010_1010_10#E4;
     F5B := 2#0.1010_1010_1010_1010_10#E5;

     IF FIX1(F5A) = IDENT1(2#1010.11#)   AND
        FIX1(-F5A) = IDENT1(-2#1010.11#) AND
        FIX1(F5B) = IDENT1(2#1_0101.01#) AND
        FIX1(-F5B) = IDENT1(-2#1_0101.01#) THEN
          COMMENT ("CONVERSION ROUNDS TO NEAREST");
     ELSIF FIX1(F5A) = IDENT1(2#1010.10#) AND
           FIX1(-F5B) = IDENT1(-2#1_0101.10#) THEN
          COMMENT ("CONVERSION ROUNDS TO LEAST FIXED-POINT VALUE");
     ELSIF FIX1(F5B) = IDENT1(2#1_0101.10#) AND
           FIX1(-F5A) = IDENT1(-2#1010.10#) THEN
          COMMENT ("CONVERSION ROUNDS TO GREATEST FIXED-POINT VALUE");
     ELSIF FIX1(F5A) = IDENT1(2#1010.10#) AND
           FIX1(-F5A) = IDENT1(-2#1010.10#) THEN
          COMMENT ("CONVERSION ROUNDS TOWARD ZERO");
     ELSIF FIX1(F5B) = IDENT1(2#1_0101.10#) AND
           FIX1(-F5B) = IDENT1(-2#1_0101.10#) THEN
          COMMENT ("CONVERSION ROUNDS AWAY FROM ZERO");
     ELSE
          COMMENT ("UNABLE TO DETERMINE CONVERSION PATTERN");
     END IF;

     RESULT;

END C46024A;
