/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HealpixNestedBMOC;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;

public class HealpixNestedUltraCompactMOC {
    public static byte[] compress(HealpixNestedBMOC moc) {
        int dd;
        HealpixNestedBMOC.CurrentValueAccessor curr;
        CustomBitSet bits = new CustomBitSet(moc.size());
        int depthMax = moc.getDepthMax();
        Iterator<HealpixNestedBMOC.CurrentValueAccessor> it = moc.iterator();
        int depth = 0;
        int currDepth = 0;
        long hash = 0L;
        long currHash = 0L;
        if (it.hasNext()) {
            curr = it.next();
            currDepth = curr.getDepth();
            currHash = curr.getHash();
            for (dd = currDepth - depth; dd >= 0; --dd) {
                long targetHash = currHash >>> (dd << 1);
                while (hash < targetHash) {
                    bits.add(false);
                    ++hash;
                }
                bits.add(true);
                hash <<= 2;
            }
            if (currDepth != depthMax) {
                bits.add(false);
                bits.add(false);
                bits.add(false);
                bits.add(false);
            }
            hash = currHash;
            depth = currDepth;
        }
        curr = it.next();
        currDepth = curr.getDepth();
        currHash = curr.getHash();
        while (true) {
            long currHashAtPrevDepth;
            if ((dd = currDepth - depth) < 0) {
                int nBits = -dd << 1;
                currHashAtPrevDepth = currHash << nBits;
            } else {
                currHashAtPrevDepth = currHash >>> (dd << 1);
            }
            dd = 63 - Long.numberOfLeadingZeros(hash ^ currHashAtPrevDepth) >> 1;
            if (dd > depth) {
                dd = depth;
            }
            depth -= dd;
            while (dd > 0) {
                while ((hash & 3L) < 3L) {
                    bits.add(false);
                    ++hash;
                }
                hash >>= 2;
                --dd;
            }
            ++hash;
            for (dd = currDepth - depth; dd >= 0; --dd) {
                long targetHash = currHash >>> (dd << 1);
                while (hash < targetHash) {
                    bits.add(false);
                    ++hash;
                }
                bits.add(true);
                hash <<= 2;
            }
            if (currDepth != depthMax) {
                bits.add(false);
                bits.add(false);
                bits.add(false);
                bits.add(false);
            }
            if (!it.hasNext()) break;
            hash = currHash;
            depth = currDepth;
            curr = it.next();
            currDepth = curr.getDepth();
            currHash = curr.getHash();
        }
        while (depth > 0) {
            for (int k = (int)hash & 3; k < 3; ++k) {
                bits.add(false);
            }
            hash >>= 2;
            --depth;
        }
        ++hash;
        while (hash < 12L) {
            bits.add(false);
            ++hash;
        }
        return bits.toByteArray();
    }

    private static final BitSet bitSetFromBytes(byte[] compressedMoc) {
        int size = 8 * compressedMoc.length;
        BitSet bs = new BitSet(8 * compressedMoc.length);
        for (int i = 0; i < size; ++i) {
            bs.set(i, (compressedMoc[i / 8] & 1 << (i & 7)) != 0);
        }
        return bs;
    }

    public static HealpixNestedBMOC decompress(int depthMax, byte[] compressedMoc) {
        BitSet bs = HealpixNestedUltraCompactMOC.bitSetFromBytes(compressedMoc);
        ArrayList<Long> res = new ArrayList<Long>(compressedMoc.length);
        int i = 0;
        int depth = 0;
        long hash = 0L;
        while (true) {
            boolean bit = bs.get(i);
            ++i;
            if (bit) {
                if (depth == depthMax) {
                    res.add(HealpixNestedBMOC.buildValue(depth, hash, true, depthMax));
                    while ((hash & 3L) == 3L && depth > 0) {
                        hash >>>= 2;
                        --depth;
                    }
                    ++hash;
                    continue;
                }
                hash <<= 2;
                ++depth;
                continue;
            }
            if (depth == 0) {
                if (hash == 12L) break;
                ++hash;
                continue;
            }
            if (!((hash & 3L) != 0L || bs.get(i) || bs.get(i + 1) || bs.get(i + 2))) {
                i += 3;
                res.add(HealpixNestedBMOC.buildValue(--depth, hash >>>= 2, true, depthMax));
            }
            while ((hash & 3L) == 3L && depth > 0) {
                hash >>>= 2;
                --depth;
            }
            ++hash;
        }
        int size = res.size();
        long[] mocCells = new long[size];
        for (int k = 0; k < size; ++k) {
            mocCells[k] = (Long)res.get(k);
        }
        return HealpixNestedBMOC.createUnsafe(depthMax, mocCells);
    }

    private static final class CustomBitSet {
        private BitSet bs;
        private int capacity;
        private int i = 0;

        private CustomBitSet(int mocSize) {
            this.bs = new BitSet(64 * mocSize);
            this.capacity = this.bs.size();
        }

        private void add(boolean bitValue) {
            if (this.i >= this.capacity) {
                int newCapacity = this.capacity + (int)(0.5 * (double)this.capacity);
                BitSet newBitSet = new BitSet(newCapacity);
                newBitSet.or(this.bs);
                this.bs = newBitSet;
                this.capacity = newCapacity;
            }
            this.bs.set(this.i++, bitValue);
        }

        private byte[] toByteArray() {
            byte[] bytes = new byte[(this.i + 7) / 8];
            for (int i = 0; i < this.i; ++i) {
                if (!this.bs.get(i)) continue;
                int n = i / 8;
                bytes[n] = (byte)(bytes[n] | 1 << (i & 7));
            }
            return bytes;
        }
    }
}

