% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_gam_model.R
\name{is_gam_model}
\alias{is_gam_model}
\title{Checks if a model is a generalized additive model}
\usage{
is_gam_model(x)
}
\arguments{
\item{x}{A model object.}
}
\value{
A logical, \code{TRUE} if \code{x} is a generalized additive model
\emph{and} has smooth-terms
}
\description{
Small helper that checks if a model is a generalized additive
model.
}
\note{
This function only returns \code{TRUE} when the model inherits from a
typical GAM model class \emph{and} when smooth terms are present in the model
formula. If model has no smooth terms or is not from a typical gam class,
\code{FALSE} is returned.
}
\examples{
\dontshow{if (require("mgcv")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(iris)
model1 <- lm(Petal.Length ~ Petal.Width + Sepal.Length, data = iris)
model2 <- mgcv::gam(Petal.Length ~ Petal.Width + s(Sepal.Length), data = iris)
is_gam_model(model1)
is_gam_model(model2)
\dontshow{\}) # examplesIf}
}
