# generated by datamodel-codegen:
#   filename:  nullable.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Annotated, List, Optional, TypeAlias, Union

from msgspec import UNSET, Meta, Struct, UnsetType, field


class Cursors(Struct):
    prev: str
    index: float
    next: Union[str, UnsetType] = 'last'
    tag: Union[str, UnsetType] = UNSET


class TopLevel(Struct):
    cursors: Cursors


class Info(Struct):
    name: str


class User(Struct):
    info: Info


class Api(Struct):
    apiKey: Union[
        Annotated[str, Meta(description='To be used as a dataset parameter value')],
        UnsetType,
    ] = UNSET
    apiVersionNumber: Union[
        Annotated[str, Meta(description='To be used as a version parameter value')],
        UnsetType,
    ] = UNSET
    apiUrl: Union[
        Annotated[str, Meta(description="The URL describing the dataset's fields")],
        UnsetType,
    ] = UNSET
    apiDocumentationUrl: Union[
        Annotated[str, Meta(description='A URL to the API console for each API')],
        UnsetType,
    ] = UNSET


Apis: TypeAlias = Optional[List[Api]]


class EmailItem(Struct):
    author: str
    address: Annotated[str, Meta(description='email address')]
    description: Union[str, UnsetType] = 'empty'
    tag: Union[str, UnsetType] = UNSET


Email: TypeAlias = List[EmailItem]


Id: TypeAlias = int


Description: TypeAlias = Annotated[Optional[str], 'example']


Name: TypeAlias = Optional[str]


Tag: TypeAlias = str


class Notes(Struct):
    comments: Union[List[str], UnsetType] = field(default_factory=list)


class Options(Struct):
    comments: List[str]
    oneOfComments: List[Union[str, float]]
