#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No description found"

    def run(self):
        if self.env["input"]["oldNumLock"] == self.env["input"]["newNumLock"]:
            return
        if self.env["input"]["newNumLock"]:
            self.env["runtime"]["OutputManager"].present_text(
                _("Numlock on"), interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("Numlock off"), interrupt=True
            )

    def set_callback(self, callback):
        pass
