#!/bin/echo this is sourced by test scripts
#
# uncomment to debug test suite
# DEBUG_CMDS=y
# 
# if [ -x /bin/posix/sh -a "${POSIXSH=}" != 1 ] ; then
#     # hack for HP/UX -- /bin/sh is really poxy
#     POSIXSH=1; export POSIXSH
#     exec /bin/posix/sh $0 $*
# fi

if [ -f /vmunix ] ; then
    SYSV=0
else
    SYSV=1
fi

if perl -e 'exit (!-t STDOUT)' ; then
    ISATTY=1
else
    ISATTY=0
fi; export ISATTY		# used for "spinning" in wait-for-daemon

echon () {
  case $SYSV in
  1 ) /bin/echo "$*\c" ;;
  0 ) /bin/echo -n "$*" ;;
  * ) echo "[echon is broken] $*"
  esac
}

dbgcmds () {
    [ "${DEBUG_CMDS:-n}" = y ] && echo "[$*]"
}

difftimes () {
  echo "$start
    $end" | perl -e '
    $_ = <>; /^ *... ... .. ..:(..):(..).*$/; $startsecs = $2 + ($1 * 60);
    $_ = <>; /^ *... ... .. ..:(..):(..).*$/; $endsecs = $2 + ($1 * 60);
    $diff = $endsecs - $startsecs;
    print ($diff < 0 ? $diff + 60*60 : $diff);
  '
}

do_test_pre () {
  PRINTER=$1; FILTERS="$2"
  clear_logs; stop_printer
}

do_test () {
  do_test_pre $*
  lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC
  do_test_post
}

do_test_post () {
  start_printer
  check_test $PRINTER $FILTERS
}

check_test () {
  echon "`get_label $PRINTER`... "
  start=`date`; wait-for-daemon; end=`date`

  dbgcmds check-output $NUMBER $DOC_SIZE $FILTERS
  check-output $NUMBER $DOC_SIZE $FILTERS < $OUT
  
  if [ "$?" = 0 ] ; then
    echo "passed (`difftimes` seconds)"; save_pass $OUT
  else
    echo "*** FAILED ***"; save_failure $OUT
  fi
}

###########################################################################

do_multi_test_pre () {
  PRINTER=$1; FILTERS="$2"
  clear_logs; stop_printer
}

do_multi_test () {
  do_multi_test_pre $*
  lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC
  lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC; lpr -P$PRINTER $DOC
  do_multi_test_post
}

do_multi_test_post () {
  start_printer
  echon "`get_label $PRINTER` (total)... "
  NUMBER=6; check_multi_test "$FILTERS" "${OUT}_1" "${OUT}_2"

#  echon "`get_label $PRINTER` (file 1)... "
#  NUMBER=3; check_multi_test "$FILTERS" "${OUT}_1"

#  echon "`get_label $PRINTER` (file 2)... "
#  NUMBER=3; check_multi_test "$FILTERS" "${OUT}_2"
}

check_multi_test () {
  start=`date`; wait-for-daemon; end=`date`
  FILTERS="$1"; shift

  dbgcmds check-output $NUMBER $DOC_SIZE $FILTERS
  for f in $* ; do
    cat $f; echo __MULTI_SEPERATOR__
  done | check-output $NUMBER $DOC_SIZE $FILTERS

  if [ "$?" = 0 ] ; then
    echo "passed (`difftimes` seconds)"; save_pass $*
  else
    echo "*** FAILED *** (`difftimes` seconds)"; save_failure $*
  fi
}

get_label () {
    egrep '^'"$PRINTER:	" src/LABELS | sed -e 's/^'"$PRINTER"': //g'
}

clear_logs () {
    for file in $LOG $OUT ${OUT}_1 ${OUT}_2 ; do
	rm -f $file
	touch $file
	[ "${DEBUG_CMDS:-n}" = y ] && ls -l $file
    done
    rm -f spool/$PRINTER/core
}

save_failure () {
    [ -d failed ] || mkdir failed
    for file in $* ; do
	if [ -r $file ] ; then
	    base=`basename $file`
	    mv $file "failed/$PRINTER.$base"
	    touch $file
	fi
    done
}

save_pass () {
    [ -d failed ] || mkdir failed
    for file in $* ; do
	if [ -r $file ] ; then
	    base=`basename $file`
	    rm -f "failed/$PRINTER.$base"
	fi
    done
}

stop_printer () {
    lpc stop $PRINTER > /dev/null
}

start_printer () {
    lpc start $PRINTER > /dev/null
}

export DEBUG_CMDS

###########################################################################
# set up some defaults and configuration

cd $TESTDIR
PATH=$PATH:$TESTDIR:$TESTDIR/src:$TESTDIR/bin
export PRINTER

OUT=spool/OUT
LOG=spool/LOG
NUMBER=3

DOC=src/doc.ascii

DOC_SIZE=`ls -l $DOC | awk '{print $5}'`
case "$DOC_SIZE" in
    [A-Za-z]* )
	# oops -- we got the date. Try again.
	DOC_SIZE=`ls -l $DOC | awk '{print $4}'`
	;;
    * )
	;;
esac

# echo "$DOC [$DOC_SIZE]"
