/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: global.c
 * Definitions of global variables.
 * NOTE: system dependent,  default values defined in lp.h
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

/*************************************************************************
 * global variables
 *************************************************************************/

char *Name;			/* program Name (argv[0]) */
char *Printer;			/* Printer Name, set for a queue handler */

char *Newjobnum;                /* A number for a new command */
int mistake;                    /* var for switching */
char ShortHost[SHORTHOSTLEN];	/* Host machine name  */
char Host[HOSTLEN];		/* Host machine name (fully-qualified) */
char *Architecture = NULL;	/* Host machine architecture */

char *From = NULL;		/* client's machine name */
char *FQDN = NULL;		/* client's machine name (fully-qualified) */

char *Person;			/* Name of Person making request */
FILE *Lfd;			/* lock file stdio file descriptor */
char *First_name;		/* first name in printcap entry */
char *All_names;
int Debug;			/* Debugging level */
int Echo_on_stdout;		/* error messages on stdout and stderr */
int Errorcode = 2;		/* exit() value for fatal termination */
struct parm *Parms = NULL;	/* character parameters */
int Parmcount;			/* number of requests */
int ParmSz = 0;			/* size of the Parm array (in struct parms) */
char Last_errormsg[BUFSIZ];	/* last errormessage */
struct plp_queue *Jobentry;	/* current job entry in queue */
int Request;			/* current lpd request code */
int Print_fd;			/* output printer file descriptor */
char CFparm[26][MAXPARMLEN + 1];/* parameters read from control file */
struct plp_queue *Queue;	/* Getq generates a vector of jobs */
int Jobcount;			/* and returns the number of jobs  */
int Short_format;		/* short status format */
int Rec_cnt;			/* number of files in a job */
int Is_root;			/* is this the root user? */
int Is_local;			/* doing this locally or remotely? */
struct stat LO_statb;		/* used to stat lockfile */
int DaemonUID;			/* daemon UID */
int DaemonGID;			/* daemon GID */

/******************************************************************
 * Definitions for the printcap variables.
 ******************************************************************/

int AB;				/* Always have a banner flag, ignore lpr -h option */
char *AF;			/* accounting file */
int AR;				/* remote accounting */
int BK;				/* Berkeley compatible remote and local */
char *BP;			/* banner printer filter */
int BR;				/* baud rate if lp is a tty */
int CL;				/* close (& re-open) output device between jobs */
int CO;				/* cost of printing in dollars per thousand pages */
char *EP;			/* end printer filter */
int FC;				/* flags to clear if lp is a tty */
int FD;				/* No forwarding, accept only from original site */
char *FF;			/* form feed string */
int FJ;				/* send control file  first to remote site */
int FO;				/* print a form feed when device is opened */
int FQ;				/* form feed on quitting */
int FS;				/* flags to set if lp is a tty */
char *FX;			/* allowable formats */
int LA;				/* local accounting */
char *LD;			/* leader string on opening */
char *LF;			/* log file for error messages */
int LH;				/* use long host name */
char *LI;			/* file size limitation (value or filename) */
char *LN;			/* group allowed to use links */
char *LO;			/* lock file Name */
char *LP;			/* line Printer device Name */
int MC;				/* maximum number of copies allowed */
char *MI;			/* minimum free space to leave on spool filesystem */
int MX;				/* maximum number of blocks to copy */
int NW;				/* Networked file system, do not make copies */
int PL;				/* page length */
char *PR;			/* pr program name */
char *PS;			/* Printer status file name */
int PW;				/* page width */
int PX;				/* page width in pixels */
int PY;				/* page length in pixels */
char *QH;			/* queue handler */
char *RM;			/* remote machine Name */
char *RP;			/* remote Printer Name */
int RT;				/* max retries */
int RW;				/* open LP for reading and writing */
int SB;				/* short banner instead of normal header */
int SC;				/* suppress multiple copies */
char *SD;			/* spool directory */
int SF;				/* suppress FF on each print job */
int SH;				/* suppress header page */
char *SS;			/* name of queue that the server serves  */
char *ST;			/* status file Name */
char *SV;			/* names of servers */
char *TR;			/* trailer string to be output when Q empties */
char *TY;			/* terminal characteristics, stty options */
int XC;				/* flags to clear for local mode */
int XS;				/* flags to set for local mode */
char *XU;			/* restrict use to users with perms in file */
char *XT;			/* check format in string for printable text only */

/*
 * EUCS: Edinburgh University additions.
 */

char *CM;			/* EUCS: status line comment */
int DB;				/* EUCS: set debug level for queue handler */
int EU;				/* EUCS: Edinburgh Univ. extended control file format */
int ML;				/* min legal chars for printable */
char *MS;			/* EUCS: terminal characteristics, Sun lpd's "ty" */
int SL;				/* remote lpd is standard - use old lpd control file
				 * format */

#ifdef EUCS_ZOPTIONS
int ED;				/* EUCS: expensive device (only jobs from trusted hosts) */
char *FL;			/* EUCS: list of valid forms */
int NC;				/* No charge queue - restrict access */
#endif

/*
 * filter arguments are indexed by first letter of the filter Name. For example:
 * "if=/usr/lib/iffilter" -> Filter_name['i'-'a']
 */
char *Filter_name[26];
/*
 * Prefilter arguments are indexed by first letter of the filter Name, as for the filters
 */
char *Prefilter_name[26];

/*************************************************************************
 * Printcap Entries,  Defaults, and Variables
 * The All_pc_vars[] and Status_pc_vars[] arrays contain the Names
 * of the printcap entries, the type of entry,  the default value,
 * and the variable which is set by the entry.
 * The array is sorted by the printcap entry.
 *************************************************************************/

PC_ENTRY All_pc_vars[] = {
    {"ab", PC_FLAG, 0, 0, (char **) &AB},
    {"ae", PC_STRING, 0, 0, &Prefilter_name['a' - 'a']},
    {"af", PC_STRING, 0, 0, &AF},
    {"ar", PC_FLAG, 1, 0, (char **) &AR},
    {"be", PC_STRING, 0, 0, &Prefilter_name['b' - 'a']},
    {"bf", PC_STRING, 0, 0, &Filter_name['b' - 'a']},
    {"bk", PC_NUM, 0, 0, (char **) &BK},
    {"bp", PC_STRING, 0, 0, &BP},
    {"br", PC_NUM, 0, 0, (char **) &BR},
    {"ce", PC_STRING, 0, 0, &Prefilter_name['c' - 'a']},
    {"cf", PC_STRING, 0, 0, &Filter_name['c' - 'a']},
    {"cl", PC_FLAG, 0, 0, (char **) &CL},
    {"cm", PC_STRING, 0, 0, &CM},
    {"co", PC_NUM, 0, 0, (char **) &CO},
    {"db", PC_NUM, 0, 0, (char **) &DB},
    {"de", PC_STRING, 0, 0, &Prefilter_name['d' - 'a']},
    {"df", PC_STRING, 0, 0, &Filter_name['d' - 'a']},
#ifdef EUCS_ZOPTIONS
    {"ed", PC_FLAG, 0, 0, (char **) &ED},
#endif
    {"eu", PC_FLAG, 0, 0, (char **) &EU},
    {"ee", PC_STRING, 0, 0, &Prefilter_name['e' - 'a']},
    {"ef", PC_STRING, 0, 0, &Filter_name['e' - 'a']},
    {"ep", PC_STRING, 0, 0, &EP},
    {"eu", PC_FLAG, 0, 0, (char **) &EU},
    {"fc", PC_NUM, 0, 0, (char **) &FC},
    {"fd", PC_FLAG, 0, 0, (char **) &FD},
    {"fe", PC_STRING, 0, 0, &Prefilter_name['f' - 'a']},
    {"ff", PC_STRING, 0, DEFFF, &FF},
    {"fj", PC_FLAG, 0, 0, (char **) &FJ},
#ifdef EUCS_ZOPTIONS
    {"fl", PC_STRING, 0, 0, &FL},
#endif
    {"fo", PC_FLAG, 0, 0, (char **) &FO},
    {"fq", PC_FLAG, 0, 0, (char **) &FQ},
    {"fs", PC_NUM, 0, 0, (char **) &FS},
    {"fx", PC_STRING, 0, 0, &FX},
    {"ge", PC_STRING, 0, 0, &Prefilter_name['g' - 'a']},
    {"gf", PC_STRING, 0, 0, &Filter_name['g' - 'a']},
    {"he", PC_STRING, 0, 0, &Prefilter_name['h' - 'a']},
    {"hf", PC_STRING, 0, 0, &Filter_name['h' - 'a']},
    {"ie", PC_STRING, 0, 0, &Prefilter_name['i' - 'a']},
    {"if", PC_STRING, 0, 0, &Filter_name['i' - 'a']},
    {"je", PC_STRING, 0, 0, &Prefilter_name['j' - 'a']},
    {"jf", PC_STRING, 0, 0, &Filter_name['j' - 'a']},
    {"ke", PC_STRING, 0, 0, &Prefilter_name['k' - 'a']},
    {"kf", PC_STRING, 0, 0, &Filter_name['k' - 'a']},
    {"la", PC_FLAG, 1, 0, (char **) &LA},
    {"ld", PC_STRING, 0, 0, &LD},
    {"le", PC_STRING, 0, 0, &Prefilter_name['l' - 'a']},
    {"lf", PC_STRING, 0, DEFLOGF, &LF},
    {"lh", PC_NUM, 0, 0, (char **) &LH},
    {"li", PC_STRING, 0, 0, &LI},
    {"ln", PC_STRING, 0, 0, &LN},
    {"lo", PC_STRING, 0, DEFLOCK, &LO},
    {"lp", PC_STRING, 0, 0, &LP},
    {"mc", PC_NUM, DEFMAXCOPIES, 0, (char **) &MC},
    {"me", PC_STRING, 0, 0, &Prefilter_name['m' - 'a']},
    {"mf", PC_STRING, 0, 0, &Filter_name['m' - 'a']},
    {"mi", PC_NUM, 0, 0, (char **) &MI},
    {"ml", PC_NUM, DEFMINLEGAL, 0, (char **) &ML},
    {"ms", PC_STRING, 0, 0, (char **) &MS},
    {"mx", PC_NUM, DEFMX, 0, (char **) &MX},
#ifdef EUCS_ZOPTIONS
    {"nc", PC_FLAG, 0, 0, (char **) &NC},
#endif
    {"ne", PC_STRING, 0, 0, &Prefilter_name['n' - 'a']},
    {"nf", PC_STRING, 0, 0, &Filter_name['n' - 'a']},
    {"nw", PC_FLAG, 0, 0, (char **) &NW},
    {"oe", PC_STRING, 0, 0, &Prefilter_name['o' - 'a']},
    {"of", PC_STRING, 0, 0, &Filter_name['o' - 'a']},
    {"pe", PC_STRING, 0, 0, &Prefilter_name['p' - 'a']},
    {"pf", PC_STRING, 0, 0, &Filter_name['p' - 'a']},
    {"pl", PC_NUM, DEFLENGTH, 0, (char **) &PL},
    {"pr", PC_STRING, 0, DEFPR, &PR},
    {"ps", PC_STRING, 0, 0, &PS},
    {"pw", PC_NUM, DEFWIDTH, 0, (char **) &PW},
    {"px", PC_NUM, 0, 0, (char **) &PX},
    {"py", PC_NUM, 0, 0, (char **) &PY},
    {"qe", PC_STRING, 0, 0, &Prefilter_name['q' - 'a']},
    {"qf", PC_STRING, 0, 0, &Filter_name['q' - 'a']},
    {"qh", PC_STRING, 0, 0, &QH},
    {"re", PC_STRING, 0, 0, &Prefilter_name['r' - 'a']},
    {"rf", PC_STRING, 0, 0, &Filter_name['r' - 'a']},
    {"rm", PC_STRING, 0, 0, &RM},
    {"rp", PC_STRING, 0, 0, &RP},
    {"rt", PC_NUM, DEFRETRY, 0, (char **) &RT},
    {"rw", PC_FLAG, 0, 0, (char **) &RW},
    {"sb", PC_FLAG, 0, 0, (char **) &SB},
    {"sc", PC_FLAG, 0, 0, (char **) &SC},
    {"sd", PC_STRING, 0, 0, &SD},
    {"se", PC_STRING, 0, 0, &Prefilter_name['s' - 'a']},
    {"sf", PC_FLAG, 0, 0, (char **) &SF},
    {"sh", PC_FLAG, 0, 0, (char **) &SH},
    {"ss", PC_STRING, 0, 0, &SS},
    {"st", PC_STRING, 0, DEFSTAT, &ST},
    {"sv", PC_STRING, 0, 0, &SV},
    {"te", PC_STRING, 0, 0, &Prefilter_name['t' - 'a']},
    {"tf", PC_STRING, 0, 0, &Filter_name['t' - 'a']},
    {"tr", PC_STRING, 0, 0, &TR},
    {"ty", PC_STRING, 0, 0, &TY},
    {"ue", PC_STRING, 0, 0, &Prefilter_name['u' - 'a']},
    {"uf", PC_STRING, 0, 0, &Filter_name['u' - 'a']},
    {"ve", PC_STRING, 0, 0, &Prefilter_name['v' - 'a']},
    {"vf", PC_STRING, 0, 0, &Filter_name['v' - 'a']},
    {"we", PC_STRING, 0, 0, &Prefilter_name['w' - 'a']},
    {"wf", PC_STRING, 0, 0, &Filter_name['w' - 'a']},
    {"xc", PC_NUM, 0, 0, (char **) &XC},
    {"xe", PC_STRING, 0, 0, &Prefilter_name['x' - 'a']},
    {"xf", PC_STRING, 0, 0, &Filter_name['x' - 'a']},
    {"xs", PC_NUM, 0, 0, (char **) &XS},
    {"xt", PC_STRING, 0, 0, &XT},
    {"xu", PC_STRING, 0, 0, &XU},
    {"ye", PC_STRING, 0, 0, &Prefilter_name['y' - 'a']},
    {"yf", PC_STRING, 0, 0, &Filter_name['y' - 'a']},
    {"ze", PC_STRING, 0, 0, &Prefilter_name['z' - 'a']},
    {"zf", PC_STRING, 0, 0, &Filter_name['z' - 'a']}

};

int All_pc_len = sizeof (All_pc_vars) / sizeof (PC_ENTRY);

/**************************************************************************
 * Status_pc_vars[]
 * status checking uses only a subset of all the printcap entries
 **************************************************************************/

PC_ENTRY Status_pc_vars[] = {
    {"af", PC_STRING, 0, 0, &AF},
    {"cl", PC_FLAG, 0, 0, (char **) &CL},
    {"cm", PC_STRING, 0, 0, &CM},
    {"co", PC_NUM, 0, 0, (char **) &CO},
    {"db", PC_NUM, 0, 0, (char **) &DB},
#ifdef EUCS_ZOPTIONS
    {"ed", PC_FLAG, 0, 0, (char **) &ED},
#endif
    {"eu", PC_FLAG, 0, 0, (char **) &EU},
    {"fd", PC_FLAG, 0, 0, (char **) &FD},
#ifdef EUCS_ZOPTIONS
    {"fl", PC_STRING, 0, 0, &FL},
#endif
    {"lf", PC_STRING, 0, DEFLOGF, &LF},
    {"lh", PC_NUM, 0, 0, (char **) &LH},
    {"lo", PC_STRING, 0, DEFLOCK, &LO},
    {"lp", PC_STRING, 0, 0, &LP},
    {"mx", PC_NUM, DEFMX, 0, (char **) &MX},
#ifdef EUCS_ZOPTIONS
    {"nc", PC_FLAG, 0, 0, (char **) &NC},
#endif
    {"nw", PC_FLAG, 0, 0, (char **) &NW},
    {"ps", PC_STRING, 0, 0, &PS},
    {"rm", PC_STRING, 0, 0, &RM},
    {"rp", PC_STRING, 0, 0, &RP},
    {"sd", PC_STRING, 0, 0, &SD},
    {"ss", PC_STRING, 0, 0, &SS},
    {"st", PC_STRING, 0, DEFSTAT, &ST},
    {"sv", PC_STRING, 0, 0, &SV},
    {"xu", PC_STRING, 0, 0, &XU}
};

int Status_pc_len = sizeof (Status_pc_vars) / sizeof (PC_ENTRY);

/**************************************************************************
 * Server_pc_vars[]
 * just used to get a select set of server information
 **************************************************************************/
PC_ENTRY Server_pc_vars[] = {
    {"db", PC_NUM, 0, 0, (char **) &DB},
    {"cm", PC_STRING, 0, 0, &CM},
    {"ps", PC_STRING, 0, 0, &PS},
    {"ss", PC_STRING, 0, 0, &SS},
    {"st", PC_STRING, 0, DEFSTAT, &ST},
    {"sv", PC_STRING, 0, 0, &SV}
};

int Server_pc_len = sizeof (Server_pc_vars) / sizeof (PC_ENTRY);

char *Lpdlogf = NULL;
char *Masterlock = NULL;
int Lpr_port_num;		/* port number to connect to */

int Maxportno;
int Minportno;

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#else
#define	LOG_ERR		4	/* synonym of LOG_ERROR */
#define	LOG_CRIT	5	/* critical information */
#define	LOG_WARNING	6	/* warning messages */
#define	LOG_NOTICE	7	/* important information */
#define	LOG_INFO	8	/* informational message */
#define	LOG_DEBUG	9	/* Debug level info */
#endif

int XLOG_ERR = LOG_ERR;		/* synonym of LOG_ERROR */
int XLOG_CRIT = LOG_CRIT;	/* critical information */
int XLOG_WARNING = LOG_WARNING;	/* warning messages */
int XLOG_NOTICE = LOG_NOTICE;	/* important information */
int XLOG_INFO = LOG_INFO;	/* informational message */
int XLOG_DEBUG = LOG_DEBUG;	/* Debug level info */

/* more Edinburgh: */

/* Printcap configuration stuff */
int num_confs = 0;		/* number of entries in pcap.conf file */
struct conf_entry conf[MAX_CONFS];	/* the entries in pcap.conf */

/*
 * Configuration file
 * 
 */

#ifdef LOCAL
char *Permfile_path = NULL;
char *Printcap_path = NULL;
#endif

#ifdef EUCS_ZOPTIONS
char *Zoptions_path = NULL;
char *Costcode_path = NULL;
char *Forms_active = NULL;
char *Forms_file = NULL;
#endif

#ifdef HESIOD
int *Hesiod_cross_domain = NULL;
char *Hesiod_printcap_key = NULL;
char *Hesiod_costcode_key = NULL;
#endif

#ifdef NIS
char *NIS_printcap_bykey = NULL;
char *NIS_printcap_byname = NULL;
char *NIS_costcode_bykey = NULL;
char *NIS_costcode_byname = NULL;
#endif

char *Errors_file = NULL;
char *Attach_file = NULL;

#ifdef EUCS_BANNER
char EUCS_banner_format;
#endif

char *ConfigFile = NULL;

char *Daemon_user = NULL;
char *Mail_command = NULL;
char *Mail_addressing = NULL;
char *Mail_from_address = NULL;

char *DefaultPrintcap = NULL;
char *Ctrlfile_logdir = NULL;

char *Filter_path = NULL;
char *Filter_LD_path = NULL;

char *Printcap_include_path = NULL;
char *Config_include_path = NULL;
char *Permfile_include_path = NULL;

char *Printer_port = NULL;
char *Host_domain = NULL;		/* the domain name */

char AllowNonPrivPorts, LogNonPrivPorts, Mail_on_errors, Restrict_symlinks;
char Log_no_filenames, Log_LPRMs, Log_LPQs, Log_LPCs, Log_LPRs;
char Check_for_nonprintable, Show_empty_queues;

char *SafeEnviron[MAXUSERENVIRON];	/* the current environment */

#ifdef SETPROCTITLE
char **Argv = NULL;			/* pointer to argument vector */
char *LastArgv = NULL;			/* end of argv */
#endif

char *Malloc_failed_msg = "malloc failed -- out of memory";

char DomainNameUnset, Use_printcap_cache, Use_perm_cache;
char DbgPcap, DbgRem, DbgLocal, DbgConf, DbgPerms;
