/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: get_printer.c
 * gets the default printer value for a user job
 ***************************************************************************
 * Get_Printer()
 * Get the Printer Name
 * 1. check for -P option
 * 2. check for PRINTER environment variable
 * 3. use first in printcap
 *
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

char default_printer_name[] = "lp";

void
Get_Printer (int all) {
    int i;

    if (Printer == 0) {
	if ((Printer = (char *) getenv ("PRINTER"))) {
	    if (Debug > 4)
		log (XLOG_DEBUG,
		     "Get_Printer: PRINTER='%s'", Printer);
	} else if
	    ((i = Get_pc_entry (default_printer_name, All_pc_vars, All_pc_len)))
	{
	    Printer = default_printer_name;
	    if (Debug > 4)
		log (XLOG_DEBUG,
		     "Get_Printer: default '%s'", Printer);
	} else {
	    /* use the default, first in list */
	    Printer = First_printer ();
	    if (Debug > 4)
		log (XLOG_DEBUG,
		     "Get_Printer: First_printer '%s'", Printer);
	}
    }
    if (Debug > 4)
	log (XLOG_DEBUG, "Get_printer: using Printer %s", Printer);
    if (all) {
	i = Get_pc_entry (Printer, All_pc_vars, All_pc_len);
    } else {
	i = Get_pc_entry (Printer, Status_pc_vars, Status_pc_len);
    }
    if (i == 0) {
	Diemsg ("no printcap entry for printer %s", Printer);
    }
}
