/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: Setup_filter.c
 *************************************************************************** 
 * create the command line to invoke a filter
 *  format: the format type of the data the filter will be invoked with
 *           (a single (char) letter identifies the type).
 *  filtername: an string containing the filter Name and arguments
 *  prog: address of a pointer which will be set to the program Name
 *
 * Actions:
 *  creates a string which contains the command to invoke a filter.
 *
 *  The command will be of the form:
 *  filtername arguments \   <- from filtername
 *      -P'Printer' -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Z'options'] [-C'class'] [-J'job'] [-R'accntname'] -n'login' -h'Host'
 *      -Fformat [affile]
 *
 *  The 'o' (of filter) only gets the -w, -l, -x, -y and -F options
 *************************************************************************/

#include "lp.h"
#include "common/setup_filter.h"
#include "library/errormsg.h"
  
static char *add_stropt (char *s, char *e, char *s1, char *s2);
static char *add_numopt (char *s, char *e, char *s1, int n);
static char *add_chropt (char *s, char *e, char *s1, int n);

char *
Setup_filter (int format, char *filtername) {
    static char cmd[BUFSIZ];	/* the command buffer */
    char *bp, *ep;		/* buffer pointer and general purpose pointer */

    assert (filtername);
    assert (*filtername);

    /* set up end of buffer pointer for error detection */
    ep = cmd + sizeof (cmd);

    /* First copy the filter progname and its fixed args */

    bp = estrcp (cmd, filtername, ep);
    bp = add_stropt (bp, ep, " -P", First_name);
    if (PWIDTH[0] == 0) {
	(void) sprintf (PWIDTH, "%d", PW);
    }
    bp = add_stropt (bp, ep, " -w", PWIDTH);
    bp = add_numopt (bp, ep, " -l", PL);
    bp = add_numopt (bp, ep, " -x", PX);
    bp = add_numopt (bp, ep, " -y", PY);

    if (format == 'o') {	/* of format */
	bp = add_chropt (bp, ep, " -F", format);
	if (bp == 0) {
	    log (XLOG_INFO, "filter command too long '%s'", cmd);
	    return (0);
	}
	return (cmd);
    }
    /*
     * -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \ [-Zoptions]
     * [-Cclass] [-Jjob] -nlogin -hHost -Fformat [affile]
     */
    if (format == 'l') {	/* add literal flag */
	bp = add_stropt (bp, ep, " -c", "");
    }
    if (INDENT[0]) {
	bp = add_stropt (bp, ep, " -i", INDENT);
    }
    if (ZOPTS[0]) {
	bp = add_stropt (bp, ep, " -Z", ZOPTS);
    }
    if (ACCNTNAME[0]) {
	bp = add_stropt (bp, ep, " -R", ACCNTNAME);
    }
    if (JOBNAME[0]) {
	bp = add_stropt (bp, ep, " -J", JOBNAME);
    }
    if (CLASSNAME[0]) {
	bp = add_stropt (bp, ep, " -C", CLASSNAME);
    }
    bp = add_stropt (bp, ep, " -n", LOGNAME);
    bp = add_stropt (bp, ep, " -h", FROMHOST);
    /*
     * accounting_filename
     */
    bp = add_chropt (bp, ep, " -F", format);
    if (AF && *AF) {
	bp = add_stropt (bp, ep, " ", AF);
    }
    if (bp == 0) {
	log (XLOG_INFO, "filter command too long '%s'", cmd);
    }
    return (cmd);
}

/* enhanced for security by jmason. This now wraps the supplied argument
 * in ticks (ie. -J'(stdin)') before passing it to sh for the exec; it
 * also checks the argument to see if it, in turn, contains ticks.
 * If it does, they are replaced with comma characters.
 *
 * This should stop users from being able to get lpd to exec arbitrary
 * command-lines as daemon, while still allowing a large degree of freedom
 * to filter writers.
 */
static char *
add_stropt (char *s, char *e, char *s1, char *s2) {
    char *tick, *new_s;

    s = estrcp (s, s1, e);
    /* wrap the argument in ticks (ie. -J'(stdin)'). */
    *(s++) = '\'';
    *s = '\0';
    new_s = estrcp (s, s2, e);
    while ((tick = strchr (new_s, '\''))) {
        *tick = ',';
    }
    s = new_s;
    *(s++) = '\'';
    *s = '\0';
    return (s);
}

static char *
add_numopt (char *s, char *e, char *s1, int n) {
    char b[31];
    (void) sprintf (b, "%d", n);
    assert(strlen(b)<sizeof(b));
    s = estrcp (s, s1, e);
    s = estrcp (s, b, e);
    return (s);
}

static char *
add_chropt (char *s, char *e, char *s1, int n) {
    char b[2];
    b[0] = n;
    b[1] = 0;
    s = estrcp (s, s1, e);
    s = estrcp (s, b, e);
    return (s);
}
