/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: setstatus.c
 * Set the lpd status into a status file
 ***************************************************************************/

#include "lp.h"
#include "common/setstatus.h"
#include "library/errormsg.h"

/* VARARGS1 */
void
#ifdef HAVE_STDARGS
setstatus (char *msg,...)
#else
setstatus (va_alist) va_dcl
#endif
{
#ifndef HAVE_STDARGS
    char *msg;
#endif
    VA_LOCAL_DECL
    int fd, i;			/* ACME Buggy Whip and Integers, Inc. */
    char buf[BUFSIZ];

    if (ST && *ST) {
	if ((fd = NonExlockcf (ST)) < 0) {
	    logerr (XLOG_INFO, "setstatus: cannot open %s", ST);
	} else {
	    VA_START (msg);
	    VA_SHIFT (msg, char *);
            assert(msg!=(char *)0);
	    (void) vsprintf (buf, msg, ap);
	    VA_END;

	    i = strlen (buf);
	    assert(i<(sizeof(buf)-1));
	    (void) strcat (buf, "\n"); i++;
	    if (write (fd, buf, i) != i) {
		logerr (XLOG_INFO, "setstatus: write error %s", ST);
	    }
	    if (Debug > 4)
		log (XLOG_DEBUG, "setstatus msg: %s", buf);
	    (void) close (fd);
	}
    }
}
