/*************************************************************************
 * portable macros to work with statfs (theoretically portable, at least)
 */

#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif
#ifdef HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#else
#ifdef HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#endif
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif

#ifdef USE_STATVFS
# define plp_statfs(path,buf) statvfs(path,buf)
# define plp_struct_statfs struct statvfs
# define statfs(path, buf) statvfs(path, buf)
# define plp_fs_free_bytes(f) (f.f_bavail * f.f_bsize)
#else

# ifdef USE_ULTRIX_STATFS
#  define plp_statfs(path,buf) statfs(path,buf)
#  define plp_struct_statfs struct fs_data
#  define plp_fs_free_bytes(f) (f.fd_bfree * f.fd_bsize)
# else

#  ifdef USE_STATFS_NO_BAVAIL
#   define plp_struct_statfs struct statfs
#   define plp_fs_free_bytes(f) (f.f_bfree * f.f_bsize)
#   define plp_statfs(path,buf) statfs(path,buf,sizeof(struct statfs),0)
#  else

#   ifdef USE_STATFS
#    define plp_struct_statfs struct statfs
#    define plp_fs_free_bytes(f) (f.f_bavail * f.f_bsize)
#    define plp_statfs(path,buf) statfs(path,buf)
#   endif
#  endif
# endif
#endif
