/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: setproctitle.c
 * Display the lpd status in the command line so it's visible by "ps".
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"
#include "LPD/setproctitle.h"

#ifndef HAVE_SETPROCTITLE

/*
 * jmason: ripped off from sendmail 8.6 -- setproctitle().
 * 
 * Copyright (c) 1983 Eric P. Allman Copyright (c) 1988, 1993 The Regents of the University
 * of California.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met: 1. Redistributions of source
 * code must retain the above copyright notice, this list of conditions and the following
 * disclaimer. 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution. 3. All advertising materials
 * mentioning features or use of this software must display the following
 * acknowledgement: This product includes software developed by the University of
 * California, Berkeley and its contributors. 4. Neither the name of the University nor
 * the names of its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT
 * SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/*
 *  SETPROCTITLE -- set process title for ps
 * 
 *	Parameters:
 *		fmt -- a printf style format string.
 *		a, b, c -- possible parameters to fmt.
 * 
 *	Returns: none.
 * 
 *	Side Effects: Clobbers argv of our main procedure so ps(1) will
 * 		      display the title.
 */

#ifdef SETPROCTITLE
# ifdef __hpux
#  include <sys/pstat.h>
# endif
# ifdef BSD4_4
#  include <machine/vmparam.h>
#  include <sys/exec.h>
#  ifdef __bsdi__
#   undef PS_STRINGS    /* BSDI 1.0 doesn't do PS_STRINGS as we expect */
#   define PROCTITLEPAD '\0'
#  endif
#  ifdef PS_STRINGS
#   define SETPROC_STATIC static
#  endif
# endif
# ifndef SETPROC_STATIC
#  define SETPROC_STATIC
# endif

# ifndef PROCTITLEPAD
#  define PROCTITLEPAD   ' '
# endif
#endif

/* VARARGS1 */
void
#ifdef HAVE_STDARGS
setproctitle (char *fmt,...)
#else
setproctitle (va_alist) va_dcl
#endif
{
#ifdef SETPROCTITLE
    register char *p;
    register int i;
    SETPROC_STATIC char buf[BUFSIZ];
# ifdef __hpux
    union pstun pst;
# endif
    extern char **Argv;
    extern char *LastArgv;
    VA_LOCAL_DECL
# ifndef HAVE_STDARGS
    char *fmt;
# endif

    p = buf;

    /* print lpd: heading for grep */
    (void) strcpy (p, "lpd: ");
    p += strlen (p);

    /* print the argument string */
    VA_START (fmt);
    VA_SHIFT (fmt, char *);
    (void) vsprintf (p, fmt, ap);
    VA_END;

    if (Debug > 3)
	log (XLOG_DEBUG, "proctitle: \"%s\"", buf);

    i = strlen (buf);

# ifdef __hpux
    pst.pst_command = buf;
    pstat (PSTAT_SETCMD, pst, i, 0, 0);
# else
#  ifdef PS_STRINGS
    PS_STRINGS->ps_nargvstr = 1;
    PS_STRINGS->ps_argvstr = buf;
#  else
    if (i > LastArgv - Argv[0] - 2) {
	i = LastArgv - Argv[0] - 2;
	buf[i] = '\0';
    }
    (void) strcpy (Argv[0], buf);
    p = &Argv[0][i];
    while (p < LastArgv)
	*p++ = PROCTITLEPAD;

#  endif
# endif
#endif				/* SETPROCTITLE */
}

#endif				/* !HAVE_SETPROCTITLE */
