/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: stty_termio.c
 * twiddle stty settings using termio
 ***************************************************************************/

/* the folks who are responsible for include files
 * must be the lowest paid/motivated ones in
 * OS development... (mj)
 */

#if !defined(TOSTOP) && defined(_TOSTOP)
#define TOSTOP _TOSTOP
#endif

struct bauds {
    char *string;
    int baud;
    int speed;
}     bauds[] = {

    "110", 110, B110,
    "134", 134, B134,
    "150", 150, B150,
    "300", 300, B300,
    "600", 600, B600,
    "1200", 1200, B1200,
    "1800", 1800, B1800,
    "2400", 2400, B2400,
    "4800", 4800, B4800,
    "9600", 9600, B9600,
    "19200", 19200, B19200,
    "38400", 38400, B38400,
    (char *) 0, 0, 0
};

struct termio tio;
static struct {
    char *string;
    int iset;
    int ireset;
    int oset;
    int oreset;
    int cset;
    int creset;
    int lset;
    int lreset;
}      tmodes[] = {

    /* input modes */
    {
	"ignbrk", IGNBRK, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-ignbrk", 0, IGNBRK, 0, 0, 0, 0, 0, 0,
    },
    {
	"brkint", BRKINT, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-brkint", 0, BRKINT, 0, 0, 0, 0, 0, 0,
    },
    {
	"ignpar", IGNPAR, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-ignpar", 0, IGNPAR, 0, 0, 0, 0, 0, 0,
    },
    {
	"parmrk", PARMRK, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-parmrk", 0, PARMRK, 0, 0, 0, 0, 0, 0,
    },
    {
	"inpck", INPCK, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-inpck", 0, INPCK, 0, 0, 0, 0, 0, 0,
    },
    {
	"istrip", ISTRIP, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-istrip", 0, ISTRIP, 0, 0, 0, 0, 0, 0,
    },
    {
	"inlcr", INLCR, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-inlcr", 0, INLCR, 0, 0, 0, 0, 0, 0,
    },
    {
	"igncr", IGNCR, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-igncr", 0, IGNCR, 0, 0, 0, 0, 0, 0,
    },
    {
	"icrnl", ICRNL, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-icrnl", 0, ICRNL, 0, 0, 0, 0, 0, 0,
    },
    {
	"iuclc", IUCLC, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-iuclc", 0, IUCLC, 0, 0, 0, 0, 0, 0,
    },
    {
	"ixon", IXON, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-ixon", 0, IXON, 0, 0, 0, 0, 0, 0,
    },
    {
	"ixany", IXANY, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-ixany", 0, IXANY, 0, 0, 0, 0, 0, 0,
    },
    {
	"ixoff", IXOFF, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-ixoff", 0, IXOFF, 0, 0, 0, 0, 0, 0,
    },
    {
	"decctlq", IXANY, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-decctlq", 0, IXANY, 0, 0, 0, 0, 0, 0,
    },
    {
	"tandem", IXOFF, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-tandem", 0, IXOFF, 0, 0, 0, 0, 0, 0,
    },
#ifdef IMAXBEL
    {
	"imaxbel", IMAXBEL, 0, 0, 0, 0, 0, 0, 0,
    },
    {
	"-maxbel", 0, IMAXBEL, 0, 0, 0, 0, 0, 0,
    },
#endif
    /* output modes */
    {
	"opost", 0, 0, OPOST, 0, 0, 0, 0, 0,
    },
    {
	"-opost", 0, 0, 0, OPOST, 0, 0, 0, 0,
    },
    {
	"olcuc", 0, 0, OLCUC, 0, 0, 0, 0, 0,
    },
    {
	"-olcuc", 0, 0, 0, OLCUC, 0, 0, 0, 0,
    },
    {
	"onlcr", 0, 0, ONLCR, 0, 0, 0, 0, 0,
    },
    {
	"-onlcr", 0, 0, 0, ONLCR, 0, 0, 0, 0,
    },
    {
	"ocrnl", 0, 0, OCRNL, 0, 0, 0, 0, 0,
    },
    {
	"-ocrnl", 0, 0, 0, OCRNL, 0, 0, 0, 0,
    },
    {
	"onocr", 0, 0, ONOCR, 0, 0, 0, 0, 0,
    },
    {
	"-onocr", 0, 0, 0, ONOCR, 0, 0, 0, 0,
    },
    {
	"onlret", 0, 0, ONLRET, 0, 0, 0, 0, 0,
    },
    {
	"-onlret", 0, 0, 0, ONLRET, 0, 0, 0, 0,
    },
    {
	"ofill", 0, 0, OFILL, 0, 0, 0, 0, 0,
    },
    {
	"-ofill", 0, 0, 0, OFILL, 0, 0, 0, 0,
    },
    {
	"ofdel", 0, 0, OFDEL, 0, 0, 0, 0, 0,
    },
    {
	"-ofdel", 0, 0, 0, OFDEL, 0, 0, 0, 0,
    },
    {
	"nl0", 0, 0, NL0, NLDLY, 0, 0, 0, 0,
    },
    {
	"nl1", 0, 0, NL1, NLDLY, 0, 0, 0, 0,
    },
    {
	"cr0", 0, 0, CR1, CRDLY, 0, 0, 0, 0,
    },
    {
	"cr1", 0, 0, CR1, CRDLY, 0, 0, 0, 0,
    },
    {
	"cr2", 0, 0, CR2, CRDLY, 0, 0, 0, 0,
    },
    {
	"cr3", 0, 0, CR3, CRDLY, 0, 0, 0, 0,
    },
    {
	"tab0", 0, 0, TAB0, TABDLY, 0, 0, 0, 0,
    },
    {
	"tab1", 0, 0, TAB1, TABDLY, 0, 0, 0, 0,
    },
    {
	"tab2", 0, 0, TAB2, TABDLY, 0, 0, 0, 0,
    },
    {
	"tab3", 0, 0, TAB2, TABDLY, 0, 0, 0, 0,
    },
    {
	"bs0", 0, 0, BS0, BSDLY, 0, 0, 0, 0,
    },
    {
	"bs1", 0, 0, BS1, BSDLY, 0, 0, 0, 0,
    },
    {
	"vt0", 0, 0, VT0, VTDLY, 0, 0, 0, 0,
    },
    {
	"vt1", 0, 0, VT1, VTDLY, 0, 0, 0, 0,
    },
    {
	"ff0", 0, 0, FF0, FFDLY, 0, 0, 0, 0,
    },
    {
	"ff1", 0, 0, FF1, FFDLY, 0, 0, 0, 0,
    },
    {
	"nopost", 0, 0, 0, OPOST, 0, 0, 0, 0,
    },
    {
	"-nopost", 0, 0, OPOST, 0, 0, 0, 0, 0,
    },
    {
	"fill", 0, 0, OFILL, OFDEL, 0, 0, 0, 0,
    },
    {
	"-fill", 0, 0, 0, OFILL | OFDEL, 0, 0, 0, 0,
    },
    {
	"nul-fill", 0, 0, OFILL, OFDEL, 0, 0, 0, 0,
    },
    {
	"del-fill", 0, 0, OFILL | OFDEL, 0, 0, 0, 0, 0,
    },
#ifdef XTABS
    {
	"-tabs", 0, 0, XTABS, TABDLY, 0, 0, 0, 0,
    },
#endif
    /* control modes */
    {
	"cs5", 0, 0, 0, 0, CS5, CSIZE, 0, 0,
    },
    {
	"cs6", 0, 0, 0, 0, CS6, CSIZE, 0, 0,
    },
    {
	"cs7", 0, 0, 0, 0, CS7, CSIZE, 0, 0,
    },
    {
	"cs8", 0, 0, 0, 0, CS8, CSIZE, 0, 0,
    },
    {
	"cstopb", 0, 0, 0, 0, CSTOPB, 0, 0, 0,
    },
    {
	"-cstopb", 0, 0, 0, 0, 0, CSTOPB, 0, 0,
    },
    {
	"cread", 0, 0, 0, 0, CREAD, 0, 0, 0,
    },
    {
	"-cread", 0, 0, 0, 0, 0, CREAD, 0, 0,
    },
    {
	"parenb", 0, 0, 0, 0, PARENB, 0, 0, 0,
    },
    {
	"-parenb", 0, 0, 0, 0, 0, PARENB, 0, 0,
    },
    {
	"parodd", 0, 0, 0, 0, PARODD, 0, 0, 0,
    },
    {
	"-parodd", 0, 0, 0, 0, 0, PARODD, 0, 0,
    },
    {
	"hupcl", 0, 0, 0, 0, HUPCL, 0, 0, 0,
    },
    {
	"-hupcl", 0, 0, 0, 0, 0, HUPCL, 0, 0,
    },
    {
	"clocal", 0, 0, 0, 0, CLOCAL, 0, 0, 0,
    },
    {
	"-clocal", 0, 0, 0, 0, 0, CLOCAL, 0, 0,
    },
#ifdef LOBLK
    {
	"loblk", 0, 0, 0, 0, LOBLK, 0, 0, 0,
    },
    {
	"-loblk", 0, 0, 0, 0, 0, LOBLK, 0, 0,
    },
#endif
    {
	"parity", 0, 0, 0, 0, PARENB | CS7, PARODD | CSIZE, 0, 0,
    },
    {
	"-parity", 0, 0, 0, 0, CS8, PARENB | CSIZE, 0, 0,
    },
    {
	"evenp", 0, 0, 0, 0, PARENB | CS7, PARODD | CSIZE, 0, 0,
    },
    {
	"-evenp", 0, 0, 0, 0, CS8, PARENB | CSIZE, 0, 0,
    },
    {
	"oddp", 0, 0, 0, 0, PARENB | PARODD | CS7, CSIZE, 0, 0,
    },
    {
	"-oddp", 0, 0, 0, 0, CS8, PARENB | PARODD | CSIZE, 0, 0,
    },
    {
	"stopb", 0, 0, 0, 0, CSTOPB, 0, 0, 0,
    },
    {
	"-stopb", 0, 0, 0, 0, 0, CSTOPB, 0, 0,
    },
    {
	"hup", 0, 0, 0, 0, HUPCL, 0, 0, 0,
    },
    {
	"-hup", 0, 0, 0, 0, 0, HUPCL, 0, 0,
    },
#ifdef CRTSCTS
    {
	"crtscts", 0, 0, 0, 0, CRTSCTS, 0, 0, 0,
    },
    {
	"-crtscts", 0, 0, 0, 0, 0, CRTSCTS, 0, 0,
    },
#endif
    /* local modes */
    {
	"isig", 0, 0, 0, 0, 0, 0, ISIG, 0,
    },
    {
	"-isig", 0, 0, 0, 0, 0, 0, 0, ISIG,
    },
    {
	"noisig", 0, 0, 0, 0, 0, 0, 0, ISIG,
    },
    {
	"-noisig", 0, 0, 0, 0, 0, 0, ISIG, 0,
    },
    {
	"icanon", 0, 0, 0, 0, 0, 0, ICANON, 0,
    },
    {
	"-icanon", 0, 0, 0, 0, 0, 0, 0, ICANON,
    },
    {
	"cbreak", 0, 0, 0, 0, 0, 0, ICANON, 0,
    },
    {
	"-cbreak", 0, 0, 0, 0, 0, 0, 0, ICANON,
    },
    {
	"xcase", 0, 0, 0, 0, 0, 0, XCASE, 0,
    },
    {
	"-xcase", 0, 0, 0, 0, 0, 0, 0, XCASE,
    },
    {
	"echo", 0, 0, 0, 0, 0, 0, ECHO, 0,
    },
    {
	"-echo", 0, 0, 0, 0, 0, 0, 0, ECHO,
    },
    {
	"echoe", 0, 0, 0, 0, 0, 0, ECHOE, 0,
    },
    {
	"-echoe", 0, 0, 0, 0, 0, 0, 0, ECHOE,
    },
    {
	"crterase", 0, 0, 0, 0, 0, 0, ECHOE, 0,
    },
    {
	"-crterase", 0, 0, 0, 0, 0, 0, 0, ECHOE,
    },
    {
	"echok", 0, 0, 0, 0, 0, 0, ECHOK, 0,
    },
    {
	"-echok", 0, 0, 0, 0, 0, 0, 0, ECHOK,
    },
    {
	"lfkc", 0, 0, 0, 0, 0, 0, ECHOK, 0,
    },
    {
	"-lfkc", 0, 0, 0, 0, 0, 0, 0, ECHOK,
    },
    {
	"echonl", 0, 0, 0, 0, 0, 0, ECHONL, 0,
    },
    {
	"-echonl", 0, 0, 0, 0, 0, 0, 0, ECHONL,
    },
    {
	"noflsh", 0, 0, 0, 0, 0, 0, NOFLSH, 0,
    },
    {
	"-noflsh", 0, 0, 0, 0, 0, 0, 0, NOFLSH,
    },
    {
	"tostop", 0, 0, 0, 0, 0, 0, TOSTOP, 0,
    },
    {
	"-tostop", 0, 0, 0, 0, 0, 0, 0, TOSTOP,
    },
#ifdef ECHOCTL
    {
	"echoctl", 0, 0, 0, 0, 0, 0, ECHOCTL, 0,
    },
    {
	"-echoctl", 0, 0, 0, 0, 0, 0, 0, ECHOCTL,
    },
    {
	"ctlecho", 0, 0, 0, 0, 0, 0, ECHOCTL, 0,
    },
    {
	"-ctlecho", 0, 0, 0, 0, 0, 0, 0, ECHOCTL,
    },
#endif
#ifdef ECHOPRT
    {
	"echoprt", 0, 0, 0, 0, 0, 0, ECHOPRT, 0,
    },
    {
	"-echoprt", 0, 0, 0, 0, 0, 0, 0, ECHOPRT,
    },
    {
	"prterase", 0, 0, 0, 0, 0, 0, ECHOPRT, 0,
    },
    {
	"-prterase", 0, 0, 0, 0, 0, 0, 0, ECHOPRT,
    },
#endif
#ifdef ECHOKE
    {
	"echoke", 0, 0, 0, 0, 0, 0, ECHOKE, 0,
    },
    {
	"-echoke", 0, 0, 0, 0, 0, 0, 0, ECHOKE,
    },
    {
	"crtkill", 0, 0, 0, 0, 0, 0, ECHOKE, 0,
    },
    {
	"-crtkill", 0, 0, 0, 0, 0, 0, 0, ECHOKE,
    },
#endif
    /* convenience modes */
    {
	"lcase", IUCLC, 0, OLCUC, 0, 0, 0, XCASE, 0,
    },
    {
	"-lcase", 0, IUCLC, 0, OLCUC, 0, 0, 0, XCASE,
    },
    {
	"LCASE", IUCLC, 0, OLCUC, 0, 0, 0, XCASE, 0,
    },
    {
	"-LCASE", 0, IUCLC, 0, OLCUC, 0, 0, 0, XCASE,
    },
    {
	"nl", 0, ICRNL, 0, ONLCR, 0, 0, 0, 0,
    },
    {
	"-nl", ICRNL, INLCR | IGNCR, ONLCR, OCRNL | ONLRET, 0, 0, 0, 0,
    },
    {
	"litout", 0, 0, OPOST, 0, CS8, CSIZE | PARENB, 0, 0,
    },
    {
	"-litout", 0, 0, 0, OPOST, CS7 | PARENB, CSIZE, 0, 0,
    },
    {
	"pass8", 0, ISTRIP, 0, 0, CS8, CSIZE | PARENB, 0, 0,
    },
    {
	"-pass8", ISTRIP, 0, 0, 0, CS7 | PARENB, CSIZE, 0, 0,
    },
    {
	"raw", 0, -1, 0, OPOST,
	CS8, CSIZE | PARENB, 0, ISIG | ICANON | XCASE,
    },
#ifdef IMAXBEL
    {
	"-raw", BRKINT | IGNPAR | ISTRIP | ICRNL | IXON | IMAXBEL, 0, OPOST, 0,
	CS7 | PARENB, CSIZE, ISIG | ICANON, 0,
    },
    {
	"sane", BRKINT | IGNPAR | ISTRIP | ICRNL | IXON | IMAXBEL,
	IGNBRK | PARMRK | INPCK | INLCR | IGNCR | IUCLC | IXOFF,
	OPOST | ONLCR,
	OLCUC | OCRNL | ONOCR | ONLRET | OFILL | OFDEL | NLDLY | CRDLY |
	TABDLY | BSDLY | VTDLY | FFDLY,
	CS7 | PARENB | CREAD, CSIZE | PARODD | CLOCAL,
	ISIG | ICANON | ECHO | ECHOK, XCASE | ECHOE | ECHONL | NOFLSH,
    },
#endif				/* IMAXBEL */
    {
	"cooked", BRKINT | IGNPAR | ISTRIP | ICRNL | IXON, 0, OPOST, 0,
	CS7 | PARENB, CSIZE, ISIG | ICANON, 0,
    },
    0,
};

void
Do_stty (int fd) {
    int i;
    char buf[BUFSIZ], *ep, *arg;

    if (ioctl (fd, TCGETA, &tio) < 0) {
	logerr_die (XLOG_INFO, "cannot get tty parameters");
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG,
	     "stty: before imode 0x%x, omode 0x%x, cmode 0x%x, lmode 0x%x",
	     tio.c_iflag, tio.c_oflag, tio.c_cflag, tio.c_lflag);

    if (BR) {
	for (i = 0; bauds[i].baud && BR != bauds[i].baud; i++);
	if (i == 0) {
	    fatal (XLOG_INFO, "illegal baud rate %d", BR);
	}
    tio.c_cflag &= ~CBAUD;
    tio.c_cflag |= bauds[i].speed;
    }
    /* don't support FC, FS, XC, XS */

    if (TY && *TY) {
	(void) strcpy (buf, TY);
	ep = buf;
    } else if (MS && *MS) {
	(void) strcpy (buf, MS);
	ep = buf;
    } else {
	ep = 0;
    }
    while (ep && *ep) {
	for (; *ep && (isspace (*ep) || *ep == ','); ++ep);
	for (arg = ep; *ep && !isspace (*ep) && *ep != ','; ++ep);
	if (*ep) {
	    *ep = 0;
	    ++ep;
	}
	for (i = 0; tmodes[i].string && strcmp (tmodes[i].string, arg); i++);

	if (tmodes[i].string) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: modes %s, ic 0x%x is 0x%x oc 0x%x os 0x%x cc 0x%x cs 0x%x lc 0x%x ls 0x%x",
		     tmodes[i].string,
		     tmodes[i].ireset, tmodes[i].iset,
		     tmodes[i].oreset, tmodes[i].oset,
		     tmodes[i].creset, tmodes[i].cset,
		     tmodes[i].lreset, tmodes[i].lset);

	    tio.c_iflag &= ~tmodes[i].ireset;
	    tio.c_iflag |= tmodes[i].iset;
	    tio.c_oflag &= ~tmodes[i].oreset;
	    tio.c_oflag |= tmodes[i].oset;
	    tio.c_cflag &= ~tmodes[i].creset;
	    tio.c_cflag |= tmodes[i].cset;
	    tio.c_lflag &= ~tmodes[i].lreset;
	    tio.c_lflag |= tmodes[i].lset;
	    continue;
	}
	for (i = 0; bauds[i].string && strcmp (bauds[i].string, arg); i++);
	if (bauds[i].string) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: speed %s", arg);
	    tio.c_cflag &= ~CBAUD;
	    tio.c_cflag |= bauds[i].speed;
	    continue;
	}
	fatal (XLOG_INFO, "unknown mode: %s\n", arg);
    }
    /* VMIN & VTIME: suggested by Michael Joosten */
    if (RW && (tio.c_cflag & ICANON) == 0) {
	/* only do this if ICANON is off -- Martin Forssen */
	if (Debug > 3)
	    log (XLOG_DEBUG,
		"setting port to read/write with unbuffered reads (MIN=1, TIME=0)");
	tio.c_cc[VMIN] = 1;
	tio.c_cc[VTIME] = 0;
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG, "stty: before imode 0x%x, omode 0x%x, cmode 0x%x, lmode 0x%x",
	     tio.c_iflag, tio.c_oflag, tio.c_cflag, tio.c_lflag);
    if (ioctl (fd, TCSETA, &tio) < 0) {
	logerr_die (XLOG_NOTICE, "cannot set tty parameters");
    }
}
