.ig
$Header: 09.t,v 1.1 88/05/21 18:39:48 papowell Locked $
$log$
..
.LG
.NH 1
Line Printer Spooler Administration
.SM
.PP
Most of the administration of PLP commands consists of
printcap entries,
permissions entries,
and spool queue management.
In addition,
killing and restarting the
.I lpd
daemon is occasionally needed.
.NH 2
Printcap File Management
.PP
Each spool queue or printer must have an entry in a printcap file.
In a single,
non-networked environment,
this is usually a simple and easily managed system,
but in a highly networked environment it may be a difficult procedure.
In order to simply the generation of printcap files,
the PLP distribution has a set of programs that allow a simple printcap
data base to be set up,
and a set of programs to generate printcaps for different hosts.
.NH 3
Printer Names
.PP
Printer names and aliases are a major problem faced by administrators.
The convention adopted by many sites is to make the primary (first)
name of the printer correspond to the physical printer type and its
location.
For exmple,
.L lw_lind23
is the name of the Apple LaserWriter in Lind Hall 23.
Additional aliases or names can then be added.
.PP
In performing permissions checking,
the name supplied by the user is checked against the information in the
printer permissions file,
and also checked in the printcap database.
For this reason,
the name used in the printer permissions file and the
name of the printer should be identical.
When sending files to a remote site,
the printer name found in the printcap entry and not the
alias provided by a user is used to determine permissions.
.NH 3
Printcap File Generation
.PP
Each printer usually has three forms of printcap entries:
remote,
forward,
and output device.
The remote entry is used by a system that will treat the spool queue
as a remote site and forward all jobs to a remote site.
The forwarding entry is usually used for sites that accept jobs
from other sites,
and then forward them to a remote site.
The forwarding is usually done by a specialized file transfer program.
Finally,
a local or output device entry is used for the host which has the
actual printer attached.
Files with the appropriate form printcap entry can be prepared.
As part of the PLP distribution,
a set of programs to generate printcap files tailored to a
particular host has been developed,
and is available in the
.L printcap
directory.
.NH 3
Printer Permissions File
.PP
The main printer permissions file is intended to act as a filter for
general user permissions.
As described elsewhere,
each line is checked for a matching set of user permissions,
and the first matching line determines the available permissions.
It is strongly suggested that the set of entries in the printer_perms
file be used to filter out unauthorized users,
and the remaining set of entries used to determine the appropriate
permissions.
.PP
If restrictions on the number of pages are desired,
the printer permissions file can be used on a global or local basis.
The current page count field is compared against the maximum
field at the time a job is spooled or printed.
In order to keep this file concurrent,
some form of simple permissions file updating must be done.
This can be done by using the
.I pac
(printer accounting) program and a suitable shell script.
Due to the wide divergence of different sites,
an accounting package to do this automatically has not been
provided.
.NH 2
Using LPC
.PP
The
.I lpc
program provides control over line printer activity.
The major commands and their intended use are described in this section.
See the manual page
.IR lpc (8)
for details, and other commands not mentioned here.
.LP
.B
status, lpq
.R
.IP
Status is used to display the current status of various line printers.
The lpq function invokes lpq with various parameters.
This is useful to monitor various printer activities.
.LP
.B
start, abort, kill
.R
.IP
.I Start
enables printing and requests 
.I lpd
to start printing jobs.
.sp
.I Abort
disables unspooling and terminates an active server and its
filters.
This is normally used to kill a
catatonic filter or spooler process
(i.e.,
.I lpq
reports that there is a daemon present but nothing is
happening).
It does not remove any jobs from the queue.
.sp
.I Kill
does an abort followed by a start.
This is handy for restarting a queue whose server process
is hung due to problems with a job or hardware.
Note that there is an upper limit on the numbers of times a server will
attempt to print a job.
.LP
.B
requeue
.R
.IP
This command is useful if the printer hardware malfunctions
during the printing of a job;
.I Requeue
will stop the printer, kill the current job, and respool the job
to the queue at top priority. Once the operator has completed
whatever printer maintenance needs to be done, the printer
should be restarted using the
.I start
command, and the job will the reprinted.
.LP
.B
enable, disable
.R
.IP
.I Enable
and 
.I disable
control spooling to a queue or list of queues.
This is used to prevent
.I lpr
from putting new jobs in the spool queue.
The main use is to prevent users from putting jobs in the queue
when the printer is expected to be unavailable for a long time.
.LP

.B
lpd
.R
.IP
.I Lpd
reports the state of the lpd on that system and its pid.
.LP

.B restart
.IP
.I Restart
allows mere mortal users to restart printer daemons when
.I lpq
reports that there is no daemon present.
.LP
.B stop
.IP
.I Stop
disables any further unspooling,
but does not kill off the server.
This is a clean way to shutdown a printer in order to perform
maintenence, etc.
Note that users can still enter jobs in a
spool queue while a printer is
.IR stopped.
.LP
.B topq
.IP
.I Topq
places jobs at the top of a printer queue.
This can be used to reorder high priority jobs.
.LP
.B
remote (command)
.R
.IP
.I remote
is used to send a command to the remote site for processing.
This is useful to control remote line printer queues.
.LP
.B clean
.IP
.I clean
totally purges a queue.
This functionality is needed very infrequently,
and perhaps should be removed.
.NH 2
Starting the LPD Daemon
.PP
Under various circumstances it may be necessary to kill and/or
restart the
.I lpd
daemon.
The currently executing daemon writes
its process ID and the time it was started in the
.L /var/spool/lpd/lock.lpd 
file.
The
program in Figure 9.1,
.L lpd.restart ,
can be used to kill and restart the LPD daemon.
.KF
.in +1i
.SM
.L
.nf
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
#!/bin/sh

pid=`head -1 /var/spool/lpd/lpd.lock`
host=`hostname`

if [ "x$pid" = x ] ; then
    echo "$h: no lpd daemon"
else
    echo "$h: killing $pid and restarting lpd"
    kill $pid; sleep 1
    /usr/local/bin/lpd
fi
.fi
.LG
.R
.in -1i
.ce
Figure 9.1 lpd.restart Program
.KE
