/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

#include <stdio.h>
#ifdef SVR4
#include <string.h>
#define		index(s,c)	strchr(s,c)
#else
#include <strings.h>
#endif
#include <ctype.h>
#include <regexp.h>
#include "config.h"
#include "infostruct.h"

extern struct filedatastruct filedata; 
extern struct convertdatastruct convertdata[];

/*  Calls the fident program and returns what type of file it is
 *  right now it returns a string, maybe one day it will return a
 *  unique number... sigh 
 */
int intype()
{
   int 	count, c;
   FILE	*fd;
   char	cmd[200], string[100];

	/*  If the user supplied an input type */

   if (filedata.in_type != NULL) {
	strtolower(filedata.in_type);
	return(TRUE);
   }

	/*  We have to figure what the input type is */

   strcpy(cmd, FIDENT);
   strcat(cmd, " ");
   strcat(cmd, filedata.in_file);

   fd = popen(cmd, "r");
   if (fd == NULL) {
      fprintf(stderr, "Error opening file identification program\n");
      exit(INTERNALERROR);
   }

   count=0;

	/*  Suck out the filename part up to the first colon */
   c = getc(fd);
   while( (c != EOF) && ( c != ':') )
       c = getc(fd);

	/* There is an extra getc in here which removes the extra space */

   while(( c = getc(fd)) != EOF) {
      if( isprint(c) ) {
	 if ( (c != 32) || ((c == 32) && (count != 0) ) ) {
            string[count] = c;
            count++; 
         }
      }
   }

   pclose(fd);

   string[count] = '\0';

   if (debug)
       fprintf(stderr, "input identified as %s\n", string);

   filedata.in_type = (char *) malloc( strlen(string) + 5 );
   strcpy(filedata.in_type, string);
   strtolower(filedata.in_type);

   return(TRUE);
}

/** Figure out what the output type is, either by converting
 ** the user supplied ascii type, or by looking at the output filename
 ** and seeing what we can figure from that 
 **/

int outtype()
{
   int loop;

   		/*  If output type specified  */
   if (filedata.out_type != NULL) {		
	strtolower(filedata.out_type);
	return(TRUE);
   }

/*  See if we can figure output type by filename suffix */

		/*  It's kind of hard to get a name from stdout */
  if (filedata.real_out_file == NULL) 
	return(FALSE);
  
  for ( loop = strlen(filedata.real_out_file); loop != 0; loop--) {
      if (filedata.real_out_file[loop] == '.')
	  break;
  }
		/*  We couldn't find a . in there, sorry */
  if (loop == 0) 
      return(FALSE);

		/*  We found a . in there, so make that the type */ 
  filedata.out_type = &filedata.real_out_file[loop+1];
  strtolower(filedata.out_type);

  return(TRUE);
}

char * matchintype(string)
char *string;
{
  regexp *rege;
  int answer;
  int loop;
  char *p;

  for (loop = 1; convertdata[loop].source != NULL; loop++) 
      if (  convertdata[loop].command == NULL   
            && index(convertdata[loop].source, '*') ) {

          rege = regcomp( convertdata[loop].source );
          answer = regexec(rege, string);
          if (answer == 1) {
	     p = (char *) malloc( strlen(convertdata[loop].destination) + 2);
	     strcpy(p, convertdata[loop].destination);
	     free(string);
	     return(p);
          }
      }
  return(string);
}

