/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "infostruct.h"

extern struct filedatastruct   filedata;
extern struct convertdatastruct convertdata[];
extern int convertdatasize;

int figure_convert(in_type, out_type, spot)
char *in_type, *out_type;
int  spot;
{
     int count, count2;
     int herebefore;
	
#ifdef DEBUGALL
     fprintf(stderr, "Figuring how to convert %s to %s\n", in_type, out_type);
#endif

	/*  Check to see if we havn't already been at this input type 
	 *  If we have get out.. or else we might end up in an infinite
	 *  Loop trying to find a conversion 
	 */
     for (count = 0; count < spot; count++) {
	if ( !strcmp( convertdata[ filedata.convert_list[count] ].source 
		     ,in_type) ) 
	   return(FALSE);
     }

/*  check to see if the output matches input, then we found a way */
/*  Make sure the string matches exactly */

     if ( !strcmp(in_type, out_type) )	/*  Then done */
	return(TRUE);

     /*  Check to see if there is a direct way though now. */

     for (count = 1; convertdata[count].source != NULL; count++)
	if ( !strcmp(convertdata[count].source, in_type) &&
	     !strcmp(convertdata[count].destination, out_type) ) {
	   filedata.convert_list[spot] = count;
           return(TRUE);
	 }

     /*  If no direct way, recursively find a way starting at beginnning */

     for (count = 1; convertdata[count].source != NULL; count++) {
	if ( !strcmp(convertdata[count].source, in_type) ) {

		/*  recursion, send the output type as the next
		 *  input type and move the storage spot by one */

           filedata.convert_list[spot] = count;
           if( figure_convert( convertdata[count].destination, 
	   		       out_type, spot+1))
	         return(TRUE);
	   }
     }
     return(FALSE);
}

