# Code of Conduct #

This Code was approved by the Sage community by a vote which ended on
March 31, 2024.

## Introduction ##

The Sage community is comprised of an international mixture of mathematicians,
computer scientists, engineers, researchers, teachers, amateurs, and others
with varied backgrounds. This diversity is one of our strengths, but it can
also lead to communication problems and unhappiness. People who love working on
Sage can more effectively collaborate with others if they follow this Code.

This document is complemented by a second, [the Code of Conduct
Committee Manual](/CODE_OF_CONDUCT_COMMITTEE.md), which describes the
roles and procedures for the Sage Code of Conduct Committee.

## Guidelines ##

1. Be friendly and patient.

2. Be welcoming. We strive to be a community that welcomes and supports people
   of all backgrounds and identities.

3. Be considerate. Your work will be used by other people and you in turn will
   depend on the work of others. Any decision you take will affect users and
   developers, so you should take those consequences into account when making
   decisions. Conversely, Sage is constantly evolving, and earlier decisions
   that were made in good faith may sometimes need to be reconsidered.
   Nonetheless, we should still appreciate the hard work done in the past.

4. Be respectful and polite. Not all of us will agree all the time, but
   disagreement is no excuse for poor behavior and poor manners. We might all
   experience some frustration now and then, but we cannot allow that
   frustration to morph into personal attacks. It is important to remember that
   a community where people feel uncomfortable or threatened is not a
   productive one. Members of the Sage community should be respectful when
   dealing with other developers and users.

   When we disagree, we should try to understand why. Disagreements, both
   social and technical, happen all the time. It is important that we resolve
   disagreements and differing views constructively. Being unable to understand
   why someone holds a viewpoint does not mean that they are wrong. Do not
   forget that it is human to err. Blame alone gets us nowhere, it is better to
   help resolve issues so we can all learn from our mistakes.

5. We will not accept harassment or other exclusionary behavior, such as:

    1. Violent or intimidating threats or language directed against another person.
    2. Sexist, racist, or otherwise discriminatory jokes and language.
    3. Posting sexually explicit or violent material.
    4. Posting (or threatening to post) other people’s personally identifying information (“doxing”).
    5. Personal insults, especially those using racist or sexist terms.
    6. Unwelcome sexual attention or comments.
    7. Excessive profanity. Please avoid swear words; people differ greatly in their sensitivity to swearing.
    8. Repeated harassment of others. In general, if someone asks you to stop, then stop.
    9. Advocating for, or encouraging, any of the above behavior.

This Code of Conduct applies to all spaces managed by the Sage
project, including all public and private mailing lists, issue
trackers, wikis, and any other communication channel used by our
community. It also applies to Sage Days and any other in-person or
virtual events.

This Code of Conduct should be honored by everyone who participates in
the Sage community formally or informally, or claims any affiliation
with the project, in any project-related activities, and, especially,
when representing the project, in any role.

This Code is neither exhaustive nor complete. It serves to distill our
common understanding of a collaborative, shared environment and
goals. Please try to follow this Code in spirit as much as in letter,
to create a friendly and productive environment that enriches the
surrounding community.

## Diversity statement ##

Sage welcomes and encourages participation in our community by people
of all backgrounds and identities. We are committed to promoting and
sustaining a culture that values mutual respect, tolerance, and
learning, and we work together as a community to help each other live
out these values.

No matter how you identify yourself or how others perceive you: we
welcome you. Though no list can hope to be comprehensive, we
explicitly honor diversity in: age, culture, ethnicity, genotype,
gender identity or expression, language, national origin, neurotype,
phenotype, political beliefs, profession, race, religion, sexual
orientation, socioeconomic status, subculture, and technical ability,
to the extent that these do not conflict with this Code of Conduct.

Though we welcome people fluent in all languages, Sage development is
conducted in English.

Standards for behavior in the Sage community are detailed in the Code
of Conduct above. Participants in our community should uphold these
standards in all their interactions and help others to do so as well.

## Reporting guidelines ##

We know that it is painfully common for internet communication to
start at or devolve into obvious and flagrant abuse. We also recognize
that sometimes people may have a bad day, or be unaware of some of the
guidelines in this Code of Conduct. Please keep this in mind when
deciding on how to respond to a breach of this Code.

For clearly intentional breaches, report those to the Sage Code of
Conduct Committee (see below). For possibly unintentional breaches,
you may reply to the person and point out this Code of Conduct (either
in public or in private, whatever is most appropriate). If you would
prefer not to do that, please feel free to report to the Sage Code of
Conduct Committee directly, or ask the committee for advice, in
confidence.

You can report issues to the Sage Code of Conduct Committee at
sage-conduct@googlegroups.com. Currently, the committee consists of:

- Nils Bruin
- J-P Labbé
- John Palmieri
- Viviane Pons
- David Roe
- Julian Rüth

If your report involves any members of the committee, or if they feel
they have a conflict of interest in handling it, then they will recuse
themselves from considering your report. Alternatively, if, for any
reason, you feel uncomfortable making a report to the whole committee,
then you can also contact individual committee members.

## Incident reporting resolution & Code of Conduct enforcement ##

This section summarizes the most important points; more details can be
found in the Code of Conduct enforcement guide.

The Sage Code of Conduct Committee will investigate and respond to all
complaints. The committee will protect the identity of the reporter,
and treat the content of complaints as confidential (unless the
reporter agrees otherwise).

In case of severe and obvious breaches, e.g., personal threat or
violent, sexist or racist language, the committee will immediately
disconnect the originator from Sage communication channels; please see
the manual for details.

In cases not involving clear severe and obvious breaches of this Code
of Conduct, the process for acting on any received Code of Conduct
violation report will be:

- acknowledgement that the report has been received
- discussion within the committee
- discussion with and/or feedback provided to the reportee
- mediation (if feedback didn’t help, and only if both reporter and
  reportee agree to this)
- enforcement via transparent decision by the Sage Code of Conduct Committee

The committee will respond to any report as soon as possible, and our
goal will be to respond within 72 hours.

Potential consequences for violating the Sage Code of Conduct include:

- Nothing (for example if the matter has been resolved publicly while
  the committee was considering responses)
- Private feedback or reprimand to the individual(s) involved
- Warning the person to cease their behavior and that any further
  reports will result in sanctions
- A public announcement that an incident occurred
- Mediation (only if both reporter and reportee agree)
- An imposed vacation (e.g. asking someone to "take a week off" from a mailing list)
- A permanent or temporary ban from some or all Sage spaces (mailing
  lists, GitHub repos, in-person events, etc.)
- Assistance to the reporter with a report to other bodies, for
  example, institutional offices or appropriate law enforcement
  agencies
- Publishing an account of the harassment and calling for the
  resignation of the alleged harasser from their responsibilities
  (usually pursued by people without formal authority: may be called
  for if the person is the event leader, or refuses to stand aside
  from the conflict of interest, or similar)
- Any other response that the Sage Code of Conduct Committee deems necessary and
  appropriate to the situation

## Policies and procedures of common project platforms ##

[GitHub Community Guidelines](https://docs.github.com/en/site-policy/github-terms/github-community-guidelines) apply:
- [Report abuse to GitHub](https://github.com/contact/report-abuse),
  [Block a user from your personal account](https://docs.github.com/en/communities/maintaining-your-safety-on-github/blocking-a-user-from-your-personal-account)
- [Manage disruptive comments](https://docs.github.com/en/communities/moderating-comments-and-conversations/managing-disruptive-comments),
- [Lock conversations](https://docs.github.com/en/communities/moderating-comments-and-conversations/locking-conversations)
(requires Maintainer role or [Organization Moderator role](https://docs.github.com/en/organizations/managing-peoples-access-to-your-organization-with-roles/managing-moderators-in-your-organization))

Google groups:
- [Content policy](https://support.google.com/groups/answer/4561696)
- [Reporting procedures](https://support.google.com/groups/answer/81275)

## Amending the Code of Conduct ##

This document may be amended by a vote of the Sage
community in the sage-devel Google group, with the exception of facts
like the membership of the Sage Code of Conduct Committee, changes to
URLs, or changes to email addresses: changes like that can be done via
a normal pull request. Any pull requests involving this document
should list the committee members as reviewers.

## Credits ##

Portions of this are adapted from the
[SciPy code of
conduct](https://docs.scipy.org/doc/scipy/dev/conduct/code_of_conduct.html)
and the [NumFOCUS code of
conduct](https://numfocus.org/code-of-conduct).
