# WPE, chapter 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("wpe01.tst");

# doc/intro.xml:58-66
gap> LoadPackage("WPE");;
gap> K := MathieuGroup(22);;
gap> H := AlternatingGroup(9);;
gap> G := WreathProduct(K, H);;
gap> C := ConjugacyClasses(G);;
gap> Size(C);
886640

# doc/intro.xml:95-100
gap> K := AlternatingGroup(5);;
gap> H := SymmetricGroup(7);;
gap> G := WreathProduct(K, H);
<permutation group of size 14108774400000000 with 4 generators>

# doc/intro.xml:104-109
gap> LoadPackage("WPE");;
gap> iso := IsomorphismWreathProduct(G);;
gap> W := Image(iso);
<group of size 14108774400000000 with 4 generators>

# doc/intro.xml:114-120
gap> g := (1,13,3,14,4,12,2,15,5,11)
>         (6,31,21,7,35,25,9,33,23,8,34,24,10,32,22)
>         (18,19,20);;
gap> g in G;
true

# doc/intro.xml:127-135
gap> w := g ^ iso;
< wreath product element with 7 base components >
gap> Print(w, "\n");
[ (1,3,4,2,5), (2,5)(3,4), (), (3,4,5), (1,2)(4,5), (), (), (1,3)(2,7,5) ]
gap> Display(w);
       1           2       3      4         5       6   7       top     
( (1,3,4,2,5), (2,5)(3,4), (), (3,4,5), (1,2)(4,5), (), (); (1,3)(2,7,5) )

# doc/intro.xml:138-143
gap> BaseComponentOfWreathProductElement(w, 2);
(2,5)(3,4)
gap> TopComponentOfWreathProductElement(w);
(1,3)(2,7,5)

# doc/intro.xml:158-166
gap> m := Order(w);
30
gap> First( [1 .. m], k -> IsOne(TopComponentOfWreathProductElement(w ^ k)) );
6
gap> Display(w ^ 6);
       1            2            3       4        5       6        7       top
( (1,2,3,5,4), (1,4,5,2,3), (1,2,3,5,4), (), (1,3,2,5,4), (), (1,3,2,5,4); () )

# doc/intro.xml:173-178
gap> Length(Territory(w));
6
gap> NrMovedPoints(H);
7

# doc/intro.xml:183-186
gap> Number(WreathCycleDecomposition(w), c -> not IsOne(Yade(c)));
3

#
gap> STOP_TEST("wpe01.tst", 1);
