# UGALY, chapter 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("ugaly01.tst");

# doc/_Chapter_Introduction.xml:23-26
gap> mt:=RandomSource(IsMersenneTwister,1);
<RandomSource in IsMersenneTwister>

# doc/_Chapter_Introduction.xml:33-42
gap> F:=AutBall(3,2);
Group([ (1,2), (3,4), (5,6), (1,3,5)(2,4,6), (1,3)(2,4) ])
gap> IsLocalAction(F);
true
gap> LocalActionDegree(F);
3
gap> LocalActionRadius(F);
2

# doc/_Chapter_Introduction.xml:47-56
gap> A3:=LocalAction(3,1,AlternatingGroup(3));
Alt( [ 1 .. 3 ] )
gap> IsLocalAction(A3);
true
gap> LocalActionDegree(A3);
3
gap> LocalActionRadius(A3);
1

# doc/_Chapter_Introduction.xml:61-66
gap> A3:=LocalAction(3,1,TransitiveGroup(3,1));
A3
gap> S3:=LocalAction(3,1,TransitiveGroup(3,2));
S3

# doc/_Chapter_Introduction.xml:71-80
gap> A3_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,A3);
[ Group([ (1,4,5)(2,3,6) ]) ]
gap> S3_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,S3);
[ Group([ (1,2)(3,5)(4,6), (1,4,5)(2,3,6) ]), 
  Group([ (1,2)(3,4)(5,6), (1,2)(3,5)(4,6), (1,4,5)(2,3,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (3,5,4,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (3,5)(4,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (5,6), (3,5,4,6) ]) ]

# doc/_Chapter_Introduction.xml:85-101
gap> LocalActionPhi(A3)=A3_extn[1];
true
gap> LocalActionGamma(3,S3)=S3_extn[1];
true
gap> LocalActionDelta(3,S3)=S3_extn[2];
false
gap> IsConjugate(AutBall(3,2),LocalActionDelta(3,S3),S3_extn[2]);
true
gap> rho:=SignHomomorphism(S3);;
gap> LocalActionPi(2,3,S3,rho,[0,1])=S3_extn[3];
true
gap> LocalActionPi(2,3,S3,rho,[1])=S3_extn[4];
true
gap> LocalActionPhi(S3)=S3_extn[5];
true

# doc/_Chapter_Introduction.xml:106-111
gap> NrPrimitiveGroups(4);
2
gap> A4:=LocalAction(4,1,PrimitiveGroup(4,1));;
gap> S4:=LocalAction(4,1,PrimitiveGroup(4,2));;

# doc/_Chapter_Introduction.xml:116-125
gap> A4_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,A4);;
gap> Size(A4_extn); Size(Filtered(A4_extn,SatisfiesD));
5
2
gap> S4_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,S4);;
gap> Size(S4_extn); Size(Filtered(S4_extn,SatisfiesD));
13
3

# doc/_Chapter_Introduction.xml:132-138
gap> S3:=SymmetricGroup(3);;
gap> rho:=SignHomomorphism(S3);;
gap> H:=LocalActionPi(2,3,S3,rho,[1]);;
gap> [SatisfiesC(H), SatisfiesD(H), not InvolutiveCompatibilityCocycle(H)=fail];
[ true, false, true ]

# doc/_Chapter_Introduction.xml:142-150
gap> grps:=ConjugacyClassRepsCompatibleGroupsWithProjection(3,H);; Size(grps);
4
gap> Size(Filtered(grps,SatisfiesD));
2
gap> z:=InvolutiveCompatibilityCocycle(H);;
gap> Size(Intersection(LocalActionGamma(H,z)^AutBall(3,3),grps));
1

# doc/_Chapter_Introduction.xml:155-161
gap> grps:=AllTransitiveGroups(NrMovedPoints,4);
[ C(4) = 4, E(4) = 2[x]2, D(4), A4, S4 ]
gap> Apply(grps,H->Size(AllInvolutiveCompatibilityCocycles(LocalAction(4,1,H))));;
gap> grps;
[ 1, 1, 8, 28, 256 ]

# doc/_Chapter_Introduction.xml:166-180
gap> mt:=RandomSource(IsMersenneTwister,1);;
gap> aut:=Random(mt,AutBall(3,2));
(1,4,5,2,3,6)
gap> aut_center:=LocalAction(1,3,2,aut,[]);
(1,2,3)
gap> aut_1:=LocalAction(1,3,2,aut,[1]);
(1,2,3)
gap> aut_2:=LocalAction(1,3,2,aut,[2]);
(1,2,3)
gap> aut_3:=LocalAction(1,3,2,aut,[3]);
(1,3)
gap> AssembleAutomorphism(3,1,[aut_1,aut_2,aut_3]);
(1,4,5,2,3,6)

# doc/_Chapter_Introduction.xml:185-200
gap> A3:=LocalAction(3,1,TransitiveGroup(3,1));;
gap> S3:=LocalAction(3,1,TransitiveGroup(3,2));;
gap> A3_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,A3);
[ Group([ (1,4,5)(2,3,6) ]) ]
gap> S3_extn:=ConjugacyClassRepsCompatibleGroupsWithProjection(2,S3);
[ Group([ (1,2)(3,5)(4,6), (1,4,5)(2,3,6) ]), 
  Group([ (1,2)(3,4)(5,6), (1,2)(3,5)(4,6), (1,4,5)(2,3,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (3,5,4,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (3,5)(4,6) ]), 
  Group([ (3,4)(5,6), (1,2)(3,4), (1,4,5)(2,3,6), (5,6), (3,5,4,6) ]) ]
gap> Apply(A3_extn,SatisfiesD); A3_extn;
[ true ]
gap> Apply(S3_extn,SatisfiesD); S3_extn;
[ true, true, false, false, false ]

# doc/_Chapter_Introduction.xml:205-214
gap> S3:=SymmetricGroup(3);;
gap> rho:=SignHomomorphism(S3);;
gap> H:=LocalActionPi(2,3,S3,rho,[1]);;
gap> z:=InvolutiveCompatibilityCocycle(H);;
gap> mt:=RandomSource(IsMersenneTwister,1);;
gap> a:=Random(mt,H); Image(z,[Image(z,[a,1]),1]);
(1,5,3)(2,6,4)
(1,5,3)(2,6,4)

#
gap> STOP_TEST("ugaly01.tst", 1);
