# SPDX-License-Identifier: GPL-2.0-or-later
# CAP: Categories, Algorithms, Programming
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## AdditionForMorphisms
InstallMethod( AddAdditionForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AdditionForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddAdditionForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AdditionForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AdditiveGenerators
InstallMethod( AddAdditiveGenerators,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AdditiveGenerators", category, func, -1 );
    
end );

InstallMethod( AddAdditiveGenerators,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AdditiveGenerators", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AdditiveInverseForMorphisms
InstallMethod( AddAdditiveInverseForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AdditiveInverseForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddAdditiveInverseForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AdditiveInverseForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AstrictionToCoimage
InstallMethod( AddAstrictionToCoimage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AstrictionToCoimage", category, func, -1 );
    
end );

InstallMethod( AddAstrictionToCoimage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AstrictionToCoimage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## AstrictionToCoimageWithGivenCoimageObject
InstallMethod( AddAstrictionToCoimageWithGivenCoimageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "AstrictionToCoimageWithGivenCoimageObject", category, func, -1 );
    
end );

InstallMethod( AddAstrictionToCoimageWithGivenCoimageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "AstrictionToCoimageWithGivenCoimageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( AstrictionToCoimageWithGivenCoimageObject,
                    "AstrictionToCoimageWithGivenCoimageObject by calling AstrictionToCoimage with the WithGiven argument(s) dropped",
                    [
                        [ AstrictionToCoimage, 1 ],
                    ],
  function( cat, alpha, C )
    
    return AstrictionToCoimage( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( AstrictionToCoimage,
                    "AstrictionToCoimage by calling AstrictionToCoimageWithGivenCoimageObject with the WithGiven object(s)",
                    [
                        [ AstrictionToCoimageWithGivenCoimageObject, 1 ],
                        [ CoimageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return AstrictionToCoimageWithGivenCoimageObject( cat, alpha, CoimageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## BasisOfExternalHom
InstallMethod( AddBasisOfExternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "BasisOfExternalHom", category, func, -1 );
    
end );

InstallMethod( AddBasisOfExternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "BasisOfExternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoastrictionToImage
InstallMethod( AddCoastrictionToImage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoastrictionToImage", category, func, -1 );
    
end );

InstallMethod( AddCoastrictionToImage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoastrictionToImage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoastrictionToImageWithGivenImageObject
InstallMethod( AddCoastrictionToImageWithGivenImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoastrictionToImageWithGivenImageObject", category, func, -1 );
    
end );

InstallMethod( AddCoastrictionToImageWithGivenImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoastrictionToImageWithGivenImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoastrictionToImageWithGivenImageObject,
                    "CoastrictionToImageWithGivenImageObject by calling CoastrictionToImage with the WithGiven argument(s) dropped",
                    [
                        [ CoastrictionToImage, 1 ],
                    ],
  function( cat, alpha, I )
    
    return CoastrictionToImage( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoastrictionToImage,
                    "CoastrictionToImage by calling CoastrictionToImageWithGivenImageObject with the WithGiven object(s)",
                    [
                        [ CoastrictionToImageWithGivenImageObject, 1 ],
                        [ ImageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return CoastrictionToImageWithGivenImageObject( cat, alpha, ImageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## CoefficientsOfMorphism
InstallMethod( AddCoefficientsOfMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoefficientsOfMorphism", category, func, -1 );
    
end );

InstallMethod( AddCoefficientsOfMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoefficientsOfMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## Coequalizer
InstallMethod( AddCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Coequalizer", category, func, -1 );
    
end );

InstallMethod( AddCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Coequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoequalizerFunctorial
InstallMethod( AddCoequalizerFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoequalizerFunctorial", category, func, -1 );
    
end );

InstallMethod( AddCoequalizerFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoequalizerFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoequalizerFunctorialWithGivenCoequalizers
InstallMethod( AddCoequalizerFunctorialWithGivenCoequalizers,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoequalizerFunctorialWithGivenCoequalizers", category, func, -1 );
    
end );

InstallMethod( AddCoequalizerFunctorialWithGivenCoequalizers,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoequalizerFunctorialWithGivenCoequalizers", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoequalizerFunctorialWithGivenCoequalizers,
                    "CoequalizerFunctorialWithGivenCoequalizers by calling CoequalizerFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ CoequalizerFunctorial, 1 ],
                    ],
  function( cat, P, morphisms, mu, morphismsp, Pp )
    
    return CoequalizerFunctorial( cat, morphisms, mu, morphismsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoequalizerFunctorial,
                    "CoequalizerFunctorial by calling CoequalizerFunctorialWithGivenCoequalizers with the WithGiven object(s)",
                    [
                        [ CoequalizerFunctorialWithGivenCoequalizers, 1 ],
                        [ Coequalizer, 2 ],
                    ],
  function( cat, morphisms, mu, morphismsp )
    
    return CoequalizerFunctorialWithGivenCoequalizers( cat, Coequalizer( cat, Source( mu ), morphisms ), morphisms, mu, morphismsp, Coequalizer( cat, Range( mu ), morphismsp ) );
    
end : is_with_given_derivation := true );

## CoimageObject
InstallMethod( AddCoimageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoimageObject", category, func, -1 );
    
end );

InstallMethod( AddCoimageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoimageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoimageObjectFunctorial
InstallMethod( AddCoimageObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoimageObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddCoimageObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoimageObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoimageObjectFunctorialWithGivenCoimageObjects
InstallMethod( AddCoimageObjectFunctorialWithGivenCoimageObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoimageObjectFunctorialWithGivenCoimageObjects", category, func, -1 );
    
end );

InstallMethod( AddCoimageObjectFunctorialWithGivenCoimageObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoimageObjectFunctorialWithGivenCoimageObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoimageObjectFunctorialWithGivenCoimageObjects,
                    "CoimageObjectFunctorialWithGivenCoimageObjects by calling CoimageObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ CoimageObjectFunctorial, 1 ],
                    ],
  function( cat, C, alpha, mu, alphap, Cp )
    
    return CoimageObjectFunctorial( cat, alpha, mu, alphap );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoimageObjectFunctorial,
                    "CoimageObjectFunctorial by calling CoimageObjectFunctorialWithGivenCoimageObjects with the WithGiven object(s)",
                    [
                        [ CoimageObjectFunctorialWithGivenCoimageObjects, 1 ],
                        [ CoimageObject, 2 ],
                    ],
  function( cat, alpha, mu, alphap )
    
    return CoimageObjectFunctorialWithGivenCoimageObjects( cat, CoimageObject( cat, alpha ), alpha, mu, alphap, CoimageObject( cat, alphap ) );
    
end : is_with_given_derivation := true );

## CoimageProjection
InstallMethod( AddCoimageProjection,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoimageProjection", category, func, -1 );
    
end );

InstallMethod( AddCoimageProjection,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoimageProjection", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoimageProjectionWithGivenCoimageObject
InstallMethod( AddCoimageProjectionWithGivenCoimageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoimageProjectionWithGivenCoimageObject", category, func, -1 );
    
end );

InstallMethod( AddCoimageProjectionWithGivenCoimageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoimageProjectionWithGivenCoimageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoimageProjectionWithGivenCoimageObject,
                    "CoimageProjectionWithGivenCoimageObject by calling CoimageProjection with the WithGiven argument(s) dropped",
                    [
                        [ CoimageProjection, 1 ],
                    ],
  function( cat, alpha, C )
    
    return CoimageProjection( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoimageProjection,
                    "CoimageProjection by calling CoimageProjectionWithGivenCoimageObject with the WithGiven object(s)",
                    [
                        [ CoimageProjectionWithGivenCoimageObject, 1 ],
                        [ CoimageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return CoimageProjectionWithGivenCoimageObject( cat, alpha, CoimageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## CokernelColift
InstallMethod( AddCokernelColift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelColift", category, func, -1 );
    
end );

InstallMethod( AddCokernelColift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelColift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CokernelColiftWithGivenCokernelObject
InstallMethod( AddCokernelColiftWithGivenCokernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelColiftWithGivenCokernelObject", category, func, -1 );
    
end );

InstallMethod( AddCokernelColiftWithGivenCokernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelColiftWithGivenCokernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CokernelColiftWithGivenCokernelObject,
                    "CokernelColiftWithGivenCokernelObject by calling CokernelColift with the WithGiven argument(s) dropped",
                    [
                        [ CokernelColift, 1 ],
                    ],
  function( cat, alpha, T, tau, P )
    
    return CokernelColift( cat, alpha, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CokernelColift,
                    "CokernelColift by calling CokernelColiftWithGivenCokernelObject with the WithGiven object(s)",
                    [
                        [ CokernelColiftWithGivenCokernelObject, 1 ],
                        [ CokernelObject, 1 ],
                    ],
  function( cat, alpha, T, tau )
    
    return CokernelColiftWithGivenCokernelObject( cat, alpha, T, tau, CokernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## CokernelObject
InstallMethod( AddCokernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelObject", category, func, -1 );
    
end );

InstallMethod( AddCokernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CokernelObjectFunctorial
InstallMethod( AddCokernelObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddCokernelObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CokernelObjectFunctorialWithGivenCokernelObjects
InstallMethod( AddCokernelObjectFunctorialWithGivenCokernelObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelObjectFunctorialWithGivenCokernelObjects", category, func, -1 );
    
end );

InstallMethod( AddCokernelObjectFunctorialWithGivenCokernelObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelObjectFunctorialWithGivenCokernelObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CokernelObjectFunctorialWithGivenCokernelObjects,
                    "CokernelObjectFunctorialWithGivenCokernelObjects by calling CokernelObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ CokernelObjectFunctorial, 1 ],
                    ],
  function( cat, P, alpha, mu, alphap, Pp )
    
    return CokernelObjectFunctorial( cat, alpha, mu, alphap );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CokernelObjectFunctorial,
                    "CokernelObjectFunctorial by calling CokernelObjectFunctorialWithGivenCokernelObjects with the WithGiven object(s)",
                    [
                        [ CokernelObjectFunctorialWithGivenCokernelObjects, 1 ],
                        [ CokernelObject, 2 ],
                    ],
  function( cat, alpha, mu, alphap )
    
    return CokernelObjectFunctorialWithGivenCokernelObjects( cat, CokernelObject( cat, alpha ), alpha, mu, alphap, CokernelObject( cat, alphap ) );
    
end : is_with_given_derivation := true );

## CokernelProjection
InstallMethod( AddCokernelProjection,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelProjection", category, func, -1 );
    
end );

InstallMethod( AddCokernelProjection,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelProjection", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CokernelProjectionWithGivenCokernelObject
InstallMethod( AddCokernelProjectionWithGivenCokernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CokernelProjectionWithGivenCokernelObject", category, func, -1 );
    
end );

InstallMethod( AddCokernelProjectionWithGivenCokernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CokernelProjectionWithGivenCokernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CokernelProjectionWithGivenCokernelObject,
                    "CokernelProjectionWithGivenCokernelObject by calling CokernelProjection with the WithGiven argument(s) dropped",
                    [
                        [ CokernelProjection, 1 ],
                    ],
  function( cat, alpha, P )
    
    return CokernelProjection( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CokernelProjection,
                    "CokernelProjection by calling CokernelProjectionWithGivenCokernelObject with the WithGiven object(s)",
                    [
                        [ CokernelProjectionWithGivenCokernelObject, 1 ],
                        [ CokernelObject, 1 ],
                    ],
  function( cat, alpha )
    
    return CokernelProjectionWithGivenCokernelObject( cat, alpha, CokernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## Colift
InstallMethod( AddColift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Colift", category, func, -1 );
    
end );

InstallMethod( AddColift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Colift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ColiftAlongEpimorphism
InstallMethod( AddColiftAlongEpimorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ColiftAlongEpimorphism", category, func, -1 );
    
end );

InstallMethod( AddColiftAlongEpimorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ColiftAlongEpimorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ComponentOfMorphismFromCoproduct
InstallMethod( AddComponentOfMorphismFromCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ComponentOfMorphismFromCoproduct", category, func, -1 );
    
end );

InstallMethod( AddComponentOfMorphismFromCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ComponentOfMorphismFromCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ComponentOfMorphismFromDirectSum
InstallMethod( AddComponentOfMorphismFromDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ComponentOfMorphismFromDirectSum", category, func, -1 );
    
end );

InstallMethod( AddComponentOfMorphismFromDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ComponentOfMorphismFromDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ComponentOfMorphismIntoDirectProduct
InstallMethod( AddComponentOfMorphismIntoDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ComponentOfMorphismIntoDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddComponentOfMorphismIntoDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ComponentOfMorphismIntoDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ComponentOfMorphismIntoDirectSum
InstallMethod( AddComponentOfMorphismIntoDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ComponentOfMorphismIntoDirectSum", category, func, -1 );
    
end );

InstallMethod( AddComponentOfMorphismIntoDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ComponentOfMorphismIntoDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## Coproduct
InstallMethod( AddCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Coproduct", category, func, -1 );
    
end );

InstallMethod( AddCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Coproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoproductFunctorial
InstallMethod( AddCoproductFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoproductFunctorial", category, func, -1 );
    
end );

InstallMethod( AddCoproductFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoproductFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoproductFunctorialWithGivenCoproducts
InstallMethod( AddCoproductFunctorialWithGivenCoproducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoproductFunctorialWithGivenCoproducts", category, func, -1 );
    
end );

InstallMethod( AddCoproductFunctorialWithGivenCoproducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoproductFunctorialWithGivenCoproducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoproductFunctorialWithGivenCoproducts,
                    "CoproductFunctorialWithGivenCoproducts by calling CoproductFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ CoproductFunctorial, 1 ],
                    ],
  function( cat, P, objects, L, objectsp, Pp )
    
    return CoproductFunctorial( cat, objects, L, objectsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoproductFunctorial,
                    "CoproductFunctorial by calling CoproductFunctorialWithGivenCoproducts with the WithGiven object(s)",
                    [
                        [ CoproductFunctorialWithGivenCoproducts, 1 ],
                        [ Coproduct, 2 ],
                    ],
  function( cat, objects, L, objectsp )
    
    return CoproductFunctorialWithGivenCoproducts( cat, Coproduct( cat, objects ), objects, L, objectsp, Coproduct( cat, objectsp ) );
    
end : is_with_given_derivation := true );

## DirectProduct
InstallMethod( AddDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectProduct", category, func, -1 );
    
end );

InstallMethod( AddDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## DirectProductFunctorial
InstallMethod( AddDirectProductFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectProductFunctorial", category, func, -1 );
    
end );

InstallMethod( AddDirectProductFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectProductFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## DirectProductFunctorialWithGivenDirectProducts
InstallMethod( AddDirectProductFunctorialWithGivenDirectProducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectProductFunctorialWithGivenDirectProducts", category, func, -1 );
    
end );

InstallMethod( AddDirectProductFunctorialWithGivenDirectProducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectProductFunctorialWithGivenDirectProducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( DirectProductFunctorialWithGivenDirectProducts,
                    "DirectProductFunctorialWithGivenDirectProducts by calling DirectProductFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ DirectProductFunctorial, 1 ],
                    ],
  function( cat, P, objects, L, objectsp, Pp )
    
    return DirectProductFunctorial( cat, objects, L, objectsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( DirectProductFunctorial,
                    "DirectProductFunctorial by calling DirectProductFunctorialWithGivenDirectProducts with the WithGiven object(s)",
                    [
                        [ DirectProductFunctorialWithGivenDirectProducts, 1 ],
                        [ DirectProduct, 2 ],
                    ],
  function( cat, objects, L, objectsp )
    
    return DirectProductFunctorialWithGivenDirectProducts( cat, DirectProduct( cat, objects ), objects, L, objectsp, DirectProduct( cat, objectsp ) );
    
end : is_with_given_derivation := true );

## DirectSum
InstallMethod( AddDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectSum", category, func, -1 );
    
end );

InstallMethod( AddDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## DirectSumFunctorial
InstallMethod( AddDirectSumFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectSumFunctorial", category, func, -1 );
    
end );

InstallMethod( AddDirectSumFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectSumFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## DirectSumFunctorialWithGivenDirectSums
InstallMethod( AddDirectSumFunctorialWithGivenDirectSums,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DirectSumFunctorialWithGivenDirectSums", category, func, -1 );
    
end );

InstallMethod( AddDirectSumFunctorialWithGivenDirectSums,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DirectSumFunctorialWithGivenDirectSums", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( DirectSumFunctorialWithGivenDirectSums,
                    "DirectSumFunctorialWithGivenDirectSums by calling DirectSumFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ DirectSumFunctorial, 1 ],
                    ],
  function( cat, P, objects, L, objectsp, Pp )
    
    return DirectSumFunctorial( cat, objects, L, objectsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( DirectSumFunctorial,
                    "DirectSumFunctorial by calling DirectSumFunctorialWithGivenDirectSums with the WithGiven object(s)",
                    [
                        [ DirectSumFunctorialWithGivenDirectSums, 1 ],
                        [ DirectSum, 2 ],
                    ],
  function( cat, objects, L, objectsp )
    
    return DirectSumFunctorialWithGivenDirectSums( cat, DirectSum( cat, objects ), objects, L, objectsp, DirectSum( cat, objectsp ) );
    
end : is_with_given_derivation := true );

## DistinguishedObjectOfHomomorphismStructure
InstallMethod( AddDistinguishedObjectOfHomomorphismStructure,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "DistinguishedObjectOfHomomorphismStructure", category, func, -1 );
    
end );

InstallMethod( AddDistinguishedObjectOfHomomorphismStructure,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "DistinguishedObjectOfHomomorphismStructure", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EmbeddingOfEqualizer
InstallMethod( AddEmbeddingOfEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EmbeddingOfEqualizer", category, func, -1 );
    
end );

InstallMethod( AddEmbeddingOfEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EmbeddingOfEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EmbeddingOfEqualizerWithGivenEqualizer
InstallMethod( AddEmbeddingOfEqualizerWithGivenEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EmbeddingOfEqualizerWithGivenEqualizer", category, func, -1 );
    
end );

InstallMethod( AddEmbeddingOfEqualizerWithGivenEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EmbeddingOfEqualizerWithGivenEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( EmbeddingOfEqualizerWithGivenEqualizer,
                    "EmbeddingOfEqualizerWithGivenEqualizer by calling EmbeddingOfEqualizer with the WithGiven argument(s) dropped",
                    [
                        [ EmbeddingOfEqualizer, 1 ],
                    ],
  function( cat, Y, morphisms, P )
    
    return EmbeddingOfEqualizer( cat, Y, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( EmbeddingOfEqualizer,
                    "EmbeddingOfEqualizer by calling EmbeddingOfEqualizerWithGivenEqualizer with the WithGiven object(s)",
                    [
                        [ EmbeddingOfEqualizerWithGivenEqualizer, 1 ],
                        [ Equalizer, 1 ],
                    ],
  function( cat, Y, morphisms )
    
    return EmbeddingOfEqualizerWithGivenEqualizer( cat, Y, morphisms, Equalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## EpimorphismFromProjectiveCoverObject
InstallMethod( AddEpimorphismFromProjectiveCoverObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EpimorphismFromProjectiveCoverObject", category, func, -1 );
    
end );

InstallMethod( AddEpimorphismFromProjectiveCoverObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EpimorphismFromProjectiveCoverObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject
InstallMethod( AddEpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject", category, func, -1 );
    
end );

InstallMethod( AddEpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject,
                    "EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject by calling EpimorphismFromProjectiveCoverObject with the WithGiven argument(s) dropped",
                    [
                        [ EpimorphismFromProjectiveCoverObject, 1 ],
                    ],
  function( cat, A, P )
    
    return EpimorphismFromProjectiveCoverObject( cat, A );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( EpimorphismFromProjectiveCoverObject,
                    "EpimorphismFromProjectiveCoverObject by calling EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject with the WithGiven object(s)",
                    [
                        [ EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject, 1 ],
                        [ ProjectiveCoverObject, 1 ],
                    ],
  function( cat, A )
    
    return EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject( cat, A, ProjectiveCoverObject( cat, A ) );
    
end : is_with_given_derivation := true );

## EpimorphismFromSomeProjectiveObject
InstallMethod( AddEpimorphismFromSomeProjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EpimorphismFromSomeProjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddEpimorphismFromSomeProjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EpimorphismFromSomeProjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject
InstallMethod( AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject,
                    "EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject by calling EpimorphismFromSomeProjectiveObject with the WithGiven argument(s) dropped",
                    [
                        [ EpimorphismFromSomeProjectiveObject, 1 ],
                    ],
  function( cat, A, P )
    
    return EpimorphismFromSomeProjectiveObject( cat, A );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( EpimorphismFromSomeProjectiveObject,
                    "EpimorphismFromSomeProjectiveObject by calling EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject with the WithGiven object(s)",
                    [
                        [ EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject, 1 ],
                        [ SomeProjectiveObject, 1 ],
                    ],
  function( cat, A )
    
    return EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject( cat, A, SomeProjectiveObject( cat, A ) );
    
end : is_with_given_derivation := true );

## Equalizer
InstallMethod( AddEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Equalizer", category, func, -1 );
    
end );

InstallMethod( AddEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Equalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EqualizerFunctorial
InstallMethod( AddEqualizerFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EqualizerFunctorial", category, func, -1 );
    
end );

InstallMethod( AddEqualizerFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EqualizerFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## EqualizerFunctorialWithGivenEqualizers
InstallMethod( AddEqualizerFunctorialWithGivenEqualizers,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "EqualizerFunctorialWithGivenEqualizers", category, func, -1 );
    
end );

InstallMethod( AddEqualizerFunctorialWithGivenEqualizers,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "EqualizerFunctorialWithGivenEqualizers", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( EqualizerFunctorialWithGivenEqualizers,
                    "EqualizerFunctorialWithGivenEqualizers by calling EqualizerFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ EqualizerFunctorial, 1 ],
                    ],
  function( cat, P, morphisms, mu, morphismsp, Pp )
    
    return EqualizerFunctorial( cat, morphisms, mu, morphismsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( EqualizerFunctorial,
                    "EqualizerFunctorial by calling EqualizerFunctorialWithGivenEqualizers with the WithGiven object(s)",
                    [
                        [ EqualizerFunctorialWithGivenEqualizers, 1 ],
                        [ Equalizer, 2 ],
                    ],
  function( cat, morphisms, mu, morphismsp )
    
    return EqualizerFunctorialWithGivenEqualizers( cat, Equalizer( cat, Source( mu ), morphisms ), morphisms, mu, morphismsp, Equalizer( cat, Range( mu ), morphismsp ) );
    
end : is_with_given_derivation := true );

## FiberProduct
InstallMethod( AddFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "FiberProduct", category, func, -1 );
    
end );

InstallMethod( AddFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "FiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## FiberProductFunctorial
InstallMethod( AddFiberProductFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "FiberProductFunctorial", category, func, -1 );
    
end );

InstallMethod( AddFiberProductFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "FiberProductFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## FiberProductFunctorialWithGivenFiberProducts
InstallMethod( AddFiberProductFunctorialWithGivenFiberProducts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "FiberProductFunctorialWithGivenFiberProducts", category, func, -1 );
    
end );

InstallMethod( AddFiberProductFunctorialWithGivenFiberProducts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "FiberProductFunctorialWithGivenFiberProducts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( FiberProductFunctorialWithGivenFiberProducts,
                    "FiberProductFunctorialWithGivenFiberProducts by calling FiberProductFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ FiberProductFunctorial, 1 ],
                    ],
  function( cat, P, morphisms, L, morphismsp, Pp )
    
    return FiberProductFunctorial( cat, morphisms, L, morphismsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( FiberProductFunctorial,
                    "FiberProductFunctorial by calling FiberProductFunctorialWithGivenFiberProducts with the WithGiven object(s)",
                    [
                        [ FiberProductFunctorialWithGivenFiberProducts, 1 ],
                        [ FiberProduct, 2 ],
                    ],
  function( cat, morphisms, L, morphismsp )
    
    return FiberProductFunctorialWithGivenFiberProducts( cat, FiberProduct( cat, morphisms ), morphisms, L, morphismsp, FiberProduct( cat, morphismsp ) );
    
end : is_with_given_derivation := true );

## HomologyObject
InstallMethod( AddHomologyObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HomologyObject", category, func, -1 );
    
end );

InstallMethod( AddHomologyObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HomologyObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## HomologyObjectFunctorialWithGivenHomologyObjects
InstallMethod( AddHomologyObjectFunctorialWithGivenHomologyObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HomologyObjectFunctorialWithGivenHomologyObjects", category, func, -1 );
    
end );

InstallMethod( AddHomologyObjectFunctorialWithGivenHomologyObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HomologyObjectFunctorialWithGivenHomologyObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## HomomorphismStructureOnMorphisms
InstallMethod( AddHomomorphismStructureOnMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HomomorphismStructureOnMorphisms", category, func, -1 );
    
end );

InstallMethod( AddHomomorphismStructureOnMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HomomorphismStructureOnMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## HomomorphismStructureOnMorphismsWithGivenObjects
InstallMethod( AddHomomorphismStructureOnMorphismsWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HomomorphismStructureOnMorphismsWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddHomomorphismStructureOnMorphismsWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HomomorphismStructureOnMorphismsWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( HomomorphismStructureOnMorphismsWithGivenObjects,
                    "HomomorphismStructureOnMorphismsWithGivenObjects by calling HomomorphismStructureOnMorphisms with the WithGiven argument(s) dropped",
                    [
                        [ HomomorphismStructureOnMorphisms, 1 ],
                    ],
  function( cat, source, alpha, beta, range )
    
    return HomomorphismStructureOnMorphisms( cat, alpha, beta );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( HomomorphismStructureOnMorphisms,
                    "HomomorphismStructureOnMorphisms by calling HomomorphismStructureOnMorphismsWithGivenObjects with the WithGiven object(s)",
                    [
                        [ HomomorphismStructureOnMorphismsWithGivenObjects, 1 ],
                        [ HomomorphismStructureOnObjects, 2 ],
                    ],
  function( cat, alpha, beta )
    
    return HomomorphismStructureOnMorphismsWithGivenObjects( cat, HomomorphismStructureOnObjects( cat, Range( alpha ), Source( beta ) ), alpha, beta, HomomorphismStructureOnObjects( cat, Source( alpha ), Range( beta ) ) );
    
end : is_with_given_derivation := true );

## HomomorphismStructureOnObjects
InstallMethod( AddHomomorphismStructureOnObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HomomorphismStructureOnObjects", category, func, -1 );
    
end );

InstallMethod( AddHomomorphismStructureOnObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HomomorphismStructureOnObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## HorizontalPostCompose
InstallMethod( AddHorizontalPostCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HorizontalPostCompose", category, func, -1 );
    
end );

InstallMethod( AddHorizontalPostCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HorizontalPostCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## HorizontalPreCompose
InstallMethod( AddHorizontalPreCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "HorizontalPreCompose", category, func, -1 );
    
end );

InstallMethod( AddHorizontalPreCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "HorizontalPreCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IdentityMorphism
InstallMethod( AddIdentityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IdentityMorphism", category, func, -1 );
    
end );

InstallMethod( AddIdentityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IdentityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IdentityTwoCell
InstallMethod( AddIdentityTwoCell,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IdentityTwoCell", category, func, -1 );
    
end );

InstallMethod( AddIdentityTwoCell,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IdentityTwoCell", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ImageEmbedding
InstallMethod( AddImageEmbedding,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ImageEmbedding", category, func, -1 );
    
end );

InstallMethod( AddImageEmbedding,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ImageEmbedding", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ImageEmbeddingWithGivenImageObject
InstallMethod( AddImageEmbeddingWithGivenImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ImageEmbeddingWithGivenImageObject", category, func, -1 );
    
end );

InstallMethod( AddImageEmbeddingWithGivenImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ImageEmbeddingWithGivenImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ImageEmbeddingWithGivenImageObject,
                    "ImageEmbeddingWithGivenImageObject by calling ImageEmbedding with the WithGiven argument(s) dropped",
                    [
                        [ ImageEmbedding, 1 ],
                    ],
  function( cat, alpha, I )
    
    return ImageEmbedding( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ImageEmbedding,
                    "ImageEmbedding by calling ImageEmbeddingWithGivenImageObject with the WithGiven object(s)",
                    [
                        [ ImageEmbeddingWithGivenImageObject, 1 ],
                        [ ImageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return ImageEmbeddingWithGivenImageObject( cat, alpha, ImageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## ImageObject
InstallMethod( AddImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ImageObject", category, func, -1 );
    
end );

InstallMethod( AddImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ImageObjectFunctorial
InstallMethod( AddImageObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ImageObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddImageObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ImageObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ImageObjectFunctorialWithGivenImageObjects
InstallMethod( AddImageObjectFunctorialWithGivenImageObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ImageObjectFunctorialWithGivenImageObjects", category, func, -1 );
    
end );

InstallMethod( AddImageObjectFunctorialWithGivenImageObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ImageObjectFunctorialWithGivenImageObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ImageObjectFunctorialWithGivenImageObjects,
                    "ImageObjectFunctorialWithGivenImageObjects by calling ImageObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ ImageObjectFunctorial, 1 ],
                    ],
  function( cat, I, alpha, nu, alphap, Ip )
    
    return ImageObjectFunctorial( cat, alpha, nu, alphap );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ImageObjectFunctorial,
                    "ImageObjectFunctorial by calling ImageObjectFunctorialWithGivenImageObjects with the WithGiven object(s)",
                    [
                        [ ImageObjectFunctorialWithGivenImageObjects, 1 ],
                        [ ImageObject, 2 ],
                    ],
  function( cat, alpha, nu, alphap )
    
    return ImageObjectFunctorialWithGivenImageObjects( cat, ImageObject( cat, alpha ), alpha, nu, alphap, ImageObject( cat, alphap ) );
    
end : is_with_given_derivation := true );

## IndecomposableInjectiveObjects
InstallMethod( AddIndecomposableInjectiveObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IndecomposableInjectiveObjects", category, func, -1 );
    
end );

InstallMethod( AddIndecomposableInjectiveObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IndecomposableInjectiveObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IndecomposableProjectiveObjects
InstallMethod( AddIndecomposableProjectiveObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IndecomposableProjectiveObjects", category, func, -1 );
    
end );

InstallMethod( AddIndecomposableProjectiveObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IndecomposableProjectiveObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InitialObject
InstallMethod( AddInitialObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InitialObject", category, func, -1 );
    
end );

InstallMethod( AddInitialObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InitialObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InitialObjectFunctorial
InstallMethod( AddInitialObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InitialObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddInitialObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InitialObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InitialObjectFunctorialWithGivenInitialObjects
InstallMethod( AddInitialObjectFunctorialWithGivenInitialObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InitialObjectFunctorialWithGivenInitialObjects", category, func, -1 );
    
end );

InstallMethod( AddInitialObjectFunctorialWithGivenInitialObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InitialObjectFunctorialWithGivenInitialObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InitialObjectFunctorialWithGivenInitialObjects,
                    "InitialObjectFunctorialWithGivenInitialObjects by calling InitialObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ InitialObjectFunctorial, 1 ],
                    ],
  function( cat, P, Pp )
    
    return InitialObjectFunctorial( cat );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InitialObjectFunctorial,
                    "InitialObjectFunctorial by calling InitialObjectFunctorialWithGivenInitialObjects with the WithGiven object(s)",
                    [
                        [ InitialObjectFunctorialWithGivenInitialObjects, 1 ],
                        [ InitialObject, 2 ],
                    ],
  function( cat )
    
    return InitialObjectFunctorialWithGivenInitialObjects( cat, InitialObject( cat ), InitialObject( cat ) );
    
end : is_with_given_derivation := true );

## InjectionOfCofactorOfCoproduct
InstallMethod( AddInjectionOfCofactorOfCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfCoproduct", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InjectionOfCofactorOfCoproductWithGivenCoproduct
InstallMethod( AddInjectionOfCofactorOfCoproductWithGivenCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfCoproductWithGivenCoproduct", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfCoproductWithGivenCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfCoproductWithGivenCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InjectionOfCofactorOfCoproductWithGivenCoproduct,
                    "InjectionOfCofactorOfCoproductWithGivenCoproduct by calling InjectionOfCofactorOfCoproduct with the WithGiven argument(s) dropped",
                    [
                        [ InjectionOfCofactorOfCoproduct, 1 ],
                    ],
  function( cat, objects, k, P )
    
    return InjectionOfCofactorOfCoproduct( cat, objects, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InjectionOfCofactorOfCoproduct,
                    "InjectionOfCofactorOfCoproduct by calling InjectionOfCofactorOfCoproductWithGivenCoproduct with the WithGiven object(s)",
                    [
                        [ InjectionOfCofactorOfCoproductWithGivenCoproduct, 1 ],
                        [ Coproduct, 1 ],
                    ],
  function( cat, objects, k )
    
    return InjectionOfCofactorOfCoproductWithGivenCoproduct( cat, objects, k, Coproduct( cat, objects ) );
    
end : is_with_given_derivation := true );

## InjectionOfCofactorOfDirectSum
InstallMethod( AddInjectionOfCofactorOfDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfDirectSum", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InjectionOfCofactorOfDirectSumWithGivenDirectSum
InstallMethod( AddInjectionOfCofactorOfDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfDirectSumWithGivenDirectSum", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfDirectSumWithGivenDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InjectionOfCofactorOfDirectSumWithGivenDirectSum,
                    "InjectionOfCofactorOfDirectSumWithGivenDirectSum by calling InjectionOfCofactorOfDirectSum with the WithGiven argument(s) dropped",
                    [
                        [ InjectionOfCofactorOfDirectSum, 1 ],
                    ],
  function( cat, objects, k, P )
    
    return InjectionOfCofactorOfDirectSum( cat, objects, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InjectionOfCofactorOfDirectSum,
                    "InjectionOfCofactorOfDirectSum by calling InjectionOfCofactorOfDirectSumWithGivenDirectSum with the WithGiven object(s)",
                    [
                        [ InjectionOfCofactorOfDirectSumWithGivenDirectSum, 1 ],
                        [ DirectSum, 1 ],
                    ],
  function( cat, objects, k )
    
    return InjectionOfCofactorOfDirectSumWithGivenDirectSum( cat, objects, k, DirectSum( cat, objects ) );
    
end : is_with_given_derivation := true );

## InjectionOfCofactorOfPushout
InstallMethod( AddInjectionOfCofactorOfPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfPushout", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InjectionOfCofactorOfPushoutWithGivenPushout
InstallMethod( AddInjectionOfCofactorOfPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectionOfCofactorOfPushoutWithGivenPushout", category, func, -1 );
    
end );

InstallMethod( AddInjectionOfCofactorOfPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectionOfCofactorOfPushoutWithGivenPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InjectionOfCofactorOfPushoutWithGivenPushout,
                    "InjectionOfCofactorOfPushoutWithGivenPushout by calling InjectionOfCofactorOfPushout with the WithGiven argument(s) dropped",
                    [
                        [ InjectionOfCofactorOfPushout, 1 ],
                    ],
  function( cat, morphisms, k, P )
    
    return InjectionOfCofactorOfPushout( cat, morphisms, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InjectionOfCofactorOfPushout,
                    "InjectionOfCofactorOfPushout by calling InjectionOfCofactorOfPushoutWithGivenPushout with the WithGiven object(s)",
                    [
                        [ InjectionOfCofactorOfPushoutWithGivenPushout, 1 ],
                        [ Pushout, 1 ],
                    ],
  function( cat, morphisms, k )
    
    return InjectionOfCofactorOfPushoutWithGivenPushout( cat, morphisms, k, Pushout( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## InjectiveColift
InstallMethod( AddInjectiveColift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectiveColift", category, func, -1 );
    
end );

InstallMethod( AddInjectiveColift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectiveColift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InjectiveDimension
InstallMethod( AddInjectiveDimension,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectiveDimension", category, func, -1 );
    
end );

InstallMethod( AddInjectiveDimension,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectiveDimension", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InjectiveEnvelopeObject
InstallMethod( AddInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InjectiveEnvelopeObject", category, func, -1 );
    
end );

InstallMethod( AddInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InjectiveEnvelopeObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure
InstallMethod( AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure", category, func, -1 );
    
end );

InstallMethod( AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects
InstallMethod( AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects,
                    "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects by calling InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure with the WithGiven argument(s) dropped",
                    [
                        [ InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure, 1 ],
                    ],
  function( cat, source, alpha, range )
    
    return InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure,
                    "InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure by calling InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects, 1 ],
                        [ DistinguishedObjectOfHomomorphismStructure, 1 ],
                        [ HomomorphismStructureOnObjects, 1 ],
                    ],
  function( cat, alpha )
    
    return InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects( cat, DistinguishedObjectOfHomomorphismStructure( cat ), alpha, HomomorphismStructureOnObjects( cat, Source( alpha ), Range( alpha ) ) );
    
end : is_with_given_derivation := true );

## InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism
InstallMethod( AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism", category, func, -1 );
    
end );

InstallMethod( AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InverseForMorphisms
InstallMethod( AddInverseForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InverseForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddInverseForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InverseForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InverseOfMorphismFromCoimageToImage
InstallMethod( AddInverseOfMorphismFromCoimageToImage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InverseOfMorphismFromCoimageToImage", category, func, -1 );
    
end );

InstallMethod( AddInverseOfMorphismFromCoimageToImage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InverseOfMorphismFromCoimageToImage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## InverseOfMorphismFromCoimageToImageWithGivenObjects
InstallMethod( AddInverseOfMorphismFromCoimageToImageWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "InverseOfMorphismFromCoimageToImageWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddInverseOfMorphismFromCoimageToImageWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "InverseOfMorphismFromCoimageToImageWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( InverseOfMorphismFromCoimageToImageWithGivenObjects,
                    "InverseOfMorphismFromCoimageToImageWithGivenObjects by calling InverseOfMorphismFromCoimageToImage with the WithGiven argument(s) dropped",
                    [
                        [ InverseOfMorphismFromCoimageToImage, 1 ],
                    ],
  function( cat, I, alpha, C )
    
    return InverseOfMorphismFromCoimageToImage( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( InverseOfMorphismFromCoimageToImage,
                    "InverseOfMorphismFromCoimageToImage by calling InverseOfMorphismFromCoimageToImageWithGivenObjects with the WithGiven object(s)",
                    [
                        [ InverseOfMorphismFromCoimageToImageWithGivenObjects, 1 ],
                        [ ImageObject, 1 ],
                        [ CoimageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return InverseOfMorphismFromCoimageToImageWithGivenObjects( cat, ImageObject( cat, alpha ), alpha, CoimageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## IsAutomorphism
InstallMethod( AddIsAutomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsAutomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsAutomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsAutomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsBijectiveObject
InstallMethod( AddIsBijectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsBijectiveObject", category, func, -1 );
    
end );

InstallMethod( AddIsBijectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsBijectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsCodominating
InstallMethod( AddIsCodominating,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsCodominating", category, func, -1 );
    
end );

InstallMethod( AddIsCodominating,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsCodominating", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsColiftable
InstallMethod( AddIsColiftable,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsColiftable", category, func, -1 );
    
end );

InstallMethod( AddIsColiftable,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsColiftable", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsColiftableAlongEpimorphism
InstallMethod( AddIsColiftableAlongEpimorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsColiftableAlongEpimorphism", category, func, -1 );
    
end );

InstallMethod( AddIsColiftableAlongEpimorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsColiftableAlongEpimorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsCongruentForMorphisms
InstallMethod( AddIsCongruentForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsCongruentForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddIsCongruentForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsCongruentForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsDominating
InstallMethod( AddIsDominating,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsDominating", category, func, -1 );
    
end );

InstallMethod( AddIsDominating,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsDominating", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEndomorphism
InstallMethod( AddIsEndomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEndomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsEndomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEndomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEpimorphism
InstallMethod( AddIsEpimorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEpimorphism", category, func, -1 );
    
end );

InstallMethod( AddIsEpimorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEpimorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualAsFactorobjects
InstallMethod( AddIsEqualAsFactorobjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualAsFactorobjects", category, func, -1 );
    
end );

InstallMethod( AddIsEqualAsFactorobjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualAsFactorobjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualAsSubobjects
InstallMethod( AddIsEqualAsSubobjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualAsSubobjects", category, func, -1 );
    
end );

InstallMethod( AddIsEqualAsSubobjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualAsSubobjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualForCacheForMorphisms
InstallMethod( AddIsEqualForCacheForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualForCacheForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddIsEqualForCacheForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualForCacheForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualForCacheForObjects
InstallMethod( AddIsEqualForCacheForObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualForCacheForObjects", category, func, -1 );
    
end );

InstallMethod( AddIsEqualForCacheForObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualForCacheForObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualForMorphisms
InstallMethod( AddIsEqualForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddIsEqualForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualForMorphismsOnMor
InstallMethod( AddIsEqualForMorphismsOnMor,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualForMorphismsOnMor", category, func, -1 );
    
end );

InstallMethod( AddIsEqualForMorphismsOnMor,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualForMorphismsOnMor", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualForObjects
InstallMethod( AddIsEqualForObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualForObjects", category, func, -1 );
    
end );

InstallMethod( AddIsEqualForObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualForObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualToIdentityMorphism
InstallMethod( AddIsEqualToIdentityMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualToIdentityMorphism", category, func, -1 );
    
end );

InstallMethod( AddIsEqualToIdentityMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualToIdentityMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsEqualToZeroMorphism
InstallMethod( AddIsEqualToZeroMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsEqualToZeroMorphism", category, func, -1 );
    
end );

InstallMethod( AddIsEqualToZeroMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsEqualToZeroMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsHomSetInhabited
InstallMethod( AddIsHomSetInhabited,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsHomSetInhabited", category, func, -1 );
    
end );

InstallMethod( AddIsHomSetInhabited,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsHomSetInhabited", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsIdempotent
InstallMethod( AddIsIdempotent,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsIdempotent", category, func, -1 );
    
end );

InstallMethod( AddIsIdempotent,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsIdempotent", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsInitial
InstallMethod( AddIsInitial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsInitial", category, func, -1 );
    
end );

InstallMethod( AddIsInitial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsInitial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsInjective
InstallMethod( AddIsInjective,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsInjective", category, func, -1 );
    
end );

InstallMethod( AddIsInjective,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsInjective", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsIsomorphicForObjects
InstallMethod( AddIsIsomorphicForObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsIsomorphicForObjects", category, func, -1 );
    
end );

InstallMethod( AddIsIsomorphicForObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsIsomorphicForObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsIsomorphism
InstallMethod( AddIsIsomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsIsomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsIsomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsIsomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsLiftable
InstallMethod( AddIsLiftable,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsLiftable", category, func, -1 );
    
end );

InstallMethod( AddIsLiftable,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsLiftable", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsLiftableAlongMonomorphism
InstallMethod( AddIsLiftableAlongMonomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsLiftableAlongMonomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsLiftableAlongMonomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsLiftableAlongMonomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsMonomorphism
InstallMethod( AddIsMonomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsMonomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsMonomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsMonomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsOne
InstallMethod( AddIsOne,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsOne", category, func, -1 );
    
end );

InstallMethod( AddIsOne,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsOne", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsProjective
InstallMethod( AddIsProjective,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsProjective", category, func, -1 );
    
end );

InstallMethod( AddIsProjective,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsProjective", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsSplitEpimorphism
InstallMethod( AddIsSplitEpimorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsSplitEpimorphism", category, func, -1 );
    
end );

InstallMethod( AddIsSplitEpimorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsSplitEpimorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsSplitMonomorphism
InstallMethod( AddIsSplitMonomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsSplitMonomorphism", category, func, -1 );
    
end );

InstallMethod( AddIsSplitMonomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsSplitMonomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsTerminal
InstallMethod( AddIsTerminal,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsTerminal", category, func, -1 );
    
end );

InstallMethod( AddIsTerminal,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsTerminal", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsWellDefinedForMorphisms
InstallMethod( AddIsWellDefinedForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsWellDefinedForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddIsWellDefinedForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsWellDefinedForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsWellDefinedForMorphismsWithGivenSourceAndRange
InstallMethod( AddIsWellDefinedForMorphismsWithGivenSourceAndRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsWellDefinedForMorphismsWithGivenSourceAndRange", category, func, -1 );
    
end );

InstallMethod( AddIsWellDefinedForMorphismsWithGivenSourceAndRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsWellDefinedForMorphismsWithGivenSourceAndRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsWellDefinedForObjects
InstallMethod( AddIsWellDefinedForObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsWellDefinedForObjects", category, func, -1 );
    
end );

InstallMethod( AddIsWellDefinedForObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsWellDefinedForObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsWellDefinedForTwoCells
InstallMethod( AddIsWellDefinedForTwoCells,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsWellDefinedForTwoCells", category, func, -1 );
    
end );

InstallMethod( AddIsWellDefinedForTwoCells,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsWellDefinedForTwoCells", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsZeroForMorphisms
InstallMethod( AddIsZeroForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsZeroForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddIsZeroForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsZeroForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsZeroForObjects
InstallMethod( AddIsZeroForObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsZeroForObjects", category, func, -1 );
    
end );

InstallMethod( AddIsZeroForObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsZeroForObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCoequalizerOfCoproductDiagramToPushout
InstallMethod( AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCoequalizerOfCoproductDiagramToPushout", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCoequalizerOfCoproductDiagramToPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct
InstallMethod( AddIsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCoimageToCokernelOfKernel
InstallMethod( AddIsomorphismFromCoimageToCokernelOfKernel,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCoimageToCokernelOfKernel", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCoimageToCokernelOfKernel,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCoimageToCokernelOfKernel", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer
InstallMethod( AddIsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCokernelOfKernelToCoimage
InstallMethod( AddIsomorphismFromCokernelOfKernelToCoimage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCokernelOfKernelToCoimage", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCokernelOfKernelToCoimage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCokernelOfKernelToCoimage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromCoproductToDirectSum
InstallMethod( AddIsomorphismFromCoproductToDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromCoproductToDirectSum", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromCoproductToDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromCoproductToDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromDirectProductToDirectSum
InstallMethod( AddIsomorphismFromDirectProductToDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromDirectProductToDirectSum", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromDirectProductToDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromDirectProductToDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromDirectSumToCoproduct
InstallMethod( AddIsomorphismFromDirectSumToCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromDirectSumToCoproduct", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromDirectSumToCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromDirectSumToCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromDirectSumToDirectProduct
InstallMethod( AddIsomorphismFromDirectSumToDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromDirectSumToDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromDirectSumToDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromDirectSumToDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct
InstallMethod( AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct
InstallMethod( AddIsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram
InstallMethod( AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject
InstallMethod( AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromImageObjectToKernelOfCokernel
InstallMethod( AddIsomorphismFromImageObjectToKernelOfCokernel,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromImageObjectToKernelOfCokernel", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromImageObjectToKernelOfCokernel,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromImageObjectToKernelOfCokernel", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromInitialObjectToZeroObject
InstallMethod( AddIsomorphismFromInitialObjectToZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInitialObjectToZeroObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInitialObjectToZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInitialObjectToZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject
InstallMethod( AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromKernelOfCokernelToImageObject
InstallMethod( AddIsomorphismFromKernelOfCokernelToImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromKernelOfCokernelToImageObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromKernelOfCokernelToImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromKernelOfCokernelToImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer
InstallMethod( AddIsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromPushoutToCoequalizerOfCoproductDiagram
InstallMethod( AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromPushoutToCoequalizerOfCoproductDiagram", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromPushoutToCoequalizerOfCoproductDiagram", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromTerminalObjectToZeroObject
InstallMethod( AddIsomorphismFromTerminalObjectToZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromTerminalObjectToZeroObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromTerminalObjectToZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromTerminalObjectToZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromZeroObjectToInitialObject
InstallMethod( AddIsomorphismFromZeroObjectToInitialObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromZeroObjectToInitialObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromZeroObjectToInitialObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromZeroObjectToInitialObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromZeroObjectToTerminalObject
InstallMethod( AddIsomorphismFromZeroObjectToTerminalObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromZeroObjectToTerminalObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromZeroObjectToTerminalObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromZeroObjectToTerminalObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## JointPairwiseDifferencesOfMorphismsFromCoproduct
InstallMethod( AddJointPairwiseDifferencesOfMorphismsFromCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "JointPairwiseDifferencesOfMorphismsFromCoproduct", category, func, -1 );
    
end );

InstallMethod( AddJointPairwiseDifferencesOfMorphismsFromCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "JointPairwiseDifferencesOfMorphismsFromCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## JointPairwiseDifferencesOfMorphismsIntoDirectProduct
InstallMethod( AddJointPairwiseDifferencesOfMorphismsIntoDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "JointPairwiseDifferencesOfMorphismsIntoDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddJointPairwiseDifferencesOfMorphismsIntoDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "JointPairwiseDifferencesOfMorphismsIntoDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## KernelEmbedding
InstallMethod( AddKernelEmbedding,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelEmbedding", category, func, -1 );
    
end );

InstallMethod( AddKernelEmbedding,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelEmbedding", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## KernelEmbeddingWithGivenKernelObject
InstallMethod( AddKernelEmbeddingWithGivenKernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelEmbeddingWithGivenKernelObject", category, func, -1 );
    
end );

InstallMethod( AddKernelEmbeddingWithGivenKernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelEmbeddingWithGivenKernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( KernelEmbeddingWithGivenKernelObject,
                    "KernelEmbeddingWithGivenKernelObject by calling KernelEmbedding with the WithGiven argument(s) dropped",
                    [
                        [ KernelEmbedding, 1 ],
                    ],
  function( cat, alpha, P )
    
    return KernelEmbedding( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( KernelEmbedding,
                    "KernelEmbedding by calling KernelEmbeddingWithGivenKernelObject with the WithGiven object(s)",
                    [
                        [ KernelEmbeddingWithGivenKernelObject, 1 ],
                        [ KernelObject, 1 ],
                    ],
  function( cat, alpha )
    
    return KernelEmbeddingWithGivenKernelObject( cat, alpha, KernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## KernelLift
InstallMethod( AddKernelLift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelLift", category, func, -1 );
    
end );

InstallMethod( AddKernelLift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelLift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## KernelLiftWithGivenKernelObject
InstallMethod( AddKernelLiftWithGivenKernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelLiftWithGivenKernelObject", category, func, -1 );
    
end );

InstallMethod( AddKernelLiftWithGivenKernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelLiftWithGivenKernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( KernelLiftWithGivenKernelObject,
                    "KernelLiftWithGivenKernelObject by calling KernelLift with the WithGiven argument(s) dropped",
                    [
                        [ KernelLift, 1 ],
                    ],
  function( cat, alpha, T, tau, P )
    
    return KernelLift( cat, alpha, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( KernelLift,
                    "KernelLift by calling KernelLiftWithGivenKernelObject with the WithGiven object(s)",
                    [
                        [ KernelLiftWithGivenKernelObject, 1 ],
                        [ KernelObject, 1 ],
                    ],
  function( cat, alpha, T, tau )
    
    return KernelLiftWithGivenKernelObject( cat, alpha, T, tau, KernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## KernelObject
InstallMethod( AddKernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelObject", category, func, -1 );
    
end );

InstallMethod( AddKernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## KernelObjectFunctorial
InstallMethod( AddKernelObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddKernelObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## KernelObjectFunctorialWithGivenKernelObjects
InstallMethod( AddKernelObjectFunctorialWithGivenKernelObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "KernelObjectFunctorialWithGivenKernelObjects", category, func, -1 );
    
end );

InstallMethod( AddKernelObjectFunctorialWithGivenKernelObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "KernelObjectFunctorialWithGivenKernelObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( KernelObjectFunctorialWithGivenKernelObjects,
                    "KernelObjectFunctorialWithGivenKernelObjects by calling KernelObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ KernelObjectFunctorial, 1 ],
                    ],
  function( cat, P, alpha, mu, alphap, Pp )
    
    return KernelObjectFunctorial( cat, alpha, mu, alphap );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( KernelObjectFunctorial,
                    "KernelObjectFunctorial by calling KernelObjectFunctorialWithGivenKernelObjects with the WithGiven object(s)",
                    [
                        [ KernelObjectFunctorialWithGivenKernelObjects, 1 ],
                        [ KernelObject, 2 ],
                    ],
  function( cat, alpha, mu, alphap )
    
    return KernelObjectFunctorialWithGivenKernelObjects( cat, KernelObject( cat, alpha ), alpha, mu, alphap, KernelObject( cat, alphap ) );
    
end : is_with_given_derivation := true );

## Lift
InstallMethod( AddLift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Lift", category, func, -1 );
    
end );

InstallMethod( AddLift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Lift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LiftAlongMonomorphism
InstallMethod( AddLiftAlongMonomorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LiftAlongMonomorphism", category, func, -1 );
    
end );

InstallMethod( AddLiftAlongMonomorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LiftAlongMonomorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## LinearCombinationOfMorphisms
InstallMethod( AddLinearCombinationOfMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "LinearCombinationOfMorphisms", category, func, -1 );
    
end );

InstallMethod( AddLinearCombinationOfMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "LinearCombinationOfMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MereExistenceOfSolutionOfLinearSystemInAbCategory
InstallMethod( AddMereExistenceOfSolutionOfLinearSystemInAbCategory,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MereExistenceOfSolutionOfLinearSystemInAbCategory", category, func, -1 );
    
end );

InstallMethod( AddMereExistenceOfSolutionOfLinearSystemInAbCategory,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MereExistenceOfSolutionOfLinearSystemInAbCategory", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonomorphismIntoInjectiveEnvelopeObject
InstallMethod( AddMonomorphismIntoInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonomorphismIntoInjectiveEnvelopeObject", category, func, -1 );
    
end );

InstallMethod( AddMonomorphismIntoInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonomorphismIntoInjectiveEnvelopeObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject
InstallMethod( AddMonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject", category, func, -1 );
    
end );

InstallMethod( AddMonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject,
                    "MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject by calling MonomorphismIntoInjectiveEnvelopeObject with the WithGiven argument(s) dropped",
                    [
                        [ MonomorphismIntoInjectiveEnvelopeObject, 1 ],
                    ],
  function( cat, A, I )
    
    return MonomorphismIntoInjectiveEnvelopeObject( cat, A );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonomorphismIntoInjectiveEnvelopeObject,
                    "MonomorphismIntoInjectiveEnvelopeObject by calling MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject with the WithGiven object(s)",
                    [
                        [ MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject, 1 ],
                        [ InjectiveEnvelopeObject, 1 ],
                    ],
  function( cat, A )
    
    return MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject( cat, A, InjectiveEnvelopeObject( cat, A ) );
    
end : is_with_given_derivation := true );

## MonomorphismIntoSomeInjectiveObject
InstallMethod( AddMonomorphismIntoSomeInjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonomorphismIntoSomeInjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddMonomorphismIntoSomeInjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonomorphismIntoSomeInjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject
InstallMethod( AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject,
                    "MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject by calling MonomorphismIntoSomeInjectiveObject with the WithGiven argument(s) dropped",
                    [
                        [ MonomorphismIntoSomeInjectiveObject, 1 ],
                    ],
  function( cat, A, I )
    
    return MonomorphismIntoSomeInjectiveObject( cat, A );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MonomorphismIntoSomeInjectiveObject,
                    "MonomorphismIntoSomeInjectiveObject by calling MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject with the WithGiven object(s)",
                    [
                        [ MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject, 1 ],
                        [ SomeInjectiveObject, 1 ],
                    ],
  function( cat, A )
    
    return MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject( cat, A, SomeInjectiveObject( cat, A ) );
    
end : is_with_given_derivation := true );

## MorphismBetweenDirectSums
InstallMethod( AddMorphismBetweenDirectSums,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismBetweenDirectSums", category, func, -1 );
    
end );

InstallMethod( AddMorphismBetweenDirectSums,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismBetweenDirectSums", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismBetweenDirectSumsWithGivenDirectSums
InstallMethod( AddMorphismBetweenDirectSumsWithGivenDirectSums,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismBetweenDirectSumsWithGivenDirectSums", category, func, -1 );
    
end );

InstallMethod( AddMorphismBetweenDirectSumsWithGivenDirectSums,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismBetweenDirectSumsWithGivenDirectSums", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismBetweenDirectSumsWithGivenDirectSums,
                    "MorphismBetweenDirectSumsWithGivenDirectSums by calling MorphismBetweenDirectSums with the WithGiven argument(s) dropped",
                    [
                        [ MorphismBetweenDirectSums, 1 ],
                    ],
  function( cat, S, source_diagram, mat, range_diagram, T )
    
    return MorphismBetweenDirectSums( cat, source_diagram, mat, range_diagram );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismBetweenDirectSums,
                    "MorphismBetweenDirectSums by calling MorphismBetweenDirectSumsWithGivenDirectSums with the WithGiven object(s)",
                    [
                        [ MorphismBetweenDirectSumsWithGivenDirectSums, 1 ],
                        [ DirectSum, 2 ],
                    ],
  function( cat, source_diagram, mat, range_diagram )
    
    return MorphismBetweenDirectSumsWithGivenDirectSums( cat, DirectSum( cat, source_diagram ), source_diagram, mat, range_diagram, DirectSum( cat, range_diagram ) );
    
end : is_with_given_derivation := true );

## MorphismConstructor
InstallMethod( AddMorphismConstructor,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismConstructor", category, func, -1 );
    
end );

InstallMethod( AddMorphismConstructor,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismConstructor", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismDatum
InstallMethod( AddMorphismDatum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismDatum", category, func, -1 );
    
end );

InstallMethod( AddMorphismDatum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismDatum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromCoimageToImage
InstallMethod( AddMorphismFromCoimageToImage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromCoimageToImage", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromCoimageToImage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromCoimageToImage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromCoimageToImageWithGivenObjects
InstallMethod( AddMorphismFromCoimageToImageWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromCoimageToImageWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromCoimageToImageWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromCoimageToImageWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromCoimageToImageWithGivenObjects,
                    "MorphismFromCoimageToImageWithGivenObjects by calling MorphismFromCoimageToImage with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromCoimageToImage, 1 ],
                    ],
  function( cat, C, alpha, I )
    
    return MorphismFromCoimageToImage( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromCoimageToImage,
                    "MorphismFromCoimageToImage by calling MorphismFromCoimageToImageWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromCoimageToImageWithGivenObjects, 1 ],
                        [ CoimageObject, 1 ],
                        [ ImageObject, 1 ],
                    ],
  function( cat, alpha )
    
    return MorphismFromCoimageToImageWithGivenObjects( cat, CoimageObject( cat, alpha ), alpha, ImageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## MorphismFromEqualizerToSink
InstallMethod( AddMorphismFromEqualizerToSink,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromEqualizerToSink", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromEqualizerToSink,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromEqualizerToSink", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromEqualizerToSinkWithGivenEqualizer
InstallMethod( AddMorphismFromEqualizerToSinkWithGivenEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromEqualizerToSinkWithGivenEqualizer", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromEqualizerToSinkWithGivenEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromEqualizerToSinkWithGivenEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromEqualizerToSinkWithGivenEqualizer,
                    "MorphismFromEqualizerToSinkWithGivenEqualizer by calling MorphismFromEqualizerToSink with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromEqualizerToSink, 1 ],
                    ],
  function( cat, Y, morphisms, P )
    
    return MorphismFromEqualizerToSink( cat, Y, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromEqualizerToSink,
                    "MorphismFromEqualizerToSink by calling MorphismFromEqualizerToSinkWithGivenEqualizer with the WithGiven object(s)",
                    [
                        [ MorphismFromEqualizerToSinkWithGivenEqualizer, 1 ],
                        [ Equalizer, 1 ],
                    ],
  function( cat, Y, morphisms )
    
    return MorphismFromEqualizerToSinkWithGivenEqualizer( cat, Y, morphisms, Equalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## MorphismFromFiberProductToSink
InstallMethod( AddMorphismFromFiberProductToSink,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromFiberProductToSink", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromFiberProductToSink,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromFiberProductToSink", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromFiberProductToSinkWithGivenFiberProduct
InstallMethod( AddMorphismFromFiberProductToSinkWithGivenFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromFiberProductToSinkWithGivenFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromFiberProductToSinkWithGivenFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromFiberProductToSinkWithGivenFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromFiberProductToSinkWithGivenFiberProduct,
                    "MorphismFromFiberProductToSinkWithGivenFiberProduct by calling MorphismFromFiberProductToSink with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromFiberProductToSink, 1 ],
                    ],
  function( cat, morphisms, P )
    
    return MorphismFromFiberProductToSink( cat, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromFiberProductToSink,
                    "MorphismFromFiberProductToSink by calling MorphismFromFiberProductToSinkWithGivenFiberProduct with the WithGiven object(s)",
                    [
                        [ MorphismFromFiberProductToSinkWithGivenFiberProduct, 1 ],
                        [ FiberProduct, 1 ],
                    ],
  function( cat, morphisms )
    
    return MorphismFromFiberProductToSinkWithGivenFiberProduct( cat, morphisms, FiberProduct( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## MorphismFromKernelObjectToSink
InstallMethod( AddMorphismFromKernelObjectToSink,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromKernelObjectToSink", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromKernelObjectToSink,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromKernelObjectToSink", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromKernelObjectToSinkWithGivenKernelObject
InstallMethod( AddMorphismFromKernelObjectToSinkWithGivenKernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromKernelObjectToSinkWithGivenKernelObject", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromKernelObjectToSinkWithGivenKernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromKernelObjectToSinkWithGivenKernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromKernelObjectToSinkWithGivenKernelObject,
                    "MorphismFromKernelObjectToSinkWithGivenKernelObject by calling MorphismFromKernelObjectToSink with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromKernelObjectToSink, 1 ],
                    ],
  function( cat, alpha, P )
    
    return MorphismFromKernelObjectToSink( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromKernelObjectToSink,
                    "MorphismFromKernelObjectToSink by calling MorphismFromKernelObjectToSinkWithGivenKernelObject with the WithGiven object(s)",
                    [
                        [ MorphismFromKernelObjectToSinkWithGivenKernelObject, 1 ],
                        [ KernelObject, 1 ],
                    ],
  function( cat, alpha )
    
    return MorphismFromKernelObjectToSinkWithGivenKernelObject( cat, alpha, KernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## MorphismFromSourceToCoequalizer
InstallMethod( AddMorphismFromSourceToCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromSourceToCoequalizerWithGivenCoequalizer
InstallMethod( AddMorphismFromSourceToCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToCoequalizerWithGivenCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToCoequalizerWithGivenCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromSourceToCoequalizerWithGivenCoequalizer,
                    "MorphismFromSourceToCoequalizerWithGivenCoequalizer by calling MorphismFromSourceToCoequalizer with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromSourceToCoequalizer, 1 ],
                    ],
  function( cat, Y, morphisms, P )
    
    return MorphismFromSourceToCoequalizer( cat, Y, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromSourceToCoequalizer,
                    "MorphismFromSourceToCoequalizer by calling MorphismFromSourceToCoequalizerWithGivenCoequalizer with the WithGiven object(s)",
                    [
                        [ MorphismFromSourceToCoequalizerWithGivenCoequalizer, 1 ],
                        [ Coequalizer, 1 ],
                    ],
  function( cat, Y, morphisms )
    
    return MorphismFromSourceToCoequalizerWithGivenCoequalizer( cat, Y, morphisms, Coequalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## MorphismFromSourceToCokernelObject
InstallMethod( AddMorphismFromSourceToCokernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToCokernelObject", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToCokernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToCokernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromSourceToCokernelObjectWithGivenCokernelObject
InstallMethod( AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToCokernelObjectWithGivenCokernelObject", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToCokernelObjectWithGivenCokernelObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromSourceToCokernelObjectWithGivenCokernelObject,
                    "MorphismFromSourceToCokernelObjectWithGivenCokernelObject by calling MorphismFromSourceToCokernelObject with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromSourceToCokernelObject, 1 ],
                    ],
  function( cat, alpha, P )
    
    return MorphismFromSourceToCokernelObject( cat, alpha );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromSourceToCokernelObject,
                    "MorphismFromSourceToCokernelObject by calling MorphismFromSourceToCokernelObjectWithGivenCokernelObject with the WithGiven object(s)",
                    [
                        [ MorphismFromSourceToCokernelObjectWithGivenCokernelObject, 1 ],
                        [ CokernelObject, 1 ],
                    ],
  function( cat, alpha )
    
    return MorphismFromSourceToCokernelObjectWithGivenCokernelObject( cat, alpha, CokernelObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## MorphismFromSourceToPushout
InstallMethod( AddMorphismFromSourceToPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToPushout", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromSourceToPushoutWithGivenPushout
InstallMethod( AddMorphismFromSourceToPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromSourceToPushoutWithGivenPushout", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromSourceToPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromSourceToPushoutWithGivenPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromSourceToPushoutWithGivenPushout,
                    "MorphismFromSourceToPushoutWithGivenPushout by calling MorphismFromSourceToPushout with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromSourceToPushout, 1 ],
                    ],
  function( cat, morphisms, P )
    
    return MorphismFromSourceToPushout( cat, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromSourceToPushout,
                    "MorphismFromSourceToPushout by calling MorphismFromSourceToPushoutWithGivenPushout with the WithGiven object(s)",
                    [
                        [ MorphismFromSourceToPushoutWithGivenPushout, 1 ],
                        [ Pushout, 1 ],
                    ],
  function( cat, morphisms )
    
    return MorphismFromSourceToPushoutWithGivenPushout( cat, morphisms, Pushout( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## MorphismsOfExternalHom
InstallMethod( AddMorphismsOfExternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismsOfExternalHom", category, func, -1 );
    
end );

InstallMethod( AddMorphismsOfExternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismsOfExternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MultiplyWithElementOfCommutativeRingForMorphisms
InstallMethod( AddMultiplyWithElementOfCommutativeRingForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MultiplyWithElementOfCommutativeRingForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddMultiplyWithElementOfCommutativeRingForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MultiplyWithElementOfCommutativeRingForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ObjectConstructor
InstallMethod( AddObjectConstructor,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ObjectConstructor", category, func, -1 );
    
end );

InstallMethod( AddObjectConstructor,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ObjectConstructor", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ObjectDatum
InstallMethod( AddObjectDatum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ObjectDatum", category, func, -1 );
    
end );

InstallMethod( AddObjectDatum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ObjectDatum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PostCompose
InstallMethod( AddPostCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PostCompose", category, func, -1 );
    
end );

InstallMethod( AddPostCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PostCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PostComposeList
InstallMethod( AddPostComposeList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PostComposeList", category, func, -1 );
    
end );

InstallMethod( AddPostComposeList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PostComposeList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PostInverseForMorphisms
InstallMethod( AddPostInverseForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PostInverseForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddPostInverseForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PostInverseForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PreCompose
InstallMethod( AddPreCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PreCompose", category, func, -1 );
    
end );

InstallMethod( AddPreCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PreCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PreComposeList
InstallMethod( AddPreComposeList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PreComposeList", category, func, -1 );
    
end );

InstallMethod( AddPreComposeList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PreComposeList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PreInverseForMorphisms
InstallMethod( AddPreInverseForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PreInverseForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddPreInverseForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PreInverseForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectionInFactorOfDirectProduct
InstallMethod( AddProjectionInFactorOfDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectionInFactorOfDirectProductWithGivenDirectProduct
InstallMethod( AddProjectionInFactorOfDirectProductWithGivenDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfDirectProductWithGivenDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfDirectProductWithGivenDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfDirectProductWithGivenDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ProjectionInFactorOfDirectProductWithGivenDirectProduct,
                    "ProjectionInFactorOfDirectProductWithGivenDirectProduct by calling ProjectionInFactorOfDirectProduct with the WithGiven argument(s) dropped",
                    [
                        [ ProjectionInFactorOfDirectProduct, 1 ],
                    ],
  function( cat, objects, k, P )
    
    return ProjectionInFactorOfDirectProduct( cat, objects, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ProjectionInFactorOfDirectProduct,
                    "ProjectionInFactorOfDirectProduct by calling ProjectionInFactorOfDirectProductWithGivenDirectProduct with the WithGiven object(s)",
                    [
                        [ ProjectionInFactorOfDirectProductWithGivenDirectProduct, 1 ],
                        [ DirectProduct, 1 ],
                    ],
  function( cat, objects, k )
    
    return ProjectionInFactorOfDirectProductWithGivenDirectProduct( cat, objects, k, DirectProduct( cat, objects ) );
    
end : is_with_given_derivation := true );

## ProjectionInFactorOfDirectSum
InstallMethod( AddProjectionInFactorOfDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfDirectSum", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectionInFactorOfDirectSumWithGivenDirectSum
InstallMethod( AddProjectionInFactorOfDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfDirectSumWithGivenDirectSum", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfDirectSumWithGivenDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ProjectionInFactorOfDirectSumWithGivenDirectSum,
                    "ProjectionInFactorOfDirectSumWithGivenDirectSum by calling ProjectionInFactorOfDirectSum with the WithGiven argument(s) dropped",
                    [
                        [ ProjectionInFactorOfDirectSum, 1 ],
                    ],
  function( cat, objects, k, P )
    
    return ProjectionInFactorOfDirectSum( cat, objects, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ProjectionInFactorOfDirectSum,
                    "ProjectionInFactorOfDirectSum by calling ProjectionInFactorOfDirectSumWithGivenDirectSum with the WithGiven object(s)",
                    [
                        [ ProjectionInFactorOfDirectSumWithGivenDirectSum, 1 ],
                        [ DirectSum, 1 ],
                    ],
  function( cat, objects, k )
    
    return ProjectionInFactorOfDirectSumWithGivenDirectSum( cat, objects, k, DirectSum( cat, objects ) );
    
end : is_with_given_derivation := true );

## ProjectionInFactorOfFiberProduct
InstallMethod( AddProjectionInFactorOfFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectionInFactorOfFiberProductWithGivenFiberProduct
InstallMethod( AddProjectionInFactorOfFiberProductWithGivenFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionInFactorOfFiberProductWithGivenFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddProjectionInFactorOfFiberProductWithGivenFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionInFactorOfFiberProductWithGivenFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ProjectionInFactorOfFiberProductWithGivenFiberProduct,
                    "ProjectionInFactorOfFiberProductWithGivenFiberProduct by calling ProjectionInFactorOfFiberProduct with the WithGiven argument(s) dropped",
                    [
                        [ ProjectionInFactorOfFiberProduct, 1 ],
                    ],
  function( cat, morphisms, k, P )
    
    return ProjectionInFactorOfFiberProduct( cat, morphisms, k );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ProjectionInFactorOfFiberProduct,
                    "ProjectionInFactorOfFiberProduct by calling ProjectionInFactorOfFiberProductWithGivenFiberProduct with the WithGiven object(s)",
                    [
                        [ ProjectionInFactorOfFiberProductWithGivenFiberProduct, 1 ],
                        [ FiberProduct, 1 ],
                    ],
  function( cat, morphisms, k )
    
    return ProjectionInFactorOfFiberProductWithGivenFiberProduct( cat, morphisms, k, FiberProduct( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## ProjectionOntoCoequalizer
InstallMethod( AddProjectionOntoCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionOntoCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddProjectionOntoCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionOntoCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectionOntoCoequalizerWithGivenCoequalizer
InstallMethod( AddProjectionOntoCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectionOntoCoequalizerWithGivenCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddProjectionOntoCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectionOntoCoequalizerWithGivenCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ProjectionOntoCoequalizerWithGivenCoequalizer,
                    "ProjectionOntoCoequalizerWithGivenCoequalizer by calling ProjectionOntoCoequalizer with the WithGiven argument(s) dropped",
                    [
                        [ ProjectionOntoCoequalizer, 1 ],
                    ],
  function( cat, Y, morphisms, P )
    
    return ProjectionOntoCoequalizer( cat, Y, morphisms );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ProjectionOntoCoequalizer,
                    "ProjectionOntoCoequalizer by calling ProjectionOntoCoequalizerWithGivenCoequalizer with the WithGiven object(s)",
                    [
                        [ ProjectionOntoCoequalizerWithGivenCoequalizer, 1 ],
                        [ Coequalizer, 1 ],
                    ],
  function( cat, Y, morphisms )
    
    return ProjectionOntoCoequalizerWithGivenCoequalizer( cat, Y, morphisms, Coequalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## ProjectiveCoverObject
InstallMethod( AddProjectiveCoverObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectiveCoverObject", category, func, -1 );
    
end );

InstallMethod( AddProjectiveCoverObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectiveCoverObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectiveDimension
InstallMethod( AddProjectiveDimension,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectiveDimension", category, func, -1 );
    
end );

InstallMethod( AddProjectiveDimension,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectiveDimension", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ProjectiveLift
InstallMethod( AddProjectiveLift,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ProjectiveLift", category, func, -1 );
    
end );

InstallMethod( AddProjectiveLift,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ProjectiveLift", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## Pushout
InstallMethod( AddPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "Pushout", category, func, -1 );
    
end );

InstallMethod( AddPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "Pushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PushoutFunctorial
InstallMethod( AddPushoutFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PushoutFunctorial", category, func, -1 );
    
end );

InstallMethod( AddPushoutFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PushoutFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## PushoutFunctorialWithGivenPushouts
InstallMethod( AddPushoutFunctorialWithGivenPushouts,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "PushoutFunctorialWithGivenPushouts", category, func, -1 );
    
end );

InstallMethod( AddPushoutFunctorialWithGivenPushouts,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "PushoutFunctorialWithGivenPushouts", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( PushoutFunctorialWithGivenPushouts,
                    "PushoutFunctorialWithGivenPushouts by calling PushoutFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ PushoutFunctorial, 1 ],
                    ],
  function( cat, P, morphisms, L, morphismsp, Pp )
    
    return PushoutFunctorial( cat, morphisms, L, morphismsp );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( PushoutFunctorial,
                    "PushoutFunctorial by calling PushoutFunctorialWithGivenPushouts with the WithGiven object(s)",
                    [
                        [ PushoutFunctorialWithGivenPushouts, 1 ],
                        [ Pushout, 2 ],
                    ],
  function( cat, morphisms, L, morphismsp )
    
    return PushoutFunctorialWithGivenPushouts( cat, Pushout( cat, morphisms ), morphisms, L, morphismsp, Pushout( cat, morphismsp ) );
    
end : is_with_given_derivation := true );

## RandomMorphismByInteger
InstallMethod( AddRandomMorphismByInteger,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismByInteger", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismByInteger,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismByInteger", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismByList
InstallMethod( AddRandomMorphismByList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismByList", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismByList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismByList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedRangeByInteger
InstallMethod( AddRandomMorphismWithFixedRangeByInteger,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedRangeByInteger", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedRangeByInteger,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedRangeByInteger", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedRangeByList
InstallMethod( AddRandomMorphismWithFixedRangeByList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedRangeByList", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedRangeByList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedRangeByList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedSourceAndRangeByInteger
InstallMethod( AddRandomMorphismWithFixedSourceAndRangeByInteger,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedSourceAndRangeByInteger", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedSourceAndRangeByInteger,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedSourceAndRangeByInteger", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedSourceAndRangeByList
InstallMethod( AddRandomMorphismWithFixedSourceAndRangeByList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedSourceAndRangeByList", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedSourceAndRangeByList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedSourceAndRangeByList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedSourceByInteger
InstallMethod( AddRandomMorphismWithFixedSourceByInteger,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedSourceByInteger", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedSourceByInteger,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedSourceByInteger", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomMorphismWithFixedSourceByList
InstallMethod( AddRandomMorphismWithFixedSourceByList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomMorphismWithFixedSourceByList", category, func, -1 );
    
end );

InstallMethod( AddRandomMorphismWithFixedSourceByList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomMorphismWithFixedSourceByList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomObjectByInteger
InstallMethod( AddRandomObjectByInteger,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomObjectByInteger", category, func, -1 );
    
end );

InstallMethod( AddRandomObjectByInteger,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomObjectByInteger", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## RandomObjectByList
InstallMethod( AddRandomObjectByList,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RandomObjectByList", category, func, -1 );
    
end );

InstallMethod( AddRandomObjectByList,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RandomObjectByList", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyEndo
InstallMethod( AddSimplifyEndo,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyEndo", category, func, -1 );
    
end );

InstallMethod( AddSimplifyEndo,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyEndo", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyEndo_IsoFromInputObject
InstallMethod( AddSimplifyEndo_IsoFromInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyEndo_IsoFromInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyEndo_IsoFromInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyEndo_IsoFromInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyEndo_IsoToInputObject
InstallMethod( AddSimplifyEndo_IsoToInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyEndo_IsoToInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyEndo_IsoToInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyEndo_IsoToInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyMorphism
InstallMethod( AddSimplifyMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyMorphism", category, func, -1 );
    
end );

InstallMethod( AddSimplifyMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyObject
InstallMethod( AddSimplifyObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyObject_IsoFromInputObject
InstallMethod( AddSimplifyObject_IsoFromInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyObject_IsoFromInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyObject_IsoFromInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyObject_IsoFromInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyObject_IsoToInputObject
InstallMethod( AddSimplifyObject_IsoToInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyObject_IsoToInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyObject_IsoToInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyObject_IsoToInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyRange
InstallMethod( AddSimplifyRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyRange", category, func, -1 );
    
end );

InstallMethod( AddSimplifyRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyRange_IsoFromInputObject
InstallMethod( AddSimplifyRange_IsoFromInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyRange_IsoFromInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyRange_IsoFromInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyRange_IsoFromInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifyRange_IsoToInputObject
InstallMethod( AddSimplifyRange_IsoToInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifyRange_IsoToInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifyRange_IsoToInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifyRange_IsoToInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySource
InstallMethod( AddSimplifySource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySource", category, func, -1 );
    
end );

InstallMethod( AddSimplifySource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySourceAndRange
InstallMethod( AddSimplifySourceAndRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySourceAndRange", category, func, -1 );
    
end );

InstallMethod( AddSimplifySourceAndRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySourceAndRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySourceAndRange_IsoFromInputRange
InstallMethod( AddSimplifySourceAndRange_IsoFromInputRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySourceAndRange_IsoFromInputRange", category, func, -1 );
    
end );

InstallMethod( AddSimplifySourceAndRange_IsoFromInputRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySourceAndRange_IsoFromInputRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySourceAndRange_IsoFromInputSource
InstallMethod( AddSimplifySourceAndRange_IsoFromInputSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySourceAndRange_IsoFromInputSource", category, func, -1 );
    
end );

InstallMethod( AddSimplifySourceAndRange_IsoFromInputSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySourceAndRange_IsoFromInputSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySourceAndRange_IsoToInputRange
InstallMethod( AddSimplifySourceAndRange_IsoToInputRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySourceAndRange_IsoToInputRange", category, func, -1 );
    
end );

InstallMethod( AddSimplifySourceAndRange_IsoToInputRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySourceAndRange_IsoToInputRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySourceAndRange_IsoToInputSource
InstallMethod( AddSimplifySourceAndRange_IsoToInputSource,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySourceAndRange_IsoToInputSource", category, func, -1 );
    
end );

InstallMethod( AddSimplifySourceAndRange_IsoToInputSource,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySourceAndRange_IsoToInputSource", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySource_IsoFromInputObject
InstallMethod( AddSimplifySource_IsoFromInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySource_IsoFromInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifySource_IsoFromInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySource_IsoFromInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SimplifySource_IsoToInputObject
InstallMethod( AddSimplifySource_IsoToInputObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SimplifySource_IsoToInputObject", category, func, -1 );
    
end );

InstallMethod( AddSimplifySource_IsoToInputObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SimplifySource_IsoToInputObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SolveLinearSystemInAbCategory
InstallMethod( AddSolveLinearSystemInAbCategory,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SolveLinearSystemInAbCategory", category, func, -1 );
    
end );

InstallMethod( AddSolveLinearSystemInAbCategory,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SolveLinearSystemInAbCategory", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeInjectiveObject
InstallMethod( AddSomeInjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeInjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddSomeInjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeInjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeIsomorphismBetweenObjects
InstallMethod( AddSomeIsomorphismBetweenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeIsomorphismBetweenObjects", category, func, -1 );
    
end );

InstallMethod( AddSomeIsomorphismBetweenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeIsomorphismBetweenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeProjectiveObject
InstallMethod( AddSomeProjectiveObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeProjectiveObject", category, func, -1 );
    
end );

InstallMethod( AddSomeProjectiveObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeProjectiveObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeReductionBySplitEpiSummand
InstallMethod( AddSomeReductionBySplitEpiSummand,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeReductionBySplitEpiSummand", category, func, -1 );
    
end );

InstallMethod( AddSomeReductionBySplitEpiSummand,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeReductionBySplitEpiSummand", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeReductionBySplitEpiSummand_MorphismFromInputRange
InstallMethod( AddSomeReductionBySplitEpiSummand_MorphismFromInputRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeReductionBySplitEpiSummand_MorphismFromInputRange", category, func, -1 );
    
end );

InstallMethod( AddSomeReductionBySplitEpiSummand_MorphismFromInputRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeReductionBySplitEpiSummand_MorphismFromInputRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SomeReductionBySplitEpiSummand_MorphismToInputRange
InstallMethod( AddSomeReductionBySplitEpiSummand_MorphismToInputRange,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SomeReductionBySplitEpiSummand_MorphismToInputRange", category, func, -1 );
    
end );

InstallMethod( AddSomeReductionBySplitEpiSummand_MorphismToInputRange,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SomeReductionBySplitEpiSummand_MorphismToInputRange", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SubtractionForMorphisms
InstallMethod( AddSubtractionForMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SubtractionForMorphisms", category, func, -1 );
    
end );

InstallMethod( AddSubtractionForMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SubtractionForMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## SumOfMorphisms
InstallMethod( AddSumOfMorphisms,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "SumOfMorphisms", category, func, -1 );
    
end );

InstallMethod( AddSumOfMorphisms,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "SumOfMorphisms", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TerminalObject
InstallMethod( AddTerminalObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TerminalObject", category, func, -1 );
    
end );

InstallMethod( AddTerminalObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TerminalObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TerminalObjectFunctorial
InstallMethod( AddTerminalObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TerminalObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddTerminalObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TerminalObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TerminalObjectFunctorialWithGivenTerminalObjects
InstallMethod( AddTerminalObjectFunctorialWithGivenTerminalObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TerminalObjectFunctorialWithGivenTerminalObjects", category, func, -1 );
    
end );

InstallMethod( AddTerminalObjectFunctorialWithGivenTerminalObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TerminalObjectFunctorialWithGivenTerminalObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TerminalObjectFunctorialWithGivenTerminalObjects,
                    "TerminalObjectFunctorialWithGivenTerminalObjects by calling TerminalObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ TerminalObjectFunctorial, 1 ],
                    ],
  function( cat, P, Pp )
    
    return TerminalObjectFunctorial( cat );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TerminalObjectFunctorial,
                    "TerminalObjectFunctorial by calling TerminalObjectFunctorialWithGivenTerminalObjects with the WithGiven object(s)",
                    [
                        [ TerminalObjectFunctorialWithGivenTerminalObjects, 1 ],
                        [ TerminalObject, 2 ],
                    ],
  function( cat )
    
    return TerminalObjectFunctorialWithGivenTerminalObjects( cat, TerminalObject( cat ), TerminalObject( cat ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromCoequalizer
InstallMethod( AddUniversalMorphismFromCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromCoequalizerWithGivenCoequalizer
InstallMethod( AddUniversalMorphismFromCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromCoequalizerWithGivenCoequalizer", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromCoequalizerWithGivenCoequalizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromCoequalizerWithGivenCoequalizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromCoequalizerWithGivenCoequalizer,
                    "UniversalMorphismFromCoequalizerWithGivenCoequalizer by calling UniversalMorphismFromCoequalizer with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromCoequalizer, 1 ],
                    ],
  function( cat, Y, morphisms, T, tau, P )
    
    return UniversalMorphismFromCoequalizer( cat, Y, morphisms, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromCoequalizer,
                    "UniversalMorphismFromCoequalizer by calling UniversalMorphismFromCoequalizerWithGivenCoequalizer with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromCoequalizerWithGivenCoequalizer, 1 ],
                        [ Coequalizer, 1 ],
                    ],
  function( cat, Y, morphisms, T, tau )
    
    return UniversalMorphismFromCoequalizerWithGivenCoequalizer( cat, Y, morphisms, T, tau, Coequalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromCoproduct
InstallMethod( AddUniversalMorphismFromCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromCoproduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromCoproductWithGivenCoproduct
InstallMethod( AddUniversalMorphismFromCoproductWithGivenCoproduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromCoproductWithGivenCoproduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromCoproductWithGivenCoproduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromCoproductWithGivenCoproduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromCoproductWithGivenCoproduct,
                    "UniversalMorphismFromCoproductWithGivenCoproduct by calling UniversalMorphismFromCoproduct with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromCoproduct, 1 ],
                    ],
  function( cat, objects, T, tau, P )
    
    return UniversalMorphismFromCoproduct( cat, objects, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromCoproduct,
                    "UniversalMorphismFromCoproduct by calling UniversalMorphismFromCoproductWithGivenCoproduct with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromCoproductWithGivenCoproduct, 1 ],
                        [ Coproduct, 1 ],
                    ],
  function( cat, objects, T, tau )
    
    return UniversalMorphismFromCoproductWithGivenCoproduct( cat, objects, T, tau, Coproduct( cat, objects ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromDirectSum
InstallMethod( AddUniversalMorphismFromDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromDirectSum", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromDirectSumWithGivenDirectSum
InstallMethod( AddUniversalMorphismFromDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromDirectSumWithGivenDirectSum", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromDirectSumWithGivenDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromDirectSumWithGivenDirectSum,
                    "UniversalMorphismFromDirectSumWithGivenDirectSum by calling UniversalMorphismFromDirectSum with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromDirectSum, 1 ],
                    ],
  function( cat, objects, T, tau, P )
    
    return UniversalMorphismFromDirectSum( cat, objects, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromDirectSum,
                    "UniversalMorphismFromDirectSum by calling UniversalMorphismFromDirectSumWithGivenDirectSum with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromDirectSumWithGivenDirectSum, 1 ],
                        [ DirectSum, 1 ],
                    ],
  function( cat, objects, T, tau )
    
    return UniversalMorphismFromDirectSumWithGivenDirectSum( cat, objects, T, tau, DirectSum( cat, objects ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromImage
InstallMethod( AddUniversalMorphismFromImage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromImage", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromImage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromImage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromImageWithGivenImageObject
InstallMethod( AddUniversalMorphismFromImageWithGivenImageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromImageWithGivenImageObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromImageWithGivenImageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromImageWithGivenImageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromImageWithGivenImageObject,
                    "UniversalMorphismFromImageWithGivenImageObject by calling UniversalMorphismFromImage with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromImage, 1 ],
                    ],
  function( cat, alpha, tau, I )
    
    return UniversalMorphismFromImage( cat, alpha, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromImage,
                    "UniversalMorphismFromImage by calling UniversalMorphismFromImageWithGivenImageObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromImageWithGivenImageObject, 1 ],
                        [ ImageObject, 1 ],
                    ],
  function( cat, alpha, tau )
    
    return UniversalMorphismFromImageWithGivenImageObject( cat, alpha, tau, ImageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromInitialObject
InstallMethod( AddUniversalMorphismFromInitialObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromInitialObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromInitialObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromInitialObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromInitialObjectWithGivenInitialObject
InstallMethod( AddUniversalMorphismFromInitialObjectWithGivenInitialObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromInitialObjectWithGivenInitialObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromInitialObjectWithGivenInitialObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromInitialObjectWithGivenInitialObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromInitialObjectWithGivenInitialObject,
                    "UniversalMorphismFromInitialObjectWithGivenInitialObject by calling UniversalMorphismFromInitialObject with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromInitialObject, 1 ],
                    ],
  function( cat, T, P )
    
    return UniversalMorphismFromInitialObject( cat, T );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromInitialObject,
                    "UniversalMorphismFromInitialObject by calling UniversalMorphismFromInitialObjectWithGivenInitialObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromInitialObjectWithGivenInitialObject, 1 ],
                        [ InitialObject, 1 ],
                    ],
  function( cat, T )
    
    return UniversalMorphismFromInitialObjectWithGivenInitialObject( cat, T, InitialObject( cat ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromPushout
InstallMethod( AddUniversalMorphismFromPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromPushout", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromPushoutWithGivenPushout
InstallMethod( AddUniversalMorphismFromPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromPushoutWithGivenPushout", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromPushoutWithGivenPushout,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromPushoutWithGivenPushout", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromPushoutWithGivenPushout,
                    "UniversalMorphismFromPushoutWithGivenPushout by calling UniversalMorphismFromPushout with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromPushout, 1 ],
                    ],
  function( cat, morphisms, T, tau, P )
    
    return UniversalMorphismFromPushout( cat, morphisms, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromPushout,
                    "UniversalMorphismFromPushout by calling UniversalMorphismFromPushoutWithGivenPushout with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromPushoutWithGivenPushout, 1 ],
                        [ Pushout, 1 ],
                    ],
  function( cat, morphisms, T, tau )
    
    return UniversalMorphismFromPushoutWithGivenPushout( cat, morphisms, T, tau, Pushout( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismFromZeroObject
InstallMethod( AddUniversalMorphismFromZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromZeroObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismFromZeroObjectWithGivenZeroObject
InstallMethod( AddUniversalMorphismFromZeroObjectWithGivenZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismFromZeroObjectWithGivenZeroObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismFromZeroObjectWithGivenZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismFromZeroObjectWithGivenZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismFromZeroObjectWithGivenZeroObject,
                    "UniversalMorphismFromZeroObjectWithGivenZeroObject by calling UniversalMorphismFromZeroObject with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismFromZeroObject, 1 ],
                    ],
  function( cat, T, P )
    
    return UniversalMorphismFromZeroObject( cat, T );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismFromZeroObject,
                    "UniversalMorphismFromZeroObject by calling UniversalMorphismFromZeroObjectWithGivenZeroObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismFromZeroObjectWithGivenZeroObject, 1 ],
                        [ ZeroObject, 1 ],
                    ],
  function( cat, T )
    
    return UniversalMorphismFromZeroObjectWithGivenZeroObject( cat, T, ZeroObject( cat ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoCoimage
InstallMethod( AddUniversalMorphismIntoCoimage,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoCoimage", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoCoimage,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoCoimage", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoCoimageWithGivenCoimageObject
InstallMethod( AddUniversalMorphismIntoCoimageWithGivenCoimageObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoCoimageWithGivenCoimageObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoCoimageWithGivenCoimageObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoCoimageWithGivenCoimageObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoCoimageWithGivenCoimageObject,
                    "UniversalMorphismIntoCoimageWithGivenCoimageObject by calling UniversalMorphismIntoCoimage with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoCoimage, 1 ],
                    ],
  function( cat, alpha, tau, C )
    
    return UniversalMorphismIntoCoimage( cat, alpha, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoCoimage,
                    "UniversalMorphismIntoCoimage by calling UniversalMorphismIntoCoimageWithGivenCoimageObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoCoimageWithGivenCoimageObject, 1 ],
                        [ CoimageObject, 1 ],
                    ],
  function( cat, alpha, tau )
    
    return UniversalMorphismIntoCoimageWithGivenCoimageObject( cat, alpha, tau, CoimageObject( cat, alpha ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoDirectProduct
InstallMethod( AddUniversalMorphismIntoDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoDirectProductWithGivenDirectProduct
InstallMethod( AddUniversalMorphismIntoDirectProductWithGivenDirectProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoDirectProductWithGivenDirectProduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoDirectProductWithGivenDirectProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoDirectProductWithGivenDirectProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoDirectProductWithGivenDirectProduct,
                    "UniversalMorphismIntoDirectProductWithGivenDirectProduct by calling UniversalMorphismIntoDirectProduct with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoDirectProduct, 1 ],
                    ],
  function( cat, objects, T, tau, P )
    
    return UniversalMorphismIntoDirectProduct( cat, objects, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoDirectProduct,
                    "UniversalMorphismIntoDirectProduct by calling UniversalMorphismIntoDirectProductWithGivenDirectProduct with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoDirectProductWithGivenDirectProduct, 1 ],
                        [ DirectProduct, 1 ],
                    ],
  function( cat, objects, T, tau )
    
    return UniversalMorphismIntoDirectProductWithGivenDirectProduct( cat, objects, T, tau, DirectProduct( cat, objects ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoDirectSum
InstallMethod( AddUniversalMorphismIntoDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoDirectSum", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoDirectSumWithGivenDirectSum
InstallMethod( AddUniversalMorphismIntoDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoDirectSumWithGivenDirectSum", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoDirectSumWithGivenDirectSum,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoDirectSumWithGivenDirectSum", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoDirectSumWithGivenDirectSum,
                    "UniversalMorphismIntoDirectSumWithGivenDirectSum by calling UniversalMorphismIntoDirectSum with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoDirectSum, 1 ],
                    ],
  function( cat, objects, T, tau, P )
    
    return UniversalMorphismIntoDirectSum( cat, objects, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoDirectSum,
                    "UniversalMorphismIntoDirectSum by calling UniversalMorphismIntoDirectSumWithGivenDirectSum with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoDirectSumWithGivenDirectSum, 1 ],
                        [ DirectSum, 1 ],
                    ],
  function( cat, objects, T, tau )
    
    return UniversalMorphismIntoDirectSumWithGivenDirectSum( cat, objects, T, tau, DirectSum( cat, objects ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoEqualizer
InstallMethod( AddUniversalMorphismIntoEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoEqualizer", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoEqualizerWithGivenEqualizer
InstallMethod( AddUniversalMorphismIntoEqualizerWithGivenEqualizer,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoEqualizerWithGivenEqualizer", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoEqualizerWithGivenEqualizer,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoEqualizerWithGivenEqualizer", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoEqualizerWithGivenEqualizer,
                    "UniversalMorphismIntoEqualizerWithGivenEqualizer by calling UniversalMorphismIntoEqualizer with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoEqualizer, 1 ],
                    ],
  function( cat, Y, morphisms, T, tau, P )
    
    return UniversalMorphismIntoEqualizer( cat, Y, morphisms, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoEqualizer,
                    "UniversalMorphismIntoEqualizer by calling UniversalMorphismIntoEqualizerWithGivenEqualizer with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoEqualizerWithGivenEqualizer, 1 ],
                        [ Equalizer, 1 ],
                    ],
  function( cat, Y, morphisms, T, tau )
    
    return UniversalMorphismIntoEqualizerWithGivenEqualizer( cat, Y, morphisms, T, tau, Equalizer( cat, Y, morphisms ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoFiberProduct
InstallMethod( AddUniversalMorphismIntoFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoFiberProductWithGivenFiberProduct
InstallMethod( AddUniversalMorphismIntoFiberProductWithGivenFiberProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoFiberProductWithGivenFiberProduct", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoFiberProductWithGivenFiberProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoFiberProductWithGivenFiberProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoFiberProductWithGivenFiberProduct,
                    "UniversalMorphismIntoFiberProductWithGivenFiberProduct by calling UniversalMorphismIntoFiberProduct with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoFiberProduct, 1 ],
                    ],
  function( cat, morphisms, T, tau, P )
    
    return UniversalMorphismIntoFiberProduct( cat, morphisms, T, tau );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoFiberProduct,
                    "UniversalMorphismIntoFiberProduct by calling UniversalMorphismIntoFiberProductWithGivenFiberProduct with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoFiberProductWithGivenFiberProduct, 1 ],
                        [ FiberProduct, 1 ],
                    ],
  function( cat, morphisms, T, tau )
    
    return UniversalMorphismIntoFiberProductWithGivenFiberProduct( cat, morphisms, T, tau, FiberProduct( cat, morphisms ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoTerminalObject
InstallMethod( AddUniversalMorphismIntoTerminalObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoTerminalObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoTerminalObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoTerminalObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoTerminalObjectWithGivenTerminalObject
InstallMethod( AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoTerminalObjectWithGivenTerminalObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoTerminalObjectWithGivenTerminalObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoTerminalObjectWithGivenTerminalObject,
                    "UniversalMorphismIntoTerminalObjectWithGivenTerminalObject by calling UniversalMorphismIntoTerminalObject with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoTerminalObject, 1 ],
                    ],
  function( cat, T, P )
    
    return UniversalMorphismIntoTerminalObject( cat, T );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoTerminalObject,
                    "UniversalMorphismIntoTerminalObject by calling UniversalMorphismIntoTerminalObjectWithGivenTerminalObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoTerminalObjectWithGivenTerminalObject, 1 ],
                        [ TerminalObject, 1 ],
                    ],
  function( cat, T )
    
    return UniversalMorphismIntoTerminalObjectWithGivenTerminalObject( cat, T, TerminalObject( cat ) );
    
end : is_with_given_derivation := true );

## UniversalMorphismIntoZeroObject
InstallMethod( AddUniversalMorphismIntoZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoZeroObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## UniversalMorphismIntoZeroObjectWithGivenZeroObject
InstallMethod( AddUniversalMorphismIntoZeroObjectWithGivenZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "UniversalMorphismIntoZeroObjectWithGivenZeroObject", category, func, -1 );
    
end );

InstallMethod( AddUniversalMorphismIntoZeroObjectWithGivenZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "UniversalMorphismIntoZeroObjectWithGivenZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( UniversalMorphismIntoZeroObjectWithGivenZeroObject,
                    "UniversalMorphismIntoZeroObjectWithGivenZeroObject by calling UniversalMorphismIntoZeroObject with the WithGiven argument(s) dropped",
                    [
                        [ UniversalMorphismIntoZeroObject, 1 ],
                    ],
  function( cat, T, P )
    
    return UniversalMorphismIntoZeroObject( cat, T );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( UniversalMorphismIntoZeroObject,
                    "UniversalMorphismIntoZeroObject by calling UniversalMorphismIntoZeroObjectWithGivenZeroObject with the WithGiven object(s)",
                    [
                        [ UniversalMorphismIntoZeroObjectWithGivenZeroObject, 1 ],
                        [ ZeroObject, 1 ],
                    ],
  function( cat, T )
    
    return UniversalMorphismIntoZeroObjectWithGivenZeroObject( cat, T, ZeroObject( cat ) );
    
end : is_with_given_derivation := true );

## VerticalPostCompose
InstallMethod( AddVerticalPostCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "VerticalPostCompose", category, func, -1 );
    
end );

InstallMethod( AddVerticalPostCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "VerticalPostCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## VerticalPreCompose
InstallMethod( AddVerticalPreCompose,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "VerticalPreCompose", category, func, -1 );
    
end );

InstallMethod( AddVerticalPreCompose,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "VerticalPreCompose", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ZeroMorphism
InstallMethod( AddZeroMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ZeroMorphism", category, func, -1 );
    
end );

InstallMethod( AddZeroMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ZeroMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ZeroObject
InstallMethod( AddZeroObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ZeroObject", category, func, -1 );
    
end );

InstallMethod( AddZeroObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ZeroObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ZeroObjectFunctorial
InstallMethod( AddZeroObjectFunctorial,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ZeroObjectFunctorial", category, func, -1 );
    
end );

InstallMethod( AddZeroObjectFunctorial,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ZeroObjectFunctorial", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## ZeroObjectFunctorialWithGivenZeroObjects
InstallMethod( AddZeroObjectFunctorialWithGivenZeroObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "ZeroObjectFunctorialWithGivenZeroObjects", category, func, -1 );
    
end );

InstallMethod( AddZeroObjectFunctorialWithGivenZeroObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "ZeroObjectFunctorialWithGivenZeroObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( ZeroObjectFunctorialWithGivenZeroObjects,
                    "ZeroObjectFunctorialWithGivenZeroObjects by calling ZeroObjectFunctorial with the WithGiven argument(s) dropped",
                    [
                        [ ZeroObjectFunctorial, 1 ],
                    ],
  function( cat, P, Pp )
    
    return ZeroObjectFunctorial( cat );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( ZeroObjectFunctorial,
                    "ZeroObjectFunctorial by calling ZeroObjectFunctorialWithGivenZeroObjects with the WithGiven object(s)",
                    [
                        [ ZeroObjectFunctorialWithGivenZeroObjects, 1 ],
                        [ ZeroObject, 2 ],
                    ],
  function( cat )
    
    return ZeroObjectFunctorialWithGivenZeroObjects( cat, ZeroObject( cat ), ZeroObject( cat ) );
    
end : is_with_given_derivation := true );
