#############################################################################
##
#W  equalityclasses.g             GAP4 Package `RCWA'             Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing list of
##  equality classes.
##
##  The list 'equalityclasses' contains lists of indices of equal groups in
##  the list grps. Due to the computational difficulty of equality tests for
##  the groups in question it is not guaranteed that grps[i] <> grps[j] if i
##  and j do not lie in the same list in 'equalityclasses'.
##
#############################################################################

local  eqclsgt1;

eqclsgt1 :=
[[1,2,68],[3,7,226,239,472,485,2413,2450,2696,8924,8937],
 [4,10],[5,8,2539],[6,12],[9,11],[23,31,44,1296,1309],
 [24,25,27,28,33,35,46,48,97,98,99,101,108,110,112,114,154,
   155,159,162,172,175,2303,2304,2309,2312,2323,2325,2368,
   2369,2374,2377,2388,2390,4513,4514,4519,4522,4533,4535],
 [26,32,41,42,1422,1423,1433,1435,1613,1622,1623,1657,1660,
   1928,1930,1955,3643,3644,3646,3868,3869,3871,4141,4166],
 [29,37,1545],[30,38],[34,36],[39,54],[40,55],
 [43,47,1982],[45,53],[49,50],[51,52],[56,59],
 [57,58],[60,64],[61,66],[62,67],[63,65],
 [69,73,219,223,465,469,4558,4579,4825,8917,8921],[70,76],
 [71,74,4684],[72,78],[75,77],
 [89,91,92,93,1289,1290,1292,1293,1333,1334,1335,1376,1378,
   1418,1419,1459,5647,5648,5649,5732,5733,5734,5775,5815],
 [90,94,107,1349,1511],[95,96],[100,113],[102,116,1796],
 [103,117],[104,118,1857],[105,120],[106,121],[109,115],
 [111,119],[122,125],[123,124],[126,130],[127,132],
 [128,133],[129,131],[134,138,6638],[135,141],[136,139],
 [137,143],[140,142],
 [156,158,163,166,173,177,1382,1385,1392,1396,1463,1466,1473,
   1477,1651,1662,1757,1957],[157,164,179],[160,183],
 [161,182,1596],[165,180,1732],[167,174],[168,169],
 [170,185],[171,186],[176,184],[178,181],[187,190],
 [188,189],[191,195],[192,197],[193,198],[194,196],
 [199,200,203,205,263,265,266,327,330,449,451,510,8717,8718,
   8720,8779,8780,8782,8901,8903,10732,10733,10735,10856,10915,
   12745,12806,16406],[201,207,388,453,8840,8905],
 [204,206,450,452,8902,8904],[208,454,8906],[209,455,8907],
 [210,456,8908],[211,457,8909],[212,458,8910],
 [213,459,8911],[214,460,8912],[215,461,8913],
 [216,462,8914],[217,463,8915],[218,464,8916],
 [220,222,466,468,8918,8920],[221,467,8919],[224,470,8922],
 [225,471,8923],[227,237,473,483,8925,8935],
 [228,243,474,489,8926,8941],[229,475,8927],
 [230,241,476,487,8928,8939],[231,477,8929],[232,478,8930],
 [233,479,8931],[234,249,480,495,8932,8947],
 [235,250,481,496,8933,8948],[236,482,8934],[238,484,8936],
 [240,248,486,494,8938,8946],[242,488,8940],[244,490,8942],
 [245,491,8943],[246,492,8944],[247,493,8945],
 [251,254,497,500,8949,8952],[252,253,498,499,8950,8951],
 [255,259,501,505,8953,8957],[256,261,502,507,8954,8959],
 [257,262,503,508,8955,8960],[258,260,504,506,8956,8958],
 [264,270,391,627],[267,269,568,626],[271,628],[272,629],
 [273,630],[274,631],[275,632],[276,633],[277,634],
 [278,635],[279,636],[280,637],[281,638],
 [282,286,639,643],[283,285,640,642],[284,641],[287,644],
 [288,645],[289,302,646,659],[290,300,647,657],
 [291,306,648,663],[292,649],[293,304,650,661],[294,651],
 [295,652],[296,653],[297,312,654,669],[298,313,655,670],
 [299,656],[301,658],[303,311,660,668],[305,662],
 [307,664],[308,665],[309,666],[310,667],
 [314,317,671,674],[315,316,672,673],[318,322,675,679],
 [319,324,676,681],[320,325,677,682],[321,323,678,680],
 [326,329,331,332,389,390,392,509,511,512,570,683],
 [333,513],[334,514],[335,515],[336,516],[337,517],
 [338,518],[339,519],[340,520],[341,521],[342,522],
 [343,523],[344,348,524,528],[345,347,525,527],[346,526],
 [349,529],[350,530],[351,364,531,544],[352,362,532,542],
 [353,368,533,548],[354,534],[355,366,535,546],[356,536],
 [357,537],[358,538],[359,374,539,554],[360,375,540,555],
 [361,541],[363,543],[365,373,545,553],[367,547],
 [369,549],[370,550],[371,551],[372,552],
 [376,379,382,387,556,559,562,567,2218,2223,2245,2250],
 [377,378,381,386,557,558,561,566,2227,2232,2236,2241],
 [380,383,384,385,560,563,564,565,2253,2255,2269,2273],
 [394,739],[395,740],[396,741],[397,742],[398,743],
 [399,744],[400,745],[401,746],[402,747],[403,748],
 [404,749],[405,409,750,754],[406,408,751,753],[407,752],
 [410,755],[411,756],[412,425,757,770],[413,423,758,768],
 [414,429,759,774],[415,760],[416,427,761,772],[417,762],
 [418,763],[419,764],[420,435,765,780],[421,436,766,781],
 [422,767],[424,769],[426,434,771,779],[428,773],
 [430,775],[431,776],[432,777],[433,778],
 [437,440,782,785],[438,439,783,784],[441,445,786,790],
 [442,447,787,792],[443,448,788,793],[444,446,789,791],
 [571,684],[572,685],[573,686],[574,687],[575,688],
 [576,689],[577,690],[578,691],[579,692],[580,693],
 [581,694],[582,586,695,699],[583,585,696,698],[584,697],
 [587,700],[588,701],[589,602,702,715],[590,600,703,713],
 [591,606,704,719],[592,705],[593,604,706,717],[594,707],
 [595,708],[596,709],[597,612,710,725],[598,613,711,726],
 [599,712],[601,714],[603,611,716,724],[605,718],
 [607,720],[608,721],[609,722],[610,723],
 [614,617,727,730],[615,616,728,729],[618,622,731,735],
 [619,624,732,737],[620,625,733,738],[621,623,734,736],
 [794,795,848],[797,798,1004],[801,802,1198],[804,808],
 [805,807],[811,824],[812,822],[813,828],[815,826],
 [819,834],[820,835],[825,833],[836,839],[837,838],
 [840,844],[841,846],[842,847],[843,845],[849,850,953],
 [853,854,1151],[857,861],[858,860],[864,877],[865,875],
 [866,881],[868,879],[872,887],[873,888],[878,886],
 [889,892],[890,891],[893,897],[894,899],[895,900],
 [896,898],[901,903,954],[905,907,1152],[909,913],
 [910,912],[916,929],[917,927],[918,933],[920,931],
 [924,939],[925,940],[930,938],[941,944],[942,943],
 [945,949],[946,951],[947,952],[948,950],[955,956,1103],
 [960,964],[961,963],[967,980],[968,978],[969,984],
 [971,982],[975,990],[976,991],[981,989],[992,995],
 [993,994],[996,1000],[997,1002],[998,1003],[999,1001],
 [1005,1007,1104],[1010,1014],[1011,1013],[1017,1030],
 [1018,1028],[1019,1034],[1021,1032],[1025,1040],
 [1026,1041],[1031,1039],[1042,1045],[1043,1044],
 [1046,1050],[1047,1052],[1048,1053],[1049,1051],
 [1054,1057,1105],[1059,1063],[1060,1062],[1066,1079],
 [1067,1077],[1068,1083],[1070,1081],[1074,1089],
 [1075,1090],[1080,1088],[1091,1094],[1092,1093],
 [1095,1099],[1096,1101],[1097,1102],[1098,1100],
 [1107,1111],[1108,1110],[1114,1127],[1115,1125],
 [1116,1131],[1118,1129],[1122,1137],[1123,1138],
 [1128,1136],[1139,1142],[1140,1141],[1143,1147],
 [1144,1149],[1145,1150],[1146,1148],[1154,1158],
 [1155,1157],[1161,1174],[1162,1172],[1163,1178],
 [1165,1176],[1169,1184],[1170,1185],[1175,1183],
 [1186,1189],[1187,1188],[1190,1194],[1191,1196],
 [1192,1197],[1193,1195],[1200,1204],[1201,1203],
 [1207,1220],[1208,1218],[1209,1224],[1211,1222],
 [1215,1230],[1216,1231],[1221,1229],[1232,1235],
 [1233,1234],[1236,1240],[1237,1242],[1238,1243],
 [1239,1241],[1245,1249],[1246,1248],[1252,1265],
 [1253,1263],[1254,1269],[1256,1267],[1260,1275],
 [1261,1276],[1266,1274],[1277,1280],[1278,1279],
 [1281,1285],[1282,1287],[1283,1288],[1284,1286],
 [1291,1306,1432,38304],[1297,1307],
 [1298,1300,1311,1313,1685,1691,1696,1756,1763,1932,1934,2049],
 [1304,1319],[1305,1320],[1310,1318],[1316,1317,2143],
 [1321,1324],[1322,1323],[1325,1329],[1326,1331],
 [1327,1332],[1328,1330],[1337,1338,1499,1500,1538],
 [1339,1343,1352,1354,1501,1505,1514,1516,1616,1627,1759,2004],
 [1340,1341,1350,1356,1502,1503,1512,1518,1649,1664,1692,1959],
 [1342,1504],[1344,1346,1506,1508,1784],[1345,1507],
 [1347,1362,1509,1524],[1348,1363,1510,1525],[1351,1513],
 [1353,1361,1515,1523],[1355,1517],[1357,1519],
 [1358,1360,1520,1522,2127],[1359,1521],
 [1364,1367,1526,1529],[1365,1366,1527,1528],
 [1368,1372,1530,1534],[1369,1374,1531,1536],
 [1370,1375,1532,1537],[1371,1373,1533,1535],[1379,1460],
 [1380,1461],
 [1381,1383,1394,1398,1462,1464,1475,1479,1614,1629,1694,2006],
 [1384,1465],[1386,1402,1467,1483],
 [1387,1388,1400,1401,1468,1469,1481,1482,1814,1826,1856,2126],
 [1389,1390,1404,1405,1470,1471,1485,1486,1873,1888,1914,2188],
 [1391,1472],[1393,1399,1474,1480],[1395,1403,1476,1484],
 [1397,1478],
 [1406,1407,1408,1409,1487,1488,1489,1490,2213,2214,2225,2234],
 [1410,1414,1491,1495],
 [1411,1412,1416,1417,1492,1493,1497,1498,2258,2263,2267,2278],
 [1413,1415,1494,1496],[1424,1439],[1426,1437],
 [1427,1428,1783],[1430,1445],[1431,1446],[1436,1444],
 [1447,1450],[1448,1449],[1451,1455],[1452,1457],
 [1453,1458],[1454,1456],[1539,1552,1555,1628,2005],
 [1540,1542,1544,1550,1650,1652,1659,1725,1726,1788,1789,1954],
 [1541,1556],[1543,1554],[1547,1562],[1548,1563],
 [1553,1561],[1564,1567],[1565,1566],[1568,1572],
 [1569,1574],[1570,1575],[1571,1573],[1576,1589],
 [1577,1587,1654,1847],[1578,1579,1593,1684,1731],
 [1580,1591,1592,1762,2048],[1584,1599],[1585,1600],
 [1590,1598],[1601,1604],[1602,1603],[1605,1609],
 [1606,1611],[1607,1612],[1608,1610],[1615,1727],
 [1617,1790],[1618,1624,1819,1820,1979],[1619,1849],
 [1620,1635,1877,2012],[1621,1636,1904,2013],
 [1626,1634,2003,2011],[1630,1631,2007,2008,2108],
 [1632,2009],[1633,2010],[1637,1640,2014,2017],
 [1638,1639,2015,2016],[1641,1645,2018,2022],
 [1642,1647,2019,2024],[1643,1648,2020,2025],
 [1644,1646,2021,2023],[1653,1663,1818,1958],
 [1655,1661,1669,1670,1875,1878,1886,1956,1964,1965,2034,2174],
 [1656,1671,1902,1966],[1665,1960],[1666,1961],[1667,1962],
 [1668,1963],[1672,1675,1967,1970],
 [1673,1674,1676,1680,1968,1969,1971,1975,2226,2230,2235,2239],
 [1677,1679,1681,1682,1972,1974,1976,1977,2259,2261,2271,2276],
 [1678,1683,1973,1978],[1686,1794],[1687,1824],
 [1688,1693,1848,1853,1983],[1689,1704,1881,2094],
 [1690,1705,1908,2095],[1695,1703,2028,2093],[1697,2069],
 [1699,1701,2089,2091,2109],[1700,2090],[1702,2092],
 [1706,1709,2096,2099],[1707,1708,2097,2098],
 [1710,1714,2100,2104],[1711,1716,2101,2106],
 [1712,1717,2102,2107],[1713,1715,2103,2105],[1718,1729],
 [1722,1737],[1723,1738],[1724,1730,1933],[1728,1736],
 [1739,1742],[1740,1741],[1743,1747],[1744,1749],
 [1745,1750],[1746,1748],[1751,1792],[1752,1822],
 [1753,1851],[1754,1769,1879,2055],
 [1755,1760,1768,1770,1905,1906,1913,2026,2035,2054,2056,2175],
 [1758,1981],[1764,1767,2050,2053,2110],[1765,2051],
 [1766,2052],
 [1771,1774,1775,1779,2057,2060,2061,2065,2216,2220,2243,2247],
 [1772,1773,2058,2059],[1776,1781,2062,2067],
 [1777,1778,1780,1782,2063,2064,2066,2068,2264,2266,2272,2277],
 [1785,1800],[1786,1801],[1791,1799],[1802,1805],
 [1803,1804],[1806,1810],[1807,1812],[1808,1813],
 [1809,1811],[1815,1830],[1816,1831],[1821,1829],
 [1832,1835],[1833,1834],[1836,1840],[1837,1842],
 [1838,1843],[1839,1841],[1844,1859],[1845,1860],
 [1850,1858],[1861,1864],[1862,1863],[1865,1869],
 [1866,1871],[1867,1872],[1868,1870],[1874,1940],
 [1876,1989],[1880,2075],[1882,2112],[1883,2129],
 [1884,2145],[1885,2160],[1889,1892,2189,2192],
 [1890,1891,2190,2191],[1893,1897,2193,2197],
 [1894,1899,2194,2199],[1895,1900,2195,2200],
 [1896,1898,2196,2198],[1901,1941],[1903,1990],[1907,2076],
 [1909,2113],[1910,2130],[1911,2146],[1912,2161],
 [1916,1919,2201,2204],[1917,1918,2202,2203],
 [1920,1924,2205,2209],[1921,1926,2206,2211],
 [1922,1927,2207,2212],[1923,1925,2208,2210],[1931,1939],
 [1942,1945],[1943,1944],[1946,1950],[1947,1952],
 [1948,1953],[1949,1951],[1980,1988],[1991,1994],
 [1992,1993],[1995,1999],[1996,2001],[1997,2002],
 [1998,2000],[2027,2074],[2029,2111],[2030,2128],
 [2031,2144],[2032,2159],[2036,2039,2176,2179],
 [2037,2038,2177,2178],[2040,2044,2180,2184],
 [2041,2046,2181,2186],[2042,2047,2182,2187],
 [2043,2045,2183,2185],[2077,2080],[2078,2079],[2081,2085],
 [2082,2087],[2083,2088],[2084,2086],[2114,2117],
 [2115,2116],[2118,2122],[2119,2124],[2120,2125],
 [2121,2123],[2131,2134],[2132,2133],[2135,2139],
 [2136,2141],[2137,2142],[2138,2140],[2147,2150],
 [2148,2149],[2151,2155],[2152,2157],[2153,2158],
 [2154,2156],[2162,2165],[2163,2164],[2166,2170],
 [2167,2172],[2168,2173],[2169,2171],[2217,2222,2244,2249],
 [2219,2221,2246,2248],[2228,2233,2237,2242],
 [2229,2231,2238,2240],[2251,2256,2260,2274],
 [2252,2257,2265,2275],[2280,2345,4490],[2281,2346,4491],
 [2282,2347,4492],[2283,2348,4493],[2284,2349,4494],
 [2285,2350,4495],[2286,2351,4496],[2287,2352,4497],
 [2288,2353,4498],[2289,2354,4499],[2290,2355,4500],
 [2291,2356,4501],[2292,2357,4502],[2293,2358,4503],
 [2294,2359,4504],[2295,2360,4505],[2296,2361,4506],
 [2297,2362,4507],[2298,2363,4508],[2299,2364,4509],
 [2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,2384,
   3560,3561,3602,3603,4510,4511,4512,4518,4528,4529,5652,5663,
   5737,5748,7732,7742,7775,7785],
 [2305,2310,2321,2370,2375,2386,4515,4520,4531],
 [2306,2307,2314,2315,2328,2329,2371,2372,2379,2380,2393,2394,
   3807,3808,4067,4068,4516,4517,4524,4525,4538,4539,5901,5915,
   5938,5952,7981,7982,8264,8293],
 [2311,2313,2320,2324,2326,2327,2376,2378,2385,2389,2391,2392,
   3943,3944,4006,4007,4521,4523,4530,4534,4536,4537,6082,6088,
   6338,6426,8229,8232,8418,8421],[2316,2381,4526],
 [2317,2382,4527],[2322,2387,4532],[2330,2395,4540],
 [2331,2396,4541],[2332,2397,4542],[2333,2398,4543],
 [2334,2399,4544],[2335,2400,4545],[2336,2401,4546],
 [2337,2402,4547],[2338,2403,4548],[2339,2404,4549],
 [2340,2405,4550],[2341,2406,4551],[2342,2407,4552],
 [2343,2408,4553],[2344,2409,4554],[2410,2411,2474],
 [2414,2416,2721,2867,2868],[2429,2437,9748],[2430,2431],
 [2432,2438],[2433,2434,2439,2441],[2435,2443,9997],
 [2436,2444],[2440,2442],[2447,2448],[2449,2453,10434],
 [2452,2454],[2455,2456],[2457,2458],[2462,2465],
 [2476,2477,2660],[2492,2500,11701],[2493,2494],
 [2495,2501],[2496,2497,2502,2504],[2498,2506,11950],
 [2499,2507],[2503,2505],[2510,2511],[2512,2516,12387],
 [2515,2517],[2518,2519],[2520,2521],[2529,2530],
 [2538,2541,2662,2852,2858],[2542,2543,2894],
 [2554,2562,13592],[2555,2556],[2557,2563],[2558,2566],
 [2559,2564],[2560,2568,13841],[2561,2569],[2565,2567],
 [2572,2573],[2574,2578,14278],[2577,2579],[2580,2581],
 [2582,2583],[2587,2593,4429],[2588,2592,4438],
 [2594,2595,4480],[2600,2601,2720],[2615,2623,15422],
 [2616,2617],[2618,2624],[2619,2627],[2620,2625],
 [2621,2629,15671],[2622,2630],[2626,2628],[2633,2634],
 [2635,2639,16108],[2638,2640],[2641,2642],[2643,2644],
 [2675,2683,17192],[2676,2677],[2678,2684],
 [2679,2680,2685,2687],[2681,2689,17441],[2682,2690],
 [2686,2688],[2693,2694],[2695,2699,17878],[2698,2700],
 [2701,2702],[2703,2704],[2714,2719],[2734,2742,18903],
 [2735,2736],[2737,2743],[2738,2746],[2739,2744],
 [2740,2748,19152],[2741,2749],[2745,2747],[2752,2753],
 [2754,2758,19589],[2757,2759],[2760,2761],[2762,2763],
 [2769,2777,4452],[2770,2778,4461],[2771,2776,4466],
 [2792,2800,20556],[2793,2794],[2795,2801],[2796,2804],
 [2797,2802],[2798,2806,20805],[2799,2807],[2803,2805],
 [2810,2811],[2812,2816,21242],[2815,2817],[2818,2819],
 [2820,2821],[2849,2857,22152],[2850,2851],[2853,2861],
 [2854,2859],[2855,2863,22401],[2856,2864],[2860,2862],
 [2869,2873,22838],[2872,2874],[2875,2876],[2877,2878],
 [2905,2913,23692],[2906,2907],[2908,2914],[2909,2917],
 [2910,2915],[2911,2919,23941],[2912,2920],[2916,2918],
 [2923,2924],[2925,2929,24378],[2928,2930],[2931,2932],
 [2933,2934],[2960,2968,25177],[2961,2962],[2963,2969],
 [2964,2972],[2965,2970],[2966,2974,25426],[2967,2975],
 [2971,2973],[2978,2979],[2980,2984,25863],[2983,2985],
 [2986,2987],[2988,2989],[3005,3006,3059],[3008,3009,3215],
 [3012,3013,3409],[3014,3022,26608],[3015,3016],
 [3017,3023],[3018,3026],[3019,3024],[3020,3028,26857],
 [3021,3029],[3025,3027],[3032,3033],[3034,3038,27294],
 [3037,3039],[3040,3041],[3042,3043],[3060,3061,3164],
 [3064,3065,3362],[3067,3075,27986],[3068,3069],
 [3070,3076],[3071,3079],[3072,3077],[3073,3081,28235],
 [3074,3082],[3078,3080],[3085,3086],[3087,3091,28672],
 [3090,3092],[3093,3094],[3095,3096],[3112,3114,3165],
 [3116,3118,3363],[3119,3127,29312],[3120,3121],
 [3122,3128],[3123,3131],[3124,3129],[3125,3133,29561],
 [3126,3134],[3130,3132],[3137,3138],[3139,3143,29998],
 [3142,3144],[3145,3146],[3147,3148],[3166,3167,3314],
 [3170,3178,30587],[3171,3172],[3173,3179],[3174,3182],
 [3175,3180],[3176,3184,30836],[3177,3185],[3181,3183],
 [3188,3189],[3190,3194,31273],[3193,3195],[3196,3197],
 [3198,3199],[3216,3218,3315],[3220,3228,31812],
 [3221,3222],[3223,3229],[3224,3232],[3225,3230],
 [3226,3234,32061],[3227,3235],[3231,3233],[3238,3239],
 [3240,3244,32498],[3243,3245],[3246,3247],[3248,3249],
 [3265,3268,3316],[3269,3277,32988],[3270,3271],
 [3272,3278],[3273,3281],[3274,3279],[3275,3283,33237],
 [3276,3284],[3280,3282],[3287,3288],[3289,3293,33674],
 [3292,3294],[3295,3296],[3297,3298],[3317,3325,34116],
 [3318,3319],[3320,3326],[3321,3329],[3322,3327],
 [3323,3331,34365],[3324,3332],[3328,3330],[3335,3336],
 [3337,3341,34802],[3340,3342],[3343,3344],[3345,3346],
 [3364,3372,35197],[3365,3366],[3367,3373],[3368,3376],
 [3369,3374],[3370,3378,35446],[3371,3379],[3375,3377],
 [3382,3383],[3384,3388,35883],[3387,3389],[3390,3391],
 [3392,3393],[3410,3418,36232],[3411,3412],[3413,3419],
 [3414,3422],[3415,3420],[3416,3424,36481],[3417,3425],
 [3421,3423],[3428,3429],[3430,3434,36918],[3433,3435],
 [3436,3437],[3438,3439],[3455,3463,37222],[3456,3457],
 [3458,3464],[3459,3467],[3460,3465],[3461,3469,37471],
 [3462,3470],[3466,3468],[3473,3474],[3475,3479,37908],
 [3478,3480],[3481,3482],[3483,3484],
 [3500,3501,3544,3550,3592,38211,38253,39156],
 [3502,3508,3633,3634,3824,38294,38295,38485],
 [3503,3504,3509,3511,3670,3673,3675,3712,3716,3825,3827,3896,
   38334,38336,38338,38373,38375,38377,38486,38488,41737,41739,
   41741,41852,41921,42591,42662,44661],
 [3505,3513,3750,3829,38411,38417,38490,43298],
 [3506,3514,3787,3830,38448,38491],
 [3510,3512,3826,3828,38487,38489],[3515,3831,38492],
 [3516,3832,38493],[3517,3518,3833,3834,4139,38494,38495,38800]
  ,[3519,3523,3835,3839,38496,38500,38854,44958],
 [3520,3836,38497],[3521,3837,38498],
 [3522,3524,3838,3840,4260,38499,38501,45025],
 [3525,3526,3841,3842,4319,38502,38503,38980],
 [3527,3528,3843,3844,4354,38504,38505,45119],
 [3529,3845,38506],[3530,3846,38507],[3531,3847,38508],
 [3532,3848,38509],[3533,3849,38510],[3534,3850,38511],
 [3535,3851,38512],[3536,3852,38513],[3537,3853,38514],
 [3538,3854,38515],[3539,3855,38516],[3540,3856,38517],
 [3541,3857,38518],[3542,3858,38519],[3543,3859,38520],
 [3545,3546,3547,3551,3552,3554,3587,3588,3589,3593,3594,3596,
   3629,3630,3635,3637,3674,3713,3860,3862],
 [3548,3549,3556,3557,3590,3591,3598,3599,3749,3757,3793,4025,
   39320,39357,40181,40182,43262,43494],[3553,3555,3595,3597],
 [3558,3600],[3559,3601],[3562,3566,3604,3608,39757,40618],
 [3563,3565,3567,3605,3607,3609,4215,4217],[3564,3606],
 [3568,3569,3610,3611],[3570,3571,3612,3613],[3572,3614],
 [3573,3574,3615,3616,4399],[3575,3617],[3576,3618],
 [3577,3578,3619,3620,4445],[3579,3621],[3580,3622],
 [3581,3623],[3582,3624],[3583,3625],[3584,3626],
 [3585,3586,3627,3628,4489],
 [3631,3636,3638,3639,3751,3753,3755,3861,3863,3864,3931,3994,
   41000,41001,43333,43400,43463,45291],[3632,3640,3788,3865],
 [3641,3866],[3642,3867],[3645,3649,3870,3874,41438,45553],
 [3647,3872],[3648,3650,3873,3875],[3651,3652,3876,3877],
 [3653,3654,3878,3879],[3655,3656,3880,3881,4385],
 [3657,3882],[3658,3883],[3659,3884],
 [3660,3662,3885,3887,4446],[3661,3886],[3663,3888],
 [3664,3889],[3665,3890],[3666,3891],
 [3667,3668,3892,3893,4487],[3669,3894],
 [3671,3679,3754,3963,41781,43432],[3672,3680,3791,3964],
 [3676,3678,3929,3962],[3681,3682,3965,3966,4084],
 [3683,3684,3688,3690,3722,3723,3727,3729,3902,3903,3907,3909,
   3967,3968,3972,3974,4143,4145,4168,4170],
 [3685,3689,3969,3973,42218,47138],[3686,3970],[3687,3971],
 [3691,3692,3693,3694,3730,3731,3732,3733,3910,3911,3912,3913,
   3975,3976,3977,3978,4320,4321,4337,4338],
 [3695,3697,3979,3981,4386],[3696,3980],
 [3698,3699,3982,3983,4424],[3700,3984],
 [3701,3702,3985,3986,4454],[3703,3704,3987,3988,4469],
 [3705,3989],[3706,3990],[3707,3709,3991,3993,4488],
 [3708,3992],[3710,3718,3752,3898,42522,43367],
 [3711,3715,3717,3719,3789,3790,3792,3895,3897,3899,3932,3995],
 [3720,3900],[3721,3901],[3724,3728,3904,3908,42959,46114],
 [3725,3905],[3726,3906],[3734,3914],[3735,3915],
 [3736,3916],[3737,3917],[3738,3918],[3739,3919],
 [3740,3920],[3741,3921],[3742,3922],[3743,3923],
 [3744,3924],[3745,3925],[3746,3926],[3747,3927],
 [3748,3928],[3758,4026,43495],[3759,4027,43496],
 [3760,3761,4028,4029,43497,43498],
 [3762,3763,3766,4030,4031,4034,4190,4216,43499,43500,43503,
   43659,43662,48038,48061,50097],[3764,4032,43501],
 [3765,3767,4033,4035,43502,43504],
 [3768,3769,4036,4037,43505,43506],
 [3770,3771,4038,4039,43507,43508],[3772,4040,43509],
 [3773,4041,43510],[3774,4042,43511],[3775,4043,43512],
 [3776,4044,43513],[3777,4045,43514],[3778,4046,43515],
 [3779,4047,43516],[3780,4048,43517],[3781,4049,43518],
 [3782,4050,43519],[3783,4051,43520],[3784,4052,43521],
 [3785,4053,43522],[3786,4054,43523],[3795,4055],
 [3796,4056],[3797,3798,4057,4058],
 [3799,3802,3803,3804,4059,4062,4063,4064,4192,4194,4259,4280,
   44327,44328,48444,48531,50140,50161],[3800,4060],
 [3801,4061],[3805,3806,4065,4066],[3809,4069],[3810,4070],
 [3811,4071],[3812,4072],[3813,4073],[3814,4074],
 [3815,4075],[3816,4076],[3817,4077],[3818,4078],
 [3819,4079],[3820,4080],[3821,4081],[3822,4082],
 [3823,4083],[3933,3996],[3934,3997],
 [3935,3936,3937,3941,3998,3999,4000,4004,4140,4144,4165,4169,
   46589,46642,47579,47603,49498,49798],[3938,4001],
 [3939,4002],[3940,3942,4003,4005],[3945,3946,4008,4009],
 [3947,4010],[3948,4011],[3949,4012],[3950,4013],
 [3951,4014],[3952,4015],[3953,4016],[3954,4017],
 [3955,4018],[3956,4019],[3957,4020],[3958,4021],
 [3959,4022],[3960,4023],[3961,4024],
 [4085,4086,4089,4142,4167],[4087,4091,48822],[4090,4092],
 [4093,4094],[4095,4096],[4112,4113],[4114,4118,49173],
 [4116,4117,4119,4237,4239],[4120,4121],[4122,4123],
 [4146,4147,4171,4172],[4148,4149,4173,4174],[4150,4175],
 [4151,4176],[4152,4177],[4153,4178],
 [4154,4161,4179,4186,4441],[4155,4180],[4156,4181],
 [4157,4182],[4158,4160,4183,4185,4470],[4159,4184],
 [4162,4187],[4163,4188],[4164,4189],[4191,4238,50119],
 [4195,4196,4281,4282,50162,50163],
 [4197,4198,4283,4284,50164,50165],[4199,4285,50166],
 [4200,4286,50167],[4201,4287,50168],[4202,4288,50169],
 [4203,4289,50170],[4204,4290,50171],[4205,4291,50172],
 [4206,4292,50173],[4207,4293,50174],[4208,4294,50175],
 [4209,4295,50176],[4210,4296,50177],[4211,4297,50178],
 [4212,4298,50179],[4213,4299,50180],[4218,4219],
 [4220,4221],[4240,4241],[4242,4243],[4261,4262,4300,4301],
 [4263,4264,4302,4303],[4265,4304],[4266,4305],[4267,4306],
 [4268,4276,4307,4315,4431],[4269,4308],[4270,4309],
 [4271,4310],[4272,4311],[4273,4312],
 [4274,4275,4313,4314,4475],[4277,4316],[4278,4317],
 [4279,4318],[4322,4339],[4323,4340],[4324,4341],
 [4325,4342],[4326,4343],[4327,4344],[4328,4345],
 [4329,4346],[4330,4347],[4331,4348],[4332,4349],
 [4333,4350],[4334,4351],[4335,4352],[4336,4353],
 [4355,4370],[4356,4371],[4357,4372],[4358,4373],
 [4359,4374],[4360,4375],[4361,4376],[4362,4377],
 [4363,4378],[4364,4379],[4365,4380],[4366,4381],
 [4367,4382],[4368,4383],[4369,4384],[4555,4556,4619],
 [4559,4561,4866,4997,4998],[4574,4576],[4575,4592,9801],
 [4577,4578],[4580,4581],[4582,4593],[4583,4584,4595,4597],
 [4585,4598],[4586,4599],[4587,4601,10248],[4588,4602],
 [4589,4603,10309],[4594,4600],[4611,4615],[4621,4622,4805],
 [4637,4639],[4638,4655,11754],[4640,4641],[4643,4644],
 [4645,4656],[4646,4647,4658,4660],[4648,4661],[4649,4662],
 [4650,4664,12201],[4651,4665],[4652,4666,12262],
 [4657,4663],[4672,4676],[4683,4686,4807,4994,4996],
 [4687,4688,5039],[4699,4701],[4700,4717,13645],
 [4702,4703],[4705,4706],[4707,4718],[4708,4722],
 [4709,4720],[4710,4723],[4711,4724],[4712,4726,14092],
 [4713,4727],[4714,4728,14153],[4719,4725],[4732,4738,6574],
 [4733,4737,6583],[4739,4740,6625],[4745,4746,4865],
 [4760,4762],[4761,4778,15475],[4763,4764],[4766,4767],
 [4768,4779],[4769,4783],[4770,4781],[4771,4784],
 [4772,4785],[4773,4787,15922],[4774,4788],
 [4775,4789,15983],[4780,4786],[4820,4822],
 [4821,4838,17245],[4823,4824],[4826,4827],[4828,4839],
 [4829,4830,4841,4843],[4831,4844],[4832,4845],
 [4833,4847,17692],[4834,4848],[4835,4849,17753],
 [4840,4846],[4860,4862],[4879,4881],[4880,4897,18956],
 [4882,4883],[4885,4886],[4887,4898],[4888,4902],
 [4889,4900],[4890,4903],[4891,4904],[4892,4906,19403],
 [4893,4907],[4894,4908,19464],[4899,4905],[4914,4922,6597],
 [4915,4923,6606],[4916,4921,6611],[4937,4939],
 [4938,4955,20609],[4940,4941],[4943,4944],[4945,4956],
 [4946,4960],[4947,4958],[4948,4961],[4949,4962],
 [4950,4964,21056],[4951,4965],[4952,4966,21117],
 [4957,4963],[4995,5012,22205],[5000,5001],[5002,5013],
 [5003,5017],[5004,5015],[5005,5018],[5006,5019],
 [5007,5021,22652],[5008,5022],[5009,5023,22713],
 [5014,5020],[5050,5052],[5051,5068,23745],[5053,5054],
 [5056,5057],[5058,5069],[5059,5073],[5060,5071],
 [5061,5074],[5062,5075],[5063,5077,24192],[5064,5078],
 [5065,5079,24253],[5070,5076],[5105,5107],
 [5106,5123,25230],[5108,5109],[5111,5112],[5113,5124],
 [5114,5128],[5115,5126],[5116,5129],[5117,5130],
 [5118,5132,25677],[5119,5133],[5120,5134,25738],
 [5125,5131],[5150,5151,5204],[5153,5154,5360],
 [5157,5158,5554],[5159,5161],[5160,5177,26661],
 [5162,5163],[5165,5166],[5167,5178],[5168,5182],
 [5169,5180],[5170,5183],[5171,5184],[5172,5186,27108],
 [5173,5187],[5174,5188,27169],[5179,5185],[5205,5206,5309],
 [5209,5210,5507],[5212,5214],[5213,5230,28039],
 [5215,5216],[5218,5219],[5220,5231],[5221,5235],
 [5222,5233],[5223,5236],[5224,5237],[5225,5239,28486],
 [5226,5240],[5227,5241,28547],[5232,5238],[5257,5259,5310],
 [5261,5263,5508],[5264,5266],[5265,5282,29365],
 [5267,5268],[5270,5271],[5272,5283],[5273,5287],
 [5274,5285],[5275,5288],[5276,5289],[5277,5291,29812],
 [5278,5292],[5279,5293,29873],[5284,5290],[5311,5312,5459],
 [5315,5317],[5316,5333,30640],[5318,5319],[5321,5322],
 [5323,5334],[5324,5338],[5325,5336],[5326,5339],
 [5327,5340],[5328,5342,31087],[5329,5343],
 [5330,5344,31148],[5335,5341],[5361,5363,5460],
 [5365,5367],[5366,5383,31865],[5368,5369],[5371,5372],
 [5373,5384],[5374,5388],[5375,5386],[5376,5389],
 [5377,5390],[5378,5392,32312],[5379,5393],
 [5380,5394,32373],[5385,5391],[5410,5413,5461],
 [5414,5416],[5415,5432,33041],[5417,5418],[5420,5421],
 [5422,5433],[5423,5437],[5424,5435],[5425,5438],
 [5426,5439],[5427,5441,33488],[5428,5442],
 [5429,5443,33549],[5434,5440],[5462,5464],
 [5463,5480,34169],[5465,5466],[5468,5469],[5470,5481],
 [5471,5485],[5472,5483],[5473,5486],[5474,5487],
 [5475,5489,34616],[5476,5490],[5477,5491,34677],
 [5482,5488],[5509,5511],[5510,5527,35250],[5512,5513],
 [5515,5516],[5517,5528],[5518,5532],[5519,5530],
 [5520,5533],[5521,5534],[5522,5536,35697],[5523,5537],
 [5524,5538,35758],[5529,5535],[5555,5557],
 [5556,5573,36285],[5558,5559],[5561,5562],[5563,5574],
 [5564,5578],[5565,5576],[5566,5579],[5567,5580],
 [5568,5582,36732],[5569,5583],[5570,5584,36793],
 [5575,5581],[5600,5602],[5601,5618,37275],[5603,5604],
 [5606,5607],[5608,5619],[5609,5623],[5610,5621],
 [5611,5624],[5612,5625],[5613,5627,37722],[5614,5628],
 [5615,5629,37783],[5620,5626],
 [5645,5646,5662,5689,5747,38221,38263,39166],
 [5650,5651,5735,5736],
 [5653,5654,5656,5665,5667,5669,5738,5739,5741,5750,5752,5754,
   6007,6020,6041,6054,6115,6117,6362,6405],
 [5655,5668,5740,5753],[5657,5671,5742,5756,38668,40432],
 [5658,5659,5672,5673,5743,5744,5757,5758,6170,6184,6212,6499,
   38728,38729,40464,40493,47913,48605],[5660,5745],
 [5661,5746],[5664,5670,5749,5755],[5666,5751],[5674,5759],
 [5675,5676,5760,5761,6544],[5677,5762],[5678,5763],
 [5679,5680,5764,5765,6590],[5681,5766],[5682,5767],
 [5683,5768],[5684,5769],[5685,5770],[5686,5771],
 [5687,5688,5772,5773,6634],
 [5690,5691,5774,5788,5828,39207,39247,40928],
 [5692,5867,39286],[5693,5694,5894,5905,5942,39324,39361,43266]
  ,[5695,5706,5978,5979,6284,39397,39398,39703],
 [5696,5697,5708,5710,6005,6013,6016,6047,6052,6286,6288,6360,
   39432,39435,39437,39466,39469,39471,39705,39707,45262,45265,
   45267,45503,45575,46062,46136,49520],
 [5698,5711,6080,6086,6289,39499,39505,39708],
 [5699,5712,6112,6119,6290,39531,39538,39709],
 [5700,5714,6143,6292,39562,39571,39711,47557],
 [5701,5715,6173,6293,39592,39712],
 [5702,5716,6202,6294,39621,39632,39713,48400],
 [5703,6230,39649],[5704,6257,39676],
 [5707,5713,6285,6291,39704,39710],[5709,6287,39706],
 [5717,6295,39714],[5718,6296,39715],[5719,6297,39716],
 [5720,6298,39717],[5721,6299,39718],[5722,6300,39719],
 [5723,6301,39720],[5724,6302,39721],[5725,6303,39722],
 [5726,6304,39723],[5727,6305,39724],[5728,6306,39725],
 [5729,6307,39726],[5730,6308,39727],[5731,6309,39728],
 [5776,5777,5816,5817],
 [5778,5779,5780,5789,5791,5793,5818,5819,5820,5829,5831,5833,
   5969,5970,5981,5983,6014,6048,6311,6313],
 [5781,5794,5821,5834],[5782,5795,5822,5835],
 [5783,5784,5797,5798,5823,5824,5837,5838,6139,6153,6182,6482,
   41252,41282,42032,42033,47447,47747],
 [5785,5799,5825,5839,41313,42093],[5786,5787,5826,5827,6229],
 [5790,5796,5830,5836],[5792,5832],[5800,5840],[5801,5841],
 [5802,5842],[5803,5804,5843,5844,6569],[5805,5845],
 [5806,5846],[5807,5847],[5808,5809,5848,5849,6614],
 [5810,5850],[5811,5851],[5812,5852],[5813,5853],
 [5814,5854],[5855,5856],
 [5857,5861,5868,5874,5972,5985,6113,6315],[5858,5872],
 [5859,5870],[5860,5873],
 [5862,5864,5876,5878,6140,6154,6211,6483,42773,42775,42832,
   42834,47476,47478,47748,48589],[5863,5877],[5869,5875],
 [5895,5906,5932,5943],
 [5896,5897,5898,5908,5910,5911,5933,5934,5935,5945,5947,5948,
   6006,6019,6040,6053,6083,6085,6361,6404],
 [5899,5912,5936,5949],[5900,5914,5937,5951,43476,44142],
 [5902,5916,5939,5953,43537,44203],[5903,5940],[5904,5941],
 [5907,5913,5944,5950],[5909,5946],[5917,5954],[5918,5955],
 [5919,5956],[5920,5957],[5921,5958],[5922,5959],
 [5923,5960],[5924,5961],[5925,5962],[5926,5963],
 [5927,5964],[5928,5965],[5929,5966],[5930,5967],
 [5931,5968],[5971,5984,6081,6314],
 [5973,5980,5986,5987,6144,6145,6151,6310,6316,6317,6341,6464,
   44771,44772,47582,47606,47729,49801],[5974,5988,6174,6318],
 [5975,5989,6203,6319,44833,48425],[5976,5982,6231,6234,6312],
 [5977,6258],[5990,6320],[5991,6321],[5992,6322],
 [5993,6323],[5994,6001,6324,6331,6586],[5995,6325],
 [5996,6326],[5997,6327],[5998,6000,6328,6330,6615],
 [5999,6329],[6002,6332],[6003,6333],[6004,6334],
 [6008,6022,6148,6407,45367,47672],[6009,6023,6178,6408],
 [6010,6024,6207,6409,45428,48515],[6011,6235],
 [6012,6017,6261,6262,6382],[6015,6021,6337,6406],
 [6025,6026,6410,6411,6530],[6027,6412],
 [6028,6036,6413,6421,6576],[6029,6414],
 [6030,6032,6415,6417,6591],[6031,6416],[6033,6418],
 [6034,6035,6419,6420,6620],[6037,6038,6422,6423,6632],
 [6039,6424],[6042,6056,6146,6364,45928,47629],
 [6043,6049,6055,6057,6175,6176,6181,6335,6342,6363,6365,6465],
 [6044,6058,6205,6366,45989,48472],[6045,6233],[6046,6260],
 [6051,6359],[6059,6367],[6060,6368],[6061,6369],
 [6062,6370],[6063,6371],[6064,6372],[6065,6373],
 [6066,6374],[6067,6375],[6068,6376],[6069,6377],
 [6070,6378],[6071,6379],[6072,6380],[6073,6381],
 [6074,6087,6118,6425],[6075,6089,6149,6427,46456,47692],
 [6076,6090,6179,6428],[6077,6091,6208,6429,46517,48535],
 [6078,6236],[6079,6263],[6084,6383],[6092,6430],
 [6093,6431],[6094,6432],[6095,6433],[6096,6434],
 [6097,6435],[6098,6436],[6099,6437],[6100,6438],
 [6101,6439],[6102,6440],[6103,6441],[6104,6442],
 [6105,6443],[6106,6444],[6107,6121,6150,6446,46952,47711],
 [6108,6122,6180,6447],
 [6109,6114,6120,6123,6204,6209,6210,6339,6343,6445,6448,6466,
   47010,47013,48449,48554,48572,50184],[6110,6237],
 [6111,6264],[6116,6384],[6124,6126,6449,6451,6531],
 [6125,6450],[6127,6452],[6128,6453],[6129,6454],
 [6130,6131,6455,6456,6599],[6132,6457],[6133,6458],
 [6134,6459],[6135,6460],[6136,6138,6461,6463,6633],
 [6137,6462],[6141,6239,47504],[6142,6266,47531],
 [6147,6386,47651],[6155,6484,47749],[6156,6485,47750],
 [6157,6486,47751],[6158,6487,47752],[6159,6488,47753],
 [6160,6489,47754],[6161,6490,47755],[6162,6491,47756],
 [6163,6492,47757],[6164,6493,47758],[6165,6494,47759],
 [6166,6495,47760],[6167,6496,47761],[6168,6497,47762],
 [6169,6498,47763],[6171,6240],[6172,6267],[6177,6387],
 [6185,6500],[6186,6501],[6187,6502],[6188,6503],
 [6189,6504],[6190,6505],[6191,6506],[6192,6507],
 [6193,6508],[6194,6509],[6195,6510],[6196,6511],
 [6197,6512],[6198,6513],[6199,6514],[6200,6241,48347],
 [6201,6268,48374],[6206,6388,48494],[6214,6515,48621],
 [6215,6516,48622],[6216,6517,48623],[6217,6518,48624],
 [6218,6519,48625],[6219,6520,48626],[6220,6521,48627],
 [6221,6522,48628],[6222,6523,48629],[6223,6524,48630],
 [6224,6525,48631],[6225,6526,48632],[6226,6527,48633],
 [6227,6528,48634],[6228,6529,48635],[6232,6238],
 [6259,6265],[6336,6385],[6344,6467],[6345,6468],
 [6346,6469],[6347,6470],[6348,6471],[6349,6472],
 [6350,6473],[6351,6474],[6352,6475],[6353,6476],
 [6354,6477],[6355,6478],[6356,6479],[6357,6480],
 [6358,6481],[6635,6636,6699],[6639,6641,6946],[6654,6655],
 [6656,6673,9844],[6657,6679],[6658,6677],[6659,6675],
 [6660,6683],[6661,6682,10048],[6662,6672],[6663,6666],
 [6665,6680,10184],[6667,6674],[6668,6669],[6678,6681],
 [6701,6702,6885],[6717,6718],[6719,6736,11797],
 [6720,6742],[6721,6740],[6722,6738],[6723,6746],
 [6724,6745,12001],[6725,6735],[6726,6729],
 [6728,6743,12137],[6730,6737],[6731,6732],[6741,6744],
 [6763,6766,6887],[6767,6768,7119],[6779,6780],
 [6781,6798,13688],[6782,6784,6800,6804],[6783,6802],
 [6785,6808],[6786,6807,13892],[6787,6797],[6788,6791],
 [6790,6805,14028],[6792,6799],[6793,6794],[6803,6806],
 [6810,6811],[6812,6818,8654],[6813,6817,6819,6820,8663,8705]
  ,[6814,6815],[6822,6823],[6825,6826,6945],[6840,6841],
 [6842,6859,15518],[6843,6865],[6844,6863,15599,15603,16083],
 [6845,6861],[6846,6869],[6847,6868,15722],[6848,6858],
 [6849,6852],[6851,6866,15858],[6853,6860],[6854,6855],
 [6864,6867],[6883,6884],[6900,6901],[6902,6919,17288],
 [6903,6925],[6904,6923],[6905,6921],[6906,6929],
 [6907,6928,17492],[6908,6918],[6909,6912],
 [6911,6926,17628],[6913,6920],[6914,6915],[6924,6927],
 [6959,6960],[6961,6978,18999],[6962,6964,6980,6984],
 [6963,6982],[6965,6988],[6966,6987,19203],[6967,6977],
 [6968,6971],[6970,6985,19339],[6972,6979],[6973,6974],
 [6975,6981],[6983,6986],[6993,7000],
 [6994,6995,7002,7003,8677,8686],[6996,7001,8691],
 [6997,6999],[7017,7018],[7019,7036,20652],[7020,7042],
 [7021,7040],[7022,7038],[7023,7046],[7024,7045,20856],
 [7025,7035],[7026,7029],[7028,7043,20992],[7030,7037],
 [7031,7032],[7041,7044],[7052,7053],[7074,7075,7078,7097],
 [7076,7093,22248],[7077,7099,22295],[7079,7095],
 [7080,7103],[7081,7102,22452],[7082,7083,7086,7092],
 [7085,7100,22588],[7087,7088,7089,7094],[7098,7101],
 [7130,7131],[7132,7149,23788],[7133,7155],[7134,7153],
 [7135,7151],[7136,7159],[7137,7158,23992],[7138,7148],
 [7139,7142,23778,23781,24047],[7141,7156,24128],[7143,7150],
 [7144,7145],[7154,7157],[7164,7171],[7185,7186],
 [7187,7204,25273],[7188,7210],[7189,7208],[7190,7206],
 [7191,7214],[7192,7213,25477],[7193,7203],[7194,7197],
 [7196,7211,25613],[7198,7205],[7199,7200],[7209,7212],
 [7223,7225],[7230,7231,7284],[7233,7234,7440],
 [7237,7238,7634],[7239,7240],[7241,7258,26704],
 [7242,7264],[7243,7262],[7244,7260],[7245,7268],
 [7246,7267,26908],[7247,7257],[7248,7251],
 [7250,7265,27044],[7252,7259],[7253,7254],[7263,7266],
 [7285,7286,7389],[7289,7290,7587],[7292,7293],
 [7294,7311,28082],[7295,7317],[7296,7315],[7297,7313],
 [7298,7321],[7299,7320,28286],[7300,7310],[7301,7304],
 [7303,7318,28422],[7305,7312],[7306,7307],[7316,7319],
 [7337,7339,7390],[7341,7343,7588],[7344,7345],
 [7346,7363,29408],[7347,7369],[7348,7367],[7349,7365],
 [7350,7373],[7351,7372,29612],[7352,7362],[7353,7356],
 [7355,7370,29748],[7357,7364],[7358,7359],[7360,7366],
 [7368,7371],[7375,7376],[7391,7392,7539],[7395,7396],
 [7397,7414,30683],[7398,7420],[7399,7418],[7400,7416],
 [7401,7424],[7402,7423,30887],[7403,7413],[7404,7407],
 [7406,7421,31023],[7408,7415],[7409,7410],[7419,7422],
 [7441,7443,7540],[7445,7446],[7447,7464,31908],
 [7448,7470],[7449,7468],[7450,7466],[7451,7474],
 [7452,7473,32112],[7453,7463],[7454,7457],
 [7456,7471,32248],[7458,7465],[7459,7460],[7461,7467],
 [7469,7472],[7476,7477],[7490,7493,7541],[7494,7495],
 [7496,7513,33084],[7497,7519],[7498,7517],[7499,7515],
 [7500,7523],[7501,7522,33288],[7502,7512],[7503,7506],
 [7505,7520,33424],[7507,7514],[7508,7509],[7518,7521],
 [7542,7543],[7544,7561,34212],[7545,7567],[7546,7565],
 [7547,7563],[7548,7571],[7549,7570,34416],[7550,7560],
 [7551,7554],[7553,7568,34552],[7555,7562],[7556,7557],
 [7566,7569],[7589,7590],[7591,7608,35293],[7592,7614],
 [7593,7612],[7594,7610],[7595,7618],[7596,7617,35497],
 [7597,7607],[7598,7601],[7600,7615,35633],[7602,7609],
 [7603,7604],[7605,7611],[7613,7616],[7620,7621],
 [7635,7636],[7637,7654,36328],[7638,7660],[7639,7658],
 [7640,7656],[7641,7664],[7642,7663,36532],[7643,7653],
 [7644,7647],[7646,7661,36668],[7648,7655],[7649,7650],
 [7659,7662],[7680,7681],[7682,7699,37318],[7683,7705],
 [7684,7703],[7685,7701],[7686,7709],[7687,7708,37522],
 [7688,7698],[7689,7692],[7691,7706,37658],[7693,7700],
 [7694,7695],[7696,7702],[7704,7707],[7711,7712],
 [7715,7716],[7718,7720],
 [7725,7726,7743,7769,7786,38222,38264,39167],
 [7727,7728,7729,7745,7747,7749,7770,7771,7772,7788,7790,7792,
   7854,7873,7895,7911,7915,7952,8440,8485],
 [7730,7731,7752,7753,7773,7774,7795,7796,7974,7995,8033,8579,
   38468,38469,39334,39371,43276,44489],
 [7733,7734,7736,7776,7777,7779,8085,8121],
 [7735,7750,7778,7793,38604,39507],[7737,7744,7780,7787],
 [7738,7739,7781,7782],[7740,7746,7783,7789],[7741,7784],
 [7748,7751,7791,7794],[7754,7797],[7755,7756,7798,7799],
 [7757,7800],[7758,7765,7801,7808],[7759,7760,7802,7803],
 [7761,7804],[7762,7764,7805,7807],[7763,7806],[7766,7809],
 [7767,7768,7810,7811],
 [7812,7814,7830,7834,7855,7869,7871,7948,7954,8391,8395,8442,
   40069,40071,40075,40148,40150,40154,40591,40595,40968,40970,
   40974,41415,41462,42932,42983,49822],
 [7813,7832,7909,7913,8393,40109,40113,40593],
 [7815,7838,7986,8399,40186,40599],
 [7816,7837,8023,8398,40223,40232,40598,44308],
 [7817,7827,8058,8059,8364,40258,40259,40564],
 [7818,7821,8087,8094,8193,40294,40393,45328],
 [7819,8128,40328],[7820,7835,8161,8396,40361,40368,40596,46620 
  ],[7822,7829,8224,8225,8390,40424,40425,40590],
 [7823,7824,8250,8254,8283,40454,40483,47903],
 [7825,7831,8311,8314,8392,40511,40514,40592],
 [7826,8338,40538],[7833,7836,8394,8397,40594,40597],
 [7839,8400,40600],[7840,7841,8401,8402,8624,40601,40602,50004]
  ,[7842,8403,40603],
 [7843,7850,8404,8411,8666,40604,40611,40866],
 [7844,7845,8405,8406,8670,40605,40606,50050],
 [7846,8407,40607],[7847,7849,8408,8410,8695,40608,40610,40895]
  ,[7848,8409,40609],[7851,8412,40612],
 [7852,7853,8413,8414,8714,40613,40614,50094],
 [7856,7879,7992,8528],[7857,7878,8029,8527,41052,44437],
 [7858,7859,7862,7868,7937,7938,7941,7947,8049,8052,8061,8065,
   8093,8096,8100,8192,8195,8199,8366,8370],[7860,8134],
 [7861,7876,8167,8525,41188,46749],
 [7863,7864,7865,7870,7942,7943,7944,7949,8219,8220,8226,8230,
   8255,8256,8260,8284,8285,8289,8415,8419],[7866,8317],
 [7867,7946,8340,8344],[7872,8464],[7874,7877,8505,8526],
 [7880,7959,8447,8529],[7881,8530],[7882,8531],
 [7883,7962,8450,8532],[7884,8533],[7885,8534],[7886,8535],
 [7887,7966,8454,8536],[7888,8537],[7889,7968,8456,8538],
 [7890,8539],[7891,8540],[7892,7971,8459,8541],[7893,8542],
 [7894,8543],[7896,7919,7990,8489],
 [7897,7914,7917,7918,8027,8028,8031,8484,8487,8488,8508,8562,
   41831,41832,44398,44418,44472,50858],
 [7898,7900,7908,8050,8063,8127,8132,8368],
 [7899,7902,8098,8197],[7901,7916,8165,8486,41968,46710],
 [7903,7910,8228,8417],[7904,7905,8258,8287],
 [7906,7907,7912,8309,8315,8341,8342,8462],[7920,8490],
 [7921,7922,8491,8492],
 [7923,7924,7931,8493,8494,8501,8649,8656],
 [7925,7926,8495,8496],[7927,8497],
 [7928,7929,7930,8498,8499,8500,8694,8700],[7932,8502],
 [7933,7934,8503,8504],
 [7935,7953,7956,7958,7988,7991,7994,8441,8444,8446,8509,8563],
 [7936,7957,8025,8445,42573,44355],[7939,8130],
 [7940,7955,8163,8443,42709,46667],[7945,8313],[7951,8439],
 [7960,8448],[7961,8449],[7963,8451],[7964,8452],
 [7965,8453],[7967,8455],[7969,8457],[7970,8458],
 [7972,8460],[7973,8461],[7975,7985,8069,8374],
 [7976,7978,7979,7993,8086,8101,8104,8154,8171,8200,8203,8546,
   43345,43412,45303,46424,46427,46770],[7977,8138],
 [7980,7987,8234,8423],[7983,8321],[7984,8348],[7989,8468],
 [7997,8595],[7998,8596],[7999,8597],[8000,8598],
 [8001,8599],[8002,8600],[8003,8601],[8004,8602],
 [8005,8603],[8006,8604],[8007,8605],[8008,8606],
 [8009,8607],[8010,8608],[8011,8609],
 [8012,8022,8068,8373,43978,44283],
 [8013,8016,8103,8202,44013,44112],
 [8014,8015,8030,8120,8135,8137,8170,8545,44045,44047,44078,
   44080,44455,45864,45866,46769],
 [8017,8024,8233,8422,44143,44332],
 [8018,8019,8263,8292,44173,44202],
 [8020,8026,8320,8467,44230,44377],[8021,8347,44257],
 [8034,8580,44490],[8035,8581,44491],[8036,8582,44492],
 [8037,8583,44493],[8038,8584,44494],[8039,8585,44495],
 [8040,8586,44496],[8041,8587,44497],[8042,8588,44498],
 [8043,8589,44499],[8044,8590,44500],[8045,8591,44501],
 [8046,8592,44502],[8047,8048,8593,8594,44503,44504],
 [8051,8064,8066,8067,8160,8166,8169,8369,8371,8372,8506,8544,
   44708,44709,46595,46730,46768,49586],[8053,8060,8223,8365],
 [8054,8055,8253,8282],[8056,8062,8310,8367],[8057,8337],
 [8070,8375],[8071,8072,8376,8377],[8073,8378],
 [8074,8081,8379,8386],[8075,8076,8380,8381],[8077,8382],
 [8078,8080,8383,8385],[8079,8384],[8082,8387],
 [8083,8084,8388,8389],[8088,8095,8187,8194],
 [8089,8090,8188,8189],[8091,8097,8190,8196],[8092,8191],
 [8099,8102,8198,8201],
 [8105,8106,8107,8204,8205,8206,8610,8611],[8108,8207],
 [8109,8116,8208,8215],
 [8110,8111,8112,8209,8210,8211,8671,8679],
 [8113,8115,8212,8214],[8114,8213],
 [8117,8118,8119,8216,8217,8218,8712,8713],[8122,8129],
 [8123,8124],[8133,8136],[8155,8162,8231,8420,46455,46644],
 [8156,8157,8261,8290,46485,46514],[8158,8318,46542],
 [8159,8345,46569],[8164,8465,46689],[8172,8547,46771],
 [8173,8174,8548,8549,46772,46773],[8175,8550,46774],
 [8176,8183,8551,8558,46775,46782],[8177,8552,46776],
 [8178,8553,46777],[8179,8554,46778],[8180,8555,46779],
 [8181,8556,46780],[8182,8557,46781],[8184,8559,46783],
 [8185,8560,46784],[8186,8561,46785],[8221,8227,8312,8416],
 [8222,8339],[8235,8424],[8236,8237,8425,8426],[8238,8427],
 [8239,8246,8428,8435],[8240,8241,8429,8430],[8242,8431],
 [8243,8245,8432,8434],[8244,8433],[8247,8436],
 [8248,8249,8437,8438],[8251,8257,8280,8286],[8252,8281],
 [8259,8262,8288,8291],[8265,8294],[8266,8267,8295,8296],
 [8268,8297],[8269,8276,8298,8305],[8270,8271,8299,8300],
 [8272,8301],[8273,8275,8302,8304],[8274,8303],[8277,8306],
 [8278,8279,8307,8308],[8316,8319],[8325,8472],[8331,8478],
 [8343,8346],[8353,8360],[8357,8359],[8463,8466],
 [8510,8564],[8511,8565],[8512,8566],[8513,8567],
 [8514,8568],[8515,8569],[8516,8570],[8517,8571],
 [8518,8572],[8519,8573],[8520,8574],[8521,8575],
 [8522,8576],[8523,8577],[8524,8578],[8614,8615],
 [8622,8623],[8629,8641],[8634,8646],[8653,8655],
 [8664,8701],[8676,8684],[8692,8693],[8716,8778,10731],
 [8719,8781,10734],[8721,8722,8783,8784,9135,10736,10737,11088]
  ,[8723,8785,10738],[8724,8786,10739],[8725,8787,10740],
 [8726,8788,10741],[8727,8789,10742],[8728,8790,10743],
 [8729,8791,10744],[8730,8792,10745],[8731,8793,10746],
 [8732,8794,10747],[8733,8795,10748],[8734,8796,10749],
 [8735,8797,10750],[8736,8798,10751],[8737,8799,10752],
 [8738,8800,10753],[8739,8801,10754],[8740,8802,10755],
 [8741,8803,10756],[8742,8804,10757],[8743,8805,10758],
 [8744,8806,10759],[8745,8807,10760],[8746,8808,10761],
 [8747,8809,10762],[8748,8810,10763],[8749,8811,10764],
 [8750,8812,10765],[8751,8813,10766],[8752,8814,10767],
 [8753,8815,10768],[8754,8816,10769],[8755,8817,10770],
 [8756,8818,10771],[8757,8819,10772],[8758,8820,10773],
 [8759,8821,10774],[8760,8822,10775],[8761,8823,10776],
 [8762,8824,10777],[8763,8825,10778],[8764,8826,10779],
 [8765,8827,10780],[8766,8772,8828,8834,10670,10781,10787,12623 
  ],[8767,8771,8829,8833,10679,10782,10786,12632],
 [8768,8830,10783],[8769,8831,10784],[8770,8832,10785],
 [8773,8774,8835,8836,10721,10788,10789,12674],
 [8775,8837,10790],[8776,8838,10791],[8777,8839,10792],
 [8841,8842,8843,8961,9020,14636,14694,18175],
 [8963,9078,18233],[8964,9079,18234],[8965,9080,18235],
 [8966,9081,18236],[8967,9082,18237],[8968,9083,18238],
 [8969,9084,18239],[8970,9085,18240],[8971,9086,18241],
 [8972,9087,18242],[8973,9088,18243],[8974,9089,18244],
 [8975,9090,18245],[8976,9091,18246],[8977,9092,18247],
 [8978,9093,18248],[8979,9094,18249],[8980,9095,18250],
 [8981,9096,18251],[8982,9097,18252],[8983,9098,18253],
 [8984,9099,18254],[8985,9100,18255],[8986,9101,18256],
 [8987,9102,18257],[8988,9103,18258],[8989,9104,18259],
 [8990,9105,18260],[8991,9106,18261],[8992,9107,18262],
 [8993,9108,18263],[8994,9109,18264],[8995,9110,18265],
 [8996,9111,18266],[8997,9112,18267],[8998,9113,18268],
 [8999,9114,18269],[9000,9115,18270],[9001,9116,18271],
 [9002,9117,18272],[9003,9118,18273],[9004,9119,18274],
 [9005,9120,18275],[9006,9121,18276],[9007,9122,18277],
 [9008,9123,18278],[9009,9124,18279],
 [9010,9018,9125,9133,10693,18280,18288,23097],
 [9011,9019,9126,9134,10702,18281,18289,23106],
 [9012,9017,9127,9132,10707,18282,18287,23111],
 [9013,9128,18283],[9014,9129,18284],[9015,9130,18285],
 [9016,9131,18286],[9246,9247,9300],[9249,9250,9456],
 [9253,9254,9650],[9301,9302,9405],[9305,9306,9603],
 [9353,9355,9406],[9357,9359,9604],[9407,9408,9555],
 [9457,9459,9556],[9506,9509,9557],[9741,9742,9785],
 [9744,9745,9911],[9750,9752,10137],[9763,9765,10501],
 [9768,9769,10595],[9786,9787,9870],[9789,9790,9990],
 [9792,9793,10101],[9804,9806,10456],[9828,9830,9871],
 [9834,9837,10103],[9839,9840,10266],[9846,9850,10458],
 [9856,9857,10640],[9860,9861,10686],[9868,9869,10730],
 [9874,9875,10065],[9879,9880,10235],[9885,9887,10407],
 [9914,9916,10066],[9922,9923,10325],[9925,9929,10409],
 [9933,9934,10578],[9939,9940,10665],[9944,9945,10710],
 [9953,9957,10068],[9958,9960,10236],[9964,9970,10411],
 [9972,9974,10579],[9992,9994,10102],[10004,10007,10457],
 [10030,10031,10136],[10043,10044,10500],[10074,10075,10380],
 [10082,10083,10560],[10109,10112,10382],[10121,10122,10626],
 [10126,10128,10687],[10133,10134,10728],[10143,10148,10384],
 [10151,10153,10561],[10176,10182,10385],[10208,10215,10386],
 [10216,10219,10562],[10220,10222,10627],[10226,10227,10695],
 [10232,10234,10729],[10240,10241,10406],[10271,10272,10431],
 [10300,10305,10435],[10327,10330,10408],[10357,10358,10478],
 [10420,10427,10682],[10424,10426,10711],[10509,10517,10672],
 [10515,10516,10716],
 [10793,10794,10795,10855,10914,14575,14576,16405],
 [10857,10916,16407],[10858,10917,16408],[10859,10918,16409],
 [10860,10919,16410],[10861,10920,16411],[10862,10921,16412],
 [10863,10922,16413],[10864,10923,16414],[10865,10924,16415],
 [10866,10925,16416],[10867,10926,16417],[10868,10927,16418],
 [10869,10928,16419],[10870,10929,16420],[10871,10930,16421],
 [10872,10931,16422],[10873,10932,16423],[10874,10933,16424],
 [10875,10934,16425],[10876,10935,16426],[10877,10936,16427],
 [10878,10937,16428],[10879,10938,16429],[10880,10939,16430],
 [10881,10940,16431],[10882,10941,16432],[10883,10942,16433],
 [10884,10943,16434],[10885,10944,16435],[10886,10945,16436],
 [10887,10946,16437],[10888,10947,16438],[10889,10948,16439],
 [10890,10949,16440],[10891,10950,16441],[10892,10951,16442],
 [10893,10952,16443],[10894,10953,16444],[10895,10954,16445],
 [10896,10955,16446],[10897,10956,16447],[10898,10957,16448],
 [10899,10958,16449],[10900,10959,16450],[10901,10960,16451],
 [10902,10961,16452],[10903,10962,16453],
 [10904,10912,10963,10971,12646,16454,16462,18137],
 [10905,10913,10964,10972,12655,16455,16463,18146],
 [10906,10911,10965,10970,12660,16456,16461,18151],
 [10907,10966,16457],[10908,10967,16458],[10909,10968,16459],
 [10910,10969,16460],[11199,11200,11253],[11202,11203,11409],
 [11206,11207,11603],[11254,11255,11358],[11258,11259,11556],
 [11306,11308,11359],[11310,11312,11557],[11360,11361,11508],
 [11410,11412,11509],[11459,11462,11510],[11694,11695,11738],
 [11697,11698,11864],[11703,11705,12090],[11716,11718,12454],
 [11721,11722,12548],[11739,11740,11823],[11742,11743,11943],
 [11745,11746,12054],[11757,11759,12409],[11781,11783,11824],
 [11787,11790,12056],[11792,11793,12219],[11799,11803,12411],
 [11809,11810,12593],[11813,11814,12639],[11821,11822,12683],
 [11827,11828,12018],[11832,11833,12188],[11838,11840,12360],
 [11867,11869,12019],[11875,11876,12278],[11878,11882,12362],
 [11886,11887,12531],[11892,11893,12618],[11897,11898,12663],
 [11906,11910,12021],[11911,11913,12189],[11917,11923,12364],
 [11925,11927,12532],[11945,11947,12055],[11957,11960,12410],
 [11983,11984,12089],[11996,11997,12453],[12027,12028,12333],
 [12035,12036,12513],[12062,12065,12335],[12074,12075,12579],
 [12079,12081,12640],[12086,12087,12681],[12096,12101,12337],
 [12104,12106,12514],[12129,12135,12338],[12161,12168,12339],
 [12169,12172,12515],[12173,12175,12580],[12179,12180,12648],
 [12185,12187,12682],[12193,12194,12359],[12224,12225,12384],
 [12253,12258,12388],[12280,12283,12361],[12310,12311,12431],
 [12373,12380,12635],[12377,12379,12664],[12462,12470,12625],
 [12468,12469,12669],[12684,12687,14577],[12685,12686,12805],
 [12688,12689,14809],[12733,12739,16344],[12734,12738,16353],
 [12740,12741,16395],[12746,12864,16464],
 [12748,12749,12922,12923,16522,16523,16579,21539],
 [12750,12924,16524],[12751,12925,16525],[12752,12926,16526],
 [12753,12927,16527],[12754,12928,16528],[12755,12929,16529],
 [12756,12930,16530],[12757,12931,16531],[12758,12932,16532],
 [12759,12933,16533],[12760,12934,16534],[12761,12935,16535],
 [12762,12936,16536],[12763,12937,16537],[12764,12938,16538],
 [12765,12939,16539],[12766,12940,16540],[12767,12941,16541],
 [12768,12942,16542],[12769,12943,16543],[12770,12944,16544],
 [12771,12945,16545],[12772,12946,16546],[12773,12947,16547],
 [12774,12948,16548],[12775,12949,16549],[12776,12950,16550],
 [12777,12951,16551],[12778,12952,16552],[12779,12953,16553],
 [12780,12954,16554],[12781,12955,16555],[12782,12956,16556],
 [12783,12957,16557],[12784,12958,16558],[12785,12959,16559],
 [12786,12960,16560],[12787,12961,16561],[12788,12962,16562],
 [12789,12963,16563],[12790,12964,16564],[12791,12965,16565],
 [12792,12966,16566],
 [12793,12799,12967,12973,16567,16573,18114,23074],
 [12794,12798,12968,12972,16568,16572,18123,23083],
 [12795,12969,16569],[12796,12970,16570],[12797,12971,16571],
 [12800,12801,12974,12975,16574,16575,18165,23125],
 [12802,12976,16576],[12803,12977,16577],[12804,12978,16578],
 [12807,12808,18290],[12836,19509],[12841,19083],
 [12849,13699],[12851,13967],[12852,12858,19825],
 [12853,12857,19834],[12854,12862,14537],[12855,12863,14546],
 [12856,12861,14551],[12859,12860,19876],[12865,12866,19943],
 [12910,12916,21478],[12911,12915,21487],[12917,12918,21529],
 [12980,13035,23135],[12981,13036,23136],[12982,13037,23137],
 [12983,13038,23138],[12984,13039,23139],[12985,13040,23140],
 [12986,13041,23141],[12987,13042,23142],[12988,13043,23143],
 [12989,13044,23144],[12990,13045,23145],[12991,13046,23146],
 [12992,13047,23147],[12993,13048,23148],[12994,13049,23149],
 [12995,13050,23150],[12996,13051,23151],[12997,13052,23152],
 [12998,13053,23153],[12999,13054,23154],[13000,13055,23155],
 [13001,13056,23156],[13002,13057,23157],[13003,13058,23158],
 [13004,13059,23159],[13005,13060,23160],[13006,13061,23161],
 [13007,13062,23162],[13008,13063,23163],[13009,13064,23164],
 [13010,13065,23165],[13011,13066,23166],[13012,13067,23167],
 [13013,13068,23168],[13014,13069,23169],[13015,13070,23170],
 [13016,13071,23171],[13017,13072,23172],[13018,13073,23173],
 [13019,13074,23174],[13020,13075,23175],[13021,13076,23176],
 [13022,13077,23177],
 [13023,13029,13078,13084,23178,23184,24614,26099],
 [13024,13028,13079,13083,23179,23183,24623,26108],
 [13025,13080,23180],[13026,13081,23181],[13027,13082,23182],
 [13030,13031,13085,13086,23185,23186,24665,26150],
 [13032,13087,23187],[13033,13088,23188],[13034,13089,23189],
 [13090,13091,13144],[13093,13094,13300],[13097,13098,13494],
 [13132,13138,27530],[13133,13137,27539],[13139,13140,27581],
 [13145,13146,13249],[13149,13150,13447],[13185,13191,28908],
 [13186,13190,28917],[13192,13193,28959],[13197,13199,13250],
 [13201,13203,13448],[13237,13243,30234],[13238,13242,30243],
 [13244,13245,30285],[13251,13252,13399],[13288,13294,31509],
 [13289,13293,31518],[13295,13296,31560],[13301,13303,13400],
 [13338,13344,32734],[13339,13343,32743],[13345,13346,32785],
 [13350,13353,13401],[13387,13393,33910],[13388,13392,33919],
 [13394,13395,33961],[13435,13441,35038],[13436,13440,35047],
 [13442,13443,35089],[13482,13488,36119],[13483,13487,36128],
 [13489,13490,36170],[13528,13534,37154],[13529,13533,37163],
 [13535,13536,37205],[13573,13579,38144],[13574,13578,38153],
 [13580,13581,38195],[13585,13586,13629],[13588,13589,13755],
 [13594,13596,13981],[13607,13609,14345],[13612,13613,14439],
 [13617,13623,39090],[13618,13622,39099],[13624,13625,39141],
 [13630,13631,13714],[13633,13634,13834],[13636,13637,13945],
 [13648,13650,14300],[13660,13666,39993],[13661,13665,40002],
 [13667,13668,40044],[13672,13674,13715],[13678,13681,13947],
 [13683,13684,14110],[13690,13694,14302],[13700,13701,14484],
 [13702,13708,40854],[13703,13707,40863],[13704,13705,14530],
 [13709,13710,40905],[13712,13713,14574],[13718,13719,13909],
 [13723,13724,14079],[13729,13731,14251],[13743,13749,41674],
 [13744,13748,41683],[13750,13751,41725],[13758,13760,13910],
 [13766,13767,14169],[13769,13773,14253],[13777,13778,14422],
 [13783,13784,13788,13789,14509,14513,14524,14554,42453,42454,
   42463,42464,52178,52179,52209,52254],[13790,13791,42505],
 [13797,13801,13912],[13802,13804,14080],[13808,13814,14255],
 [13816,13818,14423],[13822,13828,43195],[13823,13827,43204],
 [13829,13830,43246],[13836,13838,13946],[13848,13851,14301],
 [13860,13866,43898],[13861,13865,43907],[13867,13868,43949],
 [13874,13875,13980],[13881,42562],[13887,13888,14344],
 [13897,13903,44564],[13898,13902,44573],[13904,13905,44615],
 [13918,13919,14224],[13926,13927,14404],[13933,13939,45194],
 [13934,13938,45203],[13940,13941,45245],[13953,13956,14226],
 [13965,13966,14470],[13968,13974,45789],[13969,13973,45798],
 [13970,13972,14531],[13975,13976,45840],[13977,13978,14572],
 [13987,13992,14228],[13995,13997,14405],[14002,14008,46350],
 [14003,14007,46359],[14009,14010,46401],[14020,14026,14229],
 [14035,14041,46878],[14036,14040,46887],[14042,14043,46929],
 [14052,14059,14230],[14060,14063,14406],[14064,14066,14471],
 [14067,14073,47374],[14068,14072,47383],[14070,14071,14539],
 [14074,14075,47425],[14076,14078,14573],[14081,45917],
 [14084,14085,14250],[14098,14104,47839],[14099,14103,47848],
 [14105,14106,47890],[14115,14116,14275],[14128,14134,48274],
 [14129,14133,48283],[14135,14136,48325],[14144,14149,14279],
 [14157,14163,48680],[14158,14162,48689],[14164,14165,48731],
 [14171,14174,14252],[14179,48848],[14185,14191,49058],
 [14186,14190,49067],[14192,14193,49109],[14201,14202,14322],
 [14207,49200],[14212,14218,49409],[14213,14217,49418],
 [14219,14220,49460],[14238,14244,49734],[14239,14243,49743],
 [14245,14246,49785],[14263,14269,50034],
 [14264,14268,14270,14271,14525,14526,14555,14556,50043,50045,
   50076,50085,52255,52256,52265,52365],[14276,46112],
 [14287,14293,50310],[14288,14292,50319],[14294,14295,50361],
 [14310,14316,50563],[14311,14315,50572],[14317,14318,50614],
 [14323,43004],[14332,14338,50794],[14333,14337,50803],
 [14339,14340,50845],
 [14353,14359,14360,14361,14515,14516,14560,14561,51004,51005,
   51051,51055,52215,52216,52220,52375],[14354,14358,51013],
 [14373,14379,51194],[14374,14378,51203],[14380,14381,51245],
 [14392,14398,51365],[14393,14397,51374],[14399,14400,51416],
 [14410,14416,51518],[14411,14415,51527],[14417,14418,51569],
 [14427,14433,51654],[14428,14432,51663],[14434,14435,51705],
 [14443,14449,51774],[14444,14448,51783],[14450,14451,51825],
 [14458,14464,51879],[14459,14463,51888],[14465,14466,51930],
 [14472,14478,51970],[14473,14477,51979],[14479,14480,52021],
 [14485,14491,52048],[14486,14490,52057],[14492,14493,52099],
 [14497,14503,52114],[14498,14502,52123],[14504,14505,52165],
 [14510,14533,52188],[14511,14541,52196],[14512,14548,52203],
 [14517,14562,52217],[14518,14563,52218],[14519,14564,52219],
 [14520,14532,52232],[14521,14540,52240],[14522,14547,52247],
 [14527,14557,52257],[14528,14558,52258],[14529,14559,52259],
 [14534,14535,52301],[14542,14543,52329],[14549,14550,52350],
 [14566,14569,52385],[14567,14570,52386],[14568,14571,52387],
 [14637,14695,18176],[14638,14696,18177],[14639,14697,18178],
 [14640,14698,18179],[14641,14699,18180],[14642,14700,18181],
 [14643,14701,18182],[14644,14702,18183],[14645,14703,18184],
 [14646,14704,18185],[14647,14705,18186],[14648,14706,18187],
 [14649,14707,18188],[14650,14708,18189],[14651,14709,18190],
 [14652,14710,18191],[14653,14711,18192],[14654,14712,18193],
 [14655,14713,18194],[14656,14714,18195],[14657,14715,18196],
 [14658,14716,18197],[14659,14717,18198],[14660,14718,18199],
 [14661,14719,18200],[14662,14720,18201],[14663,14721,18202],
 [14664,14722,18203],[14665,14723,18204],[14666,14724,18205],
 [14667,14725,18206],[14668,14726,18207],[14669,14727,18208],
 [14670,14728,18209],[14671,14729,18210],[14672,14730,18211],
 [14673,14731,18212],[14674,14732,18213],[14675,14733,18214],
 [14676,14734,18215],[14677,14735,18216],[14678,14736,18217],
 [14679,14737,18218],[14680,14738,18219],[14681,14739,18220],
 [14682,14740,18221],[14683,14741,18222],
 [14684,14692,14742,14750,16367,18223,18231,21501],
 [14685,14693,14743,14751,16376,18224,18232,21510],
 [14686,14691,14744,14749,16381,18225,18230,21515],
 [14687,14745,18226],[14688,14746,18227],[14689,14747,18228],
 [14690,14748,18229],[14920,14921,14974],[14923,14924,15130],
 [14927,14928,15324],[14975,14976,15079],[14979,14980,15277],
 [15027,15029,15080],[15031,15033,15278],[15081,15082,15229],
 [15131,15133,15230],[15180,15183,15231],[15415,15416,15459],
 [15418,15419,15585],[15424,15426,15811],[15437,15439,16175],
 [15442,15443,16269],[15460,15461,15544],[15463,15464,15664],
 [15466,15467,15775],[15478,15480,16130],[15502,15504,15545],
 [15508,15511,15777],[15513,15514,15940],[15520,15524,16132],
 [15530,15531,16314],[15534,15535,16360],[15542,15543,16404],
 [15548,15549,15739],[15553,15554,15909],[15559,15561,16081],
 [15563,15642],[15564,15643],[15568,15647],
 [15588,15590,15740],[15596,15597,15999],[15607,15608,16252],
 [15613,15614,16339],[15618,15619,16384],[15627,15631,15742],
 [15632,15634,15910],[15638,15644,16085],[15646,15648,16253],
 [15666,15668,15776],[15678,15681,16131],[15704,15705,15810],
 [15717,15718,16174],[15748,15749,16054],[15756,15757,16234],
 [15783,15786,16056],[15785,15819],[15788,15887],
 [15789,15888],[15792,16134],[15793,15892],
 [15795,15796,16300],[15800,15802,16361],[15807,15808,16402],
 [15817,15822,16058],[15825,15827,16235],[15826,16177],
 [15850,15856,16059],[15882,15889,16060],[15890,15893,16236],
 [15891,16216],[15894,15896,16301],[15900,15901,16369],
 [15906,15908,16403],[15914,15915,16080],[15945,15946,16105],
 [15974,15979,16109],[16001,16004,16082],[16019,16020],
 [16031,16032,16152],[16042,16045],[16094,16101,16356],
 [16098,16100,16385],[16135,16217],[16164,16170],
 [16183,16191,16346],[16185,16186],[16189,16190,16390],
 [16193,16194],[16213,16214],[16690,16691,16744],
 [16693,16694,16900],[16697,16698,17094],[16745,16746,16849],
 [16749,16750,17047],[16797,16799,16850],[16801,16803,17048],
 [16851,16852,16999],[16901,16903,17000],[16950,16953,17001],
 [17185,17186,17229],[17188,17189,17355],[17194,17196,17581],
 [17207,17209,17945],[17212,17213,18039],[17230,17231,17314],
 [17233,17234,17434],[17236,17237,17545],[17248,17250,17900],
 [17272,17274,17315],[17278,17281,17547],[17283,17284,17710],
 [17290,17294,17902],[17300,17301,18084],[17304,17305,18130],
 [17312,17313,18174],[17318,17319,17509],[17323,17324,17679],
 [17329,17331,17851],[17358,17360,17510],[17366,17367,17769],
 [17369,17373,17853],[17377,17378,18022],[17383,17384,18109],
 [17388,17389,18154],[17397,17401,17512],[17402,17404,17680],
 [17408,17414,17855],[17416,17418,18023],[17436,17438,17546],
 [17448,17451,17901],[17474,17475,17580],[17487,17488,17944],
 [17518,17519,17824],[17526,17527,18004],[17553,17556,17826],
 [17565,17566,18070],[17570,17572,18131],[17577,17578,18172],
 [17587,17592,17828],[17595,17597,18005],[17620,17626,17829],
 [17652,17659,17830],[17660,17663,18006],[17664,17666,18071],
 [17670,17671,18139],[17676,17678,18173],[17684,17685,17850],
 [17715,17716,17875],[17744,17749,17879],[17771,17774,17852],
 [17801,17802,17922],[17864,17871,18126],[17868,17870,18155],
 [17953,17961,18116],[17959,17960,18160],[18336,18344,24637],
 [18337,18345,24646],[18338,18343,24651],[18391,18399,26122],
 [18392,18400,26131],[18393,18398,26136],[18401,18402,18455],
 [18404,18405,18611],[18408,18409,18805],[18445,18453,27553],
 [18446,18454,27562],[18447,18452,27567],[18456,18457,18560],
 [18460,18461,18758],[18498,18506,28931],[18499,18507,28940],
 [18500,18505,28945],[18508,18510,18561],[18512,18514,18759],
 [18550,18558,30257],[18551,18559,30266],[18552,18557,30271],
 [18562,18563,18710],[18601,18609,31532],[18602,18610,31541],
 [18603,18608,31546],[18612,18614,18711],[18651,18659,32757],
 [18652,18660,32766],[18653,18658,32771],[18661,18664,18712],
 [18700,18708,33933],[18701,18709,33942],[18702,18707,33947],
 [18748,18756,35061],[18749,18757,35070],[18750,18755,35075],
 [18795,18803,36142],[18796,18804,36151],[18797,18802,36156],
 [18841,18849,37177],[18842,18850,37186],[18843,18848,37191],
 [18886,18894,38167],[18887,18895,38176],[18888,18893,38181],
 [18896,18897,18940],[18899,18900,19066],[18905,18907,19292],
 [18918,18920,19656],[18923,18924,19750],[18930,18938,39113],
 [18931,18939,39122],[18932,18937,39127],[18941,18942,19025],
 [18944,18945,19145],[18947,18948,19256],[18959,18961,19611],
 [18973,18981,40016],[18974,18982,40025],[18975,18980,40030],
 [18983,18985,19026],[18989,18992,19258],[18994,18995,19421],
 [19001,19005,19613],[19011,19012,19795],
 [19015,19016,19023,19024,19841,19849,19856,19885,40877,40878,
   40885,40886,52281,52282,52310,52338],[19017,19022,40891],
 [19029,19030,19220],[19034,19035,19390],[19040,19042,19562],
 [19056,19064,41697],[19057,19065,41706],[19058,19063,41711],
 [19069,19071,19221],[19077,19078,19480],[19080,19084,19564],
 [19088,19089,19733],[19094,19095,19820],[19096,19104,42477],
 [19097,19105,42486],[19098,19103,42491],[19099,19100,19865],
 [19108,19112,19223],[19113,19115,19391],[19119,19125,19566],
 [19127,19129,19734],[19135,19143,43218],[19136,19144,43227],
 [19137,19142,43232],[19147,19149,19257],[19159,19162,19612],
 [19169,42539],[19173,19181,43921],[19174,19182,43930],
 [19175,19180,43935],[19185,19186,19291],[19198,19199,19655],
 [19210,19218,44587],[19211,19219,44596],[19212,19217,44601],
 [19229,19230,19535],[19237,19238,19715],[19246,19254,45217],
 [19247,19255,45226],[19248,19253,45231],[19264,19267,19537],
 [19276,19277,19781],
 [19281,19283,19288,19289,19842,19847,19863,19883,45811,45812,
   45826,45827,52287,52288,52308,52357],[19282,19290,45821],
 [19298,19303,19539],[19306,19308,19716],[19315,19323,46373],
 [19316,19324,46382],[19317,19322,46387],[19331,19337,19540],
 [19343,42713],[19348,19356,46901],[19349,19357,46910],
 [19350,19355,46915],[19363,19370,19541],[19371,19374,19717],
 [19375,19377,19782],[19380,19388,47397],
 [19381,19382,19387,19389,19850,19855,19864,19884,47404,47406,
   47411,47413,52315,52317,52337,52358],[19395,19396,19561],
 [19411,19419,47862],[19412,19420,47871],[19413,19418,47876],
 [19426,19427,19586],[19437,45962],[19441,19449,48297],
 [19442,19450,48306],[19443,19448,48311],[19455,19460,19590],
 [19467,45992],[19470,19478,48703],[19471,19479,48712],
 [19472,19477,48717],[19482,19485,19563],[19498,19506,49081],
 [19499,19507,49090],[19500,19505,49095],[19512,19513,19633],
 [19525,19533,49432],[19526,19534,49441],[19527,19532,49446],
 [19551,19559,49757],[19552,19560,49766],[19553,19558,49771],
 [19575,19582,19837],[19576,19584,50057],[19577,19585,50066],
 [19578,19583,50071],[19579,19581,19866],[19600,19608,50333],
 [19601,19609,50342],[19602,19607,50347],[19623,19631,50586],
 [19624,19632,50595],[19625,19630,50600],[19645,19653,50817],
 [19646,19654,50826],[19647,19652,50831],[19664,19672,19827],
 [19666,19674,51027],[19667,19675,51036],[19668,19673,51041],
 [19670,19671,19871],[19686,19694,51217],[19687,19695,51226],
 [19688,19693,51231],[19705,19713,51388],[19706,19714,51397],
 [19707,19712,51402],[19718,50456],[19723,19731,51541],
 [19724,19732,51550],[19725,19730,51555],[19740,19748,51677],
 [19741,19749,51686],[19742,19747,51691],[19756,19764,51797],
 [19757,19765,51806],[19758,19763,51811],[19768,50506],
 [19771,19779,51902],[19772,19780,51911],[19773,19778,51916],
 [19785,19793,51993],[19786,19794,52002],[19787,19792,52007],
 [19798,19806,52071],[19799,19807,52080],[19800,19805,52085],
 [19810,19818,52137],[19811,19819,52146],[19812,19817,52151],
 [19821,19829,52192],[19822,19830,52201],[19823,19828,52206],
 [19831,19839,52237],[19832,19840,52246],[19833,19838,52251],
 [19843,19869,52294],[19844,19874,52299],[19845,19878,52303],
 [19846,19881,52306],[19851,19870,52323],[19852,19875,52328],
 [19853,19879,52332],[19854,19882,52335],[19858,19868,52342],
 [19859,19873,52347],[19860,19877,52351],[19861,19880,52354],
 [20054,20055,20108],[20057,20058,20264],[20061,20062,20458],
 [20109,20110,20213],[20113,20114,20411],[20161,20163,20214],
 [20165,20167,20412],[20215,20216,20363],[20265,20267,20364],
 [20314,20317,20365],[20549,20550,20593],[20552,20553,20719],
 [20558,20560,20945],[20571,20573,21309],[20576,20577,21403],
 [20594,20595,20678],[20597,20598,20798],[20600,20601,20909],
 [20612,20614,21264],[20636,20638,20679],[20640,20760],
 [20642,20645,20911],[20647,20648,21074],[20654,20658,21266],
 [20656,21021],[20661,21351],[20664,20665,21448],
 [20668,20669,21494],[20676,20677,21538],[20682,20683,20873],
 [20687,20688,21043],[20693,20695,21215],[20697,20887],
 [20698,20923],[20702,21222],[20722,20724,20874],
 [20730,20731,21133],[20733,20737,21217],[20738,20957],
 [20741,20742,21386],[20747,20748,21473],[20752,20753,21518],
 [20761,20765,20876],[20766,20768,21044],[20772,20778,21219],
 [20777,21022],[20780,20782,21387],[20800,20802,20910],
 [20812,20815,21265],[20814,20989],[20819,21332],
 [20836,20837],[20838,20839,20944],[20847,20849],
 [20851,20852,21308],[20882,20883,21188],[20890,20891,21368],
 [20917,20920,21190],[20926,21025],[20927,21197],
 [20929,20930,21434],[20934,20936,21495],[20941,20942,21536],
 [20946,21011],[20951,20956,21192],[20959,20961,21369],
 [20984,20990,21193],[21016,21023,21194],[21024,21027,21370],
 [21028,21030,21435],[21034,21035,21503],[21040,21042,21537],
 [21048,21049,21214],[21052,21054],[21079,21080,21239],
 [21108,21113,21243],[21135,21138,21216],[21150,21160],
 [21165,21166,21286],[21182,21186],[21228,21235,21490],
 [21232,21234,21519],[21268,21350],[21303,21305],
 [21317,21325,21480],[21319,21321],[21323,21324,21524],
 [21326,21327],[21393,21394],[21650,21651,21704],
 [21653,21654,21860],[21657,21658,22054],[21705,21706,21809],
 [21709,21710,22007],[21757,21759,21810],[21761,21763,22008],
 [21811,21812,21959],[21861,21863,21960],[21910,21913,21961],
 [22145,22146,22189],[22148,22149,22315],[22154,22156,22541],
 [22167,22169,22905],[22172,22173,22999],[22190,22191,22274],
 [22193,22194,22394],[22196,22197,22505],[22208,22210,22860],
 [22232,22234,22275],[22238,22241,22507],[22243,22244,22670],
 [22250,22254,22862],[22260,22261,23044],[22264,22265,23090],
 [22272,22273,23134],[22278,22279,22469],[22283,22284,22639],
 [22289,22291,22811],[22318,22320,22470],[22326,22327,22729],
 [22329,22333,22813],[22337,22338,22982],[22343,22344,23069],
 [22348,22349,23114],[22357,22361,22472],[22362,22364,22640],
 [22368,22374,22815],[22376,22378,22983],[22396,22398,22506],
 [22408,22411,22861],[22434,22435,22540],[22447,22448,22904],
 [22478,22479,22784],[22486,22487,22964],[22513,22516,22786],
 [22525,22526,23030],[22530,22532,23091],[22537,22538,23132],
 [22547,22552,22788],[22555,22557,22965],[22580,22586,22789],
 [22612,22619,22790],[22620,22623,22966],[22624,22626,23031],
 [22630,22631,23099],[22636,22638,23133],[22644,22645,22810],
 [22675,22676,22835],[22704,22709,22839],[22731,22734,22812],
 [22761,22762,22882],[22824,22831,23086],[22828,22830,23115],
 [22913,22921,23076],[22919,22920,23120],[23190,23191,23244],
 [23193,23194,23400],[23197,23198,23594],[23245,23246,23349],
 [23249,23250,23547],[23297,23299,23350],[23301,23303,23548],
 [23351,23352,23499],[23401,23403,23500],[23450,23453,23501],
 [23685,23686,23729],[23688,23689,23855],[23694,23696,24081],
 [23707,23709,24445],[23712,23713,24539],[23730,23731,23814],
 [23733,23734,23934],[23736,23737,24045],[23748,23750,24400],
 [23772,23774,23815],[23783,23784,24210],[23790,23794,24402],
 [23800,23801,24584],[23804,23805,24630],[23812,23813,24674],
 [23818,23819,24009],[23821,24123],[23822,24155],
 [23823,23824,24179],[23829,23831,24351],[23839,24406],
 [23856,23895],[23858,23860,24010],[23861,24125],
 [23862,24157],[23865,24084],[23866,23867,24269],
 [23869,23873,24353],[23877,23878,24522],[23879,24449],
 [23883,23884,24609],[23888,23889,24654],[23897,23901,24012],
 [23900,24127],[23902,23904,24180],[23908,23914,24355],
 [23916,23918,24523],[23936,23938,24046],[23937,23939],
 [23948,23951,24401],[23950,23952],[23974,23975,24080],
 [23987,23988,24444],[24018,24019,24324],[24026,24027,24504],
 [24053,24056,24326],[24065,24066,24570],[24070,24072,24631],
 [24077,24078,24672],[24087,24092,24328],[24095,24097,24505],
 [24120,24126,24329],[24152,24159,24330],[24160,24163,24506],
 [24164,24166,24571],[24168,24175],[24170,24171,24639],
 [24172,24174],[24176,24178,24673],[24184,24185,24350],
 [24215,24216,24375],[24244,24249,24379],[24271,24274,24352],
 [24301,24302,24422],[24364,24371,24626],[24368,24370,24655],
 [24453,24461,24616],[24459,24460,24660],[24559,24566],
 [24579,24581],[24587,24591],[24602,24608],
 [24675,24676,24729],[24678,24679,24885],[24682,24683,25079],
 [24730,24731,24834],[24734,24735,25032],[24782,24784,24835],
 [24786,24788,25033],[24836,24837,24984],[24886,24888,24985],
 [24935,24938,24986],[25170,25171,25214],[25173,25174,25340],
 [25179,25181,25566],[25180,25346],[25192,25194,25930],
 [25197,25198,26024],[25215,25216,25299],[25218,25219,25419],
 [25221,25222,25530],[25224,25307],[25233,25235,25885],
 [25238,25361],[25257,25259,25300],[25263,25266,25532],
 [25265,25306],[25268,25269,25695],[25275,25279,25887],
 [25280,25400],[25285,25286,26069],[25289,25290,26115],
 [25297,25298,26159],[25303,25304,25494],[25308,25309,25664],
 [25314,25316,25836],[25324,25364],[25341,25435],
 [25343,25345,25495],[25351,25352,25754],[25354,25358,25838],
 [25362,25363,26007],[25368,25369,26094],[25373,25374,26139],
 [25380,25437],[25382,25386,25497],[25387,25389,25665],
 [25393,25399,25840],[25401,25403,26008],[25421,25423,25531],
 [25433,25436,25886],[25450,25452],[25459,25460,25565],
 [25472,25473,25929],[25503,25504,25809],[25511,25512,25989],
 [25538,25541,25811],[25549,25583],[25550,25551,26055],
 [25555,25557,26116],[25562,25563,26157],[25568,25703],
 [25572,25577,25813],[25580,25582,25990],[25605,25611,25814],
 [25606,25612],[25614,25616],[25633,25705],
 [25637,25644,25815],[25638,25642],[25645,25648,25991],
 [25646,25647],[25649,25651,26056],[25652,25653],
 [25655,25656,26124],[25657,25658],[25661,25663,26158],
 [25669,25670,25835],[25700,25701,25860],[25729,25734,25864],
 [25756,25759,25837],[25786,25787,25907],[25841,25888],
 [25849,25856,26111],[25853,25855,26140],[25891,25934],
 [25938,25946,26101],[25944,25945,26145],[26058,26061],
 [26078,26080],[26082,26085],
 [26161,26162,26163,26213,26214,26215,26265,26266,27591,27592,
   27593,27644,27694,28969,29020,30295],[26164,26216,27594],
 [26165,26166,26167,26217,26218,26219,26463,26464,27595,27596,
   27597,27842,27888,29167,29214,35099],[26168,26220,27598],
 [26169,26221,27599],[26170,26222,27600],[26171,26223,27601],
 [26172,26224,27602],[26173,26225,27603],[26174,26226,27604],
 [26175,26227,27605],[26176,26228,27606],[26177,26229,27607],
 [26178,26230,27608],[26179,26231,27609],[26180,26232,27610],
 [26181,26233,27611],[26182,26234,27612],[26183,26235,27613],
 [26184,26236,27614],[26185,26237,27615],[26186,26238,27616],
 [26187,26239,27617],[26188,26240,27618],[26189,26241,27619],
 [26190,26242,27620],[26191,26243,27621],[26192,26244,27622],
 [26193,26245,27623],[26194,26246,27624],[26195,26247,27625],
 [26196,26248,27626],[26197,26249,27627],[26198,26250,27628],
 [26199,26251,27629],[26200,26252,27630],[26201,26253,27631],
 [26202,26254,27632],[26203,26255,27633],[26204,26256,27634],
 [26205,26257,27635],[26206,26258,27636],[26207,26259,27637],
 [26208,26260,27638],[26209,26261,27639],[26210,26262,27640],
 [26211,26263,27641],[26212,26264,27642],[26267,26268,26415],
 [26269,26270,30489],
 [26317,26319,26320,26366,26368,26369,26416,26417,31570,31572,
   31573,31621,31714,32796,32890,34018],[26318,26367,31571],
 [26321,26370,31574],[26322,26371,31575],[26323,26372,31576],
 [26324,26373,31577],[26325,26374,31578],[26326,26375,31579],
 [26327,26376,31580],[26328,26377,31581],[26329,26378,31582],
 [26330,26379,31583],[26331,26380,31584],[26332,26381,31585],
 [26333,26382,31586],[26334,26383,31587],[26335,26384,31588],
 [26336,26385,31589],[26337,26386,31590],[26338,26387,31591],
 [26339,26388,31592],[26340,26389,31593],[26341,26390,31594],
 [26342,26391,31595],[26343,26392,31596],[26344,26393,31597],
 [26345,26394,31598],[26346,26395,31599],[26347,26396,31600],
 [26348,26397,31601],[26349,26398,31602],[26350,26399,31603],
 [26351,26400,31604],[26352,26401,31605],[26353,26402,31606],
 [26354,26403,31607],[26355,26404,31608],[26356,26405,31609],
 [26357,26406,31610],[26358,26407,31611],[26359,26408,31612],
 [26360,26409,31613],[26361,26410,31614],[26362,26411,31615],
 [26363,26412,31616],[26364,26413,31617],[26365,26414,31618],
 [26511,26556,36180],[26512,26557,36181],[26513,26558,36182],
 [26514,26559,36183],[26515,26560,36184],[26516,26561,36185],
 [26517,26562,36186],[26518,26563,36187],[26519,26564,36188],
 [26520,26565,36189],[26521,26566,36190],[26522,26567,36191],
 [26523,26568,36192],[26524,26569,36193],[26525,26570,36194],
 [26526,26571,36195],[26527,26572,36196],[26528,26573,36197],
 [26529,26574,36198],[26530,26575,36199],[26531,26576,36200],
 [26532,26577,36201],[26533,26578,36202],[26534,26579,36203],
 [26535,26580,36204],[26536,26581,36205],[26537,26582,36206],
 [26538,26583,36207],[26539,26584,36208],[26540,26585,36209],
 [26541,26586,36210],[26542,26587,36211],[26543,26588,36212],
 [26544,26589,36213],[26545,26590,36214],[26546,26591,36215],
 [26547,26592,36216],[26548,26593,36217],[26549,26594,36218],
 [26550,26595,36219],[26551,26596,36220],[26552,26597,36221],
 [26553,26598,36222],[26554,26599,36223],[26555,26600,36224],
 [26601,26602,26645],[26604,26605,26771],[26610,26612,26997],
 [26623,26625,27361],[26628,26629,27455],[26646,26647,26730],
 [26649,26650,26850],[26652,26653,26961],[26664,26666,27316],
 [26688,26690,26731],[26694,26697,26963],[26699,26700,27126],
 [26706,26710,27318],[26716,26717,27500],[26720,26721,27546],
 [26728,26729,27590],[26734,26735,26925],[26739,26740,27095],
 [26745,26747,27267],[26774,26776,26926],[26782,26783,27185],
 [26785,26789,27269],[26793,26794,27438],[26799,26800,27525],
 [26804,26805,27570],[26813,26817,26928],[26818,26820,27096],
 [26824,26830,27271],[26832,26834,27439],[26852,26854,26962],
 [26864,26867,27317],[26890,26891,26996],[26903,26904,27360],
 [26934,26935,27240],[26942,26943,27420],[26969,26972,27242],
 [26981,26982,27486],[26986,26988,27547],[26993,26994,27588],
 [27003,27008,27244],[27011,27013,27421],[27036,27042,27245],
 [27068,27075,27246],[27076,27079,27422],[27080,27082,27487],
 [27086,27087,27555],[27092,27094,27589],[27100,27101,27266],
 [27131,27132,27291],[27160,27165,27295],[27187,27190,27268],
 [27217,27218,27338],[27280,27287,27542],[27284,27286,27571],
 [27369,27377,27532],[27375,27376,27576],
 [27645,27646,27647,27695,27696,27697,27793,27794,30296,30297,
   30298,30395,30442,31619,31667,33971],[27648,27698,30299],
 [27649,27699,30300],[27650,27700,30301],[27651,27701,30302],
 [27652,27702,30303],[27653,27703,30304],[27654,27704,30305],
 [27655,27705,30306],[27656,27706,30307],[27657,27707,30308],
 [27658,27708,30309],[27659,27709,30310],[27660,27710,30311],
 [27661,27711,30312],[27662,27712,30313],[27663,27713,30314],
 [27664,27714,30315],[27665,27715,30316],[27666,27716,30317],
 [27667,27717,30318],[27668,27718,30319],[27669,27719,30320],
 [27670,27720,30321],[27671,27721,30322],[27672,27722,30323],
 [27673,27723,30324],[27674,27724,30325],[27675,27725,30326],
 [27676,27726,30327],[27677,27727,30328],[27678,27728,30329],
 [27679,27729,30330],[27680,27730,30331],[27681,27731,30332],
 [27682,27732,30333],[27683,27733,30334],[27684,27734,30335],
 [27685,27735,30336],[27686,27736,30337],[27687,27737,30338],
 [27688,27738,30339],[27689,27739,30340],[27690,27740,30341],
 [27691,27741,30342],[27692,27742,30343],[27693,27743,30344],
 [27744,27747,27795],[27745,27746,32843],[27843,27889,35100],
 [27844,27890,35101],[27845,27891,35102],[27846,27892,35103],
 [27847,27893,35104],[27848,27894,35105],[27849,27895,35106],
 [27850,27896,35107],[27851,27897,35108],[27852,27898,35109],
 [27853,27899,35110],[27854,27900,35111],[27855,27901,35112],
 [27856,27902,35113],[27857,27903,35114],[27858,27904,35115],
 [27859,27905,35116],[27860,27906,35117],[27861,27907,35118],
 [27862,27908,35119],[27863,27909,35120],[27864,27910,35121],
 [27865,27911,35122],[27866,27912,35123],[27867,27913,35124],
 [27868,27914,35125],[27869,27915,35126],[27870,27916,35127],
 [27871,27917,35128],[27872,27918,35129],[27873,27919,35130],
 [27874,27920,35131],[27875,27921,35132],[27876,27922,35133],
 [27877,27923,35134],[27878,27924,35135],[27879,27925,35136],
 [27880,27926,35137],[27881,27927,35138],[27882,27928,35139],
 [27883,27929,35140],[27884,27930,35141],[27885,27931,35142],
 [27886,27932,35143],[27887,27933,35144],[27979,27980,28023],
 [27982,27983,28149],[27988,27990,28375],[28001,28003,28739],
 [28006,28007,28833],[28024,28025,28108],[28027,28028,28228],
 [28030,28031,28339],[28042,28044,28694],[28066,28068,28109],
 [28072,28075,28341],[28077,28078,28504],[28084,28088,28696],
 [28094,28095,28878],[28098,28099,28924],[28106,28107,28968],
 [28112,28113,28303],[28117,28118,28473],[28123,28125,28645],
 [28152,28154,28304],[28160,28161,28563],[28163,28167,28647],
 [28171,28172,28816],[28177,28178,28903],[28182,28183,28948],
 [28191,28195,28306],[28196,28198,28474],[28202,28208,28649],
 [28210,28212,28817],[28230,28232,28340],[28242,28245,28695],
 [28268,28269,28374],[28281,28282,28738],[28312,28313,28618],
 [28320,28321,28798],[28347,28350,28620],[28359,28360,28864],
 [28364,28366,28925],[28371,28372,28966],[28381,28386,28622],
 [28389,28391,28799],[28414,28420,28623],[28446,28453,28624],
 [28454,28457,28800],[28458,28460,28865],[28464,28465,28933],
 [28470,28472,28967],[28478,28479,28644],[28509,28510,28669],
 [28538,28543,28673],[28565,28568,28646],[28595,28596,28716],
 [28658,28665,28920],[28662,28664,28949],[28747,28755,28910],
 [28753,28754,28954],
 [28971,28972,28974,29070,29071,29073,29119,29121,30345,30346,
   30348,30396,30443,32795,32844,33972],[28973,29072,30347],
 [28975,29074,30349],[28976,29075,30350],[28977,29076,30351],
 [28978,29077,30352],[28979,29078,30353],[28980,29079,30354],
 [28981,29080,30355],[28982,29081,30356],[28983,29082,30357],
 [28984,29083,30358],[28985,29084,30359],[28986,29085,30360],
 [28987,29086,30361],[28988,29087,30362],[28989,29088,30363],
 [28990,29089,30364],[28991,29090,30365],[28992,29091,30366],
 [28993,29092,30367],[28994,29093,30368],[28995,29094,30369],
 [28996,29095,30370],[28997,29096,30371],[28998,29097,30372],
 [28999,29098,30373],[29000,29099,30374],[29001,29100,30375],
 [29002,29101,30376],[29003,29102,30377],[29004,29103,30378],
 [29005,29104,30379],[29006,29105,30380],[29007,29106,30381],
 [29008,29107,30382],[29009,29108,30383],[29010,29109,30384],
 [29011,29110,30385],[29012,29111,30386],[29013,29112,30387],
 [29014,29113,30388],[29015,29114,30389],[29016,29115,30390],
 [29017,29116,30391],[29018,29117,30392],[29019,29118,30393],
 [29021,29023,29120],[29022,29024,31668],[29169,29260,35145],
 [29170,29261,35146],[29171,29262,35147],[29172,29263,35148],
 [29173,29264,35149],[29174,29265,35150],[29175,29266,35151],
 [29176,29267,35152],[29177,29268,35153],[29178,29269,35154],
 [29179,29270,35155],[29180,29271,35156],[29181,29272,35157],
 [29182,29273,35158],[29183,29274,35159],[29184,29275,35160],
 [29185,29276,35161],[29186,29277,35162],[29187,29278,35163],
 [29188,29279,35164],[29189,29280,35165],[29190,29281,35166],
 [29191,29282,35167],[29192,29283,35168],[29193,29284,35169],
 [29194,29285,35170],[29195,29286,35171],[29196,29287,35172],
 [29197,29288,35173],[29198,29289,35174],[29199,29290,35175],
 [29200,29291,35176],[29201,29292,35177],[29202,29293,35178],
 [29203,29294,35179],[29204,29295,35180],[29205,29296,35181],
 [29206,29297,35182],[29207,29298,35183],[29208,29299,35184],
 [29209,29300,35185],[29210,29301,35186],[29211,29302,35187],
 [29212,29303,35188],[29213,29304,35189],[29305,29306,29349],
 [29308,29309,29475],[29314,29316,29701],[29327,29329,30065],
 [29332,29333,30159],[29350,29351,29434],[29353,29354,29554],
 [29356,29357,29665],[29368,29370,30020],[29392,29394,29435],
 [29398,29401,29667],[29403,29404,29830],[29410,29414,30022],
 [29420,29421,30204],[29424,29425,30250],[29432,29433,30294],
 [29438,29439,29629],[29443,29444,29799],[29449,29451,29971],
 [29478,29480,29630],[29486,29487,29889],[29489,29493,29973],
 [29497,29498,30142],[29503,29504,30229],[29508,29509,30274],
 [29517,29521,29632],[29522,29524,29800],[29528,29534,29975],
 [29536,29538,30143],[29556,29558,29666],[29568,29571,30021],
 [29594,29595,29700],[29607,29608,30064],[29638,29639,29944],
 [29646,29647,30124],[29673,29676,29946],[29685,29686,30190],
 [29690,29692,30251],[29697,29698,30292],[29707,29712,29948],
 [29715,29717,30125],[29740,29746,29949],[29772,29779,29950],
 [29780,29783,30126],[29784,29786,30191],[29790,29791,30259],
 [29796,29798,30293],[29804,29805,29970],[29835,29836,29995],
 [29864,29869,29999],[29891,29894,29972],[29921,29922,30042],
 [29984,29991,30246],[29988,29990,30275],[30073,30081,30236],
 [30079,30080,30280],[30397,30444,33973],[30398,30445,33974],
 [30399,30446,33975],[30400,30447,33976],[30401,30448,33977],
 [30402,30449,33978],[30403,30450,33979],[30404,30451,33980],
 [30405,30452,33981],[30406,30453,33982],[30407,30454,33983],
 [30408,30455,33984],[30409,30456,33985],[30410,30457,33986],
 [30411,30458,33987],[30412,30459,33988],[30413,30460,33989],
 [30414,30461,33990],[30415,30462,33991],[30416,30463,33992],
 [30417,30464,33993],[30418,30465,33994],[30419,30466,33995],
 [30420,30467,33996],[30421,30468,33997],[30422,30469,33998],
 [30423,30470,33999],[30424,30471,34000],[30425,30472,34001],
 [30426,30473,34002],[30427,30474,34003],[30428,30475,34004],
 [30429,30476,34005],[30430,30477,34006],[30431,30478,34007],
 [30432,30479,34008],[30433,30480,34009],[30434,30481,34010],
 [30435,30482,34011],[30436,30483,34012],[30437,30484,34013],
 [30438,30485,34014],[30439,30486,34015],[30440,30487,34016],
 [30441,30488,34017],[30580,30581,30624],[30583,30584,30750],
 [30589,30591,30976],[30602,30604,31340],[30607,30608,31434],
 [30625,30626,30709],[30628,30629,30829],[30631,30632,30940],
 [30643,30645,31295],[30667,30669,30710],[30673,30676,30942],
 [30678,30679,31105],[30685,30689,31297],[30695,30696,31479],
 [30699,30700,31525],[30707,30708,31569],[30713,30714,30904],
 [30718,30719,31074],[30724,30726,31246],[30753,30755,30905],
 [30761,30762,31164],[30764,30768,31248],[30772,30773,31417],
 [30778,30779,31504],[30783,30784,31549],[30792,30796,30907],
 [30797,30799,31075],[30803,30809,31250],[30811,30813,31418],
 [30831,30833,30941],[30843,30846,31296],[30869,30870,30975],
 [30882,30883,31339],[30913,30914,31219],[30921,30922,31399],
 [30948,30951,31221],[30960,30961,31465],[30965,30967,31526],
 [30972,30973,31567],[30982,30987,31223],[30990,30992,31400],
 [31015,31021,31224],[31047,31054,31225],[31055,31058,31401],
 [31059,31061,31466],[31065,31066,31534],[31071,31073,31568],
 [31079,31080,31245],[31110,31111,31270],[31139,31144,31274],
 [31166,31169,31247],[31196,31197,31317],[31259,31266,31521],
 [31263,31265,31550],[31348,31356,31511],[31354,31355,31555],
 [31622,31715,34019],[31623,31716,34020],[31624,31717,34021],
 [31625,31718,34022],[31626,31719,34023],[31627,31720,34024],
 [31628,31721,34025],[31629,31722,34026],[31630,31723,34027],
 [31631,31724,34028],[31632,31725,34029],[31633,31726,34030],
 [31634,31727,34031],[31635,31728,34032],[31636,31729,34033],
 [31637,31730,34034],[31638,31731,34035],[31639,31732,34036],
 [31640,31733,34037],[31641,31734,34038],[31642,31735,34039],
 [31643,31736,34040],[31644,31737,34041],[31645,31738,34042],
 [31646,31739,34043],[31647,31740,34044],[31648,31741,34045],
 [31649,31742,34046],[31650,31743,34047],[31651,31744,34048],
 [31652,31745,34049],[31653,31746,34050],[31654,31747,34051],
 [31655,31748,34052],[31656,31749,34053],[31657,31750,34054],
 [31658,31751,34055],[31659,31752,34056],[31660,31753,34057],
 [31661,31754,34058],[31662,31755,34059],[31663,31756,34060],
 [31664,31757,34061],[31665,31758,34062],[31666,31759,34063],
 [31805,31806,31849],[31808,31809,31975],[31814,31816,32201],
 [31827,31829,32565],[31832,31833,32659],[31850,31851,31934],
 [31853,31854,32054],[31856,31857,32165],[31868,31870,32520],
 [31892,31894,31935],[31898,31901,32167],[31903,31904,32330],
 [31910,31914,32522],[31920,31921,32704],[31924,31925,32750],
 [31932,31933,32794],[31938,31939,32129],[31943,31944,32299],
 [31949,31951,32471],[31978,31980,32130],[31986,31987,32389],
 [31989,31993,32473],[31997,31998,32642],[32003,32004,32729],
 [32008,32009,32774],[32017,32021,32132],[32022,32024,32300],
 [32028,32034,32475],[32036,32038,32643],[32056,32058,32166],
 [32068,32071,32521],[32094,32095,32200],[32107,32108,32564],
 [32138,32139,32444],[32146,32147,32624],[32173,32176,32446],
 [32185,32186,32690],[32190,32192,32751],[32197,32198,32792],
 [32207,32212,32448],[32215,32217,32625],[32240,32246,32449],
 [32272,32279,32450],[32280,32283,32626],[32284,32286,32691],
 [32290,32291,32759],[32296,32298,32793],[32304,32305,32470],
 [32335,32336,32495],[32364,32369,32499],[32391,32394,32472],
 [32421,32422,32542],[32484,32491,32746],[32488,32490,32775],
 [32573,32581,32736],[32579,32580,32780],[32798,32936,34064],
 [32799,32937,34065],[32800,32938,34066],[32801,32939,34067],
 [32802,32940,34068],[32803,32941,34069],[32804,32942,34070],
 [32805,32943,34071],[32806,32944,34072],[32807,32945,34073],
 [32808,32946,34074],[32809,32947,34075],[32810,32948,34076],
 [32811,32949,34077],[32812,32950,34078],[32813,32951,34079],
 [32814,32952,34080],[32815,32953,34081],[32816,32954,34082],
 [32817,32955,34083],[32818,32956,34084],[32819,32957,34085],
 [32820,32958,34086],[32821,32959,34087],[32822,32960,34088],
 [32823,32961,34089],[32824,32962,34090],[32825,32963,34091],
 [32826,32964,34092],[32827,32965,34093],[32828,32966,34094],
 [32829,32967,34095],[32830,32968,34096],[32831,32969,34097],
 [32832,32970,34098],[32833,32971,34099],[32834,32972,34100],
 [32835,32973,34101],[32836,32974,34102],[32837,32975,34103],
 [32838,32976,34104],[32839,32977,34105],[32840,32978,34106],
 [32841,32979,34107],[32842,32980,34108],[32981,32982,33025],
 [32984,32985,33151],[32990,32992,33377],[33003,33005,33741],
 [33008,33009,33835],[33026,33027,33110],[33029,33030,33230],
 [33032,33033,33341],[33044,33046,33696],[33068,33070,33111],
 [33074,33077,33343],[33079,33080,33506],[33086,33090,33698],
 [33096,33097,33880],[33100,33101,33926],[33108,33109,33970],
 [33114,33115,33305],[33119,33120,33475],[33125,33127,33647],
 [33154,33156,33306],[33162,33163,33565],[33165,33169,33649],
 [33173,33174,33818],[33179,33180,33905],[33184,33185,33950],
 [33193,33197,33308],[33198,33200,33476],[33204,33210,33651],
 [33212,33214,33819],[33232,33234,33342],[33244,33247,33697],
 [33270,33271,33376],[33283,33284,33740],[33314,33315,33620],
 [33322,33323,33800],[33349,33352,33622],[33361,33362,33866],
 [33366,33368,33927],[33373,33374,33968],[33383,33388,33624],
 [33391,33393,33801],[33416,33422,33625],[33448,33455,33626],
 [33456,33459,33802],[33460,33462,33867],[33466,33467,33935],
 [33472,33474,33969],[33480,33481,33646],[33511,33512,33671],
 [33540,33545,33675],[33567,33570,33648],[33597,33598,33718],
 [33660,33667,33922],[33664,33666,33951],[33749,33757,33912],
 [33755,33756,33956],[34109,34110,34153],[34112,34113,34279],
 [34118,34120,34505],[34131,34133,34869],[34136,34137,34963],
 [34154,34155,34238],[34157,34158,34358],[34160,34161,34469],
 [34172,34174,34824],[34196,34198,34239],[34202,34205,34471],
 [34207,34208,34634],[34214,34218,34826],[34224,34225,35008],
 [34228,34229,35054],[34236,34237,35098],[34242,34243,34433],
 [34247,34248,34603],[34253,34255,34775],[34282,34284,34434],
 [34290,34291,34693],[34293,34297,34777],[34301,34302,34946],
 [34307,34308,35033],[34312,34313,35078],[34321,34325,34436],
 [34326,34328,34604],[34332,34338,34779],[34340,34342,34947],
 [34360,34362,34470],[34372,34375,34825],[34398,34399,34504],
 [34411,34412,34868],[34442,34443,34748],[34450,34451,34928],
 [34477,34480,34750],[34489,34490,34994],[34494,34496,35055],
 [34501,34502,35096],[34511,34516,34752],[34519,34521,34929],
 [34544,34550,34753],[34576,34583,34754],[34584,34587,34930],
 [34588,34590,34995],[34594,34595,35063],[34600,34602,35097],
 [34608,34609,34774],[34639,34640,34799],[34668,34673,34803],
 [34695,34698,34776],[34725,34726,34846],[34788,34795,35050],
 [34792,34794,35079],[34877,34885,35040],[34883,34884,35084],
 [35190,35191,35234],[35193,35194,35360],[35199,35201,35586],
 [35212,35214,35950],[35217,35218,36044],[35235,35236,35319],
 [35238,35239,35439],[35241,35242,35550],[35253,35255,35905],
 [35277,35279,35320],[35283,35286,35552],[35288,35289,35715],
 [35295,35299,35907],[35305,35306,36089],[35309,35310,36135],
 [35317,35318,36179],[35323,35324,35514],[35328,35329,35684],
 [35334,35336,35856],[35363,35365,35515],[35371,35372,35774],
 [35374,35378,35858],[35382,35383,36027],[35388,35389,36114],
 [35393,35394,36159],[35402,35406,35517],[35407,35409,35685],
 [35413,35419,35860],[35421,35423,36028],[35441,35443,35551],
 [35453,35456,35906],[35479,35480,35585],[35492,35493,35949],
 [35523,35524,35829],[35531,35532,36009],[35558,35561,35831],
 [35570,35571,36075],[35575,35577,36136],[35582,35583,36177],
 [35592,35597,35833],[35600,35602,36010],[35625,35631,35834],
 [35657,35664,35835],[35665,35668,36011],[35669,35671,36076],
 [35675,35676,36144],[35681,35683,36178],[35689,35690,35855],
 [35720,35721,35880],[35749,35754,35884],[35776,35779,35857],
 [35806,35807,35927],[35869,35876,36131],[35873,35875,36160],
 [35958,35966,36121],[35964,35965,36165],[36225,36226,36269],
 [36228,36229,36395],[36234,36236,36621],[36247,36249,36985],
 [36252,36253,37079],[36270,36271,36354],[36273,36274,36474],
 [36276,36277,36585],[36288,36290,36940],[36312,36314,36355],
 [36318,36321,36587],[36323,36324,36750],[36330,36334,36942],
 [36340,36341,37124],[36344,36345,37170],[36352,36353,37214],
 [36358,36359,36549],[36363,36364,36719],[36369,36371,36891],
 [36398,36400,36550],[36406,36407,36809],[36409,36413,36893],
 [36417,36418,37062],[36423,36424,37149],[36428,36429,37194],
 [36437,36441,36552],[36442,36444,36720],[36448,36454,36895],
 [36456,36458,37063],[36476,36478,36586],[36488,36491,36941],
 [36514,36515,36620],[36527,36528,36984],[36558,36559,36864],
 [36566,36567,37044],[36593,36596,36866],[36605,36606,37110],
 [36610,36612,37171],[36617,36618,37212],[36627,36632,36868],
 [36635,36637,37045],[36660,36666,36869],[36692,36699,36870],
 [36700,36703,37046],[36704,36706,37111],[36710,36711,37179],
 [36716,36718,37213],[36724,36725,36890],[36755,36756,36915],
 [36784,36789,36919],[36811,36814,36892],[36841,36842,36962],
 [36904,36911,37166],[36908,36910,37195],[36993,37001,37156],
 [36999,37000,37200],[37215,37216,37259],[37218,37219,37385],
 [37224,37226,37611],[37237,37239,37975],[37242,37243,38069],
 [37260,37261,37344],[37263,37264,37464],[37266,37267,37575],
 [37278,37280,37930],[37302,37304,37345],[37308,37311,37577],
 [37313,37314,37740],[37320,37324,37932],[37330,37331,38114],
 [37334,37335,38160],[37342,37343,38204],[37348,37349,37539],
 [37353,37354,37709],[37359,37361,37881],[37388,37390,37540],
 [37396,37397,37799],[37399,37403,37883],[37407,37408,38052],
 [37413,37414,38139],[37418,37419,38184],[37427,37431,37542],
 [37432,37434,37710],[37438,37444,37885],[37446,37448,38053],
 [37466,37468,37576],[37478,37481,37931],[37504,37505,37610],
 [37517,37518,37974],[37548,37549,37854],[37556,37557,38034],
 [37583,37586,37856],[37595,37596,38100],[37600,37602,38161],
 [37607,37608,38202],[37617,37622,37858],[37625,37627,38035],
 [37650,37656,37859],[37682,37689,37860],[37690,37693,38036],
 [37694,37696,38101],[37700,37701,38169],[37706,37708,38203],
 [37714,37715,37880],[37745,37746,37905],[37774,37779,37909],
 [37801,37804,37882],[37831,37832,37952],[37894,37901,38156],
 [37898,37900,38185],[37983,37991,38146],[37989,37990,38190],
 [38206,38207,38208,38248,38249,38250,38290,38291,39151,39152,
   39153,39194,39234,40054,40095,40915],
 [38209,38210,38251,38252,38410,39154,39155,40174],
 [38212,38213,38215,38254,38255,38257,38521,38523,39157,39158,
   39160,39426,39460,40285,40321,45256],[38214,38256,39159],
 [38216,38258,39161],
 [38217,38218,38259,38260,38686,39162,39163,39589],
 [38219,38261,39164],[38220,38262,39165],[38223,38265,39168],
 [38224,38226,38228,38266,38268,38270,38876,38878,39169,39171,
   39173,39781,39824,40640,40685,50394],[38225,38267,39170],
 [38227,38269,39172],[38229,38271,39174],[38230,38272,39175],
 [38231,38232,38273,38274,39176,39177,39918,40779],
 [38233,38275,39178],
 [38234,38235,38276,38277,39060,39179,39180,39963],
 [38236,38278,39181],[38237,38279,39182],
 [38238,38239,38280,38281,39106,39183,39184,40009],
 [38240,38282,39185],[38241,38283,39186],[38242,38284,39187],
 [38243,38285,39188],[38244,38286,39189],[38245,38287,39190],
 [38246,38247,38288,38289,39150,39191,39192,40053],
 [38296,38298,41141],[38299,38300,38655],[38305,38307,38827],
 [38309,38311,41505],[38314,38315,41599],[38332,38371,41735],
 [38333,38372,41736],[38335,38374,41738],[38337,38376,41740],
 [38339,38341,38378,38380,38656,41742,41744,42020],
 [38340,38379,41743],
 [38342,38343,38381,38382,38745,41745,41746,42850],
 [38344,38383,41747],
 [38345,38349,38351,38384,38388,38390,38829,38831,41748,41752,
   41754,42195,42285,42934,43026,49865],[38346,38385,41749],
 [38347,38386,41750],[38348,38387,41751],[38350,38389,41753],
 [38352,38391,41755],
 [38353,38354,38355,38392,38393,38394,38998,38999,41756,41757,
   41758,42363,42379,43103,43120,51579],[38356,38395,41759],
 [38357,38396,41760],[38358,38397,41761],
 [38359,38360,38398,38399,39085,41762,41763,43190],
 [38361,38400,41764],[38362,38401,41765],[38363,38402,41766],
 [38364,38365,38403,38404,39130,41767,41768,43235],
 [38366,38405,41769],[38367,38406,41770],[38368,38407,41771],
 [38369,38408,41772],[38370,38409,41773],[38412,38414,38522],
 [38413,38415,43365],[38424,38427,38877],[38426,38428,43729],
 [38431,38432,43823],
 [38450,38451,38452,38556,38590,44031,44064,45850],
 [38463,38464,38465,38920,38941,44395,44415,50855],
 [38529,38532,38802],[38534,38536,45620],[38539,38540,45714],
 [38541,38542,39046],[38546,38548,39107],[38553,38554,39148],
 [38558,38623,45883],[38559,38624,45884],[38560,38625,45885],
 [38561,38626,45886],[38562,38627,45887],
 [38563,38568,38570,38628,38633,38635,38804,38806,45888,45893,
   45895,46066,46181,47088,47205,49565],[38564,38629,45889],
 [38565,38630,45890],[38566,38631,45891],[38567,38632,45892],
 [38569,38634,45894],
 [38571,38573,38574,38636,38638,38639,38981,38982,45896,45898,
   45899,46242,46275,47265,47299,51443],[38572,38637,45897],
 [38575,38577,38640,38642,39047,45900,45902,46307],
 [38576,38641,45901],[38578,38643,45903],[38579,38644,45904],
 [38580,38645,45905],
 [38581,38582,38646,38647,39115,45906,45907,46375],
 [38583,38648,45908],[38584,38649,45909],[38585,38650,45910],
 [38586,38651,45911],
 [38587,38589,38652,38654,39149,45912,45914,46409],
 [38588,38653,45913],[38596,38602,38805],[38601,38603,46709],
 [38606,38607,46803],[38660,38661,38826],[38664,38666,47670],
 [38669,38670,47764],[38691,38692,38851],[38694,38696,48105],
 [38699,38700,48199],[38702,48248],
 [38720,38723,38725,38853,38855,48443,48511,50141],
 [38747,38750,38828],[38751,38753,48889],[38756,38757,48983],
 [38777,38778,38780,38898,38900,49219,49240,50625],
 [38783,38784,49334],[38809,38810,49659],[38834,38835,49959],
 [38840,38847,39102],[38844,38846,39131],[38858,38859,50235],
 [38881,38882,50488],[38899,50653],[38903,38904,50719],
 [38922,38961,50875],[38923,38962,50876],
 [38924,38925,38963,38964,50877,50878,50929,51290],
 [38926,38965,50879],[38927,38966,50880],[38928,38967,50881],
 [38929,38937,38968,38976,39092,50882,50890,51367],
 [38930,38969,50883],[38931,38970,50884],[38932,38971,50885],
 [38933,38972,50886],[38934,38973,50887],
 [38935,38936,38974,38975,39136,50888,50889,51411],
 [38938,38977,50891],[38939,38978,50892],[38940,38979,50893],
 [38944,38945,51119],[39016,39031,51715],[39017,39032,51716],
 [39018,39033,51717],[39019,39034,51718],[39020,39035,51719],
 [39021,39036,51720],[39022,39037,51721],[39023,39038,51722],
 [39024,39039,51723],[39025,39040,51724],[39026,39041,51725],
 [39027,39042,51726],[39028,39043,51727],[39029,39044,51728],
 [39030,39045,51729],
 [39195,39196,39235,39236,40916,40917,40994,41774],
 [39197,39198,39199,39237,39238,39239,39388,39389,40918,40919,
   40920,41070,41105,41849,41885,44625],[39200,39240,40921],
 [39201,39241,40922],
 [39202,39203,39242,39243,39558,40923,40924,42019],
 [39204,39244,40925],
 [39205,39206,39245,39246,39648,40926,40927,41329],
 [39208,39210,39212,39248,39250,39252,39730,39732,40929,40931,
   40933,41413,41460,42191,42240,49820],[39209,39249,40930],
 [39211,39251,40932],[39213,39253,40934],[39214,39254,40935],
 [39215,39255,40936],
 [39216,39217,39256,39257,39901,40937,40938,41582],
 [39218,39258,40939],[39219,39259,40940],[39220,39260,40941],
 [39221,39261,40942],
 [39222,39223,39262,39263,39988,40943,40944,41669],
 [39224,39264,40945],[39225,39265,40946],[39226,39266,40947],
 [39227,39228,39267,39268,40033,40948,40949,41714],
 [39229,39269,40950],[39230,39270,40951],[39231,39271,40952],
 [39232,39272,40953],[39233,39273,40954],[39274,39275,42515],
 [39276,39280,39391],[39277,39278,42626],[39281,39283,39559],
 [39287,39293,39734],[39289,39291,42981],[39295,39297,39902],
 [39314,39351,43256],
 [39315,39316,39317,39352,39353,39354,39425,39459,43257,43258,
   43259,43329,43364,43995,43996,45255],[39318,39355,43260],
 [39319,39356,43261],[39321,39358,43263],[39322,39359,43264],
 [39323,39360,43265],[39325,39362,43267],[39326,39363,43268],
 [39327,39329,39330,39364,39366,39367,39780,39823,43269,43271,
   43272,43684,43728,44350,44351,50393],[39328,39365,43270],
 [39331,39368,43273],[39332,39369,43274],[39333,39370,43275],
 [39335,39372,43277],[39336,39373,43278],[39337,39374,43279],
 [39338,39375,43280],[39339,39376,43281],[39340,39377,43282],
 [39341,39378,43283],[39342,39379,43284],[39343,39380,43285],
 [39344,39381,43286],[39345,39382,43287],[39346,39383,43288],
 [39347,39384,43289],[39348,39385,43290],[39349,39386,43291],
 [39350,39387,43292],[39400,39402,44980],[39405,39406,39883],
 [39427,39461,45257],[39428,39462,45258],[39429,39463,45259],
 [39430,39464,45260],[39431,39465,45261],[39433,39467,45263],
 [39434,39468,45264],[39436,39470,45266],[39438,39472,45268],
 [39439,39473,45269],
 [39440,39442,39474,39476,39884,45270,45272,45680],
 [39441,39475,45271],[39443,39477,45273],
 [39444,39445,39478,39479,39949,45274,45275,46306],
 [39446,39480,45276],[39447,39481,45277],[39448,39482,45278],
 [39449,39451,39483,39485,40010,45279,45281,46367],
 [39450,39484,45280],[39452,39486,45282],[39453,39487,45283],
 [39454,39488,45284],[39455,39489,45285],
 [39456,39457,39490,39491,40051,45286,45287,46408],
 [39458,39492,45288],[39502,39504,46664],[39534,39536,47160],
 [39539,39542,39885],[39543,39545,39950],[39549,39550,40018],
 [39555,39557,40052],[39563,39564,39729],[39565,39567,47625],
 [39594,39595,39597,39754,39756,48037,48060,50096],
 [39623,39628,39758],[39624,39626,48466],[39635,48665],
 [39650,39653,39731],[39652,39654,48844],[39658,48971],
 [39679,39680,39681,39778,39801,49194,49195,50371],
 [39743,39750,40005],[39747,39749,40034],[39782,39825,50395],
 [39783,39826,50396],[39784,39827,50397],[39785,39828,50398],
 [39786,39829,50399],[39787,39830,50400],[39788,39831,50401],
 [39789,39797,39832,39840,39995,50402,50410,50565],
 [39790,39833,50403],[39791,39834,50404],[39792,39835,50405],
 [39793,39836,50406],[39794,39837,50407],
 [39795,39796,39838,39839,40039,50408,50409,50609],
 [39798,39841,50411],[39799,39842,50412],[39800,39843,50413],
 [40056,40135,40955],[40057,40136,40956],
 [40058,40059,40062,40137,40138,40141,40249,40252,40957,40958,
   40961,41072,41107,42590,42628,44627],[40060,40139,40959],
 [40061,40140,40960],
 [40063,40064,40065,40142,40143,40144,40419,40420,40962,40963,
   40964,41240,41270,42760,42791,47435],[40066,40145,40965],
 [40067,40146,40966],[40068,40147,40967],[40070,40149,40969],
 [40072,40151,40971],[40073,40152,40972],[40074,40153,40973],
 [40076,40155,40975],
 [40077,40079,40156,40158,40763,40976,40978,41583],
 [40078,40157,40977],[40080,40159,40979],
 [40081,40082,40160,40161,40980,40981,41644,43165],
 [40083,40162,40982],[40084,40163,40983],
 [40085,40086,40164,40165,40984,40985,41690,43211],
 [40087,40166,40986],[40088,40167,40987],[40089,40168,40988],
 [40090,40169,40989],[40091,40170,40990],[40092,40171,40991],
 [40093,40094,40172,40173,40992,40993,41734,43255],
 [40098,40100,40250],[40099,40102,41887],[40104,40105,42050],
 [40106,40107,40509],[40111,40115,42242],[40117,40118,40762],
 [40121,40122,42424],[40123,40124,40849],[40125,40126,42470],
 [40128,40129,40894],[40133,40134,42514],
 [40176,40178,40179,40286,40354,43331,43398,45289],
 [40188,40191,40192,40641,40705,43686,43749,50414],
 [40198,40199,43868],[40202,40203,43914],[40210,40211,43958],
 [40213,40216,43997],[40214,40215,40320],[40218,40219,44160],
 [40225,40229,44352],[40227,40228,40684],[40235,40236,44534],
 [40239,40240,44580],[40247,40248,44624],[40254,40255,44790],
 [40261,40265,44982],[40266,40267,40744],[40271,40272,45164],
 [40275,40276,45210],[40283,40284,45254],[40288,40387,45322],
 [40289,40290,40388,40389,45323,45324,45385,46970],
 [40291,40390,45325],[40292,40391,45326],
 [40293,40296,40300,40392,40395,40399,40566,40570,45327,45330,
   45334,45505,45577,47086,47162,49522],[40295,40394,45329],
 [40297,40396,45331],[40298,40397,45332],[40299,40398,45333],
 [40301,40304,40400,40403,40746,45335,45338,45681],
 [40302,40401,45336],[40303,40402,45337],
 [40305,40306,40307,40404,40405,40406,40810,40811,45339,45340,
   45341,45746,45759,47330,47344,51940],[40308,40407,45342],
 [40309,40408,45343],
 [40310,40311,40312,40409,40410,40411,40871,40879,45344,45345,
   45346,45805,45814,47390,47391,52275],[40313,40412,45347],
 [40314,40413,45348],[40315,40414,45349],[40316,40415,45350],
 [40317,40318,40319,40416,40417,40418,40912,40913,45351,45352,
   45353,45848,45849,47432,47434,52394],[40323,40324,45946],
 [40327,40332,40568],[40330,40334,46138],[40335,40337,40745],
 [40340,40341,46320],[40344,40345,46366],[40352,40353,46410],
 [40356,40357,46474],[40360,40366,40569],[40363,40367,46666],
 [40372,46838],[40373,40374,46848],[40377,40378,46894],
 [40385,40386,46938],[40426,40430,47627],[40436,40437,47809],
 [40440,40441,47855],[40448,40449,47899],[40451,40480,47900],
 [40452,40481,47901],[40453,40482,47902],
 [40455,40456,40460,40484,40485,40489,40615,40619,47904,47905,
   47909,48039,48062,48441,48468,50098],[40457,40486,47906],
 [40458,40487,47907],[40459,40488,47908],[40461,40490,47910],
 [40462,40491,47911],[40463,40492,47912],[40465,40494,47914],
 [40466,40467,40495,40496,47915,47916,48244,48650],
 [40468,40497,47917],[40469,40498,47918],
 [40470,40471,40499,40500,47919,47920,48290,48696],
 [40472,40501,47921],[40473,40502,47922],[40474,40503,47923],
 [40475,40504,47924],[40476,40505,47925],[40477,40506,47926],
 [40478,40479,40507,40508,47927,47928,48334,48740],
 [40513,40517,48846],[40523,40524,49028],[40527,40528,49074],
 [40535,40536,49118],[40540,40544,49197],[40541,40542,40662],
 [40550,40551,49379],[40554,40555,49425],[40562,40563,49469],
 [40576,40577,49704],[40580,40581,49750],[40588,40589,49794],
 [40625,40626,50280],[40629,40630,50326],[40637,40638,50370],
 [40639,40664,50373],[40643,40725,50434],[40644,40726,50435],
 [40645,40727,50436],[40646,40728,50437],[40647,40729,50438],
 [40648,40649,40730,40731,50439,50440,50533,51335],
 [40650,40732,50441],[40651,40733,50442],
 [40652,40653,40734,40735,50443,50444,50579,51381],
 [40654,40736,50445],[40655,40737,50446],[40656,40738,50447],
 [40657,40739,50448],[40658,40740,50449],[40659,40741,50450],
 [40660,40661,40742,40743,50451,50452,50623,51425],
 [40670,40671,50764],[40674,40675,50810],[40682,40683,50854],
 [40691,40692,50974],[40693,40701,40856],[40695,40696,51020],
 [40699,40700,40900],[40703,40704,51064],[40711,40712,51164],
 [40715,40716,51210],[40723,40724,51254],[40747,51479],
 [40748,40749,51488],[40752,40753,51534],[40760,40761,51578],
 [40765,40766,51624],[40769,40770,51670],[40777,40778,51714],
 [40781,40782,51744],[40785,40786,51790],[40793,40794,51834],
 [40796,40797,51849],[40800,40801,51895],[40808,40809,51939],
 [40814,40815,51986],[40822,40823,52030],[40825,40837,52031],
 [40826,40838,52032],
 [40827,40828,40839,40840,52033,52034,52064,52130],
 [40829,40841,52035],[40830,40842,52036],[40831,40843,52037],
 [40832,40844,52038],[40833,40845,52039],[40834,40846,52040],
 [40835,40836,40847,40848,52041,52042,52108,52174],
 [40850,40851,52185],[40858,40859,52229],[40860,40861,52230],
 [40868,40869,52274],[40872,40880,52276],[40873,40881,52277],
 [40874,40882,52278],[40875,40883,52279],[40876,40884,52280],
 [40892,40893,52359],[40898,40899,52374],[40903,40904,52384],
 [40907,40908,52390],[40910,40911,52393],
 [40995,40996,40998,41071,41106,43293,43295,44626],
 [41006,41008,41011,41414,41461,43635,43638,49821],
 [41032,41033,43959],[41034,41035,41140],[41037,41038,44129],
 [41043,41045,44301],[41047,41048,41504],
 [41073,41074,41108,41109,44628,44629,44759,45354],
 [41075,41110,44630],[41076,41111,44631],[41077,41112,44632],
 [41078,41079,41081,41113,41114,41116,41384,41386,44633,44634,
   44636,44906,44931,45499,45526,49471],[41080,41115,44635],
 [41082,41117,44637],[41083,41118,44638],[41084,41119,44639],
 [41085,41120,44640],
 [41086,41087,41121,41122,41564,44641,44642,45679],
 [41088,41123,44643],[41089,41124,44644],
 [41090,41091,41125,41126,41630,44645,44646,45150],
 [41092,41127,44647],[41093,41128,44648],[41094,41129,44649],
 [41095,41097,41130,41132,41691,44650,44652,45211],
 [41096,41131,44651],[41098,41133,44653],[41099,41134,44654],
 [41100,41135,44655],[41101,41136,44656],
 [41102,41103,41137,41138,41732,44657,44658,45252],
 [41104,41139,44659],[41142,41143,45915],[41147,41152,41388],
 [41148,41150,46087],[41155,41157,41565],[41175,41176,46443],
 [41180,41186,41389],[41181,41183,46615],[41192,46846],
 [41207,41208,46939],[41212,41219,41390],[41213,41215,47111],
 [41220,41223,41566],[41224,41226,41631],[41230,41231,41699],
 [41236,41238,41733],[41241,41271,47436],[41242,41272,47437],
 [41243,41273,47438],
 [41244,41245,41246,41274,41275,41276,41410,41435,47439,47440,
   47441,47576,47600,48010,48011,49795],[41247,41277,47442],
 [41248,41278,47443],[41249,41279,47444],[41250,41280,47445],
 [41251,41281,47446],[41253,41283,47448],[41254,41284,47449],
 [41255,41285,47450],[41256,41286,47451],[41257,41287,47452],
 [41258,41288,47453],[41259,41289,47454],[41260,41290,47455],
 [41261,41291,47456],[41262,41292,47457],[41263,41293,47458],
 [41264,41294,47459],[41265,41295,47460],[41266,41296,47461],
 [41267,41297,47462],[41268,41298,47463],[41269,41299,47464],
 [41303,41305,48417],[41304,41309,41439],
 [41331,41333,41334,41412,41459,48795,48843,49819],
 [41358,41360,49146],[41361,41362,41482],[41367,49339],
 [41416,41463,49823],[41417,41464,49824],[41418,41465,49825],
 [41419,41466,49826],[41420,41467,49827],[41421,41468,49828],
 [41422,41469,49829],[41423,41470,49830],
 [41424,41431,41471,41478,41686,49831,49838,50575],
 [41425,41472,49832],[41426,41473,49833],[41427,41474,49834],
 [41428,41430,41475,41477,41715,49835,49837,50604],
 [41429,41476,49836],[41432,41479,49839],[41433,41480,49840],
 [41434,41481,49841],[41513,41521,41676],[41519,41520,41720],
 [41775,41777,43294],[41776,41778,41886],[41783,41784,43553],
 [41786,41790,43637],[41788,41791,42241],[41794,41795,43806],
 [41800,41801,43893],[41805,41806,43938],
 [41812,41814,41815,41851,41920,43960,43961,44660],
 [41820,41821,44219],
 [41823,41827,41828,42194,42284,44303,44304,49864],
 [41837,41838,44559],[41842,41843,44604],[41853,41922,44662],
 [41854,41923,44663],[41855,41924,44664],
 [41856,41857,41925,41926,44665,44666,44849,46005],
 [41858,41859,41863,41927,41928,41932,42164,42168,44667,44668,
   44672,44908,44933,46060,46089,49473],[41860,41929,44669],
 [41861,41930,44670],[41862,41931,44671],[41864,41933,44673],
 [41865,41934,44674],
 [41866,41867,41868,41935,41936,41937,42344,42345,44675,44676,
   44677,45085,45102,46240,46258,51426],[41869,41938,44678],
 [41870,41939,44679],[41871,41940,44680],[41872,41941,44681],
 [41873,41874,41942,41943,44682,44683,45189,46345],
 [41875,41944,44684],[41876,41945,44685],[41877,41946,44686],
 [41878,41879,41947,41948,44687,44688,45234,46390],
 [41880,41949,44689],[41881,41950,44690],[41882,41951,44691],
 [41883,41952,44692],[41884,41953,44693],[41891,41892,45444],
 [41893,41896,42166],[41894,41898,45528],[41902,41903,45697],
 [41905,41906,42410],[41908,41909,45784],[41910,41912,42471],
 [41913,41914,45829],[41917,41918,42512],[41958,41959,46533],
 [41960,41966,42169],[41961,41965,46617],[41969,41970,46786],
 [41975,41976,46873],[41980,41981,46918],[41990,41991,47029],
 [41992,41999,42170],[41993,41997,47113],[42000,42003,42346],
 [42001,42002,47282],[42004,42006,42411],[42007,42008,47369],
 [42010,42011,42479],[42012,42013,47414],[42016,42018,42513],
 [42021,42022,47494],
 [42024,42025,42028,42190,42217,47578,47602,49797],
 [42038,42039,47834],[42043,42044,47879],[42051,42052,47929],
 [42054,42058,48013],[42055,42056,42215],[42062,42063,48182],
 [42068,42069,48269],[42073,42074,48314],[42080,42081,48335],
 [42083,42087,48419],[42084,42089,42219],[42091,42092,48588],
 [42097,42098,48675],[42102,42103,48720],[42110,42137,48741],
 [42111,42114,42115,42138,42141,42142,42192,42262,48742,48745,
   48746,48797,48866,49147,49148,49842],[42112,42139,48743],
 [42113,42140,48744],[42116,42143,48747],[42117,42144,48748],
 [42118,42145,48749],
 [42119,42120,42146,42147,48750,48751,48966,49317],
 [42121,42148,48752],[42122,42149,48753],[42123,42150,48754],
 [42124,42151,48755],
 [42125,42126,42152,42153,48756,48757,49053,49404],
 [42127,42154,48758],[42128,42155,48759],[42129,42156,48760],
 [42130,42131,42157,42158,48761,48762,49098,49449],
 [42132,42159,48763],[42133,42160,48764],[42134,42161,48765],
 [42135,42162,48766],[42136,42163,48767],[42172,42173,49642],
 [42178,42179,49729],[42183,42184,49774],[42196,42286,49866],
 [42197,42198,42287,42288,49867,49868,49942,50912],
 [42199,42289,49869],[42200,42290,49870],[42201,42291,49871],
 [42202,42292,49872],
 [42203,42204,42211,42293,42294,42301,42456,42466,49873,49874,
   49881,50029,50036,50999,51016,52181],[42205,42295,49875],
 [42206,42296,49876],[42207,42297,49877],
 [42208,42209,42210,42298,42299,42300,42495,42500,49878,49879,
   49880,50074,50080,51044,51045,52360],[42212,42302,49882],
 [42213,42303,49883],[42214,42304,49884],[42216,50129],
 [42221,42222,50218],[42227,42228,50305],[42232,42233,50350],
 [42244,42245,50471],[42250,42251,50558],[42255,42256,50603],
 [42263,50659],[42266,42267,50702],[42272,42273,50789],
 [42277,42278,50834],[42307,42308,51102],[42313,42314,51189],
 [42318,42319,51234],[42326,42327,51273],[42332,42333,51360],
 [42337,42338,51405],[42350,42351,51513],[42355,42356,51558],
 [42364,42380,51580],[42365,42381,51581],[42366,42382,51582],
 [42367,42368,42383,42384,51583,51584,51649,51769],
 [42369,42385,51585],[42370,42386,51586],[42371,42387,51587],
 [42372,42373,42388,42389,51588,51589,51694,51814],
 [42374,42390,51590],[42375,42391,51591],[42376,42392,51592],
 [42377,42393,51593],[42378,42394,51594],[42398,42399,51874],
 [42403,42404,51919],[42412,42413,51965],[42417,42418,52010],
 [42425,42426,52043],[42430,42431,52088],[42437,42438,52109],
 [42442,42443,52154],[42450,42460,52175],[42451,42461,52176],
 [42452,42462,52177],[42455,42465,52180],[42457,42467,52182],
 [42458,42468,52183],[42459,42469,52184],[42472,42473,52290],
 [42480,42481,52318],[42487,42488,52339],[42496,42501,52361],
 [42497,42502,52362],[42498,42503,52363],[42499,42504,52364],
 [42516,42520,43296],[42517,42519,42627],[42521,42523,43464],
 [42527,42533,43639],[42529,42532,42982],[42535,42537,43807],
 [42553,42557,43962],[42555,42556,42661],[42558,42560,44130],
 [42564,42570,44305],[42568,42569,43025],[42572,42574,44473],
 [42592,42695,44694],
 [42594,42596,42728,42730,44727,44729,44760,46940],
 [42595,42729,44728],[42597,42731,44730],[42598,42732,44731],
 [42599,42600,42606,42733,42734,42740,42905,42911,44732,44733,
   44739,44910,44935,47084,47115,49475],[42601,42735,44734],
 [42602,42736,44735],[42603,42737,44736],[42604,42738,44737],
 [42605,42739,44738],
 [42607,42608,42610,42741,42742,42744,43085,43087,44740,44741,
   44743,45086,45103,47264,47283,51427],[42609,42743,44742],
 [42611,42613,42745,42747,43152,44744,44746,45151],
 [42612,42746,44745],[42614,42748,44747],[42615,42749,44748],
 [42616,42750,44749],
 [42617,42618,42751,42752,43220,44750,44751,45219],
 [42619,42753,44752],[42620,42754,44753],[42621,42755,44754],
 [42622,42756,44755],
 [42623,42625,42757,42759,43254,44756,44758,45253],
 [42624,42758,44757],[42629,42631,45355],[42634,42637,42907],
 [42635,42641,45530],[42643,42645,45698],[42646,42647,43151],
 [42651,42653,43212],[42658,42659,43253],[42663,42665,45916],
 [42668,42673,42909],[42669,42675,46091],[42676,42678,43086],
 [42677,42679,46259],[42696,42698,46444],[42701,42707,42910],
 [42702,42708,46619],[42710,42712,46787],[42762,42821,47465],
 [42763,42822,47466],[42764,42823,47467],
 [42765,42766,42771,42824,42825,42830,42931,42960,47468,47469,
   47474,47580,47604,48416,48421,49799],[42767,42826,47470],
 [42768,42827,47471],[42769,42828,47472],[42770,42829,47473],
 [42772,42831,47475],[42774,42833,47477],[42776,42835,47479],
 [42777,42836,47480],[42778,42837,47481],[42779,42838,47482],
 [42780,42839,47483],[42781,42840,47484],[42782,42841,47485],
 [42783,42842,47486],[42784,42843,47487],[42785,42844,47488],
 [42786,42845,47489],[42787,42846,47490],[42788,42847,47491],
 [42789,42848,47492],[42790,42849,47493],[42795,42801,48015],
 [42796,42797,42956],[42803,42805,48183],
 [42852,42855,42858,42933,43005,48799,48868,49844],
 [42860,42862,48967],[42879,42885,49150],[42882,42883,43003],
 [42887,42889,49318],[42913,42915,49643],[42935,43046,49885],
 [42937,43066,49905],
 [42938,42940,43067,43069,49906,49908,49943,51274],
 [42939,43068,49907],[42941,43070,49909],[42942,43071,49910],
 [42943,43072,49911],[42944,43073,49912],
 [42945,42952,43074,43081,43207,49913,49920,51377],
 [42946,43075,49914],[42947,43076,49915],[42948,43077,49916],
 [42949,42951,43078,43080,43236,49917,49919,51406],
 [42950,43079,49918],[42953,43082,49921],[42954,43083,49922],
 [42955,43084,49923],[42962,42964,50219],[42985,42987,50472],
 [43007,43009,50703],[43028,43030,50913],[43034,43042,43197],
 [43040,43041,43241],[43048,43050,51103],[43105,43136,51595],
 [43106,43137,51596],[43107,43138,51597],[43108,43139,51598],
 [43109,43140,51599],[43110,43141,51600],[43111,43142,51601],
 [43112,43143,51602],[43113,43144,51603],[43114,43145,51604],
 [43115,43146,51605],[43116,43147,51606],[43117,43148,51607],
 [43118,43149,51608],[43119,43150,51609],[43302,43303,43608],
 [43305,43308,44981],[43310,43311,43788],[43315,43878],
 [43332,43399,45290],[43334,43401,45292],[43335,43402,45293],
 [43336,43403,45294],
 [43337,43340,43343,43404,43407,43410,43610,43613,45295,45298,
   45301,45504,45576,46590,46665,49521],[43338,43405,45296],
 [43339,43406,45297],[43341,43408,45299],[43342,43409,45300],
 [43344,43411,45302],[43346,43413,45304],[43347,43414,45305],
 [43348,43415,45306],
 [43349,43350,43416,43417,43854,45307,45308,46834],
 [43351,43418,45309],[43352,43419,45310],[43353,43420,45311],
 [43354,43356,43421,43423,43915,45312,45314,46895],
 [43355,43422,45313],[43357,43424,45315],[43358,43425,45316],
 [43359,43426,45317],[43360,43427,45318],
 [43361,43362,43428,43429,43956,45319,45320,46936],
 [43363,43430,45321],[43371,43376,43612],[43374,43377,46137],
 [43379,43381,43789],[43436,43443,43614],[43439,43442,47161],
 [43444,43447,43790],[43448,43450,43855],[43449,43873],
 [43454,43455,43923],[43460,43462,43957],[43468,43469,43634],
 [43470,43473,47626],[43528,43533,43663],[43529,43532,48467],
 [43555,43558,43636],[43557,43560,48845],[43584,43587,49196],
 [43585,43586,43706],[43648,43655,43910],[43652,43654,43939],
 [43683,43707,50372],[43687,43750,50415],[43688,43751,50416],
 [43689,43752,50417],[43690,43753,50418],[43691,43754,50419],
 [43692,43755,50420],[43693,43756,50421],[43694,43757,50422],
 [43695,43758,50423],[43696,43759,50424],[43697,43760,50425],
 [43698,43761,50426],[43699,43762,50427],[43700,43763,50428],
 [43701,43764,50429],[43702,43765,50430],[43703,43766,50431],
 [43704,43767,50432],[43705,43768,50433],[43737,43745,43900],
 [43743,43744,43944],[43968,43969,44274],[43973,43974,45024],
 [43976,43977,44454],[44003,44006,44276],[44008,44009,45619],
 [44015,44016,44520],[44020,44022,44581],[44027,44028,44622],
 [44032,44065,45851],[44033,44066,45852],[44034,44067,45853],
 [44035,44068,45854],[44036,44069,45855],
 [44037,44042,44043,44070,44075,44076,44278,44279,45856,45861,
   45862,46065,46180,46592,46708,49564],[44038,44071,45857],
 [44039,44072,45858],[44040,44073,45859],[44041,44074,45860],
 [44044,44077,45863],[44046,44079,45865],[44048,44081,45867],
 [44049,44082,45868],[44050,44083,45869],[44051,44084,45870],
 [44052,44085,45871],[44053,44086,45872],[44054,44087,45873],
 [44055,44088,45874],[44056,44089,45875],[44057,44090,45876],
 [44058,44091,45877],[44059,44092,45878],[44060,44093,45879],
 [44061,44094,45880],[44062,44095,45881],[44063,44096,45882],
 [44102,44109,44280],[44107,44108,47204],[44110,44113,44456],
 [44114,44116,44521],[44120,44121,44589],[44126,44128,44623],
 [44134,44135,44300],[44138,44139,47669],[44165,44166,44325],
 [44168,44169,48104],[44194,44199,44329],[44197,44198,48510],
 [44221,44224,44302],[44225,44226,48888],[44248,44269],
 [44251,44252,44253,44372,44373,49218,49239,50624],
 [44254,44270],[44314,44321,44576],[44318,44320,44605],
 [44396,44416,50856],[44397,44417,50857],[44399,44419,50859],
 [44400,44420,50860],[44401,44421,50861],[44402,44422,50862],
 [44403,44411,44423,44431,44566,50863,50871,51196],
 [44404,44424,50864],[44405,44425,50865],[44406,44426,50866],
 [44407,44427,50867],[44408,44428,50868],
 [44409,44410,44429,44430,44610,50869,50870,51240],
 [44412,44432,50872],[44413,44433,50873],[44414,44434,50874],
 [44700,44701,44706,44909,44934,46588,46618,49474],
 [44763,44764,44765,44905,44930,47549,47550,49470],
 [44793,44794,47984],[44795,44796,44955],[44801,44802,48164],
 [44822,44823,48390],[44824,44829,44959],[44830,44831,48570],
 [44850,44851,44854,44907,44932,48768,48771,49472],
 [44858,44859,48948],[44877,44878,49119],[44881,44882,45002],
 [44885,44886,49299],
 [44911,44912,44936,44937,49476,49477,49624,49924],
 [44913,44938,49478],[44914,44939,49479],[44915,44940,49480],
 [44916,44941,49481],[44917,44942,49482],[44918,44943,49483],
 [44919,44926,44944,44951,45206,49484,49491,49746],
 [44920,44945,49485],[44921,44946,49486],[44922,44947,49487],
 [44923,44925,44948,44950,45235,49488,49490,49775],
 [44924,44949,49489],[44927,44952,49492],[44928,44953,49493],
 [44929,44954,49494],[44956,50133],[44960,44961,50200],
 [44983,44984,50453],[45005,45006,50684],[45026,45027,50894],
 [45033,45041,45196],[45039,45040,45240],[45046,45047,51084],
 [45065,45066,51255],[45087,45104,51428],[45088,45105,51429],
 [45089,45106,51430],[45090,45107,51431],[45091,45108,51432],
 [45092,45109,51433],[45093,45110,51434],[45094,45111,51435],
 [45095,45112,51436],[45096,45113,51437],[45097,45114,51438],
 [45098,45115,51439],[45099,45116,51440],[45100,45117,51441],
 [45101,45118,51442],[45358,45361,47551],[45359,45360,45525],
 [45370,45371,47795],[45375,45377,47856],[45382,45383,47897],
 [45388,45390,45391,45500,45550,47985,47986,49495],
 [45400,45401,48230],[45405,45407,48291],[45412,45413,48332],
 [45417,45420,48392],[45419,45424,45554],[45429,45430,48636],
 [45431,48673],[45434,45436,48697],[45441,45442,48738],
 [45445,45448,48770],[45446,45449,45527],[45457,45458,49014],
 [45462,45464,49075],[45469,45470,49116],[45472,45475,49121],
 [45476,45477,45597],[45484,45485,49365],[45489,45491,49426],
 [45496,45497,49467],[45502,45574,49519],[45506,45578,49523],
 [45507,45579,49524],[45508,45580,49525],[45509,45581,49526],
 [45510,45511,45582,45583,49527,49528,49690,50519],
 [45512,45584,49529],[45513,45585,49530],[45514,45586,49531],
 [45515,45517,45587,45589,49532,49534,49751,50580],
 [45516,45588,49533],[45518,45590,49535],[45519,45591,49536],
 [45520,45592,49537],[45521,45593,49538],
 [45522,45523,45594,45595,49539,49540,49792,50621],
 [45524,45596,49541],[45535,45536,49990],[45539,45546,45801],
 [45540,45542,50051],[45543,45545,45830],[45547,45548,50092],
 [45559,45560,50266],[45564,45566,50327],[45571,45572,50368],
 [45604,45605,50750],[45609,45611,50811],[45616,45617,50852],
 [45625,45626,50960],[45628,45636,45791],[45630,45632,51021],
 [45634,45635,45835],[45637,45638,51062],[45645,45646,51150],
 [45650,45652,51211],[45657,45658,51252],[45664,45665,51321],
 [45669,45671,51382],[45676,45677,51423],[45682,45683,51474],
 [45687,45689,51535],[45694,45695,51576],[45699,45700,51610],
 [45704,45706,51671],[45711,45712,51712],[45715,45716,51730],
 [45720,45722,51791],[45727,45728,51832],[45730,45731,51835],
 [45732,51866],[45735,45737,51896],[45742,45743,51937],
 [45747,45760,51941],[45748,45761,51942],
 [45749,45751,45762,45764,51943,51945,51987,52065],
 [45750,45763,51944],[45752,45765,51946],[45753,45766,51947],
 [45754,45767,51948],[45755,45768,51949],
 [45756,45757,45769,45770,51950,51951,52028,52106],
 [45758,45771,51952],[45774,45776,52131],[45781,45782,52172],
 [45785,45787,52186],[45792,45793,52227],[45795,45797,52231],
 [45802,45803,52272],[45807,45822,52283],[45808,45823,52284],
 [45809,45824,52285],[45810,45825,52286],[45813,45828,52289],
 [45819,45820,52336],[45832,45833,52372],[45837,45838,52382],
 [45841,45842,52388],[45844,45845,52391],[45919,45924,47553],
 [45920,45921,46086],[45927,45929,47730],[45949,45954,47988],
 [45951,45952,46111],[45957,45959,48165],[45978,45983,48394],
 [45980,45985,46115],[45986,45988,48571],[46006,46011,48772],
 [46007,46010,46088],[46014,46016,48949],
 [46033,46037,46038,46063,46158,49122,49123,49542],
 [46041,46043,49300],[46061,46113,49497],
 [46067,46069,46182,46184,49566,49568,49625,50895],
 [46068,46183,49567],[46070,46185,49569],[46071,46186,49570],
 [46072,46187,49571],[46073,46188,49572],
 [46074,46082,46189,46197,46352,49573,49581,49736],
 [46075,46190,49574],[46076,46191,49575],[46077,46192,49576],
 [46078,46193,49577],[46079,46194,49578],
 [46080,46081,46195,46196,46396,49579,49580,49780],
 [46083,46198,49582],[46084,46199,49583],[46085,46200,49584],
 [46092,46094,49925],[46100,46107,46362],[46104,46106,46391],
 [46116,46118,50201],[46139,46141,50454],[46161,46163,50685],
 [46202,46204,51085],[46221,46223,51256],[46243,46276,51444],
 [46244,46277,51445],[46245,46278,51446],[46246,46279,51447],
 [46247,46280,51448],[46248,46281,51449],[46249,46282,51450],
 [46250,46283,51451],[46251,46284,51452],[46252,46285,51453],
 [46253,46286,51454],[46254,46287,51455],[46255,46288,51456],
 [46256,46289,51457],[46257,46290,51458],
 [46416,46422,46423,46594,46729,47089,47225,49585],
 [46428,46430,46835],[46434,46435,46903],[46440,46442,46937],
 [46447,46453,47554],[46448,46449,46614],[46477,46483,47989],
 [46479,46480,46639],[46506,46512,48395],[46508,46513,46643],
 [46534,46540,48773],[46535,46538,46616],[46561,46567,49124],
 [46565,46566,46686],[46591,46687,49543],[46596,46731,49587],
 [46597,46732,49588],[46598,46733,49589],[46599,46734,49590],
 [46600,46735,49591],[46601,46736,49592],[46602,46737,49593],
 [46603,46738,49594],[46604,46739,49595],[46605,46740,49596],
 [46606,46741,49597],[46607,46742,49598],[46608,46743,49599],
 [46609,46744,49600],[46610,46745,49601],[46611,46746,49602],
 [46612,46747,49603],[46613,46748,49604],[46628,46635,46890],
 [46632,46634,46919],[46717,46725,46880],[46723,46724,46924],
 [46943,46950,47555],[46944,46945,47110],[46951,46954,47731],
 [46955,46957,47796],[46961,46962,47864],[46967,46969,47898],
 [46973,46980,47990],[46975,46976,47135],[46981,46984,48166],
 [46985,46987,48231],[46986,48256],[46991,46992,48299],
 [46997,46999,48333],
 [47002,47004,47009,47085,47139,48391,48396,49499],
 [47014,47016,48637],[47020,47021,48705],[47026,47028,48739],
 [47030,47037,48774],[47031,47034,47112],[47038,47041,48950],
 [47042,47044,49015],[47048,47049,49083],[47054,47056,49117],
 [47057,47064,49125],[47061,47062,47182],[47065,47068,49301],
 [47069,47071,49366],[47075,47076,49434],[47081,47083,49468],
 [47087,47184,49544],
 [47091,47094,47245,47248,49605,49608,49626,51257],
 [47092,47246,49606],[47093,47247,49607],
 [47095,47097,47249,47251,49609,49611,49691,51322],
 [47096,47250,49610],[47098,47252,49612],[47099,47253,49613],
 [47100,47254,49614],
 [47101,47102,47255,47256,49615,49616,49759,51390],
 [47103,47257,49617],[47104,47258,49618],[47105,47259,49619],
 [47106,47260,49620],
 [47107,47109,47261,47263,49621,49623,49793,51424],
 [47108,47262,49622],[47116,47119,49926],[47120,47122,49991],
 [47124,47131,47386],[47126,47127,50059],[47128,47130,47415],
 [47132,47134,50093],[47140,47143,50202],[47144,47146,50267],
 [47150,47151,50335],[47156,47158,50369],[47163,47166,50455],
 [47167,47169,50520],[47173,47174,50588],[47179,47181,50622],
 [47185,47188,50686],[47189,47191,50751],[47195,47196,50819],
 [47201,47203,50853],[47206,47209,50896],[47210,47212,50961],
 [47213,47221,47376],[47216,47217,51029],[47219,47220,47420],
 [47222,47224,51063],[47226,47229,51086],[47230,47232,51151],
 [47236,47237,51219],[47242,47244,51253],
 [47267,47269,47315,47317,51459,51461,51475,51836],
 [47268,47316,51460],[47270,47318,51462],[47271,47319,51463],
 [47272,47320,51464],
 [47273,47274,47321,47322,51465,51466,51543,51904],
 [47275,47323,51467],[47276,47324,51468],[47277,47325,51469],
 [47278,47326,51470],
 [47279,47281,47327,47329,51471,51473,51577,51938],
 [47280,47328,51472],[47284,47286,51611],[47290,47291,51679],
 [47296,47298,51713],[47300,47302,51731],[47306,47307,51799],
 [47312,47314,51833],[47332,47357,51953],[47333,47358,51954],
 [47334,47359,51955],
 [47335,47336,47360,47361,51956,51957,51995,52139],
 [47337,47362,51958],[47338,47363,51959],[47339,47364,51960],
 [47340,47365,51961],
 [47341,47343,47366,47368,51962,51964,52029,52173],
 [47342,47367,51963],[47348,47349,52073],[47354,47356,52107],
 [47371,47372,52194],[47377,47379,52228],[47381,47382,52239],
 [47387,47389,52273],[47396,47398,52309],[47400,47407,52311],
 [47401,47408,52312],[47402,47409,52313],[47403,47410,52314],
 [47405,47412,52316],[47417,47419,52373],[47422,47424,52383],
 [47426,47428,52389],[47429,47431,52392],[47495,47517],
 [47496,47497,47499,47577,47601,48794,48820,49796],
 [47500,47518],[47523,47524,49145],[47526,47527,47647],
 [47581,47605,49800],[47583,47607,49802],[47584,47608,49803],
 [47585,47609,49804],[47586,47610,49805],[47587,47611,49806],
 [47588,47612,49807],
 [47589,47596,47613,47620,47851,49808,49815,50322],
 [47590,47614,49809],[47591,47615,49810],[47592,47616,49811],
 [47593,47595,47617,47619,47880,49812,49814,50351],
 [47594,47618,49813],[47597,47621,49816],[47598,47622,49817],
 [47599,47623,49818],[47678,47686,47841],[47684,47685,47885],
 [47931,47934,48012],[47932,47933,48819],[47959,47960,49170],
 [47961,47962,48082],[48024,48031,48286],[48028,48030,48315],
 [48036,48059,50095],[48040,48063,50099],[48041,48064,50100],
 [48042,48065,50101],[48043,48066,50102],[48044,48067,50103],
 [48045,48068,50104],[48046,48069,50105],[48047,48070,50106],
 [48048,48071,50107],[48049,48072,50108],[48050,48073,50109],
 [48051,48074,50110],[48052,48075,50111],[48053,48076,50112],
 [48054,48077,50113],[48055,48078,50114],[48056,48079,50115],
 [48057,48080,50116],[48058,48081,50117],[48113,48121,48276],
 [48119,48120,48320],[48337,48340,48418],[48338,48343,48823],
 [48365,48370,49174],[48367,48368,48488],[48430,48437,48692],
 [48434,48436,48721],[48442,48490,50120],[48446,48551,50181],
 [48447,48552,50182],[48448,48553,50183],[48450,48555,50185],
 [48451,48556,50186],[48452,48557,50187],[48453,48558,50188],
 [48454,48559,50189],[48455,48560,50190],[48456,48561,50191],
 [48457,48562,50192],[48458,48563,50193],[48459,48564,50194],
 [48460,48565,50195],[48461,48566,50196],[48462,48567,50197],
 [48463,48568,50198],[48464,48569,50199],[48519,48527,48682],
 [48525,48526,48726],[48798,48867,49843],[48800,48869,49845],
 [48801,48870,49846],[48802,48871,49847],[48803,48872,49848],
 [48804,48873,49849],[48805,48874,49850],[48806,48875,49851],
 [48807,48876,49852],
 [48808,48815,48877,48884,49070,49853,49860,50806],
 [48809,48878,49854],[48810,48879,49855],[48811,48880,49856],
 [48812,48814,48881,48883,49099,49857,49859,50835],
 [48813,48882,49858],[48816,48885,49861],[48817,48886,49862],
 [48818,48887,49863],[48891,48977],[48897,48905,49060],
 [48903,48904,49104],[49153,49343],[49159,49166,49421],
 [49163,49165,49450],[49171,49172,50118],[49220,49241,50626],
 [49221,49242,50627],[49222,49243,50628],[49223,49244,50629],
 [49224,49245,50630],[49225,49246,50631],[49226,49247,50632],
 [49227,49235,49248,49256,49411,50633,50641,50796],
 [49228,49249,50634],[49229,49250,50635],[49230,49251,50636],
 [49231,49252,50637],[49232,49253,50638],
 [49233,49234,49254,49255,49455,50639,50640,50840],
 [49236,49257,50642],[49237,49258,50643],[49238,49259,50644],
 [49677,51871],[49894,49901,51206],[49898,49900,51235],
 [49931,49938,51530],[49935,49937,51559],[49948,49955,51666],
 [49952,49954,51695],[49964,49971,51786],[49968,49970,51815],
 [49979,49986,51891],[49983,49985,51920],[49993,50000,51982],
 [49997,49999,52011],[50006,50013,52060],[50010,50012,52089],
 [50018,50025,52126],[50022,50024,52155],[50033,50035,52210],
 [50040,50055,52235],[50041,50063,52243],[50042,50070,52250],
 [50044,50081,52261],[50047,50089,52269],[50048,50090,52270],
 [50049,50091,52271],[50052,50054,52291],[50060,50062,52319],
 [50067,50069,52340],[50077,50086,52366],[50078,50087,52367],
 [50079,50088,52368],[50149,50157,50312],[50155,50156,50356],
 [50900,50908,51520],[50906,50907,51564],[50917,50925,51656],
 [50923,50924,51700],[50933,50941,51776],[50939,50940,51820],
 [50948,50956,51881],[50954,50955,51925],[50962,50970,51972],
 [50968,50969,52016],[50975,50983,52050],[50981,50982,52094],
 [50987,50995,52116],[50993,50994,52160],[51000,51025,52190],
 [51001,51033,52198],[51002,51040,52205],[51003,51046,52211],
 [51007,51059,52224],[51008,51060,52225],[51009,51061,52226],
 [51014,51015,52260],[51023,51024,52296],[51031,51032,52324],
 [51038,51039,52345],[51052,51056,52376],[51053,51057,52377],
 [51054,51058,52378],[51258,51487]];

return Union(eqclsgt1,List(Difference([1..52394],Union(eqclsgt1)),i->[i]));

#############################################################################
##
#E  equalityclasses.g . . . . . . . . . . . . . . . . . . . . . . . ends here
