/*
 * spaceball.h - prototypes and definitions for Tachyon 
 *               Spaceball/SpaceNavigator interfaces
 *
 * (C) Copyright 1994-2022 John E. Stone
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * $Id: spaceball.h,v 1.5 2022/02/18 18:18:36 johns Exp $
 *
 */

#if defined(USESPACEBALL)
#include "sball.h"
#endif

typedef struct {
  void *glwin;
#if defined(USESPACEBALL)
  SBallHandle sball;
#endif
  int buttondown;

  apivector camcent;
  apivector camviewvec;
  apivector camupvec;

  apivector orig_camcent;
  apivector orig_camviewvec;
  apivector orig_camupvec;
  apivector orig_camrightvec;

  float curtrans[3];
  float newtrans[3];
  float curquat[4];
  float lastquat[4];
} sbHandle;

void * tachyon_init_spaceball(SceneHandle scene, void * glwin, char * port);
int tachyon_spaceball_update(sbHandle * bh, SceneHandle scene);


