from collections.abc import Set
from typing import Any

class GBElement:
    def __init__(self, x: Any, ls: Any, n: int) -> None: ...
    def __hash__(self) -> int: ...
    def __richcmp__(self, other: Any, op: int) -> Any: ...

class GroebnerStrategy:
    def __init__(self, I: Any) -> None: ...
    def leading_support(self, f: Any) -> Any: ...
    def partial_S_poly_left(self, f: GBElement, g: GBElement) -> GBElement: ...
    def partial_S_poly_right(self, f: GBElement, g: GBElement) -> GBElement: ...
    def build_elt(self, f: Any) -> GBElement: ...
    def prod_GB_term(self, f: GBElement, t: Any) -> GBElement: ...
    def prod_term_GB(self, t: Any, f: GBElement) -> GBElement: ...
    def build_S_poly(self, f: GBElement, g: GBElement) -> bool: ...
    def preprocessing(
        self, P: list[tuple[GBElement, GBElement]], G: list[GBElement]
    ) -> Set[GBElement]: ...
    def reduction(
        self, P: list[tuple[GBElement, GBElement]], G: list[GBElement]
    ) -> list[GBElement]: ...
    def compute_groebner(self, reduced: bool = True) -> None: ...
    def reduced_gb(self, G: list[GBElement]) -> int: ...
    def reduce_computed_gb(self) -> None: ...
    def reduce(self, f: Any) -> Any: ...
    def reduce_single(self, f: Any, g: Any) -> bool: ...
    def bitset_to_int(self, X: Any) -> int: ...
    def int_to_bitset(self, n: int) -> Any: ...
    def sorted_monomials(self, as_dict: bool = False) -> list[Any]: ...
    def monomial_to_int(self) -> dict: ...

class GroebnerStrategyNegLex(GroebnerStrategy):
    def bitset_to_int(self, X: Any) -> int: ...
    def int_to_bitset(self, n: int) -> Any: ...

class GroebnerStrategyDegRevLex(GroebnerStrategy):
    def bitset_to_int(self, X: Any) -> int: ...
    def int_to_bitset(self, n: int) -> Any: ...

class GroebnerStrategyDegLex(GroebnerStrategy):
    def bitset_to_int(self, X: Any) -> int: ...
    def int_to_bitset(self, n: int) -> Any: ...
