# RepnDecomp, chapter 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("repndecomp03.tst");

# /doc/_Chunks.xml:261-287
gap> G := SymmetricGroup(3);;
gap> irreps := IrreducibleRepresentations(G);;
gap> # It happens that we are given unitary irreps, so
> # rho is also unitary (its blocks are unitary)
> rho := DirectSumOfRepresentations([irreps[1], irreps[2]]);;
gap> IsUnitaryRepresentation(rho);
true
gap> # Arbitrary change of basis
> A := [ [ -1, 1 ], [ -2, -1 ] ];;
gap> tau := ComposeHomFunction(rho, x -> A^-1 * x * A);;
gap> # Not unitary, but still isomorphic to rho
> IsUnitaryRepresentation(tau);
false
gap> AreRepsIsomorphic(rho, tau);
true
gap> # Now we unitarise tau
> tau_u := UnitaryRepresentation(tau);;
gap> # We get a record with the unitarised rep:
> AreRepsIsomorphic(tau, tau_u.unitary_rep);
true
gap> AreRepsIsomorphic(rho, tau_u.unitary_rep);
true
gap> # The basis change is also in the record:
> ForAll(G, g -> tau_u.basis_change * Image(tau_u.unitary_rep, g) = Image(tau, g) * tau_u.basis_change);
true

# /doc/_Chunks.xml:293-295
gap> # TODO: this example

# /doc/_Chunks.xml:301-316
gap> A := [ [ 3, 2*E(3)+E(3)^2, -3 ], [ E(3)+2*E(3)^2, -3, 3 ], [ -3, 3, -6 ] ];;
gap> # A is a conjugate symmetric matrix
> A = ConjugateTranspose@RepnDecomp(A);
true
gap> # Note that A is not symmetric - the LDL decomposition works for any
> # conjugate symmetric matrix.
> A = TransposedMat(A);
false
gap> decomp := LDLDecomposition(A);;
gap> # The LDL decomposition is such that A = LDL^*, D diagonal, and L lower triangular.
> A = decomp.L * DiagonalMat(decomp.D) * ConjugateTranspose@RepnDecomp(decomp.L);
true
gap> decomp.L[1][2] = 0 and decomp.L[1][3] = 0 and decomp.L[2][3] = 0;
true

#
gap> STOP_TEST("repndecomp03.tst", 1);
