// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

pragma ComponentBehavior: Bound

import QtQuick
import QtQuick3D

Item {
    id: currentToy

    property alias toy: toy3D.toy
    property bool isMaximized: false
    property int index: -1
    required property AccessoryModel accessoryModel

    implicitWidth: {
        if (!isMaximized)
            return ApplicationConfig.isPortrait ? ApplicationConfig.responsiveSize(1051)
                                                : ApplicationConfig.responsiveSize(1366)
        return ApplicationConfig.isPortrait ? ApplicationConfig.responsiveSize(1664)
                                            : ApplicationConfig.responsiveSize(1699)
    }
    implicitHeight: {
        if (!isMaximized)
            return ApplicationConfig.isPortrait ? ApplicationConfig.responsiveSize(1051)
                                                : ApplicationConfig.responsiveSize(1366)
        return ApplicationConfig.isPortrait ? ApplicationConfig.responsiveSize(2237)
                                            : ApplicationConfig.responsiveSize(2318)
    }

    View3D {
        id: toy3D
        property var toy: bearLoader.item
        anchors.fill: parent

        camera: sceneCamera

        environment: SceneEnvironment {
            id: sceneEnv
            backgroundMode: SceneEnvironment.Transparent
            clearColor: "transparent"
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.High
        }

        Node {
            id: sceneRoot

            PerspectiveCamera {
                id: sceneCamera
                y: 92
                z: 280
                clipNear: 100
                clipFar: 2000
                frustumCullingEnabled: true
                fieldOfView: 40
                eulerRotation: Qt.vector3d(0, 0, -3)
            }

            SpotLight {
                id: key
                x: 80
                y: 220
                z: 280
                visible: true
                eulerRotation.x: -25
                color: "#e7e7e7"
                brightness: 20
                coneAngle: 71
                innerConeAngle: 26
                linearFade: 1.4
                quadraticFade: 0.3
                castsShadow: true
                shadowMapQuality: Light.ShadowMapQualityVeryHigh
                shadowBias: 5
                shadowFactor: 93
            }

            Node {
                id: loaderNode
                Loader3D {
                    id: bearLoader
                    active: true
                    sourceComponent: {
                        const item = ToyModel.get(currentToy.index)
                        if (!item)
                            return emptyComponent
                        if (item.name === qsTr("Teddy Bear"))
                            return bearComponent
                        if (item.name === qsTr("Koala"))
                            return koalaComponent
                        if (item.name === qsTr("Lion"))
                            return lionComponent
                        if (item.name === qsTr("Monkey"))
                            return monkeyComponent
                        if (item.name === qsTr("Cat"))
                            return catComponent
                        if (item.name === qsTr("Reindeer"))
                            return deerComponent
                        if (item.name === qsTr("Panda"))
                            return pandaComponent
                        if (item.name === qsTr("Sloth"))
                            return slothComponent
                        if (item.name === qsTr("Raccoon"))
                            return raccoonComponent
                        if (item.name === qsTr("Sheep"))
                            return sheepComponent
                        if (item.name === qsTr("Squirrel"))
                            return squirrelComponent
                        if (item.name === qsTr("Pig"))
                            return pigComponent
                        if (item.name === qsTr("Rabbit"))
                            return rabbitComponent
                        if (item.name === qsTr("Tiger"))
                            return tigerComponent
                        return emptyComponent
                    }

                    Component {
                        id: emptyComponent
                        QtObject {}
                    }

                    Component {
                        id: lionComponent
                        LionCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: bearComponent
                        BearCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: koalaComponent
                        KoalaCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: monkeyComponent
                        MonkeyCustom {accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: catComponent
                        CatCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: deerComponent
                        DeerCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: pandaComponent
                        PandaCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: slothComponent
                        SlothCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: raccoonComponent
                        RaccoonCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: sheepComponent
                        SheepCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: squirrelComponent
                        SquirrelCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: rabbitComponent
                        RabbitCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: pigComponent
                        PigCustom { accessoryModel: currentToy.accessoryModel }
                    }

                    Component {
                        id: tigerComponent
                        TigerCustom { accessoryModel: currentToy.accessoryModel }
                    }
                }
            }

            Node {
                id: accessoriesRoot
            }
        }

        OrbitCameraController {
            id: orbitCam
            anchors.fill: parent
            origin: loaderNode
            camera: sceneCamera
        }
    }
}
