// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

#ifdef QPROPERTY_MACRO
//! [0]
Q_PROPERTY(type name
           (READ getFunction [WRITE setFunction] |
            MEMBER memberName [(READ getFunction | WRITE setFunction)])
           [RESET resetFunction]
           [NOTIFY notifySignal]
           [REVISION int | REVISION(int[, int])]
           [DESIGNABLE bool]
           [SCRIPTABLE bool]
           [STORED bool]
           [USER bool]
           [BINDABLE bindableProperty]
           [CONSTANT]
           [FINAL]
           [VIRTUAL]
           [OVERRIDE]
           [REQUIRED])
//! [0]


//! [1]
Q_PROPERTY(bool focus READ hasFocus)
Q_PROPERTY(bool enabled READ isEnabled WRITE setEnabled)
Q_PROPERTY(QCursor cursor READ cursor WRITE setCursor RESET unsetCursor)
//! [1]

//! [2]
Q_PROPERTY(QDate date READ getDate WRITE setDate)
//! [2]
#endif

#if __has_include(<QPushButton>)
#include <QPushButton>
void button_example()
{
    //! [3]
    QPushButton *button = new QPushButton;
    QObject *object = button;

    button->setDown(true);
    object->setProperty("down", true);
    //! [3]
}
#endif

#include <QMetaProperty>
void qobject_example()
{
    //! [4]
    QObject *object = new QObject;
    const QMetaObject *metaobject = object->metaObject();
    int count = metaobject->propertyCount();
    for (int i=0; i<count; ++i) {
        QMetaProperty metaproperty = metaobject->property(i);
        const char *name = metaproperty.name();
        QVariant value = object->property(name);
        //...
    }
    //! [4]
}

//! [5]
class MyClass : public QObject
{
    Q_OBJECT
    Q_PROPERTY(Priority priority READ priority WRITE setPriority NOTIFY priorityChanged)

public:
    MyClass(QObject *parent = nullptr);
    ~MyClass();

    enum Priority { High, Low, VeryHigh, VeryLow };
    Q_ENUM(Priority)

    void setPriority(Priority priority)
    {
        if (m_priority == priority)
            return;

        m_priority = priority;
        emit priorityChanged(priority);
    }
    Priority priority() const
    { return m_priority; }

signals:
    void priorityChanged(Priority);

private:
    Priority m_priority;
};
//! [5]

void example(){
    //! [6]
    MyClass *myinstance = new MyClass;
    QObject *object = myinstance;

    myinstance->setPriority(MyClass::VeryHigh);
    object->setProperty("priority", "VeryHigh");
    //! [6]
}

#ifdef QPROPERTY_MACRO
//! [7]
Q_CLASSINFO("DefaultProperty", "content")
//! [7]

//! [8]
    Q_PROPERTY(QColor color MEMBER m_color NOTIFY colorChanged)
    Q_PROPERTY(qreal spacing MEMBER m_spacing NOTIFY spacingChanged)
    Q_PROPERTY(QString text MEMBER m_text NOTIFY textChanged)
    //...
signals:
    void colorChanged();
    void spacingChanged();
    void textChanged(const QString &newText);

private:
    QColor  m_color;
    qreal   m_spacing;
    QString m_text;
//! [8]
#endif
