# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import sys

from PySide6.QtWidgets import QApplication

from generator import init_generator
from gui_utils import show_warning
from mainwindow import MainWindow
from options import Options


FUSION_STYLE_SHEET = """
QPushButton {
    border-radius: 3px;
    background-color: #dbdbdb;
    min-width: 80px;
    padding: 3px;
}

QPushButton:pressed {
    background-color:  #9d9faa;
}

QPushButton:disabled {
    color: #8a8a8a;
}

QMenuBar {
    background-color: #afafaf;
}

QHeaderView {
    background-color: #dbdbdb;
}
"""


if __name__ == '__main__':
    if sys.version_info < (3, 6, 0):
        raise Exception("This script requires Python 3.6+")

    app = QApplication(sys.argv)
    try:
        init_generator()
    except ImportError as e:
        show_warning(None, "Error", str(e))
        sys.exit(-1)

    Options.load_options()
    window = MainWindow()

    if len(sys.argv) > 1 and not window.load_project_from_file(sys.argv[1]):
        sys.exit(-1)

    screen_size = window.screen().size()
    window.setMinimumSize(800, 600)
    window.resize(screen_size.width() * 2 / 3, screen_size.height() * 4 / 5)

    # Use styling only for Fusion when not using QtCreator
    if not Options.use_creator() and window.style().objectName() == 'fusion':
        window.setStyleSheet(FUSION_STYLE_SHEET)

    window.show()

    exit_code = app.exec()
    Options.save_options()
    sys.exit(exit_code)
