/*
   SPDX-FileCopyrightText: 2020-2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "libruqolawidgets_private_export.h"
#include <QDialog>
class CreateDirectMessagesWidget;
class RocketChatAccount;
class LIBRUQOLAWIDGETS_TESTS_EXPORT CreateDirectMessagesDialog : public QDialog
{
    Q_OBJECT
public:
    explicit CreateDirectMessagesDialog(RocketChatAccount *account, QWidget *parent = nullptr);
    ~CreateDirectMessagesDialog() override;

    [[nodiscard]] QStringList userNames() const;

private:
    LIBRUQOLAWIDGETS_NO_EXPORT void readConfig();
    LIBRUQOLAWIDGETS_NO_EXPORT void writeConfig();

    CreateDirectMessagesWidget *const mCreateDirectMessagesWidget;
};
