/*
 * Decompiled with CFR 0.152.
 */
package mso.generator.utils;

import mso.generator.utils.Choice;
import mso.generator.utils.Lim;
import mso.generator.utils.Member;
import mso.generator.utils.Struct;
import mso.generator.utils.Type;
import org.eclipse.jdt.annotation.Nullable;

public class Option {
    public final Struct type;
    public final Type limitsType;
    public final Lim lim;

    private Option(Struct struct, Type type, Lim lim) {
        this.type = struct;
        this.limitsType = type;
        this.lim = lim;
    }

    public static Option parseOption(Struct struct, @Nullable Type type) {
        return Option.setLimitations(struct, struct, type);
    }

    private static Option setLimitations(Struct struct, Struct struct2, Choice choice) {
        Lim[] limArray = new Lim[choice.options.size()];
        for (int i = 0; i < choice.options.size(); ++i) {
            limArray[i] = choice.options.get((int)i).lim;
        }
        Type type = choice.commonType;
        if (type == null) {
            throw new Error("Common type is null.");
        }
        return new Option(struct, type, new Lim(limArray));
    }

    private static Option setLimitations(Struct struct, Struct struct2, @Nullable Type type) {
        Member member = struct2.members.get(0);
        System.out.println(struct.name + " " + struct2.name + " , " + member.name + " . " + member.type());
        if (member.isOptional) {
            throw new Error("choice member may not be optional");
        }
        Type type2 = member.type();
        if (type2 instanceof Choice) {
            return Option.setLimitations(struct, struct2, (Choice)type2);
        }
        if (type2 == type) {
            return new Option(struct, type, new Lim(member.limitations));
        }
        if (member.limitations.length == 0) {
            return Option.setLimitations(struct, (Struct)type2, type);
        }
        return new Option(struct, type2, new Lim(member.limitations));
    }
}

