# <img src="org.kde.accessibilityinspector.svg" width="40"/> Accessibility Inspector

Inspect your application's accessibility tree

![Main Window](https://cdn.kde.org/screenshots/accessibility-inspector/properties.png)

## Support

If you have an issue with Accessibility Inspector, please [open a support thread on KDE Discuss](https://discuss.kde.org). Alternatively, you can ask in the [KDE Matrix room](https://go.kde.org/matrix/#/#kde:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.

## Building

The easiest way to make changes and test Accessibility Inspector during development is to [build it with kdesrc-build](https://community.kde.org/Get_Involved/development).

## Contributing

Like other projects in the KDE ecosystem, contributions are welcome from all. This repository is managed in [KDE Invent](https://invent.kde.org/accessibility/accessibility-inspector), our GitLab instance.

* Want to contribute code? See the [GitLab wiki page](https://community.kde.org/Infrastructure/GitLab) for a tutorial on how to send a merge request.
* Reporting a bug? Please submit it on the [KDE Bugtracking System](https://bugs.kde.org/enter_bug.cgi?format=guided&product=Accessibility%20Inspector). Please do not use GitLab issues
 to report bugs.
* Is there a part of Accessibility Inspector that's not translated? See the [Getting Involved in Translation wiki page](https://community.kde.org/Get_Involved/translation) to see how
  you can help translate!

If you get stuck or need help with anything at all, head over to the [KDE New Contributors room](https://go.kde.org/matrix/#/#kde-welcome:kde.org) on Matrix. For questions about Accessibility Inspector, please ask in the [KDE Development room](https://go.kde.org/matrix/#/#kde-devel:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.

## License

This project's source code and assets are under multiple licenses, please see the REUSE metadata for specific licensing requirements.