// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file types.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_TYPES_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(TYPES_SOURCE)
#define TYPES_DllAPI __declspec( dllexport )
#else
#define TYPES_DllAPI __declspec( dllimport )
#endif // TYPES_SOURCE
#else
#define TYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define TYPES_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace statistics {

namespace detail {

/*!
 * @brief This class represents the structure EntityId_s defined by the user in the IDL file.
 * @ingroup types
 */
class EntityId_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityId_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityId_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityId_s that will be copied.
     */
    eProsima_user_DllExport EntityId_s(
            const EntityId_s& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityId_s that will be copied.
     */
    eProsima_user_DllExport EntityId_s(
            EntityId_s&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityId_s that will be copied.
     */
    eProsima_user_DllExport EntityId_s& operator =(
            const EntityId_s& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityId_s that will be copied.
     */
    eProsima_user_DllExport EntityId_s& operator =(
            EntityId_s&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityId_s& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityId_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityId_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 4>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 4>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 4>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 4>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 4> m_value{0};

};
/*!
 * @brief This class represents the structure GuidPrefix_s defined by the user in the IDL file.
 * @ingroup types
 */
class GuidPrefix_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GuidPrefix_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GuidPrefix_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GuidPrefix_s that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_s(
            const GuidPrefix_s& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GuidPrefix_s that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_s(
            GuidPrefix_s&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GuidPrefix_s that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_s& operator =(
            const GuidPrefix_s& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GuidPrefix_s that will be copied.
     */
    eProsima_user_DllExport GuidPrefix_s& operator =(
            GuidPrefix_s&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GuidPrefix_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GuidPrefix_s& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x GuidPrefix_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GuidPrefix_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const std::array<uint8_t, 12>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            std::array<uint8_t, 12>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const std::array<uint8_t, 12>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport std::array<uint8_t, 12>& value()
    {
        return m_value;
    }



private:

    std::array<uint8_t, 12> m_value{0};

};
/*!
 * @brief This class represents the structure GUID_s defined by the user in the IDL file.
 * @ingroup types
 */
class GUID_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport GUID_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~GUID_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object GUID_s that will be copied.
     */
    eProsima_user_DllExport GUID_s(
            const GUID_s& x)
    {
                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object GUID_s that will be copied.
     */
    eProsima_user_DllExport GUID_s(
            GUID_s&& x) noexcept
    {
        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object GUID_s that will be copied.
     */
    eProsima_user_DllExport GUID_s& operator =(
            const GUID_s& x)
    {

                    m_guidPrefix = x.m_guidPrefix;

                    m_entityId = x.m_entityId;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object GUID_s that will be copied.
     */
    eProsima_user_DllExport GUID_s& operator =(
            GUID_s&& x) noexcept
    {

        m_guidPrefix = std::move(x.m_guidPrefix);
        m_entityId = std::move(x.m_entityId);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const GUID_s& x) const
    {
        return (m_guidPrefix == x.m_guidPrefix &&
           m_entityId == x.m_entityId);
    }

    /*!
     * @brief Comparison operator.
     * @param x GUID_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const GUID_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member guidPrefix
     * @param _guidPrefix New value to be copied in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            const GuidPrefix_s& _guidPrefix)
    {
        m_guidPrefix = _guidPrefix;
    }

    /*!
     * @brief This function moves the value in member guidPrefix
     * @param _guidPrefix New value to be moved in member guidPrefix
     */
    eProsima_user_DllExport void guidPrefix(
            GuidPrefix_s&& _guidPrefix)
    {
        m_guidPrefix = std::move(_guidPrefix);
    }

    /*!
     * @brief This function returns a constant reference to member guidPrefix
     * @return Constant reference to member guidPrefix
     */
    eProsima_user_DllExport const GuidPrefix_s& guidPrefix() const
    {
        return m_guidPrefix;
    }

    /*!
     * @brief This function returns a reference to member guidPrefix
     * @return Reference to member guidPrefix
     */
    eProsima_user_DllExport GuidPrefix_s& guidPrefix()
    {
        return m_guidPrefix;
    }


    /*!
     * @brief This function copies the value in member entityId
     * @param _entityId New value to be copied in member entityId
     */
    eProsima_user_DllExport void entityId(
            const EntityId_s& _entityId)
    {
        m_entityId = _entityId;
    }

    /*!
     * @brief This function moves the value in member entityId
     * @param _entityId New value to be moved in member entityId
     */
    eProsima_user_DllExport void entityId(
            EntityId_s&& _entityId)
    {
        m_entityId = std::move(_entityId);
    }

    /*!
     * @brief This function returns a constant reference to member entityId
     * @return Constant reference to member entityId
     */
    eProsima_user_DllExport const EntityId_s& entityId() const
    {
        return m_entityId;
    }

    /*!
     * @brief This function returns a reference to member entityId
     * @return Reference to member entityId
     */
    eProsima_user_DllExport EntityId_s& entityId()
    {
        return m_entityId;
    }



private:

    GuidPrefix_s m_guidPrefix;
    EntityId_s m_entityId;

};
/*!
 * @brief This class represents the structure SequenceNumber_s defined by the user in the IDL file.
 * @ingroup types
 */
class SequenceNumber_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SequenceNumber_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SequenceNumber_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SequenceNumber_s that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_s(
            const SequenceNumber_s& x)
    {
                    m_high = x.m_high;

                    m_low = x.m_low;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SequenceNumber_s that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_s(
            SequenceNumber_s&& x) noexcept
    {
        m_high = x.m_high;
        m_low = x.m_low;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SequenceNumber_s that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_s& operator =(
            const SequenceNumber_s& x)
    {

                    m_high = x.m_high;

                    m_low = x.m_low;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SequenceNumber_s that will be copied.
     */
    eProsima_user_DllExport SequenceNumber_s& operator =(
            SequenceNumber_s&& x) noexcept
    {

        m_high = x.m_high;
        m_low = x.m_low;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SequenceNumber_s& x) const
    {
        return (m_high == x.m_high &&
           m_low == x.m_low);
    }

    /*!
     * @brief Comparison operator.
     * @param x SequenceNumber_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SequenceNumber_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member high
     * @param _high New value for member high
     */
    eProsima_user_DllExport void high(
            int32_t _high)
    {
        m_high = _high;
    }

    /*!
     * @brief This function returns the value of member high
     * @return Value of member high
     */
    eProsima_user_DllExport int32_t high() const
    {
        return m_high;
    }

    /*!
     * @brief This function returns a reference to member high
     * @return Reference to member high
     */
    eProsima_user_DllExport int32_t& high()
    {
        return m_high;
    }


    /*!
     * @brief This function sets a value in member low
     * @param _low New value for member low
     */
    eProsima_user_DllExport void low(
            uint32_t _low)
    {
        m_low = _low;
    }

    /*!
     * @brief This function returns the value of member low
     * @return Value of member low
     */
    eProsima_user_DllExport uint32_t low() const
    {
        return m_low;
    }

    /*!
     * @brief This function returns a reference to member low
     * @return Reference to member low
     */
    eProsima_user_DllExport uint32_t& low()
    {
        return m_low;
    }



private:

    int32_t m_high{0};
    uint32_t m_low{0};

};
/*!
 * @brief This class represents the structure SampleIdentity_s defined by the user in the IDL file.
 * @ingroup types
 */
class SampleIdentity_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SampleIdentity_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SampleIdentity_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleIdentity_s that will be copied.
     */
    eProsima_user_DllExport SampleIdentity_s(
            const SampleIdentity_s& x)
    {
                    m_writer_guid = x.m_writer_guid;

                    m_sequence_number = x.m_sequence_number;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleIdentity_s that will be copied.
     */
    eProsima_user_DllExport SampleIdentity_s(
            SampleIdentity_s&& x) noexcept
    {
        m_writer_guid = std::move(x.m_writer_guid);
        m_sequence_number = std::move(x.m_sequence_number);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleIdentity_s that will be copied.
     */
    eProsima_user_DllExport SampleIdentity_s& operator =(
            const SampleIdentity_s& x)
    {

                    m_writer_guid = x.m_writer_guid;

                    m_sequence_number = x.m_sequence_number;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleIdentity_s that will be copied.
     */
    eProsima_user_DllExport SampleIdentity_s& operator =(
            SampleIdentity_s&& x) noexcept
    {

        m_writer_guid = std::move(x.m_writer_guid);
        m_sequence_number = std::move(x.m_sequence_number);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentity_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SampleIdentity_s& x) const
    {
        return (m_writer_guid == x.m_writer_guid &&
           m_sequence_number == x.m_sequence_number);
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentity_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SampleIdentity_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member writer_guid
     * @param _writer_guid New value to be copied in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            const GUID_s& _writer_guid)
    {
        m_writer_guid = _writer_guid;
    }

    /*!
     * @brief This function moves the value in member writer_guid
     * @param _writer_guid New value to be moved in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            GUID_s&& _writer_guid)
    {
        m_writer_guid = std::move(_writer_guid);
    }

    /*!
     * @brief This function returns a constant reference to member writer_guid
     * @return Constant reference to member writer_guid
     */
    eProsima_user_DllExport const GUID_s& writer_guid() const
    {
        return m_writer_guid;
    }

    /*!
     * @brief This function returns a reference to member writer_guid
     * @return Reference to member writer_guid
     */
    eProsima_user_DllExport GUID_s& writer_guid()
    {
        return m_writer_guid;
    }


    /*!
     * @brief This function copies the value in member sequence_number
     * @param _sequence_number New value to be copied in member sequence_number
     */
    eProsima_user_DllExport void sequence_number(
            const SequenceNumber_s& _sequence_number)
    {
        m_sequence_number = _sequence_number;
    }

    /*!
     * @brief This function moves the value in member sequence_number
     * @param _sequence_number New value to be moved in member sequence_number
     */
    eProsima_user_DllExport void sequence_number(
            SequenceNumber_s&& _sequence_number)
    {
        m_sequence_number = std::move(_sequence_number);
    }

    /*!
     * @brief This function returns a constant reference to member sequence_number
     * @return Constant reference to member sequence_number
     */
    eProsima_user_DllExport const SequenceNumber_s& sequence_number() const
    {
        return m_sequence_number;
    }

    /*!
     * @brief This function returns a reference to member sequence_number
     * @return Reference to member sequence_number
     */
    eProsima_user_DllExport SequenceNumber_s& sequence_number()
    {
        return m_sequence_number;
    }



private:

    GUID_s m_writer_guid;
    SequenceNumber_s m_sequence_number;

};
/*!
 * @brief This class represents the structure Locator_s defined by the user in the IDL file.
 * @ingroup types
 */
class Locator_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Locator_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Locator_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Locator_s that will be copied.
     */
    eProsima_user_DllExport Locator_s(
            const Locator_s& x)
    {
                    m_kind = x.m_kind;

                    m_port = x.m_port;

                    m_address = x.m_address;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Locator_s that will be copied.
     */
    eProsima_user_DllExport Locator_s(
            Locator_s&& x) noexcept
    {
        m_kind = x.m_kind;
        m_port = x.m_port;
        m_address = std::move(x.m_address);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Locator_s that will be copied.
     */
    eProsima_user_DllExport Locator_s& operator =(
            const Locator_s& x)
    {

                    m_kind = x.m_kind;

                    m_port = x.m_port;

                    m_address = x.m_address;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Locator_s that will be copied.
     */
    eProsima_user_DllExport Locator_s& operator =(
            Locator_s&& x) noexcept
    {

        m_kind = x.m_kind;
        m_port = x.m_port;
        m_address = std::move(x.m_address);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Locator_s& x) const
    {
        return (m_kind == x.m_kind &&
           m_port == x.m_port &&
           m_address == x.m_address);
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Locator_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member kind
     * @param _kind New value for member kind
     */
    eProsima_user_DllExport void kind(
            int32_t _kind)
    {
        m_kind = _kind;
    }

    /*!
     * @brief This function returns the value of member kind
     * @return Value of member kind
     */
    eProsima_user_DllExport int32_t kind() const
    {
        return m_kind;
    }

    /*!
     * @brief This function returns a reference to member kind
     * @return Reference to member kind
     */
    eProsima_user_DllExport int32_t& kind()
    {
        return m_kind;
    }


    /*!
     * @brief This function sets a value in member port
     * @param _port New value for member port
     */
    eProsima_user_DllExport void port(
            uint32_t _port)
    {
        m_port = _port;
    }

    /*!
     * @brief This function returns the value of member port
     * @return Value of member port
     */
    eProsima_user_DllExport uint32_t port() const
    {
        return m_port;
    }

    /*!
     * @brief This function returns a reference to member port
     * @return Reference to member port
     */
    eProsima_user_DllExport uint32_t& port()
    {
        return m_port;
    }


    /*!
     * @brief This function copies the value in member address
     * @param _address New value to be copied in member address
     */
    eProsima_user_DllExport void address(
            const std::array<uint8_t, 16>& _address)
    {
        m_address = _address;
    }

    /*!
     * @brief This function moves the value in member address
     * @param _address New value to be moved in member address
     */
    eProsima_user_DllExport void address(
            std::array<uint8_t, 16>&& _address)
    {
        m_address = std::move(_address);
    }

    /*!
     * @brief This function returns a constant reference to member address
     * @return Constant reference to member address
     */
    eProsima_user_DllExport const std::array<uint8_t, 16>& address() const
    {
        return m_address;
    }

    /*!
     * @brief This function returns a reference to member address
     * @return Reference to member address
     */
    eProsima_user_DllExport std::array<uint8_t, 16>& address()
    {
        return m_address;
    }



private:

    int32_t m_kind{0};
    uint32_t m_port{0};
    std::array<uint8_t, 16> m_address{0};

};

} // namespace detail
/*!
 * @brief This class represents the structure DiscoveryTime defined by the user in the IDL file.
 * @ingroup types
 */
class DiscoveryTime
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DiscoveryTime()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DiscoveryTime()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DiscoveryTime that will be copied.
     */
    eProsima_user_DllExport DiscoveryTime(
            const DiscoveryTime& x)
    {
                    m_local_participant_guid = x.m_local_participant_guid;

                    m_remote_entity_guid = x.m_remote_entity_guid;

                    m_time = x.m_time;

                    m_host = x.m_host;

                    m_user = x.m_user;

                    m_process = x.m_process;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DiscoveryTime that will be copied.
     */
    eProsima_user_DllExport DiscoveryTime(
            DiscoveryTime&& x) noexcept
    {
        m_local_participant_guid = std::move(x.m_local_participant_guid);
        m_remote_entity_guid = std::move(x.m_remote_entity_guid);
        m_time = x.m_time;
        m_host = std::move(x.m_host);
        m_user = std::move(x.m_user);
        m_process = std::move(x.m_process);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DiscoveryTime that will be copied.
     */
    eProsima_user_DllExport DiscoveryTime& operator =(
            const DiscoveryTime& x)
    {

                    m_local_participant_guid = x.m_local_participant_guid;

                    m_remote_entity_guid = x.m_remote_entity_guid;

                    m_time = x.m_time;

                    m_host = x.m_host;

                    m_user = x.m_user;

                    m_process = x.m_process;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DiscoveryTime that will be copied.
     */
    eProsima_user_DllExport DiscoveryTime& operator =(
            DiscoveryTime&& x) noexcept
    {

        m_local_participant_guid = std::move(x.m_local_participant_guid);
        m_remote_entity_guid = std::move(x.m_remote_entity_guid);
        m_time = x.m_time;
        m_host = std::move(x.m_host);
        m_user = std::move(x.m_user);
        m_process = std::move(x.m_process);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DiscoveryTime object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DiscoveryTime& x) const
    {
        return (m_local_participant_guid == x.m_local_participant_guid &&
           m_remote_entity_guid == x.m_remote_entity_guid &&
           m_time == x.m_time &&
           m_host == x.m_host &&
           m_user == x.m_user &&
           m_process == x.m_process);
    }

    /*!
     * @brief Comparison operator.
     * @param x DiscoveryTime object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DiscoveryTime& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member local_participant_guid
     * @param _local_participant_guid New value to be copied in member local_participant_guid
     */
    eProsima_user_DllExport void local_participant_guid(
            const detail::GUID_s& _local_participant_guid)
    {
        m_local_participant_guid = _local_participant_guid;
    }

    /*!
     * @brief This function moves the value in member local_participant_guid
     * @param _local_participant_guid New value to be moved in member local_participant_guid
     */
    eProsima_user_DllExport void local_participant_guid(
            detail::GUID_s&& _local_participant_guid)
    {
        m_local_participant_guid = std::move(_local_participant_guid);
    }

    /*!
     * @brief This function returns a constant reference to member local_participant_guid
     * @return Constant reference to member local_participant_guid
     */
    eProsima_user_DllExport const detail::GUID_s& local_participant_guid() const
    {
        return m_local_participant_guid;
    }

    /*!
     * @brief This function returns a reference to member local_participant_guid
     * @return Reference to member local_participant_guid
     */
    eProsima_user_DllExport detail::GUID_s& local_participant_guid()
    {
        return m_local_participant_guid;
    }


    /*!
     * @brief This function copies the value in member remote_entity_guid
     * @param _remote_entity_guid New value to be copied in member remote_entity_guid
     */
    eProsima_user_DllExport void remote_entity_guid(
            const detail::GUID_s& _remote_entity_guid)
    {
        m_remote_entity_guid = _remote_entity_guid;
    }

    /*!
     * @brief This function moves the value in member remote_entity_guid
     * @param _remote_entity_guid New value to be moved in member remote_entity_guid
     */
    eProsima_user_DllExport void remote_entity_guid(
            detail::GUID_s&& _remote_entity_guid)
    {
        m_remote_entity_guid = std::move(_remote_entity_guid);
    }

    /*!
     * @brief This function returns a constant reference to member remote_entity_guid
     * @return Constant reference to member remote_entity_guid
     */
    eProsima_user_DllExport const detail::GUID_s& remote_entity_guid() const
    {
        return m_remote_entity_guid;
    }

    /*!
     * @brief This function returns a reference to member remote_entity_guid
     * @return Reference to member remote_entity_guid
     */
    eProsima_user_DllExport detail::GUID_s& remote_entity_guid()
    {
        return m_remote_entity_guid;
    }


    /*!
     * @brief This function sets a value in member time
     * @param _time New value for member time
     */
    eProsima_user_DllExport void time(
            uint64_t _time)
    {
        m_time = _time;
    }

    /*!
     * @brief This function returns the value of member time
     * @return Value of member time
     */
    eProsima_user_DllExport uint64_t time() const
    {
        return m_time;
    }

    /*!
     * @brief This function returns a reference to member time
     * @return Reference to member time
     */
    eProsima_user_DllExport uint64_t& time()
    {
        return m_time;
    }


    /*!
     * @brief This function copies the value in member host
     * @param _host New value to be copied in member host
     */
    eProsima_user_DllExport void host(
            const std::string& _host)
    {
        m_host = _host;
    }

    /*!
     * @brief This function moves the value in member host
     * @param _host New value to be moved in member host
     */
    eProsima_user_DllExport void host(
            std::string&& _host)
    {
        m_host = std::move(_host);
    }

    /*!
     * @brief This function returns a constant reference to member host
     * @return Constant reference to member host
     */
    eProsima_user_DllExport const std::string& host() const
    {
        return m_host;
    }

    /*!
     * @brief This function returns a reference to member host
     * @return Reference to member host
     */
    eProsima_user_DllExport std::string& host()
    {
        return m_host;
    }


    /*!
     * @brief This function copies the value in member user
     * @param _user New value to be copied in member user
     */
    eProsima_user_DllExport void user(
            const std::string& _user)
    {
        m_user = _user;
    }

    /*!
     * @brief This function moves the value in member user
     * @param _user New value to be moved in member user
     */
    eProsima_user_DllExport void user(
            std::string&& _user)
    {
        m_user = std::move(_user);
    }

    /*!
     * @brief This function returns a constant reference to member user
     * @return Constant reference to member user
     */
    eProsima_user_DllExport const std::string& user() const
    {
        return m_user;
    }

    /*!
     * @brief This function returns a reference to member user
     * @return Reference to member user
     */
    eProsima_user_DllExport std::string& user()
    {
        return m_user;
    }


    /*!
     * @brief This function copies the value in member process
     * @param _process New value to be copied in member process
     */
    eProsima_user_DllExport void process(
            const std::string& _process)
    {
        m_process = _process;
    }

    /*!
     * @brief This function moves the value in member process
     * @param _process New value to be moved in member process
     */
    eProsima_user_DllExport void process(
            std::string&& _process)
    {
        m_process = std::move(_process);
    }

    /*!
     * @brief This function returns a constant reference to member process
     * @return Constant reference to member process
     */
    eProsima_user_DllExport const std::string& process() const
    {
        return m_process;
    }

    /*!
     * @brief This function returns a reference to member process
     * @return Reference to member process
     */
    eProsima_user_DllExport std::string& process()
    {
        return m_process;
    }



private:

    detail::GUID_s m_local_participant_guid;
    detail::GUID_s m_remote_entity_guid;
    uint64_t m_time{0};
    std::string m_host;
    std::string m_user;
    std::string m_process;

};
/*!
 * @brief This class represents the structure EntityCount defined by the user in the IDL file.
 * @ingroup types
 */
class EntityCount
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityCount()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityCount()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityCount that will be copied.
     */
    eProsima_user_DllExport EntityCount(
            const EntityCount& x)
    {
                    m_guid = x.m_guid;

                    m_count = x.m_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityCount that will be copied.
     */
    eProsima_user_DllExport EntityCount(
            EntityCount&& x) noexcept
    {
        m_guid = std::move(x.m_guid);
        m_count = x.m_count;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityCount that will be copied.
     */
    eProsima_user_DllExport EntityCount& operator =(
            const EntityCount& x)
    {

                    m_guid = x.m_guid;

                    m_count = x.m_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityCount that will be copied.
     */
    eProsima_user_DllExport EntityCount& operator =(
            EntityCount&& x) noexcept
    {

        m_guid = std::move(x.m_guid);
        m_count = x.m_count;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityCount object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityCount& x) const
    {
        return (m_guid == x.m_guid &&
           m_count == x.m_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityCount object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityCount& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member guid
     * @param _guid New value to be copied in member guid
     */
    eProsima_user_DllExport void guid(
            const detail::GUID_s& _guid)
    {
        m_guid = _guid;
    }

    /*!
     * @brief This function moves the value in member guid
     * @param _guid New value to be moved in member guid
     */
    eProsima_user_DllExport void guid(
            detail::GUID_s&& _guid)
    {
        m_guid = std::move(_guid);
    }

    /*!
     * @brief This function returns a constant reference to member guid
     * @return Constant reference to member guid
     */
    eProsima_user_DllExport const detail::GUID_s& guid() const
    {
        return m_guid;
    }

    /*!
     * @brief This function returns a reference to member guid
     * @return Reference to member guid
     */
    eProsima_user_DllExport detail::GUID_s& guid()
    {
        return m_guid;
    }


    /*!
     * @brief This function sets a value in member count
     * @param _count New value for member count
     */
    eProsima_user_DllExport void count(
            uint64_t _count)
    {
        m_count = _count;
    }

    /*!
     * @brief This function returns the value of member count
     * @return Value of member count
     */
    eProsima_user_DllExport uint64_t count() const
    {
        return m_count;
    }

    /*!
     * @brief This function returns a reference to member count
     * @return Reference to member count
     */
    eProsima_user_DllExport uint64_t& count()
    {
        return m_count;
    }



private:

    detail::GUID_s m_guid;
    uint64_t m_count{0};

};
/*!
 * @brief This class represents the structure SampleIdentityCount defined by the user in the IDL file.
 * @ingroup types
 */
class SampleIdentityCount
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport SampleIdentityCount()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~SampleIdentityCount()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object SampleIdentityCount that will be copied.
     */
    eProsima_user_DllExport SampleIdentityCount(
            const SampleIdentityCount& x)
    {
                    m_sample_id = x.m_sample_id;

                    m_count = x.m_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object SampleIdentityCount that will be copied.
     */
    eProsima_user_DllExport SampleIdentityCount(
            SampleIdentityCount&& x) noexcept
    {
        m_sample_id = std::move(x.m_sample_id);
        m_count = x.m_count;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object SampleIdentityCount that will be copied.
     */
    eProsima_user_DllExport SampleIdentityCount& operator =(
            const SampleIdentityCount& x)
    {

                    m_sample_id = x.m_sample_id;

                    m_count = x.m_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object SampleIdentityCount that will be copied.
     */
    eProsima_user_DllExport SampleIdentityCount& operator =(
            SampleIdentityCount&& x) noexcept
    {

        m_sample_id = std::move(x.m_sample_id);
        m_count = x.m_count;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentityCount object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const SampleIdentityCount& x) const
    {
        return (m_sample_id == x.m_sample_id &&
           m_count == x.m_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x SampleIdentityCount object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const SampleIdentityCount& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member sample_id
     * @param _sample_id New value to be copied in member sample_id
     */
    eProsima_user_DllExport void sample_id(
            const detail::SampleIdentity_s& _sample_id)
    {
        m_sample_id = _sample_id;
    }

    /*!
     * @brief This function moves the value in member sample_id
     * @param _sample_id New value to be moved in member sample_id
     */
    eProsima_user_DllExport void sample_id(
            detail::SampleIdentity_s&& _sample_id)
    {
        m_sample_id = std::move(_sample_id);
    }

    /*!
     * @brief This function returns a constant reference to member sample_id
     * @return Constant reference to member sample_id
     */
    eProsima_user_DllExport const detail::SampleIdentity_s& sample_id() const
    {
        return m_sample_id;
    }

    /*!
     * @brief This function returns a reference to member sample_id
     * @return Reference to member sample_id
     */
    eProsima_user_DllExport detail::SampleIdentity_s& sample_id()
    {
        return m_sample_id;
    }


    /*!
     * @brief This function sets a value in member count
     * @param _count New value for member count
     */
    eProsima_user_DllExport void count(
            uint64_t _count)
    {
        m_count = _count;
    }

    /*!
     * @brief This function returns the value of member count
     * @return Value of member count
     */
    eProsima_user_DllExport uint64_t count() const
    {
        return m_count;
    }

    /*!
     * @brief This function returns a reference to member count
     * @return Reference to member count
     */
    eProsima_user_DllExport uint64_t& count()
    {
        return m_count;
    }



private:

    detail::SampleIdentity_s m_sample_id;
    uint64_t m_count{0};

};
/*!
 * @brief This class represents the structure Entity2LocatorTraffic defined by the user in the IDL file.
 * @ingroup types
 */
class Entity2LocatorTraffic
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Entity2LocatorTraffic()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Entity2LocatorTraffic()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Entity2LocatorTraffic that will be copied.
     */
    eProsima_user_DllExport Entity2LocatorTraffic(
            const Entity2LocatorTraffic& x)
    {
                    m_src_guid = x.m_src_guid;

                    m_dst_locator = x.m_dst_locator;

                    m_packet_count = x.m_packet_count;

                    m_byte_count = x.m_byte_count;

                    m_byte_magnitude_order = x.m_byte_magnitude_order;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Entity2LocatorTraffic that will be copied.
     */
    eProsima_user_DllExport Entity2LocatorTraffic(
            Entity2LocatorTraffic&& x) noexcept
    {
        m_src_guid = std::move(x.m_src_guid);
        m_dst_locator = std::move(x.m_dst_locator);
        m_packet_count = x.m_packet_count;
        m_byte_count = x.m_byte_count;
        m_byte_magnitude_order = x.m_byte_magnitude_order;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Entity2LocatorTraffic that will be copied.
     */
    eProsima_user_DllExport Entity2LocatorTraffic& operator =(
            const Entity2LocatorTraffic& x)
    {

                    m_src_guid = x.m_src_guid;

                    m_dst_locator = x.m_dst_locator;

                    m_packet_count = x.m_packet_count;

                    m_byte_count = x.m_byte_count;

                    m_byte_magnitude_order = x.m_byte_magnitude_order;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Entity2LocatorTraffic that will be copied.
     */
    eProsima_user_DllExport Entity2LocatorTraffic& operator =(
            Entity2LocatorTraffic&& x) noexcept
    {

        m_src_guid = std::move(x.m_src_guid);
        m_dst_locator = std::move(x.m_dst_locator);
        m_packet_count = x.m_packet_count;
        m_byte_count = x.m_byte_count;
        m_byte_magnitude_order = x.m_byte_magnitude_order;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Entity2LocatorTraffic object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Entity2LocatorTraffic& x) const
    {
        return (m_src_guid == x.m_src_guid &&
           m_dst_locator == x.m_dst_locator &&
           m_packet_count == x.m_packet_count &&
           m_byte_count == x.m_byte_count &&
           m_byte_magnitude_order == x.m_byte_magnitude_order);
    }

    /*!
     * @brief Comparison operator.
     * @param x Entity2LocatorTraffic object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Entity2LocatorTraffic& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member src_guid
     * @param _src_guid New value to be copied in member src_guid
     */
    eProsima_user_DllExport void src_guid(
            const detail::GUID_s& _src_guid)
    {
        m_src_guid = _src_guid;
    }

    /*!
     * @brief This function moves the value in member src_guid
     * @param _src_guid New value to be moved in member src_guid
     */
    eProsima_user_DllExport void src_guid(
            detail::GUID_s&& _src_guid)
    {
        m_src_guid = std::move(_src_guid);
    }

    /*!
     * @brief This function returns a constant reference to member src_guid
     * @return Constant reference to member src_guid
     */
    eProsima_user_DllExport const detail::GUID_s& src_guid() const
    {
        return m_src_guid;
    }

    /*!
     * @brief This function returns a reference to member src_guid
     * @return Reference to member src_guid
     */
    eProsima_user_DllExport detail::GUID_s& src_guid()
    {
        return m_src_guid;
    }


    /*!
     * @brief This function copies the value in member dst_locator
     * @param _dst_locator New value to be copied in member dst_locator
     */
    eProsima_user_DllExport void dst_locator(
            const detail::Locator_s& _dst_locator)
    {
        m_dst_locator = _dst_locator;
    }

    /*!
     * @brief This function moves the value in member dst_locator
     * @param _dst_locator New value to be moved in member dst_locator
     */
    eProsima_user_DllExport void dst_locator(
            detail::Locator_s&& _dst_locator)
    {
        m_dst_locator = std::move(_dst_locator);
    }

    /*!
     * @brief This function returns a constant reference to member dst_locator
     * @return Constant reference to member dst_locator
     */
    eProsima_user_DllExport const detail::Locator_s& dst_locator() const
    {
        return m_dst_locator;
    }

    /*!
     * @brief This function returns a reference to member dst_locator
     * @return Reference to member dst_locator
     */
    eProsima_user_DllExport detail::Locator_s& dst_locator()
    {
        return m_dst_locator;
    }


    /*!
     * @brief This function sets a value in member packet_count
     * @param _packet_count New value for member packet_count
     */
    eProsima_user_DllExport void packet_count(
            uint64_t _packet_count)
    {
        m_packet_count = _packet_count;
    }

    /*!
     * @brief This function returns the value of member packet_count
     * @return Value of member packet_count
     */
    eProsima_user_DllExport uint64_t packet_count() const
    {
        return m_packet_count;
    }

    /*!
     * @brief This function returns a reference to member packet_count
     * @return Reference to member packet_count
     */
    eProsima_user_DllExport uint64_t& packet_count()
    {
        return m_packet_count;
    }


    /*!
     * @brief This function sets a value in member byte_count
     * @param _byte_count New value for member byte_count
     */
    eProsima_user_DllExport void byte_count(
            uint64_t _byte_count)
    {
        m_byte_count = _byte_count;
    }

    /*!
     * @brief This function returns the value of member byte_count
     * @return Value of member byte_count
     */
    eProsima_user_DllExport uint64_t byte_count() const
    {
        return m_byte_count;
    }

    /*!
     * @brief This function returns a reference to member byte_count
     * @return Reference to member byte_count
     */
    eProsima_user_DllExport uint64_t& byte_count()
    {
        return m_byte_count;
    }


    /*!
     * @brief This function sets a value in member byte_magnitude_order
     * @param _byte_magnitude_order New value for member byte_magnitude_order
     */
    eProsima_user_DllExport void byte_magnitude_order(
            int16_t _byte_magnitude_order)
    {
        m_byte_magnitude_order = _byte_magnitude_order;
    }

    /*!
     * @brief This function returns the value of member byte_magnitude_order
     * @return Value of member byte_magnitude_order
     */
    eProsima_user_DllExport int16_t byte_magnitude_order() const
    {
        return m_byte_magnitude_order;
    }

    /*!
     * @brief This function returns a reference to member byte_magnitude_order
     * @return Reference to member byte_magnitude_order
     */
    eProsima_user_DllExport int16_t& byte_magnitude_order()
    {
        return m_byte_magnitude_order;
    }



private:

    detail::GUID_s m_src_guid;
    detail::Locator_s m_dst_locator;
    uint64_t m_packet_count{0};
    uint64_t m_byte_count{0};
    int16_t m_byte_magnitude_order{0};

};
/*!
 * @brief This class represents the structure WriterReaderData defined by the user in the IDL file.
 * @ingroup types
 */
class WriterReaderData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport WriterReaderData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~WriterReaderData()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object WriterReaderData that will be copied.
     */
    eProsima_user_DllExport WriterReaderData(
            const WriterReaderData& x)
    {
                    m_writer_guid = x.m_writer_guid;

                    m_reader_guid = x.m_reader_guid;

                    m_data = x.m_data;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object WriterReaderData that will be copied.
     */
    eProsima_user_DllExport WriterReaderData(
            WriterReaderData&& x) noexcept
    {
        m_writer_guid = std::move(x.m_writer_guid);
        m_reader_guid = std::move(x.m_reader_guid);
        m_data = x.m_data;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object WriterReaderData that will be copied.
     */
    eProsima_user_DllExport WriterReaderData& operator =(
            const WriterReaderData& x)
    {

                    m_writer_guid = x.m_writer_guid;

                    m_reader_guid = x.m_reader_guid;

                    m_data = x.m_data;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object WriterReaderData that will be copied.
     */
    eProsima_user_DllExport WriterReaderData& operator =(
            WriterReaderData&& x) noexcept
    {

        m_writer_guid = std::move(x.m_writer_guid);
        m_reader_guid = std::move(x.m_reader_guid);
        m_data = x.m_data;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x WriterReaderData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const WriterReaderData& x) const
    {
        return (m_writer_guid == x.m_writer_guid &&
           m_reader_guid == x.m_reader_guid &&
           m_data == x.m_data);
    }

    /*!
     * @brief Comparison operator.
     * @param x WriterReaderData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const WriterReaderData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member writer_guid
     * @param _writer_guid New value to be copied in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            const detail::GUID_s& _writer_guid)
    {
        m_writer_guid = _writer_guid;
    }

    /*!
     * @brief This function moves the value in member writer_guid
     * @param _writer_guid New value to be moved in member writer_guid
     */
    eProsima_user_DllExport void writer_guid(
            detail::GUID_s&& _writer_guid)
    {
        m_writer_guid = std::move(_writer_guid);
    }

    /*!
     * @brief This function returns a constant reference to member writer_guid
     * @return Constant reference to member writer_guid
     */
    eProsima_user_DllExport const detail::GUID_s& writer_guid() const
    {
        return m_writer_guid;
    }

    /*!
     * @brief This function returns a reference to member writer_guid
     * @return Reference to member writer_guid
     */
    eProsima_user_DllExport detail::GUID_s& writer_guid()
    {
        return m_writer_guid;
    }


    /*!
     * @brief This function copies the value in member reader_guid
     * @param _reader_guid New value to be copied in member reader_guid
     */
    eProsima_user_DllExport void reader_guid(
            const detail::GUID_s& _reader_guid)
    {
        m_reader_guid = _reader_guid;
    }

    /*!
     * @brief This function moves the value in member reader_guid
     * @param _reader_guid New value to be moved in member reader_guid
     */
    eProsima_user_DllExport void reader_guid(
            detail::GUID_s&& _reader_guid)
    {
        m_reader_guid = std::move(_reader_guid);
    }

    /*!
     * @brief This function returns a constant reference to member reader_guid
     * @return Constant reference to member reader_guid
     */
    eProsima_user_DllExport const detail::GUID_s& reader_guid() const
    {
        return m_reader_guid;
    }

    /*!
     * @brief This function returns a reference to member reader_guid
     * @return Reference to member reader_guid
     */
    eProsima_user_DllExport detail::GUID_s& reader_guid()
    {
        return m_reader_guid;
    }


    /*!
     * @brief This function sets a value in member data
     * @param _data New value for member data
     */
    eProsima_user_DllExport void data(
            float _data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function returns the value of member data
     * @return Value of member data
     */
    eProsima_user_DllExport float data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport float& data()
    {
        return m_data;
    }



private:

    detail::GUID_s m_writer_guid;
    detail::GUID_s m_reader_guid;
    float m_data{0.0};

};
/*!
 * @brief This class represents the structure Locator2LocatorData defined by the user in the IDL file.
 * @ingroup types
 */
class Locator2LocatorData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Locator2LocatorData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Locator2LocatorData()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Locator2LocatorData that will be copied.
     */
    eProsima_user_DllExport Locator2LocatorData(
            const Locator2LocatorData& x)
    {
                    m_src_locator = x.m_src_locator;

                    m_dst_locator = x.m_dst_locator;

                    m_data = x.m_data;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Locator2LocatorData that will be copied.
     */
    eProsima_user_DllExport Locator2LocatorData(
            Locator2LocatorData&& x) noexcept
    {
        m_src_locator = std::move(x.m_src_locator);
        m_dst_locator = std::move(x.m_dst_locator);
        m_data = x.m_data;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Locator2LocatorData that will be copied.
     */
    eProsima_user_DllExport Locator2LocatorData& operator =(
            const Locator2LocatorData& x)
    {

                    m_src_locator = x.m_src_locator;

                    m_dst_locator = x.m_dst_locator;

                    m_data = x.m_data;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Locator2LocatorData that will be copied.
     */
    eProsima_user_DllExport Locator2LocatorData& operator =(
            Locator2LocatorData&& x) noexcept
    {

        m_src_locator = std::move(x.m_src_locator);
        m_dst_locator = std::move(x.m_dst_locator);
        m_data = x.m_data;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator2LocatorData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Locator2LocatorData& x) const
    {
        return (m_src_locator == x.m_src_locator &&
           m_dst_locator == x.m_dst_locator &&
           m_data == x.m_data);
    }

    /*!
     * @brief Comparison operator.
     * @param x Locator2LocatorData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Locator2LocatorData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member src_locator
     * @param _src_locator New value to be copied in member src_locator
     */
    eProsima_user_DllExport void src_locator(
            const detail::Locator_s& _src_locator)
    {
        m_src_locator = _src_locator;
    }

    /*!
     * @brief This function moves the value in member src_locator
     * @param _src_locator New value to be moved in member src_locator
     */
    eProsima_user_DllExport void src_locator(
            detail::Locator_s&& _src_locator)
    {
        m_src_locator = std::move(_src_locator);
    }

    /*!
     * @brief This function returns a constant reference to member src_locator
     * @return Constant reference to member src_locator
     */
    eProsima_user_DllExport const detail::Locator_s& src_locator() const
    {
        return m_src_locator;
    }

    /*!
     * @brief This function returns a reference to member src_locator
     * @return Reference to member src_locator
     */
    eProsima_user_DllExport detail::Locator_s& src_locator()
    {
        return m_src_locator;
    }


    /*!
     * @brief This function copies the value in member dst_locator
     * @param _dst_locator New value to be copied in member dst_locator
     */
    eProsima_user_DllExport void dst_locator(
            const detail::Locator_s& _dst_locator)
    {
        m_dst_locator = _dst_locator;
    }

    /*!
     * @brief This function moves the value in member dst_locator
     * @param _dst_locator New value to be moved in member dst_locator
     */
    eProsima_user_DllExport void dst_locator(
            detail::Locator_s&& _dst_locator)
    {
        m_dst_locator = std::move(_dst_locator);
    }

    /*!
     * @brief This function returns a constant reference to member dst_locator
     * @return Constant reference to member dst_locator
     */
    eProsima_user_DllExport const detail::Locator_s& dst_locator() const
    {
        return m_dst_locator;
    }

    /*!
     * @brief This function returns a reference to member dst_locator
     * @return Reference to member dst_locator
     */
    eProsima_user_DllExport detail::Locator_s& dst_locator()
    {
        return m_dst_locator;
    }


    /*!
     * @brief This function sets a value in member data
     * @param _data New value for member data
     */
    eProsima_user_DllExport void data(
            float _data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function returns the value of member data
     * @return Value of member data
     */
    eProsima_user_DllExport float data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport float& data()
    {
        return m_data;
    }



private:

    detail::Locator_s m_src_locator;
    detail::Locator_s m_dst_locator;
    float m_data{0.0};

};
/*!
 * @brief This class represents the structure EntityData defined by the user in the IDL file.
 * @ingroup types
 */
class EntityData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EntityData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EntityData()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EntityData that will be copied.
     */
    eProsima_user_DllExport EntityData(
            const EntityData& x)
    {
                    m_guid = x.m_guid;

                    m_data = x.m_data;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EntityData that will be copied.
     */
    eProsima_user_DllExport EntityData(
            EntityData&& x) noexcept
    {
        m_guid = std::move(x.m_guid);
        m_data = x.m_data;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EntityData that will be copied.
     */
    eProsima_user_DllExport EntityData& operator =(
            const EntityData& x)
    {

                    m_guid = x.m_guid;

                    m_data = x.m_data;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EntityData that will be copied.
     */
    eProsima_user_DllExport EntityData& operator =(
            EntityData&& x) noexcept
    {

        m_guid = std::move(x.m_guid);
        m_data = x.m_data;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EntityData& x) const
    {
        return (m_guid == x.m_guid &&
           m_data == x.m_data);
    }

    /*!
     * @brief Comparison operator.
     * @param x EntityData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EntityData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member guid
     * @param _guid New value to be copied in member guid
     */
    eProsima_user_DllExport void guid(
            const detail::GUID_s& _guid)
    {
        m_guid = _guid;
    }

    /*!
     * @brief This function moves the value in member guid
     * @param _guid New value to be moved in member guid
     */
    eProsima_user_DllExport void guid(
            detail::GUID_s&& _guid)
    {
        m_guid = std::move(_guid);
    }

    /*!
     * @brief This function returns a constant reference to member guid
     * @return Constant reference to member guid
     */
    eProsima_user_DllExport const detail::GUID_s& guid() const
    {
        return m_guid;
    }

    /*!
     * @brief This function returns a reference to member guid
     * @return Reference to member guid
     */
    eProsima_user_DllExport detail::GUID_s& guid()
    {
        return m_guid;
    }


    /*!
     * @brief This function sets a value in member data
     * @param _data New value for member data
     */
    eProsima_user_DllExport void data(
            float _data)
    {
        m_data = _data;
    }

    /*!
     * @brief This function returns the value of member data
     * @return Value of member data
     */
    eProsima_user_DllExport float data() const
    {
        return m_data;
    }

    /*!
     * @brief This function returns a reference to member data
     * @return Reference to member data
     */
    eProsima_user_DllExport float& data()
    {
        return m_data;
    }



private:

    detail::GUID_s m_guid;
    float m_data{0.0};

};
/*!
 * @brief This class represents the structure PhysicalData defined by the user in the IDL file.
 * @ingroup types
 */
class PhysicalData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PhysicalData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PhysicalData()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PhysicalData that will be copied.
     */
    eProsima_user_DllExport PhysicalData(
            const PhysicalData& x)
    {
                    m_participant_guid = x.m_participant_guid;

                    m_host = x.m_host;

                    m_user = x.m_user;

                    m_process = x.m_process;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PhysicalData that will be copied.
     */
    eProsima_user_DllExport PhysicalData(
            PhysicalData&& x) noexcept
    {
        m_participant_guid = std::move(x.m_participant_guid);
        m_host = std::move(x.m_host);
        m_user = std::move(x.m_user);
        m_process = std::move(x.m_process);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PhysicalData that will be copied.
     */
    eProsima_user_DllExport PhysicalData& operator =(
            const PhysicalData& x)
    {

                    m_participant_guid = x.m_participant_guid;

                    m_host = x.m_host;

                    m_user = x.m_user;

                    m_process = x.m_process;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PhysicalData that will be copied.
     */
    eProsima_user_DllExport PhysicalData& operator =(
            PhysicalData&& x) noexcept
    {

        m_participant_guid = std::move(x.m_participant_guid);
        m_host = std::move(x.m_host);
        m_user = std::move(x.m_user);
        m_process = std::move(x.m_process);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PhysicalData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PhysicalData& x) const
    {
        return (m_participant_guid == x.m_participant_guid &&
           m_host == x.m_host &&
           m_user == x.m_user &&
           m_process == x.m_process);
    }

    /*!
     * @brief Comparison operator.
     * @param x PhysicalData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PhysicalData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member participant_guid
     * @param _participant_guid New value to be copied in member participant_guid
     */
    eProsima_user_DllExport void participant_guid(
            const detail::GUID_s& _participant_guid)
    {
        m_participant_guid = _participant_guid;
    }

    /*!
     * @brief This function moves the value in member participant_guid
     * @param _participant_guid New value to be moved in member participant_guid
     */
    eProsima_user_DllExport void participant_guid(
            detail::GUID_s&& _participant_guid)
    {
        m_participant_guid = std::move(_participant_guid);
    }

    /*!
     * @brief This function returns a constant reference to member participant_guid
     * @return Constant reference to member participant_guid
     */
    eProsima_user_DllExport const detail::GUID_s& participant_guid() const
    {
        return m_participant_guid;
    }

    /*!
     * @brief This function returns a reference to member participant_guid
     * @return Reference to member participant_guid
     */
    eProsima_user_DllExport detail::GUID_s& participant_guid()
    {
        return m_participant_guid;
    }


    /*!
     * @brief This function copies the value in member host
     * @param _host New value to be copied in member host
     */
    eProsima_user_DllExport void host(
            const std::string& _host)
    {
        m_host = _host;
    }

    /*!
     * @brief This function moves the value in member host
     * @param _host New value to be moved in member host
     */
    eProsima_user_DllExport void host(
            std::string&& _host)
    {
        m_host = std::move(_host);
    }

    /*!
     * @brief This function returns a constant reference to member host
     * @return Constant reference to member host
     */
    eProsima_user_DllExport const std::string& host() const
    {
        return m_host;
    }

    /*!
     * @brief This function returns a reference to member host
     * @return Reference to member host
     */
    eProsima_user_DllExport std::string& host()
    {
        return m_host;
    }


    /*!
     * @brief This function copies the value in member user
     * @param _user New value to be copied in member user
     */
    eProsima_user_DllExport void user(
            const std::string& _user)
    {
        m_user = _user;
    }

    /*!
     * @brief This function moves the value in member user
     * @param _user New value to be moved in member user
     */
    eProsima_user_DllExport void user(
            std::string&& _user)
    {
        m_user = std::move(_user);
    }

    /*!
     * @brief This function returns a constant reference to member user
     * @return Constant reference to member user
     */
    eProsima_user_DllExport const std::string& user() const
    {
        return m_user;
    }

    /*!
     * @brief This function returns a reference to member user
     * @return Reference to member user
     */
    eProsima_user_DllExport std::string& user()
    {
        return m_user;
    }


    /*!
     * @brief This function copies the value in member process
     * @param _process New value to be copied in member process
     */
    eProsima_user_DllExport void process(
            const std::string& _process)
    {
        m_process = _process;
    }

    /*!
     * @brief This function moves the value in member process
     * @param _process New value to be moved in member process
     */
    eProsima_user_DllExport void process(
            std::string&& _process)
    {
        m_process = std::move(_process);
    }

    /*!
     * @brief This function returns a constant reference to member process
     * @return Constant reference to member process
     */
    eProsima_user_DllExport const std::string& process() const
    {
        return m_process;
    }

    /*!
     * @brief This function returns a reference to member process
     * @return Reference to member process
     */
    eProsima_user_DllExport std::string& process()
    {
        return m_process;
    }



private:

    detail::GUID_s m_participant_guid;
    std::string m_host;
    std::string m_user;
    std::string m_process;

};
namespace EventKind {

const uint32_t HISTORY2HISTORY_LATENCY = 0x1;
const uint32_t NETWORK_LATENCY = 0x2;
const uint32_t PUBLICATION_THROUGHPUT = 0x4;
const uint32_t SUBSCRIPTION_THROUGHPUT = 0x8;
const uint32_t RTPS_SENT = 0x10;
const uint32_t RTPS_LOST = 0x20;
const uint32_t RESENT_DATAS = 0x40;
const uint32_t HEARTBEAT_COUNT = 0x80;
const uint32_t ACKNACK_COUNT = 0x100;
const uint32_t NACKFRAG_COUNT = 0x200;
const uint32_t GAP_COUNT = 0x400;
const uint32_t DATA_COUNT = 0x800;
const uint32_t PDP_PACKETS = 0x1000;
const uint32_t EDP_PACKETS = 0x2000;
const uint32_t DISCOVERED_ENTITY = 0x4000;
const uint32_t SAMPLE_DATAS = 0x8000;
const uint32_t PHYSICAL_DATA = 0x10000;

} // namespace EventKind
/*!
 * @brief This class represents the union Data defined by the user in the IDL file.
 * @ingroup types
 */
class Data
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Data()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Data()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Data that will be copied.
     */
    eProsima_user_DllExport Data(
            const Data& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            writer_reader_data_() = x.m_writer_reader_data;
                            break;

                        case 0x00000002:
                            locator2locator_data_() = x.m_locator2locator_data;
                            break;

                        case 0x00000003:
                            entity_data_() = x.m_entity_data;
                            break;

                        case 0x00000004:
                            entity2locator_traffic_() = x.m_entity2locator_traffic;
                            break;

                        case 0x00000005:
                            entity_count_() = x.m_entity_count;
                            break;

                        case 0x00000006:
                            discovery_time_() = x.m_discovery_time;
                            break;

                        case 0x00000007:
                            sample_identity_count_() = x.m_sample_identity_count;
                            break;

                        case 0x00000008:
                            physical_data_() = x.m_physical_data;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Data that will be copied.
     */
    eProsima_user_DllExport Data(
            Data&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            writer_reader_data_() = std::move(x.m_writer_reader_data);
                            break;

                        case 0x00000002:
                            locator2locator_data_() = std::move(x.m_locator2locator_data);
                            break;

                        case 0x00000003:
                            entity_data_() = std::move(x.m_entity_data);
                            break;

                        case 0x00000004:
                            entity2locator_traffic_() = std::move(x.m_entity2locator_traffic);
                            break;

                        case 0x00000005:
                            entity_count_() = std::move(x.m_entity_count);
                            break;

                        case 0x00000006:
                            discovery_time_() = std::move(x.m_discovery_time);
                            break;

                        case 0x00000007:
                            sample_identity_count_() = std::move(x.m_sample_identity_count);
                            break;

                        case 0x00000008:
                            physical_data_() = std::move(x.m_physical_data);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Data that will be copied.
     */
    eProsima_user_DllExport Data& operator =(
            const Data& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            writer_reader_data_() = x.m_writer_reader_data;
                            break;

                        case 0x00000002:
                            locator2locator_data_() = x.m_locator2locator_data;
                            break;

                        case 0x00000003:
                            entity_data_() = x.m_entity_data;
                            break;

                        case 0x00000004:
                            entity2locator_traffic_() = x.m_entity2locator_traffic;
                            break;

                        case 0x00000005:
                            entity_count_() = x.m_entity_count;
                            break;

                        case 0x00000006:
                            discovery_time_() = x.m_discovery_time;
                            break;

                        case 0x00000007:
                            sample_identity_count_() = x.m_sample_identity_count;
                            break;

                        case 0x00000008:
                            physical_data_() = x.m_physical_data;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Data that will be copied.
     */
    eProsima_user_DllExport Data& operator =(
            Data&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            writer_reader_data_() = std::move(x.m_writer_reader_data);
                            break;

                        case 0x00000002:
                            locator2locator_data_() = std::move(x.m_locator2locator_data);
                            break;

                        case 0x00000003:
                            entity_data_() = std::move(x.m_entity_data);
                            break;

                        case 0x00000004:
                            entity2locator_traffic_() = std::move(x.m_entity2locator_traffic);
                            break;

                        case 0x00000005:
                            entity_count_() = std::move(x.m_entity_count);
                            break;

                        case 0x00000006:
                            discovery_time_() = std::move(x.m_discovery_time);
                            break;

                        case 0x00000007:
                            sample_identity_count_() = std::move(x.m_sample_identity_count);
                            break;

                        case 0x00000008:
                            physical_data_() = std::move(x.m_physical_data);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Data object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Data& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_writer_reader_data == m_writer_reader_data);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_locator2locator_data == m_locator2locator_data);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_entity_data == m_entity_data);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_entity2locator_traffic == m_entity2locator_traffic);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_entity_count == m_entity_count);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_discovery_time == m_discovery_time);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_sample_identity_count == m_sample_identity_count);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_physical_data == m_physical_data);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x Data object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Data& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint32_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case EventKind::HISTORY2HISTORY_LATENCY:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::NETWORK_LATENCY:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::PUBLICATION_THROUGHPUT:
                        case EventKind::SUBSCRIPTION_THROUGHPUT:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::RTPS_SENT:
                        case EventKind::RTPS_LOST:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::RESENT_DATAS:
                        case EventKind::HEARTBEAT_COUNT:
                        case EventKind::ACKNACK_COUNT:
                        case EventKind::NACKFRAG_COUNT:
                        case EventKind::GAP_COUNT:
                        case EventKind::DATA_COUNT:
                        case EventKind::PDP_PACKETS:
                        case EventKind::EDP_PACKETS:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::DISCOVERED_ENTITY:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::SAMPLE_DATAS:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EventKind::PHYSICAL_DATA:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint32_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member writer_reader_data
     * @param _writer_reader_data New value to be copied in member writer_reader_data
     */
    eProsima_user_DllExport void writer_reader_data(
            const WriterReaderData& _writer_reader_data)
    {
        writer_reader_data_() = _writer_reader_data;
        m__d = EventKind::HISTORY2HISTORY_LATENCY;
    }

    /*!
     * @brief This function moves the value in member writer_reader_data
     * @param _writer_reader_data New value to be moved in member writer_reader_data
     */
    eProsima_user_DllExport void writer_reader_data(
            WriterReaderData&& _writer_reader_data)
    {
        writer_reader_data_() = _writer_reader_data;
        m__d = EventKind::HISTORY2HISTORY_LATENCY;
    }

    /*!
     * @brief This function returns a constant reference to member writer_reader_data
     * @return Constant reference to member writer_reader_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const WriterReaderData& writer_reader_data() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_writer_reader_data;
    }

    /*!
     * @brief This function returns a reference to member writer_reader_data
     * @return Reference to member writer_reader_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport WriterReaderData& writer_reader_data()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_writer_reader_data;
    }


    /*!
     * @brief This function copies the value in member locator2locator_data
     * @param _locator2locator_data New value to be copied in member locator2locator_data
     */
    eProsima_user_DllExport void locator2locator_data(
            const Locator2LocatorData& _locator2locator_data)
    {
        locator2locator_data_() = _locator2locator_data;
        m__d = EventKind::NETWORK_LATENCY;
    }

    /*!
     * @brief This function moves the value in member locator2locator_data
     * @param _locator2locator_data New value to be moved in member locator2locator_data
     */
    eProsima_user_DllExport void locator2locator_data(
            Locator2LocatorData&& _locator2locator_data)
    {
        locator2locator_data_() = _locator2locator_data;
        m__d = EventKind::NETWORK_LATENCY;
    }

    /*!
     * @brief This function returns a constant reference to member locator2locator_data
     * @return Constant reference to member locator2locator_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Locator2LocatorData& locator2locator_data() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_locator2locator_data;
    }

    /*!
     * @brief This function returns a reference to member locator2locator_data
     * @return Reference to member locator2locator_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Locator2LocatorData& locator2locator_data()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_locator2locator_data;
    }


    /*!
     * @brief This function copies the value in member entity_data
     * @param _entity_data New value to be copied in member entity_data
     */
    eProsima_user_DllExport void entity_data(
            const EntityData& _entity_data)
    {
        entity_data_() = _entity_data;
        m__d = EventKind::PUBLICATION_THROUGHPUT;
    }

    /*!
     * @brief This function moves the value in member entity_data
     * @param _entity_data New value to be moved in member entity_data
     */
    eProsima_user_DllExport void entity_data(
            EntityData&& _entity_data)
    {
        entity_data_() = _entity_data;
        m__d = EventKind::PUBLICATION_THROUGHPUT;
    }

    /*!
     * @brief This function returns a constant reference to member entity_data
     * @return Constant reference to member entity_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const EntityData& entity_data() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_data;
    }

    /*!
     * @brief This function returns a reference to member entity_data
     * @return Reference to member entity_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport EntityData& entity_data()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_data;
    }


    /*!
     * @brief This function copies the value in member entity2locator_traffic
     * @param _entity2locator_traffic New value to be copied in member entity2locator_traffic
     */
    eProsima_user_DllExport void entity2locator_traffic(
            const Entity2LocatorTraffic& _entity2locator_traffic)
    {
        entity2locator_traffic_() = _entity2locator_traffic;
        m__d = EventKind::RTPS_SENT;
    }

    /*!
     * @brief This function moves the value in member entity2locator_traffic
     * @param _entity2locator_traffic New value to be moved in member entity2locator_traffic
     */
    eProsima_user_DllExport void entity2locator_traffic(
            Entity2LocatorTraffic&& _entity2locator_traffic)
    {
        entity2locator_traffic_() = _entity2locator_traffic;
        m__d = EventKind::RTPS_SENT;
    }

    /*!
     * @brief This function returns a constant reference to member entity2locator_traffic
     * @return Constant reference to member entity2locator_traffic
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Entity2LocatorTraffic& entity2locator_traffic() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity2locator_traffic;
    }

    /*!
     * @brief This function returns a reference to member entity2locator_traffic
     * @return Reference to member entity2locator_traffic
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Entity2LocatorTraffic& entity2locator_traffic()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity2locator_traffic;
    }


    /*!
     * @brief This function copies the value in member entity_count
     * @param _entity_count New value to be copied in member entity_count
     */
    eProsima_user_DllExport void entity_count(
            const EntityCount& _entity_count)
    {
        entity_count_() = _entity_count;
        m__d = EventKind::RESENT_DATAS;
    }

    /*!
     * @brief This function moves the value in member entity_count
     * @param _entity_count New value to be moved in member entity_count
     */
    eProsima_user_DllExport void entity_count(
            EntityCount&& _entity_count)
    {
        entity_count_() = _entity_count;
        m__d = EventKind::RESENT_DATAS;
    }

    /*!
     * @brief This function returns a constant reference to member entity_count
     * @return Constant reference to member entity_count
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const EntityCount& entity_count() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_count;
    }

    /*!
     * @brief This function returns a reference to member entity_count
     * @return Reference to member entity_count
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport EntityCount& entity_count()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_count;
    }


    /*!
     * @brief This function copies the value in member discovery_time
     * @param _discovery_time New value to be copied in member discovery_time
     */
    eProsima_user_DllExport void discovery_time(
            const DiscoveryTime& _discovery_time)
    {
        discovery_time_() = _discovery_time;
        m__d = EventKind::DISCOVERED_ENTITY;
    }

    /*!
     * @brief This function moves the value in member discovery_time
     * @param _discovery_time New value to be moved in member discovery_time
     */
    eProsima_user_DllExport void discovery_time(
            DiscoveryTime&& _discovery_time)
    {
        discovery_time_() = _discovery_time;
        m__d = EventKind::DISCOVERED_ENTITY;
    }

    /*!
     * @brief This function returns a constant reference to member discovery_time
     * @return Constant reference to member discovery_time
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const DiscoveryTime& discovery_time() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_discovery_time;
    }

    /*!
     * @brief This function returns a reference to member discovery_time
     * @return Reference to member discovery_time
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport DiscoveryTime& discovery_time()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_discovery_time;
    }


    /*!
     * @brief This function copies the value in member sample_identity_count
     * @param _sample_identity_count New value to be copied in member sample_identity_count
     */
    eProsima_user_DllExport void sample_identity_count(
            const SampleIdentityCount& _sample_identity_count)
    {
        sample_identity_count_() = _sample_identity_count;
        m__d = EventKind::SAMPLE_DATAS;
    }

    /*!
     * @brief This function moves the value in member sample_identity_count
     * @param _sample_identity_count New value to be moved in member sample_identity_count
     */
    eProsima_user_DllExport void sample_identity_count(
            SampleIdentityCount&& _sample_identity_count)
    {
        sample_identity_count_() = _sample_identity_count;
        m__d = EventKind::SAMPLE_DATAS;
    }

    /*!
     * @brief This function returns a constant reference to member sample_identity_count
     * @return Constant reference to member sample_identity_count
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const SampleIdentityCount& sample_identity_count() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sample_identity_count;
    }

    /*!
     * @brief This function returns a reference to member sample_identity_count
     * @return Reference to member sample_identity_count
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport SampleIdentityCount& sample_identity_count()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sample_identity_count;
    }


    /*!
     * @brief This function copies the value in member physical_data
     * @param _physical_data New value to be copied in member physical_data
     */
    eProsima_user_DllExport void physical_data(
            const PhysicalData& _physical_data)
    {
        physical_data_() = _physical_data;
        m__d = EventKind::PHYSICAL_DATA;
    }

    /*!
     * @brief This function moves the value in member physical_data
     * @param _physical_data New value to be moved in member physical_data
     */
    eProsima_user_DllExport void physical_data(
            PhysicalData&& _physical_data)
    {
        physical_data_() = _physical_data;
        m__d = EventKind::PHYSICAL_DATA;
    }

    /*!
     * @brief This function returns a constant reference to member physical_data
     * @return Constant reference to member physical_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PhysicalData& physical_data() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_physical_data;
    }

    /*!
     * @brief This function returns a reference to member physical_data
     * @return Reference to member physical_data
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PhysicalData& physical_data()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_physical_data;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            WriterReaderData& writer_reader_data_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_writer_reader_data.~WriterReaderData();
                    };
                    new(&m_writer_reader_data) WriterReaderData();

                }

                return m_writer_reader_data;
            }

            Locator2LocatorData& locator2locator_data_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_locator2locator_data.~Locator2LocatorData();
                    };
                    new(&m_locator2locator_data) Locator2LocatorData();

                }

                return m_locator2locator_data;
            }

            EntityData& entity_data_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_entity_data.~EntityData();
                    };
                    new(&m_entity_data) EntityData();

                }

                return m_entity_data;
            }

            Entity2LocatorTraffic& entity2locator_traffic_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_entity2locator_traffic.~Entity2LocatorTraffic();
                    };
                    new(&m_entity2locator_traffic) Entity2LocatorTraffic();

                }

                return m_entity2locator_traffic;
            }

            EntityCount& entity_count_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_entity_count.~EntityCount();
                    };
                    new(&m_entity_count) EntityCount();

                }

                return m_entity_count;
            }

            DiscoveryTime& discovery_time_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]()
                    {
                        m_discovery_time.~DiscoveryTime();
                    };
                    new(&m_discovery_time) DiscoveryTime();

                }

                return m_discovery_time;
            }

            SampleIdentityCount& sample_identity_count_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = [&]()
                    {
                        m_sample_identity_count.~SampleIdentityCount();
                    };
                    new(&m_sample_identity_count) SampleIdentityCount();

                }

                return m_sample_identity_count;
            }

            PhysicalData& physical_data_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = [&]()
                    {
                        m_physical_data.~PhysicalData();
                    };
                    new(&m_physical_data) PhysicalData();

                }

                return m_physical_data;
            }


    uint32_t m__d {2147483647};

    union
    {
        WriterReaderData m_writer_reader_data;
        Locator2LocatorData m_locator2locator_data;
        EntityData m_entity_data;
        Entity2LocatorTraffic m_entity2locator_traffic;
        EntityCount m_entity_count;
        DiscoveryTime m_discovery_time;
        SampleIdentityCount m_sample_identity_count;
        PhysicalData m_physical_data;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};

} // namespace statistics

} // namespace fastdds

} // namespace eprosima

#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_STATISTICS_TYPES_HPP_


