import * as React from 'react';
import { MuiDateSectionName, MuiPickerFieldAdapter } from '../../models';
import { PickerStateValueManager } from '../usePickerState';
import { InferError, Validator } from '../validation/useValidation';
export interface UseFieldParams<TInputValue, TValue, TDate, TSection extends FieldSection, TForwardedProps extends UseFieldForwardedProps, TInternalProps extends UseFieldInternalProps<any, any, any>> {
    forwardedProps: TForwardedProps;
    internalProps: TInternalProps;
    valueManager: PickerStateValueManager<TInputValue, TValue, TDate>;
    fieldValueManager: FieldValueManager<TValue, TDate, TSection, InferError<TInternalProps>>;
    validator: Validator<TDate, UseFieldValidationProps<TInputValue, TInternalProps>>;
}
export interface UseFieldInternalProps<TInputValue, TValue, TError> {
    value?: TInputValue;
    onChange?: (value: TValue) => void;
    onError?: (error: TError, value: TInputValue) => void;
    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue?: TInputValue;
    format?: string;
    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     * @default false
     */
    readOnly?: boolean;
}
export interface UseFieldForwardedProps {
    onKeyDown?: React.KeyboardEventHandler;
    onClick?: () => void;
    onFocus?: () => void;
    onBlur?: () => void;
}
export interface UseFieldResponse<TForwardedProps extends UseFieldForwardedProps> {
    inputProps: UseFieldResponseInputProps<TForwardedProps>;
    inputRef: React.RefObject<HTMLInputElement>;
}
export declare type UseFieldResponseInputProps<TForwardedProps extends UseFieldForwardedProps> = Omit<TForwardedProps, keyof UseFieldForwardedProps> & NonNullable<UseFieldForwardedProps> & {
    value: string;
    error: boolean;
};
export interface FieldSection {
    start: number;
    end: number;
    value: string;
    emptyValue: string;
    separator: string | null;
    dateSectionName: MuiDateSectionName;
    formatValue: string;
    query: string | null;
}
export interface FieldValueManager<TValue, TDate, TSection extends FieldSection, TError> {
    getSectionsFromValue: (utils: MuiPickerFieldAdapter<TDate>, prevSections: TSection[] | null, value: TValue, format: string) => TSection[];
    getValueStrFromSections: (sections: TSection[]) => string;
    getValueFromSections: (utils: MuiPickerFieldAdapter<TDate>, prevSections: TSection[], sections: TSection[], format: string) => {
        value: TValue;
        shouldPublish: boolean;
    };
    getActiveDateFromActiveSection: (value: TValue, activeSection: TSection) => {
        value: TDate | null;
        update: (newActiveDate: TDate | null) => TValue;
    };
    hasError: (error: TError) => boolean;
    isSameError: (error: TError, prevError: TError | null) => boolean;
}
export interface UseFieldState<TValue, TSections> {
    valueStr: string;
    valueParsed: TValue;
    sections: TSections;
    selectedSectionIndexes: {
        start: number;
        end: number;
    } | null;
}
export declare type UseFieldValidationProps<TInputValue, TInternalProps extends UseFieldInternalProps<any, any, any>> = Omit<TInternalProps, 'value' | 'defaultValue'> & {
    value: TInputValue;
};
export declare type AvailableAdjustKeyCode = 'ArrowUp' | 'ArrowDown' | 'PageUp' | 'PageDown' | 'Home' | 'End';
