# Copyright 2021-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

RUST_MIN_VER=1.85.0
inherit cargo toolchain-funcs

DESCRIPTION="Create a book from markdown files"
HOMEPAGE="https://rust-lang.github.io/mdBook/"
SRC_URI="
	https://github.com/rust-lang/mdBook/archive/refs/tags/v${PV}.tar.gz
		-> ${P}.tar.gz
	https://dev.gentoo.org/~ionen/distfiles/${P}-vendor.tar.xz
"
S=${WORKDIR}/${P/b/B}

# OFL-1.1: embeds fonts inside the executable
LICENSE="MPL-2.0 OFL-1.1"
LICENSE+="
	Apache-2.0 BSD CC-BY-4.0 CC0-1.0 ISC MIT MPL-2.0 Unicode-3.0
" # crates
SLOT="0"
KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc ~ppc64 ~riscv ~s390 ~sparc ~x86"
IUSE="doc"

QA_FLAGS_IGNORED="usr/bin/${PN}"

src_compile() {
	cargo_src_compile

	if use doc; then
		if tc-is-cross-compiler; then
			ewarn "html docs were skipped due to cross-compilation"
		else
			"$(cargo_target_dir)"/${PN} build -d "${T}"/html guide || die
		fi
	fi
}

src_test() {
	local -x COLUMNS=100 #960393

	cargo_src_test
}

src_install() {
	cargo_src_install

	dodoc CHANGELOG.md README.md
	use doc && ! tc-is-cross-compiler && dodoc -r "${T}"/html
}
