# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Cryptography Primitives sink"
HOMEPAGE="https://github.com/kazu-yamamoto/crypton"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="check-alignment +integer-gmp old-toolchain-inliner +support-aesni +support-deepseq +support-pclmuldq +support-rdrand support-sse +target-attributes"

RDEPEND=">=dev-haskell/basement-0.0.6:=[profile?]
	>=dev-haskell/memory-0.14.18:=[profile?]
	>=dev-lang/ghc-8.8.1:=
	virtual/libc
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.0.0.0
	test? ( dev-haskell/tasty
		dev-haskell/tasty-hunit
		dev-haskell/tasty-kat
		dev-haskell/tasty-quickcheck )
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag check-alignment check_alignment) \
		$(cabal_flag integer-gmp integer-gmp) \
		$(cabal_flag old-toolchain-inliner old_toolchain_inliner) \
		$(cabal_flag support-aesni support_aesni) \
		$(cabal_flag support-deepseq support_deepseq) \
		$(cabal_flag support-pclmuldq support_pclmuldq) \
		$(cabal_flag support-rdrand support_rdrand) \
		$(cabal_flag support-sse support_sse) \
		$(cabal_flag target-attributes use_target_attributes)
}
