/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.TupleSorter;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class UserFunction
extends Procedure {
    private StructuredQName functionName;
    private boolean tailCalls = false;
    private boolean tailRecursive = false;
    private UserFunctionParameter[] parameterDefinitions;
    private SequenceType resultType;
    protected int evaluationMode = -1;
    private boolean isUpdating = false;
    private int inlineable = -1;

    public void setFunctionName(StructuredQName name) {
        this.functionName = name;
    }

    public StructuredQName getFunctionName() {
        return this.functionName;
    }

    public StructuredQName getObjectName() {
        return this.functionName;
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.tailRecursive ? ExpressionTool.eagerEvaluationMode(this.getBody()) : ExpressionTool.lazyEvaluationMode(this.getBody());
    }

    public Boolean isInlineable() {
        if (this.inlineable < 0) {
            return null;
        }
        return this.inlineable == 1;
    }

    public void setInlineable(boolean inlineable) {
        this.inlineable = inlineable ? 1 : 0;
    }

    public void setParameterDefinitions(UserFunctionParameter[] params) {
        this.parameterDefinitions = params;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setResultType(SequenceType resultType) {
        this.resultType = resultType;
    }

    public void setTailRecursive(boolean tailCalls, boolean recursiveTailCalls) {
        this.tailCalls = tailCalls;
        this.tailRecursive = recursiveTailCalls;
    }

    public boolean containsTailCalls() {
        return this.tailCalls;
    }

    public boolean isTailRecursive() {
        return this.tailRecursive;
    }

    public void setUpdating(boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public SequenceType getResultType(TypeHierarchy th) {
        if (this.resultType == SequenceType.ANY_SEQUENCE && !UserFunction.containsUserFunctionCalls(this.getBody())) {
            this.resultType = SequenceType.makeSequenceType(this.getBody().getItemType(th), this.getBody().getCardinality());
        }
        return this.resultType;
    }

    public SequenceType getDeclaredResultType() {
        return this.resultType;
    }

    private static boolean containsUserFunctionCalls(Expression exp) {
        if (exp instanceof UserFunctionCall) {
            return true;
        }
        Iterator<Expression> i = exp.iterateSubExpressions();
        while (i.hasNext()) {
            Expression e = i.next();
            if (!UserFunction.containsUserFunctionCalls(e)) continue;
            return true;
        }
        return false;
    }

    public SequenceType getArgumentType(int n) {
        return this.parameterDefinitions[n].getRequiredType();
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    public int getNumberOfArguments() {
        return this.parameterDefinitions.length;
    }

    public boolean isMemoFunction() {
        return false;
    }

    public void gatherDirectContributingCallees(Set result) {
        Expression body = this.getBody();
        this.gatherDirectContributingCallees(body, result);
    }

    private void gatherDirectContributingCallees(Expression exp, Set result) {
        Iterator<Expression> kids = exp.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression kid = kids.next();
            if (kid instanceof UserFunctionCall) {
                result.add(((UserFunctionCall)kid).getFunction());
                continue;
            }
            if (kid instanceof Assignation) {
                this.gatherDirectContributingCallees(((Assignation)kid).getAction(), result);
                continue;
            }
            if (kid instanceof Choose) {
                Expression[] actions = ((Choose)kid).getActions();
                for (int c = 0; c < actions.length; ++c) {
                    this.gatherDirectContributingCallees(actions[c], result);
                }
                continue;
            }
            if (kid instanceof ParentNodeConstructor) {
                this.gatherDirectContributingCallees(((ParentNodeConstructor)kid).getContentExpression(), result);
                continue;
            }
            if (kid instanceof FilterExpression) {
                this.gatherDirectContributingCallees(((FilterExpression)kid).getControllingExpression(), result);
                continue;
            }
            if (kid instanceof SortExpression) {
                this.gatherDirectContributingCallees(((SortExpression)kid).getBaseExpression(), result);
                continue;
            }
            if (kid instanceof TupleSorter) {
                this.gatherDirectContributingCallees(((TupleSorter)kid).getBaseExpression(), result);
                continue;
            }
            if (!(kid instanceof TailCallLoop)) continue;
            this.gatherDirectContributingCallees(((TailCallLoop)kid).getBaseExpression(), result);
        }
    }

    public ValueRepresentation call(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        ValueRepresentation result;
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        try {
            result = ExpressionTool.evaluate(this.getBody(), this.evaluationMode, context, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        return result;
    }

    public void process(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        this.getBody().process(context);
    }

    public EventIterator iterateEvents(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        return this.getBody().iterateEvents(context);
    }

    public ValueRepresentation call(ValueRepresentation[] actualArgs, Controller controller) throws XPathException {
        return this.call(actualArgs, controller.newXPathContext());
    }

    public void callUpdating(ValueRepresentation[] actualArgs, XPathContextMajor context, PendingUpdateList pul) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        try {
            this.getBody().evaluatePendingUpdates(context, pul);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public int getConstructType() {
        return 2065;
    }
}

