/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CodeFlag {
    CO_OPTIMIZED(1),
    CO_NEWLOCALS(2),
    CO_VARARGS(4),
    CO_VARKEYWORDS(8),
    CO_GENERATOR(32),
    CO_NESTED(16),
    CO_GENERATOR_ALLOWED(4096),
    CO_FUTURE_DIVISION(8192),
    CO_FUTURE_ABSOLUTE_IMPORT(16384),
    CO_FUTURE_WITH_STATEMENT(32768);

    public final int flag;
    private static Iterable<CodeFlag> allFlags;

    private CodeFlag(int flag) {
        this.flag = flag;
    }

    public boolean isFlagBitSetIn(int flags) {
        return (flags & this.flag) != 0;
    }

    static Iterable<CodeFlag> parse(final int flags) {
        return new Iterable<CodeFlag>(){

            @Override
            public Iterator<CodeFlag> iterator() {
                return new Iterator<CodeFlag>(){
                    Iterator<CodeFlag> all = CodeFlag.access$000().iterator();
                    CodeFlag next = null;

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.all.hasNext()) {
                            CodeFlag flag = this.all.next();
                            if (!flag.isFlagBitSetIn(flags)) continue;
                            this.next = flag;
                            return true;
                        }
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CodeFlag next() {
                        if (this.hasNext()) {
                            try {
                                CodeFlag codeFlag = this.next;
                                return codeFlag;
                            }
                            finally {
                                this.next = null;
                            }
                        }
                        throw new IllegalStateException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static /* synthetic */ Iterable access$000() {
        return allFlags;
    }

    static {
        allFlags = Collections.unmodifiableList(Arrays.asList(CodeFlag.values()));
    }
}

