//===- Transforms/Instrumentation/InstrProfiling.h --------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
/// \file
/// This file provides the interface for LLVM's PGO Instrumentation lowering
/// pass.
//===----------------------------------------------------------------------===//

#ifndef LLVM_TRANSFORMS_INSTRUMENTATION_INSTRPROFILING_H
#define LLVM_TRANSFORMS_INSTRUMENTATION_INSTRPROFILING_H

#include "llvm/IR/PassManager.h"
#include "llvm/Transforms/Utils/Instrumentation.h"

namespace llvm {

class TargetLibraryInfo;
/// Instrumentation based profiling lowering pass. This pass lowers
/// the profile instrumented code generated by FE or the IR based
/// instrumentation pass.
class InstrProfilingLoweringPass
    : public PassInfoMixin<InstrProfilingLoweringPass> {
  const InstrProfOptions Options = {};
  // Is this lowering for the context-sensitive instrumentation.
  const bool IsCS = false;

public:
  InstrProfilingLoweringPass() = default;
  InstrProfilingLoweringPass(const InstrProfOptions &Options, bool IsCS = false)
      : Options(Options), IsCS(IsCS) {}

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &AM);
};
} // end namespace llvm

#endif // LLVM_TRANSFORMS_INSTRUMENTATION_INSTRPROFILING_H
