/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.MemoryIO;

public final class NativeMethod {
    final long function;
    final long name;
    final long signature;

    public NativeMethod(long address, String name, String signature) {
        this.function = address;
        this.name = NativeMethod.nativeString(name);
        this.signature = NativeMethod.nativeString(signature);
    }

    private static final long nativeString(String s) {
        byte[] bytes = s.getBytes();
        long memory = MemoryIO.getInstance().allocateMemory(bytes.length + 1, false);
        if (memory == 0L) {
            throw new OutOfMemoryError("failed to allocate memory for string");
        }
        MemoryIO.getInstance().putZeroTerminatedByteArray(memory, bytes, 0, bytes.length);
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.name != 0L) {
                MemoryIO.getInstance().freeMemory(this.name);
            }
            if (this.signature != 0L) {
                MemoryIO.getInstance().freeMemory(this.signature);
            }
        }
        finally {
            super.finalize();
        }
    }
}

