/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;

public class HistoryItem
implements IEncodedStreamContentAccessor,
ITypedElement,
IModificationDate,
IResourceProvider {
    private final ITypedElement fBase;
    private final IFileState fFileState;

    public HistoryItem(ITypedElement base, IFileState fileState) {
        this.fBase = base;
        this.fFileState = fileState;
    }

    @Override
    public String getName() {
        return this.fBase.getName();
    }

    @Override
    public Image getImage() {
        return this.fBase.getImage();
    }

    @Override
    public String getType() {
        return this.fBase.getType();
    }

    @Override
    public long getModificationDate() {
        return this.fFileState.getModificationTime();
    }

    @Override
    public InputStream getContents() throws CoreException {
        return new BufferedInputStream(this.fFileState.getContents());
    }

    @Override
    public String getCharset() throws CoreException {
        IResource resource;
        String charset = this.fFileState.getCharset();
        if (charset == null && (resource = this.getResource()) instanceof IEncodedStorage) {
            charset = ((IEncodedStorage)resource).getCharset();
        }
        return charset;
    }

    @Override
    public IResource getResource() {
        IPath fullPath = this.fFileState.getFullPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(fullPath);
    }
}

