/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class PostgreJobSchedule
implements PostgreObject,
DBPNamedObject2,
DBPRefreshableObject,
DBPSaveableObject {
    private final PostgreJob job;
    private final long id;
    private String name;
    private String description;
    private boolean enabled;
    private Timestamp start;
    private Timestamp end;
    private boolean[] minutes;
    private boolean[] hours;
    private boolean[] weekDays;
    private boolean[] monthDays;
    private boolean[] months;
    private boolean persisted;

    public PostgreJobSchedule(@NotNull PostgreJob job, ResultSet dbResult) {
        this.job = job;
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"jscid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jscname");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jscdesc");
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"jscenabled");
        this.start = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"jscstart");
        this.end = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"jscend");
        this.minutes = ArrayUtils.unbox((Boolean[])PostgreUtils.safeGetBooleanArray(dbResult, "jscminutes"));
        this.hours = ArrayUtils.unbox((Boolean[])PostgreUtils.safeGetBooleanArray(dbResult, "jschours"));
        this.weekDays = ArrayUtils.unbox((Boolean[])PostgreUtils.safeGetBooleanArray(dbResult, "jscweekdays"));
        this.monthDays = ArrayUtils.unbox((Boolean[])PostgreUtils.safeGetBooleanArray(dbResult, "jscmonthdays"));
        this.months = ArrayUtils.unbox((Boolean[])PostgreUtils.safeGetBooleanArray(dbResult, "jscmonths"));
        this.persisted = true;
    }

    public PostgreJobSchedule(@NotNull PostgreJob job, @NotNull String name) {
        this.job = job;
        this.id = 0L;
        this.name = name;
        this.description = "";
        this.enabled = true;
        this.start = Timestamp.from(Instant.now());
        this.end = null;
        this.minutes = new boolean[60];
        this.hours = new boolean[24];
        this.weekDays = new boolean[7];
        this.monthDays = new boolean[32];
        this.months = new boolean[12];
        this.persisted = false;
    }

    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, editable=true, updatable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Property(viewable=true, order=4, specific=true)
    @NotNull
    public Timestamp getStart() {
        return this.start;
    }

    @Property(viewable=true, order=5, specific=true)
    @Nullable
    public Timestamp getEnd() {
        return this.end;
    }

    @NotNull
    public boolean[] getMinutes() {
        return this.minutes;
    }

    @NotNull
    public boolean[] getHours() {
        return this.hours;
    }

    @NotNull
    public boolean[] getWeekDays() {
        return this.weekDays;
    }

    @NotNull
    public boolean[] getMonthDays() {
        return this.monthDays;
    }

    @NotNull
    public boolean[] getMonths() {
        return this.months;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @NotNull
    public PostgreJob getParentObject() {
        return this.job;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.job.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.job.getDatabase();
    }

    @Nullable
    public PostgreJobSchedule refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return (PostgreJobSchedule)this.job.getScheduleCache().refreshObject(monitor, this.job, this);
    }
}

