/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.run.ui.AggregationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0007H\u0007J\u0006\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/run/ui/Aggregator;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "extractor", "Lcom/intellij/database/extractors/DataExtractor;", "simpleName", "", "name", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/extractors/DataExtractor;Ljava/lang/String;Ljava/lang/String;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "lastTask", "Ljava/util/concurrent/Future;", "result", "update", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/database/run/ui/AggregationResult;", "getSimpleName", "getName", "intellij.grid.impl"})
public final class Aggregator {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final DataExtractor extractor;
    @NotNull
    private final String simpleName;
    @NotNull
    private final String name;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private Future<?> lastTask;
    @NotNull
    private Object result;

    public Aggregator(@NotNull DataGrid grid, @NotNull DataExtractor extractor, @NotNull String simpleName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.grid = grid;
        this.extractor = extractor;
        this.simpleName = simpleName;
        this.name = name;
        ExecutorService executorService = ApplicationManager.getApplication().isUnitTestMode() ? ConcurrencyUtil.newSameThreadExecutorService() : (ExecutorService)ConcurrencyUtil.newSingleThreadExecutor((String)"Aggregator script executor");
        Intrinsics.checkNotNull((Object)executorService);
        this.executor = executorService;
        this.result = "";
    }

    @NotNull
    public final CompletableFuture<AggregationResult> update() {
        boolean bl = ApplicationManager.getApplication().isDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Future<?> future = this.lastTask;
        if (future != null) {
            future.cancel(true);
        }
        this.result = "";
        CompletableFuture<AggregationResult> completableFuture = new CompletableFuture<AggregationResult>();
        Future<Boolean> future2 = this.executor.submit(() -> Aggregator.update$lambda$0(this, completableFuture));
        Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
        Future<Boolean> task = future2;
        this.lastTask = task;
        return completableFuture;
    }

    @NlsSafe
    @NotNull
    public final String getSimpleName() {
        return this.simpleName;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private static final Boolean update$lambda$0(Aggregator this$0, CompletableFuture $completableFuture) {
        String string;
        Throwable th = null;
        try {
            string = this$0.grid.getSelectionModel().getSelectedColumnCount() * this$0.grid.getSelectionModel().getSelectedRowCount() == 0 ? DataGridBundle.message((String)"label.aggregator.not.enough.values", (Object[])new Object[0]) : GridUtil.extractSelectedValues(this$0.grid, this$0.extractor);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Throwable e) {
            th = e;
            String string2 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
            string = StringsKt.replace$default((String)string2, (String)"com.intellij.ide.script.IdeScriptException: ", (String)"", (boolean)false, (int)4, null);
        }
        String text = string;
        AggregationResult result = new AggregationResult(text, th);
        result.setDecorateState(result.isFullTextShown());
        return $completableFuture.complete(result);
    }
}

