/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private static final String PROTOCOL = "mock";
    private final MyVirtualFile myRoot = new MyVirtualFile("", null){

        @Override
        @NotNull
        public VirtualFileSystem getFileSystem() {
            MockVirtualFileSystem mockVirtualFileSystem = MockVirtualFileSystem.this;
            if (mockVirtualFileSystem == null) {
                1.$$$reportNull$$$0(0);
            }
            return mockVirtualFileSystem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$1", "getFileSystem"));
        }
    };

    @NotNull
    public LightVirtualFile findFileByPath(@NotNull String path) {
        String normalized;
        if (path == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if (StringUtil.startsWithChar((CharSequence)(normalized = path.replace(File.separatorChar, '/').replace('/', ':')), (char)':')) {
            normalized = normalized.substring(1);
        }
        MyVirtualFile file = this.myRoot;
        for (String component : StringUtil.split((String)normalized, (String)":")) {
            file = file.getOrCreate(component);
        }
        MyVirtualFile myVirtualFile = file;
        if (myVirtualFile == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return myVirtualFile;
    }

    @NotNull
    public MockVirtualFileSystem file(@NotNull String path, @NotNull String data) {
        if (path == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(2);
        }
        if (data == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(3);
        }
        LightVirtualFile file = this.findFileByPath(path);
        file.setContent(null, (CharSequence)data, false);
        MockVirtualFileSystem mockVirtualFileSystem = this;
        if (mockVirtualFileSystem == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(4);
        }
        return mockVirtualFileSystem;
    }

    @NotNull
    public VirtualFile getRoot() {
        MyVirtualFile myVirtualFile = this.myRoot;
        if (myVirtualFile == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(5);
        }
        return myVirtualFile;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            MockVirtualFileSystem.$$$reportNull$$$0(6);
        }
        return this.findFileByPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockVirtualFileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockVirtualFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "file";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "file";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class MyVirtualFile
    extends LightVirtualFile {
        private final MyVirtualFile myParent;
        private Map<String, MyVirtualFile> myChildren;

        private MyVirtualFile(String name, MyVirtualFile parent) {
            super(name);
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
            if (virtualFileSystem == null) {
                MyVirtualFile.$$$reportNull$$$0(0);
            }
            return virtualFileSystem;
        }

        @NotNull
        public MyVirtualFile getOrCreate(@NotNull String name) {
            MyVirtualFile file;
            if (name == null) {
                MyVirtualFile.$$$reportNull$$$0(1);
            }
            if ((file = this.findChild(name)) == null) {
                if (this.myChildren == null) {
                    this.myChildren = CollectionFactory.createSmallMemoryFootprintMap();
                }
                file = new MyVirtualFile(name, this);
                this.myChildren.put(name, file);
            }
            MyVirtualFile myVirtualFile = file;
            if (myVirtualFile == null) {
                MyVirtualFile.$$$reportNull$$$0(2);
            }
            return myVirtualFile;
        }

        public boolean isDirectory() {
            return this.myParent == null || this.myChildren != null && !this.myChildren.isEmpty();
        }

        @NotNull
        public String getPath() {
            MyVirtualFile parent = this.getParent();
            Object object = parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
            if (object == null) {
                MyVirtualFile.$$$reportNull$$$0(3);
            }
            return object;
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            return this.myChildren == null ? EMPTY_ARRAY : VfsUtilCore.toVirtualFileArray(this.myChildren.values());
        }

        @Nullable
        public MyVirtualFile findChild(@NotNull String name) {
            if (name == null) {
                MyVirtualFile.$$$reportNull$$$0(4);
            }
            return this.myChildren == null ? null : this.myChildren.get(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSystem";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreate";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

