var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import React, { Component } from 'react';
import AsyncApiStandalone from './Standalone';
import { isFetchingSchemaInterface, } from '../../types';
import { SpecificationHelpers, Parser } from '../../helpers';
var AsyncApiComponent = (function (_super) {
    __extends(AsyncApiComponent, _super);
    function AsyncApiComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            asyncapi: undefined,
            error: undefined,
        };
        return _this;
    }
    AsyncApiComponent.prototype.componentDidMount = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, schema, config;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.props.schema) return [3, 2];
                        _a = this.props, schema = _a.schema, config = _a.config;
                        return [4, this.parseSchema(schema, config === null || config === void 0 ? void 0 : config.parserOptions)];
                    case 1:
                        _b.sent();
                        _b.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    AsyncApiComponent.prototype.componentDidUpdate = function (prevProps) {
        return __awaiter(this, void 0, void 0, function () {
            var oldSchema, newSchema, config;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        oldSchema = prevProps.schema;
                        newSchema = this.props.schema;
                        if (!(oldSchema !== newSchema)) return [3, 2];
                        config = this.props.config;
                        return [4, this.parseSchema(newSchema, config === null || config === void 0 ? void 0 : config.parserOptions)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    AsyncApiComponent.prototype.render = function () {
        var _a = this.props, schema = _a.schema, config = _a.config;
        var _b = this.state, asyncapi = _b.asyncapi, error = _b.error;
        return (React.createElement(AsyncApiStandalone, { schema: asyncapi !== null && asyncapi !== void 0 ? asyncapi : schema, config: config, error: error }));
    };
    AsyncApiComponent.prototype.parseSchema = function (schema, parserOptions) {
        return __awaiter(this, void 0, void 0, function () {
            var parsedSpec, parsedFromUrl, parsed;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        parsedSpec = SpecificationHelpers.retrieveParsedSpec(schema);
                        if (parsedSpec) {
                            this.setState({
                                asyncapi: parsedSpec,
                            });
                            return [2];
                        }
                        if (!isFetchingSchemaInterface(schema)) return [3, 2];
                        return [4, Parser.parseFromUrl(schema, parserOptions)];
                    case 1:
                        parsedFromUrl = _a.sent();
                        this.setState({
                            asyncapi: parsedFromUrl.asyncapi,
                            error: parsedFromUrl.error,
                        });
                        return [2];
                    case 2: return [4, Parser.parse(schema, parserOptions)];
                    case 3:
                        parsed = _a.sent();
                        this.setState({
                            asyncapi: parsed.asyncapi,
                            error: parsed.error,
                        });
                        return [2];
                }
            });
        });
    };
    return AsyncApiComponent;
}(Component));
export default AsyncApiComponent;
//# sourceMappingURL=AsyncApi.js.map